/*
 * Decompiled with CFR 0.152.
 */
package com.questmsm.FPTable;

import com.questmsm.FPTable.Column;
import com.questmsm.FPTable.ContinueFillingBetweenDialog;
import com.questmsm.FPTable.ContinueFillingDialog;
import com.questmsm.FPTable.FillDialog;
import com.questmsm.FPTable.InsertBetweenDialog;
import com.questmsm.FPTable.IntervalsDialog;
import com.questmsm.FPTable.Table;
import com.questmsm.FPTable.TableHolder;
import com.questmsm.FPTable.TableRow;
import com.questmsm.FPTable.TableShell;
import com.questmsm.FPTable.TableVariableTag;
import com.questmsm.FunctionProbe.Master;
import com.questmsm.Utilities.FPNumberFormatException;
import com.questmsm.Utilities.MyStringTokenizer;
import com.questmsm.Utilities.fp_resource;
import com.questmsm.Utilities.utils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.PrintJob;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.StreamTokenizer;
import java.util.Properties;

public class TablePanel
extends TableShell {
    private static boolean fInitialized = false;
    Table table;
    static final int XINDENT = 40;
    static final int YINDENT = 40;

    public TablePanel(TableHolder tableHolder, Table table, Color color) {
        super(tableHolder, table, color);
        this.table = table;
        int n = 0;
        Column column = this.fFirstCol = new Column(this, this.fNumRows, n, 64, this.fNumDecimalPlaces);
        int n2 = 1;
        while (n2 < 5) {
            column = column.next = new Column(this, this.fNumRows, n += 64, 64, this.fNumDecimalPlaces);
            ++n2;
        }
        this.fLastCol = column;
        this.fXTag = new TableVariableTag(this, this.fFirstCol, 'x');
        this.fYTag = new TableVariableTag(this, this.fFirstCol.next, 'y');
        this.fRTag = new TableVariableTag(this, this.fFirstCol, 'r');
        this.fThTag = new TableVariableTag(this, this.fFirstCol.next, 'q');
        this.fTTag = new TableVariableTag(this, this.fFirstCol.next.next, 't');
    }

    /*
     * Unable to fully structure code
     */
    public void setBounds(int var1_1, int var2_2, int var3_3, int var4_4, boolean var5_5) {
        block2: {
            if (TablePanel.fInitialized) ** GOTO lbl7
            this.appendColumn();
            this.addARowNoRedraw();
            TablePanel.fInitialized = true;
            break block2;
lbl-1000:
            // 1 sources

            {
                this.appendColumn();
lbl7:
                // 2 sources

                ** while (var3_3 > this.maxWidth())
            }
lbl8:
            // 2 sources

            while (var4_4 > this.maxHeight()) {
                this.addARowNoRedraw();
            }
        }
        super.setBounds(var1_1, var2_2, var3_3, var4_4, var5_5);
    }

    public void setBounds(int n, int n2, int n3, int n4) {
        this.setBounds(n, n2, n3, n4, true);
    }

    public void setBounds() {
        this.setBounds(this.getLocation().x, this.getLocation().y, this.getSize().width, this.getSize().height);
    }

    public boolean doCommandOnColumn(String string) {
        if (this.fSelectedCol == null) {
            utils.showErrorDialog(Master.gFrame, fp_resource.getString("str_error__no_column_selected"));
            return false;
        }
        if (string.equals("sort ascending")) {
            this.copyToUndo(fp_resource.getString("str_undo_sort"));
            this.doSort(true);
            return true;
        }
        if (string.equals("sort descending")) {
            this.copyToUndo(fp_resource.getString("str_undo_sort"));
            this.doSort(false);
            return true;
        }
        if (string.equals("difference")) {
            if (!this.insertColumn()) {
                return false;
            }
            this.copyToUndo(fp_resource.getString("str_undo_difference"));
            this.fSelectedCol.next.nudgeFactor(this.fSelectedCol.nudgeFactor() + 1);
            this.fSelectedCol.next.difference(this.fSelectedCol);
            this.redraw(true);
            return true;
        }
        if (string.equals("ratio")) {
            if (!this.insertColumn()) {
                return false;
            }
            this.copyToUndo(fp_resource.getString("str_undo_ratio"));
            this.fSelectedCol.next.nudgeFactor(this.fSelectedCol.nudgeFactor() + 1);
            this.fSelectedCol.next.ratio(this.fSelectedCol);
            this.redraw(true);
            return true;
        }
        if (string.equals("gmean")) {
            if (!this.insertColumn()) {
                return false;
            }
            this.copyToUndo(fp_resource.getString("str_undo_geom_mean"));
            this.fSelectedCol.next.nudgeFactor(this.fSelectedCol.nudgeFactor() + 1);
            this.fSelectedCol.next.gMean(this.fSelectedCol);
            this.redraw(true);
            return true;
        }
        if (string.equals("amean")) {
            if (!this.insertColumn()) {
                return false;
            }
            this.copyToUndo(fp_resource.getString("str_undo_arith_mean"));
            this.fSelectedCol.next.nudgeFactor(this.fSelectedCol.nudgeFactor() + 1);
            this.fSelectedCol.next.aMean(this.fSelectedCol);
            this.redraw(true);
            return true;
        }
        return false;
    }

    public boolean doCommandOnColumn(String string, double d) {
        if (this.fSelectedCol == null) {
            utils.showErrorDialog(Master.gFrame, fp_resource.getString("str_error__no_column_selected"));
            return false;
        }
        if (string.equals("accumulate")) {
            if (!this.insertColumn()) {
                return false;
            }
            this.copyToUndo(fp_resource.getString("str_undo_accumulate"));
            this.fSelectedCol.next.nudgeFactor(this.fSelectedCol.nudgeFactor() + 1);
            this.fSelectedCol.next.accum(this.fSelectedCol, d);
            this.redraw(true);
            return true;
        }
        return false;
    }

    public void doSort(boolean bl) {
        if (this.fActOnLinks && this.fSelectedCol.linked()) {
            this.fSelectedCol.sort(bl, this.fNumLinkedCols, this.fLinkedCols);
        } else {
            this.fSelectedCol.sort(bl, 0, null);
        }
        this.reevaluate();
        this.redraw(true);
    }

    public boolean inDependenceTree(Column column, Column column2) {
        Column[] columnArray = new Column[10];
        int n = column2.getDependencies(columnArray);
        if (column == column2) {
            return true;
        }
        int n2 = 0;
        while (n2 < n) {
            if (column == columnArray[n2]) {
                return true;
            }
            if (this.inDependenceTree(column, columnArray[n2])) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public boolean deleteable(Column column) {
        Column[] columnArray = new Column[10];
        Column column2 = this.fFirstCol;
        while (column2 != null) {
            int n = column2.getDependencies(columnArray);
            int n2 = 0;
            while (n2 < n) {
                if (column == columnArray[n2]) {
                    return false;
                }
                ++n2;
            }
            column2 = column2.next;
        }
        return true;
    }

    public boolean canNudgeUp() {
        if (this.fSelectedCol == null) {
            return false;
        }
        return this.fSelectedCol.nudgeFactor() > 0;
    }

    public Column getColumn(char c) {
        Column column = this.fFirstCol;
        while (column != null) {
            if (column.active() && column.depVar() == c) {
                return column;
            }
            column = column.next;
        }
        return column;
    }

    /*
     * Unable to fully structure code
     */
    public Column getColumn(int var1_1) {
        var2_2 = this.fFirstCol;
        if (var1_1 >= 0) ** GOTO lbl7
        return null;
lbl-1000:
        // 1 sources

        {
            if (var2_2.getID() == var1_1) {
                return var2_2;
            }
            var2_2 = var2_2.next;
lbl7:
            // 2 sources

            ** while (var2_2 != null)
        }
lbl8:
        // 1 sources

        return null;
    }

    public double getColRowVal(int n, int n2) {
        if (n2 < 0) {
            return -1.23456123;
        }
        Column column = this.getColumn(n);
        if (column == null) {
            return -1.23456123;
        }
        TableRow tableRow = column.row(n2);
        if (tableRow == null) {
            return -1.23456123;
        }
        if (tableRow.isNum()) {
            return tableRow.num();
        }
        return -1.23456123;
    }

    public double getDifference(int n, double d) {
        if (d < 0.0) {
            return -1.23456123;
        }
        Column column = this.getColumn(n);
        if (column == null) {
            return -1.23456123;
        }
        int n2 = column.getIndexAdjustedForNudge(d);
        if (n2 == -999) {
            return -0.7654321;
        }
        if (n2 < 0) {
            return -1.23456123;
        }
        TableRow tableRow = column.row(n2);
        if (!tableRow.isNum()) {
            return -1.23456123;
        }
        double d2 = tableRow.num();
        int n3 = n2 + 1;
        while (n3 < this.fNumRows) {
            tableRow = column.row(n3);
            if (tableRow.isNum()) {
                return tableRow.num() - d2;
            }
            ++n3;
        }
        return -1.23456123;
    }

    public double getVal(char c, double d) {
        if (d < 0.0) {
            return -1.23456123;
        }
        Column column = this.getColumn(c);
        if (column == null) {
            return -1.23456123;
        }
        int n = column.getIndexAdjustedForNudge(d);
        if (n == -999) {
            return -1.23456123;
        }
        TableRow tableRow = column.row(n);
        if (tableRow == null) {
            return -0.7654321;
        }
        if (tableRow.isNum()) {
            return tableRow.num();
        }
        return -1.23456123;
    }

    public int getColumnIndex(Column column) {
        Column column2 = this.fFirstCol;
        int n = 0;
        while (column2 != null) {
            if (column2 == column) {
                return n;
            }
            ++n;
            column2 = column2.next;
        }
        return -1;
    }

    public Column getIndexedColumn(int n) {
        if (n < 0) {
            return null;
        }
        Column column = this.fFirstCol;
        int n2 = 0;
        while (column != null) {
            if (n == n2) {
                return column;
            }
            ++n2;
            column = column.next;
        }
        return null;
    }

    public void continueFilling(int n, double[] dArray, boolean bl) {
        int n2 = this.fSelectedRow;
        this.copyToUndo(fp_resource.getString("str_undo_fill"));
        if (!bl && n > n2 + 1) {
            this.fSelectedCol.insertRows(-1, n - (n2 + 1));
            n2 += n - (n2 + 1);
        }
        int n3 = 0;
        while (n3 < n) {
            this.fSelectedCol.row(n2).set(dArray[n3]);
            if (bl) {
                if (++n2 >= this.fNumRows && n3 < n - 1) {
                    this.addARowNoRedraw();
                }
                if (this.fNumRows == 300) {
                    utils.showErrorDialog(Master.gFrame, String.valueOf(fp_resource.getString("str_error__exceeded_maximum_number_of_rows")) + " (" + 300 + ")");
                    break;
                }
            } else if (--n2 < 0 && n3 < n - 1) {
                utils.showErrorDialog(Master.gFrame, fp_resource.getString("str_error__filled_past_top_row"));
                break;
            }
            ++n3;
        }
        this.reevaluate();
        this.redraw(true);
    }

    public void continueFillingBetween(int n, double[] dArray, boolean bl) {
        int n2;
        int n3 = this.fSelectedRow;
        this.copyToUndo(fp_resource.getString("str_undo_fill_between"));
        this.fSelectedCol.insertRows(n3, n);
        if (this.fActOnLinks && this.fSelectedCol.linked()) {
            n2 = 0;
            while (n2 < this.fNumLinkedCols) {
                if (this.fSelectedCol != this.fLinkedCols[n2]) {
                    this.fLinkedCols[n2].insertAllBlanks(n, n3, n3 + 1);
                }
                ++n2;
            }
        }
        n2 = 0;
        while (n2 <= n) {
            this.fSelectedCol.row(n3).set(dArray[n2]);
            if (bl) {
                if (++n3 >= this.fNumRows) {
                    this.addARowNoRedraw();
                }
                if (this.fNumRows == 300) {
                    return;
                }
            } else if (--n3 < 0) {
                utils.showErrorDialog(Master.gFrame, fp_resource.getString("str_error__filled_past_top_row"));
                return;
            }
            ++n2;
        }
        this.selectRow(this.fSelectedRow);
        this.fSelectedCol.row(this.fSelectedRow).selectAll();
        this.reevaluate();
        this.redraw(true);
    }

    public void fill(FillDialog fillDialog) {
        if (this.fSelectedCol == null) {
            return;
        }
        if (this.fSelectedRow < 0) {
            return;
        }
        double[] dArray = new double[300];
        int n = fillDialog.getValues(dArray);
        boolean bl = fillDialog.getDirection();
        fillDialog.doNo();
        if (n >= this.fRunawayFill) {
            ContinueFillingDialog continueFillingDialog = new ContinueFillingDialog(n, dArray, bl, this);
            ((Component)continueFillingDialog).setVisible(true);
        } else {
            this.continueFilling(n, dArray, bl);
        }
    }

    public void insertBetween(InsertBetweenDialog insertBetweenDialog) {
        if (this.fSelectedCol == null) {
            return;
        }
        int n = 0;
        try {
            n = insertBetweenDialog.getValue();
        }
        catch (FPNumberFormatException fPNumberFormatException) {
            return;
        }
        this.copyToUndo(fp_resource.getString("str_undo_insert_between"));
        if (this.fSelectedRow < 0 || this.fSelectedStopRow < 0 || this.fSelectedRow == this.fSelectedStopRow) {
            this.fSelectedCol.insertBetween(insertBetweenDialog, 0, this.fNumRows - 1);
            if (this.fActOnLinks && this.fSelectedCol.linked()) {
                int n2 = 0;
                while (n2 < this.fNumLinkedCols) {
                    if (this.fSelectedCol != this.fLinkedCols[n2]) {
                        this.fLinkedCols[n2].insertAllBlanks(n, 0, this.fNumRows - 1);
                    }
                    ++n2;
                }
            }
        } else {
            this.fSelectedCol.insertBetween(insertBetweenDialog, this.fSelectedRow, this.fSelectedStopRow);
            if (this.fActOnLinks && this.fSelectedCol.linked()) {
                int n3 = 0;
                while (n3 < this.fNumLinkedCols) {
                    if (this.fSelectedCol != this.fLinkedCols[n3]) {
                        this.fLinkedCols[n3].insertAllBlanks(n, this.fSelectedRow, this.fSelectedStopRow);
                    }
                    ++n3;
                }
            }
        }
        this.selectRow(this.fSelectedRow);
        this.reevaluate();
        this.redraw(true);
    }

    public void fillBetween(FillDialog fillDialog) {
        if (this.fSelectedCol == null) {
            utils.showErrorDialog(this.fTable, fp_resource.getString("str_must_have_a_column_selected"));
            return;
        }
        if (this.fSelectedRow < 0) {
            utils.showErrorDialog(this.fTable, fp_resource.getString("str_must_have_data_cells_selected"));
            return;
        }
        double[] dArray = new double[300];
        int n = fillDialog.getValues(dArray);
        if (dArray[--n] == this.fSelectedCol.row(this.fSelectedRow + 1).num()) {
            --n;
        }
        int n2 = this.fSelectedRow;
        boolean bl = fillDialog.getDirection();
        fillDialog.doNo();
        if (n >= this.fRunawayFill) {
            ContinueFillingBetweenDialog continueFillingBetweenDialog = new ContinueFillingBetweenDialog(n, dArray, bl, this);
            ((Component)continueFillingBetweenDialog).setVisible(true);
        } else {
            this.continueFillingBetween(n, dArray, bl);
        }
    }

    public void doEliminateBlanks() {
        if (this.fSelectedCol == null) {
            return;
        }
        this.copyToUndo(fp_resource.getString("str_undo_eliminate_blanks"));
        this.fSelectedCol.eliminateBlanks();
        this.reevaluate();
        this.redraw(true);
    }

    public void doIndex() {
        if (this.fSelectedCol == null) {
            return;
        }
        this.copyToUndo(fp_resource.getString("str_undo_index"));
        Column column = this.insertColumnBefore();
        int n = 1;
        int n2 = 0;
        while (n2 < this.fNumRows) {
            if (this.fSelectedCol.row(n2).isNum()) {
                column.row(n2).setVal(n);
                ++n;
            }
            ++n2;
        }
        column.numDecimalPlaces(0);
        char c = this.fSelectedCol.getDepVar();
        if (c == '\u0000') {
            column.labelRow().set(fp_resource.getString("str_index"));
        } else {
            column.labelRow().set(String.valueOf(fp_resource.getString("str_index_for")) + " " + c);
        }
        this.redraw(true);
    }

    public void nudgeUp() {
        this.copyToUndo(fp_resource.getString("str_undo_nudge_up"));
        if (this.fSelectedCol.linked()) {
            int n = 0;
            while (n < this.fNumLinkedCols) {
                this.fLinkedCols[n].nudgeUp();
                ++n;
            }
        } else {
            this.fSelectedCol.nudgeUp();
        }
        this.reevaluate();
        this.redraw(true);
    }

    public void nudgeDown() {
        this.copyToUndo(fp_resource.getString("str_undo_nudge_down"));
        if (this.fSelectedCol.linked()) {
            int n = 0;
            while (n < this.fNumLinkedCols) {
                this.fLinkedCols[n].nudgeDown();
                ++n;
            }
        } else {
            this.fSelectedCol.nudgeDown();
        }
        this.reevaluate();
        this.redraw(true);
    }

    public void colDecimalPlaces(int n) {
        if (this.fSelectedCol == null) {
            return;
        }
        this.fSelectedCol.numDecimalPlaces(n);
    }

    public int colDecimalPlaces() {
        if (this.fSelectedCol == null) {
            return 2;
        }
        return this.fSelectedCol.numDecimalPlaces();
    }

    public void colSciNotation(boolean bl) {
        if (this.fSelectedCol == null) {
            return;
        }
        this.fSelectedCol.sciNotation(bl);
    }

    public boolean colSciNotation() {
        if (this.fSelectedCol == null) {
            return false;
        }
        return this.fSelectedCol.sciNotation();
    }

    public void colRecalculate() {
        if (this.fSelectedCol == null) {
            return;
        }
        this.fSelectedCol.recalculatePositions(this.dy, this.dy + this.getSize().height);
    }

    public void colActive(boolean bl) {
        Column column;
        char c;
        if (this.fSelectedCol == null) {
            return;
        }
        if (!this.fSelectedCol.active() && bl && (c = this.fSelectedCol.depVar()) != '\u0000' && (column = this.getColumn(this.fSelectedCol.depVar())) != null) {
            utils.showErrorDialog(Master.gFrame, fp_resource.getString("str_error__variable_already_exists_in_an_active_column"));
            return;
        }
        this.fSelectedCol.active(bl);
        this.redraw(false);
    }

    public void deleteColumn() {
        Column column;
        if (this.fSelectedCol == null) {
            return;
        }
        if (!this.deleteable(this.fSelectedCol)) {
            utils.showErrorDialog(Master.gFrame, fp_resource.getString("str_error__another_column_is_dependent_upon_this_one_and_so_it_may_not_be_deleted"));
            return;
        }
        if (this.fLastCol == this.fFirstCol) {
            utils.showErrorDialog(Master.gFrame, fp_resource.getString("str_error__you_may_not_delete_the_last_column_from_the_table"));
            return;
        }
        this.copyToUndo(fp_resource.getString("str_undo_delete_column"));
        if (this.fSelectedCol.linked()) {
            int n = 0;
            while (n < this.fNumLinkedCols) {
                if (this.fLinkedCols[n] == this.fSelectedCol) {
                    int n2 = n;
                    while (n2 < this.fNumLinkedCols - 1) {
                        this.fLinkedCols[n2] = this.fLinkedCols[n2 + 1];
                        ++n2;
                    }
                    --this.fNumLinkedCols;
                    break;
                }
                ++n;
            }
        }
        Column column2 = null;
        column2 = this.fSelectedCol == this.fLastCol ? this.fFirstCol : this.fSelectedCol.next;
        if (this.fXTag.column() == this.fSelectedCol) {
            this.fXTag.column(column2);
        }
        if (this.fYTag.column() == this.fSelectedCol) {
            this.fYTag.column(column2);
        }
        if (this.fRTag.column() == this.fSelectedCol) {
            this.fRTag.column(column2);
        }
        if (this.fThTag.column() == this.fSelectedCol) {
            this.fThTag.column(column2);
        }
        if (this.fTTag.column() == this.fSelectedCol) {
            this.fTTag.column(column2);
        }
        this.repositionTags();
        if (this.fFirstCol == this.fSelectedCol) {
            this.fFirstCol = this.fSelectedCol.next;
            this.fFirstCol.left(0);
            column = this.fFirstCol;
        } else {
            column = this.prevColumn();
            if (this.fSelectedCol == this.fLastCol) {
                this.fLastCol = column;
                this.fSelectedCol = column;
                return;
            }
            column.next = this.fSelectedCol.next;
        }
        this.fSelectedCol = this.fSelectedCol.next;
        Column column3 = column;
        while (column3.next != null) {
            column3.next.left(column3.left() + column3.width());
            column3 = column3.next;
        }
    }

    public boolean insertColumn() {
        if (this.fSelectedCol == null) {
            return false;
        }
        Column column = this.fSelectedCol.next;
        if (column == null) {
            this.fSelectedCol.next = new Column(this, this.fNumRows, this.fSelectedCol.right(), 64, this.fNumDecimalPlaces);
            this.fSelectedCol.next.copyOptions(this.fSelectedCol);
            if (this.globallyLinked()) {
                this.linkColumn(this.fSelectedCol.next);
            }
            this.fLastCol = this.fSelectedCol.next;
            this.fLastCol.next = null;
            return true;
        }
        this.fSelectedCol.next = new Column(this, this.fNumRows, column.left(), 64, this.fNumDecimalPlaces);
        this.fSelectedCol.next.copyOptions(this.fSelectedCol);
        if (this.globallyLinked()) {
            this.linkColumn(this.fSelectedCol.next);
        }
        this.fSelectedCol.next.next = column;
        while (column != null) {
            column.left(column.left() + 64);
            column = column.next;
        }
        return true;
    }

    public Column insertColumnBefore() {
        if (this.fSelectedCol == null) {
            return null;
        }
        if (this.fSelectedCol == this.fFirstCol) {
            Column column = new Column(this, this.fNumRows, 0, 64, this.fNumDecimalPlaces);
            if (this.globallyLinked()) {
                this.linkColumn(column);
            }
            column.next = this.fFirstCol;
            this.fFirstCol = column;
            column = column.next;
            while (column != null) {
                column.left(column.left() + 64);
                column = column.next;
            }
            return this.fFirstCol;
        }
        Column column = this.fFirstCol;
        while (column.next != this.fSelectedCol) {
            column = column.next;
        }
        Column column2 = new Column(this, this.fNumRows, column.next.left(), 64, this.fNumDecimalPlaces);
        if (this.globallyLinked()) {
            this.linkColumn(column2);
        }
        column.next = column2;
        column2.next = this.fSelectedCol;
        column = this.fSelectedCol;
        while (column != null) {
            column.left(column.left() + 64);
            column = column.next;
        }
        return column2;
    }

    public void addIntervals(IntervalsDialog intervalsDialog) {
        if (this.fSelectedCol == null) {
            return;
        }
        if (!this.fActOnLinks || this.fNumLinkedCols == 0 || !this.fSelectedCol.linked()) {
            this.fSelectedCol.addIntervals(intervalsDialog);
        }
        if (this.fActOnLinks && this.fSelectedCol.linked()) {
            int n = 0;
            while (n < this.fNumLinkedCols) {
                this.fLinkedCols[n].addIntervals(intervalsDialog);
                ++n;
            }
        }
    }

    public void setIntervals() {
        if (this.fSelectedCol == null) {
            return;
        }
        if (!this.fActOnLinks || this.fNumLinkedCols == 0 || !this.fSelectedCol.linked()) {
            this.fSelectedCol.setIntervals(this.fNumOldIntervals, this.fOldIntervals);
        }
        if (this.fActOnLinks && this.fSelectedCol.linked()) {
            int n = 0;
            while (n < this.fNumLinkedCols) {
                this.fLinkedCols[n].setIntervals(this.fNumOldIntervals, this.fOldIntervals);
                ++n;
            }
        }
    }

    public void deleteIntervals() {
        if (this.fSelectedCol == null) {
            return;
        }
        if (!this.fActOnLinks || this.fNumLinkedCols == 0 || !this.fSelectedCol.linked()) {
            this.fSelectedCol.deleteIntervals();
        }
        if (this.fActOnLinks && this.fSelectedCol.linked()) {
            int n = 0;
            while (n < this.fNumLinkedCols) {
                this.fLinkedCols[n].deleteIntervals();
                ++n;
            }
        }
    }

    public boolean selectedColHasIntervals() {
        if (this.fSelectedCol == null) {
            return false;
        }
        return this.fSelectedCol.hasIntervals();
    }

    public int numDecimalPlaces() {
        return this.fNumDecimalPlaces;
    }

    public void numDecimalPlaces(int n) {
        this.fNumDecimalPlaces = n;
    }

    public void showDependencies(boolean bl) {
        this.fShowDependencies = bl;
    }

    public boolean showDependencies() {
        return this.fShowDependencies;
    }

    public boolean allowComplexFill() {
        return this.fAllowComplexFill;
    }

    public boolean allowIterateFill() {
        return this.fAllowIterateFill;
    }

    public void allowComplexFill(boolean bl) {
        this.fAllowComplexFill = bl;
    }

    public void allowIterateFill(boolean bl) {
        this.fAllowIterateFill = bl;
    }

    public String currentVar() {
        if (this.fSelectedCol == null) {
            return "";
        }
        char c = this.fSelectedCol.depVar();
        if (c == '\u0000') {
            return "";
        }
        return String.valueOf(c);
    }

    public Column selectedColumn() {
        return this.fSelectedCol;
    }

    public int selectedRowNum() {
        return this.fSelectedRow;
    }

    public int runawayFill() {
        return this.fRunawayFill;
    }

    public void runawayFill(int n) {
        this.fRunawayFill = n;
    }

    public boolean colActive() {
        if (this.fSelectedCol == null) {
            return true;
        }
        return this.fSelectedCol.active();
    }

    public boolean isEmptyColumn() {
        if (this.fSelectedCol == null) {
            return true;
        }
        return this.fSelectedCol.isEmpty();
    }

    public boolean dependent() {
        if (this.fSelectedCol != null) {
            return this.fSelectedCol.dependent();
        }
        return false;
    }

    public boolean deleteable() {
        if (this.fSelectedCol != null) {
            return this.deleteable(this.fSelectedCol);
        }
        return false;
    }

    public Color foregroundColor() {
        if (this.fSelectedCol == null) {
            return Color.black;
        }
        return this.fSelectedCol.foregroundColor();
    }

    public void foregroundColor(Color color) {
        if (this.fSelectedCol == null) {
            return;
        }
        this.fSelectedCol.foregroundColor(color);
    }

    public void sendPointsToGraph() {
        int n = 0;
        int n2 = 0;
        if (!this.allowSendPointsToGraph()) {
            return;
        }
        if (this.varMode() == 0) {
            int n3;
            Column column = this.fXTag.column();
            Column column2 = this.fYTag.column();
            int n4 = (int)((double)(column.nudgeFactor() - column2.nudgeFactor()) / 2.0);
            int n5 = 0;
            while (n5 < this.fNumRows) {
                n3 = n5 + n4;
                if (n3 >= 0 && n3 < this.fNumRows && column.row(n5).isNum() && column2.row(n3).isNum()) {
                    ++n;
                }
                ++n5;
            }
            if (n == 0) {
                utils.showErrorDialog(this.fTable, fp_resource.getString("str_error__no_valid_points_in_columns"));
                return;
            }
            double[] dArray = new double[n];
            double[] dArray2 = new double[n];
            int n6 = 0;
            while (n6 < this.fNumRows) {
                n3 = n6 + n4;
                if (n3 >= 0 && n3 < this.fNumRows && column.row(n6).isNum() && column2.row(n3).isNum()) {
                    dArray[n2] = column.row(n6).num();
                    dArray2[n2] = column2.row(n3).num();
                    ++n2;
                }
                ++n6;
            }
            Master.sendPointsToGraph(dArray, dArray2, n, column.depVar(), column2.depVar());
        } else if (this.varMode() == 2) {
            int n7;
            Column column = this.fRTag.column();
            Column column3 = this.fThTag.column();
            int n8 = (int)((double)(column.nudgeFactor() - column3.nudgeFactor()) / 2.0);
            int n9 = 0;
            while (n9 < this.fNumRows) {
                n7 = n9 + n8;
                if (n7 >= 0 && n7 < this.fNumRows && column.row(n9).isNum() && column3.row(n7).isNum()) {
                    ++n;
                }
                ++n9;
            }
            if (n == 0) {
                utils.showErrorDialog(this.fTable, fp_resource.getString("str_error__no_valid_points_in_columns"));
                return;
            }
            double[] dArray = new double[n];
            double[] dArray3 = new double[n];
            int n10 = 0;
            while (n10 < this.fNumRows) {
                n7 = n10 + n8;
                if (n7 >= 0 && n7 < this.fNumRows && column.row(n10).isNum() && column3.row(n7).isNum()) {
                    dArray[n2] = column.row(n10).num();
                    dArray3[n2] = column3.row(n7).num();
                    ++n2;
                }
                ++n10;
            }
            Master.sendPolarPointsToGraph(dArray, dArray3, n);
        }
    }

    public boolean allowSendBarsToGraph() {
        if (this.varMode() != 0) {
            return false;
        }
        Column column = this.fXTag.column();
        Column column2 = this.fYTag.column();
        if (column == null) {
            return false;
        }
        if (column2 == null) {
            return false;
        }
        return (double)(column.nudgeFactor() - column2.nudgeFactor()) / 2.0 != (double)((int)((double)(column.nudgeFactor() - column2.nudgeFactor()) / 2.0));
    }

    public boolean allowSendPointsToGraph() {
        if (this.varMode() == 0) {
            return this.allowSendBarsToGraph() ^ true;
        }
        Column column = this.fRTag.column();
        Column column2 = this.fThTag.column();
        if (column == null) {
            return false;
        }
        if (column2 == null) {
            return false;
        }
        return (double)(column.nudgeFactor() - column2.nudgeFactor()) / 2.0 == (double)((int)((double)(column.nudgeFactor() - column2.nudgeFactor()) / 2.0));
    }

    public void sendBarsToGraph() {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        if (!this.allowSendBarsToGraph()) {
            return;
        }
        if (this.varMode() == 0) {
            Column column = this.fXTag.column();
            Column column2 = this.fYTag.column();
            n3 = (int)((double)(column.nudgeFactor() - column2.nudgeFactor()) / 2.0);
            int n4 = 0;
            int n5 = 0;
            while (n5 < this.fNumRows) {
                int n6 = n5 + n3;
                if (n6 >= 0 && n6 < this.fNumRows && column.row(n5).isNum() && column2.row(n6).isNum()) {
                    n4 = n5;
                    ++n;
                }
                ++n5;
            }
            if (n == 0) {
                utils.showErrorDialog(this.fTable, fp_resource.getString("str_error__no_valid_points_in_xy_columns"));
                return;
            }
            boolean bl = false;
            if (n4 >= this.fNumRows - 1) {
                bl = true;
            } else {
                bl = column.row(n4 + 1).isNum() ^ true;
                if (!bl) {
                    ++n;
                }
            }
            double[] dArray = new double[n];
            double[] dArray2 = new double[n];
            int n7 = 0;
            while (n7 < this.fNumRows) {
                if (column.row(n7).isNum() && column2.row(n7).isNum()) {
                    dArray[n2] = column.row(n7).num();
                    dArray2[n2] = column2.row(n7).num();
                    ++n2;
                }
                ++n7;
            }
            if (!bl) {
                dArray[n2] = column.row(n4 + 1).num();
                dArray2[n2] = 0.0;
            }
            Master.sendBarsToGraph(dArray, dArray2, n);
        }
    }

    public void sendValueToCalc() {
        if (this.fSelectedCol == null) {
            utils.showErrorDialog(this.fTable, fp_resource.getString("str_error__must_have_a_column_selected"));
            return;
        }
        if (this.fSelectedRow < 0 || this.fSelectedStopRow < 0) {
            utils.showErrorDialog(this.fTable, fp_resource.getString("str_error__must_have_a_valid_cell_selected"));
            return;
        }
        if (this.fSelectedRow != this.fSelectedStopRow) {
            utils.showErrorDialog(this.fTable, fp_resource.getString("str_error__must_have_only_a_single_cell_selected"));
            return;
        }
        if (!this.fSelectedCol.row(this.fSelectedRow).isNum()) {
            utils.showErrorDialog(this.fTable, fp_resource.getString("str_error__must_have_a_cell_with_a_numeric_entry_selected"));
            return;
        }
        Master.sendValueToCalc(this.fSelectedCol.row(this.fSelectedRow).num());
    }

    public void doPaste() {
        String string;
        if (this.fSelectedCol == null) {
            utils.showErrorDialog(this.fTable, fp_resource.getString("str_error__must_have_a_column_selected"));
            return;
        }
        if (this.fSelectedRow < 0) {
            utils.showErrorDialog(this.fTable, fp_resource.getString("str_error__must_be_in_data_class"));
            return;
        }
        Transferable transferable = Toolkit.getDefaultToolkit().getSystemClipboard().getContents(this);
        try {
            string = (String)transferable.getTransferData(DataFlavor.stringFlavor);
        }
        catch (UnsupportedFlavorException unsupportedFlavorException) {
            utils.showErrorDialog(this.fTable, fp_resource.getString("str_error__cant_paste_a_nontext_clipboard"));
            return;
        }
        catch (IOException iOException) {
            utils.showErrorDialog(this.fTable, fp_resource.getString("str_error__in_io"));
            return;
        }
        MyStringTokenizer myStringTokenizer = new MyStringTokenizer(string);
        int n = myStringTokenizer.countTokens();
        int n2 = this.fSelectedRow;
        int n3 = 0;
        while (n3 < n) {
            this.fSelectedCol.row(n2).setVal(myStringTokenizer.nextToken());
            if (++n2 >= this.fNumRows) {
                this.addARow();
            }
            if (this.fNumRows == 300) {
                utils.showErrorDialog(this.fTable, fp_resource.getString("str_error__exceeded_maximum_number_of_rows"));
                return;
            }
            ++n3;
        }
        this.reevaluate();
        this.redraw(true);
    }

    public void doClear() {
        if (this.fSelectedCol == null) {
            utils.showErrorDialog(this.fTable, fp_resource.getString("str_error__must_have_a_column_selected"));
            return;
        }
        if (this.fSelectedRow < 0) {
            utils.showErrorDialog(this.fTable, fp_resource.getString("str_error__must_be_in_data_cell"));
            return;
        }
        int n = this.fSelectedRow;
        while (n <= this.fSelectedStopRow) {
            this.fSelectedCol.row(n).setVal("");
            ++n;
        }
        this.reevaluate();
        this.redraw(true);
    }

    public void doCut() {
        this.doCopy();
        this.deleteCells();
    }

    public void doCopy() {
        if (this.fSelectedCol == null) {
            utils.showErrorDialog(this.fTable, fp_resource.getString("str_error__must_have_a_column_selected"));
            return;
        }
        if (this.fSelectedRow < 0) {
            utils.showErrorDialog(this.fTable, fp_resource.getString("str_error__must_be_in_data_cell"));
            return;
        }
        String string = "";
        int n = this.fSelectedRow;
        while (n <= this.fSelectedStopRow) {
            string = String.valueOf(string) + this.fSelectedCol.row(n).str();
            if (n != this.fSelectedStopRow) {
                string = String.valueOf(string) + "\r";
            }
            ++n;
        }
        StringSelection stringSelection = new StringSelection(string);
        Toolkit.getDefaultToolkit().getSystemClipboard().setContents(stringSelection, stringSelection);
    }

    public void setValueTo(double d) {
        if (this.fSelectedCol == null) {
            utils.showErrorDialog(this.fTable, fp_resource.getString("str_error__must_have_a_column_selected"));
            return;
        }
        if (this.fSelectedRow < 0) {
            utils.showErrorDialog(this.fTable, fp_resource.getString("str_error__must_have_data_cells_selected_in_table"));
            return;
        }
        int n = this.fSelectedRow;
        while (n <= this.fSelectedStopRow) {
            this.fSelectedCol.row(n).setVal(d);
            ++n;
        }
        this.reevaluate();
        this.redraw(true);
    }

    public void sendBarsToTable(double[] dArray, double[] dArray2, double[] dArray3, int n, String string, char c) {
        this.fSelectedCol = this.fFirstCol;
        this.selectRow(0);
        this.insertColumnBefore();
        this.recalculate();
        this.insertColumnBefore();
        this.fSelectedCol = null;
        this.selectRow(-1);
        this.dx = 0;
        Column column = this.fFirstCol;
        Column column2 = this.fFirstCol.next;
        this.fFirstCol.labelRow().set(String.valueOf(c));
        this.fFirstCol.next.labelRow().set(string);
        int n2 = 0;
        if (string.equals("heights") || string.equals(fp_resource.getString("str_heights"))) {
            n2 = 1;
        } else if (string.equals("areas") || string.equals(fp_resource.getString("str_areas"))) {
            n2 = 2;
        } else if (string.equals("accum") || string.equals(fp_resource.getString("str_accum"))) {
            n2 = 3;
        } else {
            return;
        }
        double d = 0.0;
        int n3 = 0;
        while (n3 < n) {
            if (n3 >= this.fNumRows) {
                this.addARowNoRedraw();
            }
            if (this.fNumRows == 300) {
                utils.showErrorDialog(this.fTable, fp_resource.getString("str_error__exceeded_maximum_number_of_rows"));
                return;
            }
            column.row(n3).setVal(dArray[n3]);
            d += dArray2[n3] * dArray3[n3];
            switch (n2) {
                case 1: {
                    column2.row(n3).setVal(dArray2[n3]);
                    break;
                }
                case 2: {
                    column2.row(n3).setVal(dArray2[n3] * dArray3[n3]);
                    break;
                }
                case 3: {
                    column2.row(n3).setVal(d);
                    break;
                }
            }
            ++n3;
        }
        if (n3 >= this.fNumRows) {
            this.addARowNoRedraw();
        }
        if (this.fNumRows == 300) {
            utils.showErrorDialog(this.fTable, fp_resource.getString("str_error__exceeded_maximum_number_of_rows"));
            return;
        }
        column.row(n3).setVal(dArray[n3 - 1] + dArray3[n3 - 1]);
        column.nudgeFactor(0);
        column2.nudgeFactor(1);
        this.redraw(true);
    }

    public void sendPointsToTable(double[] dArray, double[] dArray2, int n, char c, char c2) {
        String string;
        this.fSelectedCol = this.fFirstCol;
        this.selectRow(0);
        this.insertColumnBefore();
        this.recalculate();
        this.insertColumnBefore();
        this.fSelectedCol = null;
        this.selectRow(-1);
        this.dx = 0;
        Column column = this.fFirstCol;
        Column column2 = this.fFirstCol.next;
        this.fFirstCol.labelRow().set(fp_resource.getString("str_horiz"));
        this.fFirstCol.next.labelRow().set(fp_resource.getString("str_vert"));
        Column column3 = this.getColumn(c2);
        if (column3 != null) {
            column3.active(false);
            string = fp_resource.getString("str_warning__c_was_already_defined_in_another_column_made_that_column_inactive");
            string = utils.sprintf(string, String.valueOf(c2));
            utils.showWarningDialog(Master.gFrame, string);
        }
        this.fFirstCol.equationRow().set(String.valueOf(c2));
        this.fFirstCol.updateVars();
        column3 = this.getColumn(c);
        if (column3 != null) {
            column3.active(false);
            string = fp_resource.getString("str_warning__c_was_already_defined_in_another_column_made_that_column_inactive");
            string = utils.sprintf(string, String.valueOf(c));
            utils.showWarningDialog(Master.gFrame, string);
        }
        this.fFirstCol.next.equationRow().set(String.valueOf(c));
        this.fFirstCol.next.updateVars();
        int n2 = 0;
        while (n2 < n) {
            if (n2 >= this.fNumRows) {
                this.addARowNoRedraw();
            }
            if (this.fNumRows == 300) {
                utils.showErrorDialog(this.fTable, fp_resource.getString("str_error__exceeded_maximum_number_of_rows"));
                return;
            }
            column.row(n2).setVal(dArray[n2]);
            column2.row(n2).setVal(dArray2[n2]);
            ++n2;
        }
        this.redraw(true);
    }

    public Column appendColumn(int n, int n2, int n3) {
        Column column = new Column(this, this.fNumRows, n, n2, n3);
        if (this.fLastCol == null || this.fFirstCol == null) {
            this.fFirstCol = column;
            this.fLastCol = column;
        } else {
            this.fLastCol.next = column;
            this.fLastCol = column;
        }
        if (this.globallyLinked()) {
            this.linkColumn(column);
        }
        return column;
    }

    public void resetTags() {
        if (this.fFirstCol != null) {
            this.fXTag.column(this.fFirstCol);
            this.fRTag.column(this.fFirstCol);
            if (this.fFirstCol.next != null) {
                this.fYTag.column(this.fFirstCol.next);
                this.fThTag.column(this.fFirstCol.next);
                this.fTTag.column(this.fFirstCol.next);
            } else {
                this.fYTag.column(this.fFirstCol);
                this.fThTag.column(this.fFirstCol);
                this.fTTag.column(this.fFirstCol);
            }
        }
        this.repositionTags();
    }

    public void clearTable() {
        this.clearSelectsNoUpdate();
        this.unlinkColumns();
        Column column = this.firstCol();
        while (column != null) {
            Column column2 = column.next;
            column = null;
            column = column2;
        }
        this.fFirstCol = null;
        this.fLastCol = null;
    }

    public void appendColumn() {
        if (this.fLastCol == null) {
            this.fFirstCol = new Column(this, this.fNumRows, 0, 64, this.fNumDecimalPlaces);
            if (this.globallyLinked()) {
                this.linkColumn(this.fFirstCol);
            }
            this.fLastCol = this.fFirstCol;
            return;
        }
        this.fLastCol.next = new Column(this, this.fNumRows, this.fLastCol.right(), 64, this.fNumDecimalPlaces);
        if (this.globallyLinked()) {
            this.linkColumn(this.fLastCol.next);
        }
        this.fLastCol = this.fLastCol.next;
        this.fLastCol.next = null;
    }

    public void doPrint() {
        if (this.fLastCol == null) {
            return;
        }
        Properties properties = new Properties();
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        PrintJob printJob = toolkit.getPrintJob(this.fTable, fp_resource.getString("str_table"), properties);
        if (printJob == null) {
            return;
        }
        Dimension dimension = printJob.getPageDimension();
        int n = this.fLastCol.right();
        int n2 = this.fLastCol.bottom();
        dimension.width -= 80;
        dimension.height -= 80;
        int n3 = (int)Math.floor((double)n / (double)dimension.width) + 1;
        int n4 = (int)Math.floor((double)n2 / (double)dimension.height) + 1;
        Dimension dimension2 = Master.table().getSize();
        int n5 = 0;
        while (n5 < n4) {
            int n6 = n5 * dimension.height + 40;
            int n7 = 0;
            while (n7 < n3) {
                int n8 = n7 * dimension.width + 40;
                Graphics graphics = printJob.getGraphics();
                graphics.translate(n8, n6);
                graphics.setClip(0, 0, dimension2.width + n8, dimension2.height + n6);
                this.printBackground(graphics);
                graphics.translate(-n8, -n6);
                graphics.dispose();
                ++n7;
            }
            ++n5;
        }
        printJob.end();
    }

    public void doImport() {
        this.clearTable();
        int n = 0;
        FileDialog fileDialog = new FileDialog((Frame)this.fTable, fp_resource.getString("str_open_text_file"), 0);
        fileDialog.setFilenameFilter(new 1());
        ((Component)fileDialog).setVisible(true);
        String string = fileDialog.getFile();
        if (string != null) {
            try {
                FileInputStream fileInputStream = new FileInputStream(String.valueOf(fileDialog.getDirectory()) + string);
                InputStreamReader inputStreamReader = new InputStreamReader(fileInputStream);
                StreamTokenizer streamTokenizer = new StreamTokenizer(inputStreamReader);
                streamTokenizer.eolIsSignificant(true);
                this.copyToUndo(fp_resource.getString("str_undo_import"));
                Column column = this.fFirstCol;
                int n2 = 0;
                while (n != -1) {
                    n = streamTokenizer.nextToken();
                    if (n == -2) {
                        if (column == null) {
                            this.appendColumn();
                            column = this.fLastCol;
                        }
                        if (n2 >= this.fNumRows) {
                            this.addARowNoRedraw();
                        }
                        column.row(n2).set(streamTokenizer.nval);
                        column = column.next;
                        continue;
                    }
                    if (n == -3) {
                        if (column == null) {
                            this.appendColumn();
                            column = this.fLastCol;
                        }
                        if (n2 >= this.fNumRows) {
                            this.addARowNoRedraw();
                        }
                        column.row(n2).set(streamTokenizer.sval);
                        column = column.next;
                        continue;
                    }
                    if (n != 10 && n != -1) continue;
                    ++n2;
                    column = this.fFirstCol;
                }
                fileInputStream.close();
            }
            catch (Exception exception) {
                File file = new File(string);
                String string2 = utils.sprintf(fp_resource.getString("str_error__file_not_text"), string);
                utils.showErrorDialog(this.fTable, string2);
                return;
            }
            this.resetTags();
            this.fTable.setBounds();
            this.redraw(true);
        } else {
            this.cantUndo();
        }
    }

    public void doExport() {
        FileDialog fileDialog = new FileDialog(Master.gFrame, String.valueOf(fp_resource.getString("str_save_as_text_file")) + "...", 1);
        fileDialog.setFile(String.valueOf(fp_resource.getString("str_untitled")) + ".txt");
        ((Component)fileDialog).setVisible(true);
        String string = fileDialog.getFile();
        String string2 = fileDialog.getDirectory();
        if (string != null) {
            if (!string.endsWith(".txt")) {
                utils.showErrorDialog(Master.gFrame, String.valueOf(fp_resource.getString("str_error__file_must_end_with_")) + ".txt");
                return;
            }
            try {
                String string3 = String.valueOf(string2) + string;
                FileWriter fileWriter = new FileWriter(string3);
                char[] cArray = new char[1000];
                int n = 0;
                while (n < this.fNumRows) {
                    Column column = this.fFirstCol;
                    String string4 = "";
                    while (column != null) {
                        TableRow tableRow = column.row(n);
                        string4 = tableRow.isNum() ? String.valueOf(string4) + utils.num2str(tableRow.num()) : String.valueOf(string4) + tableRow.str();
                        if (column == this.fLastCol) {
                            string4 = String.valueOf(string4) + '\n';
                            break;
                        }
                        string4 = String.valueOf(string4) + '\t';
                        column = column.next;
                    }
                    string4.getChars(0, string4.length(), cArray, 0);
                    fileWriter.write(cArray, 0, string4.length());
                    ++n;
                }
                fileWriter.flush();
                fileWriter.close();
            }
            catch (IOException iOException) {
                utils.showErrorDialog(Master.gFrame, String.valueOf(fp_resource.getString("str_error__in_io_during_save")) + ":" + iOException.getMessage());
                return;
            }
        }
    }

    public int getVarColID(String string) {
        Column column = null;
        if (string.equals("x")) {
            column = this.fXTag.column();
        } else if (string.equals("y")) {
            column = this.fYTag.column();
        } else if (string.equals("r")) {
            column = this.fRTag.column();
        } else if (string.equals("theta")) {
            column = this.fThTag.column();
        }
        if (column == null) {
            return -1;
        }
        return column.getID();
    }

    public void setVarColID(String string, int n) {
        if (n == -1) {
            return;
        }
        Column column = this.getColumn(n);
        if (column == null) {
            return;
        }
        if (string.equals("x")) {
            this.fXTag.column(column);
        } else if (string.equals("y")) {
            this.fYTag.column(column);
        } else if (string.equals("r")) {
            this.fRTag.column(column);
        } else if (string.equals("theta")) {
            this.fThTag.column(column);
        }
    }

    public boolean columnValid() {
        if (this.fSelectedCol == null) {
            return false;
        }
        return this.fSelectedCol.hasNumericEntries();
    }

    public int columnData(double[] dArray) {
        if (this.fSelectedCol == null) {
            return 0;
        }
        return this.fSelectedCol.columnData(dArray);
    }

    private final class 1
    implements FilenameFilter {
        public boolean accept(File file, String string) {
            return string.endsWith(".txt");
        }

        /* synthetic */ 1() {
        }
    }
}

