/*
 * Decompiled with CFR 0.152.
 */
package com.questmsm.FPTable;

import com.questmsm.FPTable.Column;
import com.questmsm.FPTable.SubElement;
import com.questmsm.FPTable.TableEquation;
import com.questmsm.FPTable.TablePanel;
import com.questmsm.Utilities.BadComputationException;
import com.questmsm.Utilities.FPNumberFormatException;
import com.questmsm.Utilities.fp_resource;
import com.questmsm.Utilities.utils;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;

public class TableRow {
    protected boolean fIsNum;
    protected double fNum;
    protected String fStr;
    protected static final Font fFont = new Font("Times", 0, 12);
    protected static final Font fItalicFont = new Font("Times", 2, 12);
    protected static FontMetrics fMetric;
    protected TablePanel fContainer;
    protected static final Color kBackground;
    protected static final Color kForeground;
    protected static final int kMaxElements = 50;
    protected int fNumElements;
    protected SubElement[] fElement = new SubElement[50];
    protected int fSelectedStart;
    protected int fSelectedStop;
    protected int fTop;
    protected int fLeft;
    protected int fHeight;
    protected int fWidth;
    protected static final int kOffset = 3;
    private Column fColumn;
    protected int fRowNum = 0;

    static {
        kBackground = Color.white;
        kForeground = Color.black;
    }

    public TableRow(TablePanel tablePanel, Column column) {
        this.fContainer = tablePanel;
        fMetric = this.fContainer.getFontMetrics(fFont);
        this.fNumElements = 0;
        this.fSelectedStart = -1;
        this.fSelectedStop = -1;
        this.fTop = 0;
        this.fLeft = 0;
        this.fHeight = 0;
        this.fWidth = 0;
        this.fColumn = column;
    }

    public TableRow(TablePanel tablePanel, double d, Column column) {
        this.fContainer = tablePanel;
        fMetric = this.fContainer.getFontMetrics(fFont);
        this.fIsNum = true;
        this.fNum = d;
        this.fStr = String.valueOf(d);
        this.fNumElements = 0;
        this.fTop = 0;
        this.fLeft = 0;
        this.fHeight = 0;
        this.fWidth = 0;
        this.fSelectedStart = -1;
        this.fSelectedStop = -1;
        int n = 0;
        while (n < this.fStr.length()) {
            this.add(this.fStr.charAt(n));
            ++n;
        }
        this.fSelectedStart = -1;
        this.fSelectedStop = -1;
        this.fColumn = column;
    }

    public TableRow(TablePanel tablePanel, String string, Column column, int n) {
        this.fContainer = tablePanel;
        fMetric = this.fContainer.getFontMetrics(fFont);
        this.fIsNum = false;
        this.fStr = string;
        this.fNum = 0.0;
        this.fRowNum = n;
        this.fNumElements = 0;
        this.fTop = 0;
        this.fLeft = 0;
        this.fHeight = 0;
        this.fWidth = 0;
        this.fSelectedStart = -1;
        this.fSelectedStop = -1;
        int n2 = 0;
        while (n2 < this.fStr.length()) {
            this.add(this.fStr.charAt(n2));
            ++n2;
        }
        this.fSelectedStart = -1;
        this.fSelectedStop = -1;
        this.fColumn = column;
    }

    public boolean inside(int n, int n2) {
        return n2 >= this.fTop && n2 <= this.fTop + this.fHeight;
    }

    public void clear() {
        this.fNumElements = 0;
        this.fSelectedStart = -1;
        this.fSelectedStop = -1;
        this.fStr = "";
        this.fNum = 0.0;
    }

    public void recalculateFlushLeft(int n, int n2, int n3, int n4) {
        this.fLeft = n;
        this.fWidth = n2;
        this.fTop = n3;
        this.fHeight = n4;
        int n5 = this.fLeft + 3;
        int n6 = 0;
        int n7 = 0;
        while (n7 < this.fNumElements) {
            char c = this.fElement[n7].theChar();
            n6 = this.fElement[n7].width(fMetric);
            this.fElement[n7].setSpacing(n5, n5 + n6, n3, 15);
            n5 += n6;
            ++n7;
        }
    }

    public void recalculateFlushRight(int n, int n2, int n3, int n4) {
        this.fLeft = n;
        this.fWidth = n2;
        this.fTop = n3;
        this.fHeight = n4;
        int n5 = this.fLeft + this.fWidth - 3;
        int n6 = 0;
        int n7 = this.fNumElements - 1;
        while (n7 >= 0) {
            char c = this.fElement[n7].theChar();
            n6 = this.fElement[n7].width(fMetric);
            this.fElement[n7].setSpacing(n5 - n6, n5, n3, 15);
            n5 -= n6;
            --n7;
        }
    }

    public void recalculateFlushCenter(int n, int n2, int n3, int n4) {
        char c;
        int n5;
        int n6;
        this.fLeft = n;
        this.fWidth = n2;
        this.fTop = n3;
        this.fHeight = n4;
        int n7 = 0;
        int n8 = 0;
        int n9 = 0;
        int n10 = 0;
        int n11 = 0;
        int n12 = 0;
        while (n7 < this.fNumElements) {
            if (this.fElement[n7].theChar() == '\n' || this.fElement[n7].theChar() == '\r') {
                n9 = n7 - 1;
                n10 = 0;
                n6 = n8;
                while (n6 <= n9) {
                    n10 += this.fElement[n6].width(fMetric);
                    ++n6;
                }
                n11 = this.fLeft + (this.fWidth - n10) / 2;
                n5 = n8;
                while (n5 <= n9) {
                    c = this.fElement[n5].theChar();
                    n12 = this.fElement[n5].width(fMetric);
                    this.fElement[n5].setSpacing(n11, n11 + n12, n3, 15);
                    n11 += n12;
                    ++n5;
                }
                this.fElement[n7].setSpacing(n11, n11, n3, 15);
                n3 += 15;
                n8 = n7;
            }
            ++n7;
        }
        n9 = this.fNumElements - 1;
        n10 = 0;
        n6 = n8;
        while (n6 <= n9) {
            n10 += this.fElement[n6].width(fMetric);
            ++n6;
        }
        n11 = this.fLeft + (this.fWidth - n10) / 2;
        n5 = n8;
        while (n5 <= n9) {
            c = this.fElement[n5].theChar();
            n12 = this.fElement[n5].width(fMetric);
            this.fElement[n5].setSpacing(n11, n11 + n12, n3, 15);
            n11 += n12;
            ++n5;
        }
    }

    public void recalculatePositions(int n, int n2, int n3, int n4, int n5) {
        if (!this.fIsNum && !this.fStr.equals("") || this.fIsNum && this.fContainer.displayAsEquations() && this.fColumn.equationString() != null) {
            this.recalculateFlushLeft(n, n2, n3, n4);
        } else {
            this.recalculateFlushRight(n, n2, n3, n4);
        }
        this.fRowNum = n5;
    }

    public void deleteSelected() {
        int n;
        if (!this.fColumn.active()) {
            return;
        }
        if (this.fSelectedStart > this.fSelectedStop) {
            n = this.fSelectedStart;
            this.fSelectedStart = this.fSelectedStop;
            this.fSelectedStop = n;
        }
        n = this.fSelectedStop - this.fSelectedStart + 1;
        int n2 = this.fSelectedStart;
        while (n2 < this.fNumElements - n) {
            this.fElement[n2] = this.fElement[n2 + n];
            ++n2;
        }
        this.fNumElements -= n;
        if (this.fNumElements < 0) {
            this.fNumElements = 0;
        }
    }

    private void setStr() {
        this.fStr = "";
        if (this.fNumElements == 0) {
            this.fIsNum = true;
            return;
        }
        int n = 0;
        while (n < this.fNumElements) {
            this.fStr = String.valueOf(this.fStr) + String.valueOf(this.fElement[n].theChar());
            ++n;
        }
        if (this.fNumElements <= 0) {
            this.fNumElements = 0;
            this.fNum = 0.0;
            this.fIsNum = false;
            return;
        }
        if (this.fElement[this.fNumElements - 1].theChar() == '\n' || this.fElement[this.fNumElements - 1].theChar() == '\r') {
            return;
        }
        double d = 0.0;
        try {
            d = utils.str2num(this.fStr);
            if (d == -1.23456123) {
                throw new FPNumberFormatException();
            }
        }
        catch (FPNumberFormatException fPNumberFormatException) {
            this.fNum = 0.0;
            this.fIsNum = false;
            return;
        }
        this.fNum = d;
        this.fIsNum = true;
    }

    public void insert(char c) {
        if (!this.fColumn.active()) {
            return;
        }
        if (c == '\b') {
            this.backspace();
            return;
        }
        if (c == '\u007f') {
            this.deletekey();
            return;
        }
        if (this.fNumElements == 50) {
            return;
        }
        if (this.fSelectedStart == -1) {
            this.fSelectedStart = 0;
        }
        if (this.fSelectedStop != -1) {
            this.deleteSelected();
        }
        if (this.fNumElements == 50) {
            return;
        }
        int n = this.fNumElements;
        while (n > this.fSelectedStart) {
            this.fElement[n] = this.fElement[n - 1];
            --n;
        }
        this.fElement[this.fSelectedStart] = new SubElement(c);
        ++this.fSelectedStart;
        ++this.fNumElements;
        this.fSelectedStop = -1;
        this.setStr();
        this.recalculatePositions(this.fLeft, this.fWidth, this.fTop, this.fHeight, this.fRowNum);
    }

    public void deletekey() {
        if (!this.fColumn.active()) {
            return;
        }
        if (this.fNumElements == 0) {
            return;
        }
        if (this.fSelectedStart < 0) {
            return;
        }
        if (this.fSelectedStop == -1) {
            if (this.fSelectedStart == this.fNumElements) {
                return;
            }
            this.fSelectedStop = this.fSelectedStart;
            this.deleteSelected();
            this.fSelectedStop = -1;
            this.setStr();
            this.recalculatePositions(this.fLeft, this.fWidth, this.fTop, this.fHeight, this.fRowNum);
            return;
        }
        this.deleteSelected();
        this.fSelectedStop = -1;
        this.setStr();
        this.recalculatePositions(this.fLeft, this.fWidth, this.fTop, this.fHeight, this.fRowNum);
    }

    public void backspace() {
        if (!this.fColumn.active()) {
            return;
        }
        if (this.fNumElements == 0) {
            return;
        }
        if (this.fSelectedStart < 0) {
            return;
        }
        if (this.fSelectedStop == -1) {
            if (this.fSelectedStart == 0) {
                return;
            }
            --this.fSelectedStart;
            this.fSelectedStop = this.fSelectedStart;
            this.deleteSelected();
            this.fSelectedStop = -1;
            this.setStr();
            this.recalculatePositions(this.fLeft, this.fWidth, this.fTop, this.fHeight, this.fRowNum);
            return;
        }
        this.deleteSelected();
        this.fSelectedStop = -1;
        this.setStr();
        this.recalculatePositions(this.fLeft, this.fWidth, this.fTop, this.fHeight, this.fRowNum);
    }

    public void add(char c) {
        if (!this.fColumn.active()) {
            return;
        }
        if (this.fNumElements == 50) {
            return;
        }
        this.fElement[this.fNumElements] = new SubElement(c);
        ++this.fNumElements;
        this.fSelectedStart = this.fNumElements;
        this.fSelectedStop = -1;
        this.recalculatePositions(this.fLeft, this.fWidth, this.fTop, this.fHeight, this.fRowNum);
    }

    public int left() {
        int n = 0;
        if (this.fNumElements > 0) {
            n = this.fElement[0].left();
        }
        return n;
    }

    public int right() {
        int n = 0;
        if (this.fNumElements > 0) {
            n = this.fElement[this.fNumElements - 1].right();
        }
        return n;
    }

    public int top() {
        return this.fTop;
    }

    public int bottom() {
        return this.fTop + this.fHeight;
    }

    public void erase(Graphics graphics) {
        graphics.setColor(this.fColumn.backgroundColor());
        graphics.fillRect(this.fLeft + 2, this.fTop + 1, this.fWidth - 3, this.fHeight - 2);
    }

    public boolean selected() {
        return this.fSelectedStart != -1;
    }

    public boolean tryToMoveLeft() {
        if (this.fSelectedStart <= 0) {
            return false;
        }
        --this.fSelectedStart;
        this.fSelectedStop = -1;
        return true;
    }

    public boolean tryToMoveRight() {
        if (this.fSelectedStart == -1) {
            return false;
        }
        if (this.fSelectedStart == this.fNumElements) {
            return false;
        }
        if (this.fSelectedStop == -1) {
            ++this.fSelectedStart;
            this.fSelectedStop = -1;
        } else {
            if (this.fSelectedStop >= this.fNumElements - 1) {
                return false;
            }
            this.fSelectedStart = this.fSelectedStop + 1;
            this.fSelectedStop = -1;
        }
        return true;
    }

    public void clearSelects() {
        Object object;
        this.fSelectedStart = -1;
        this.fSelectedStop = -1;
        if (!this.fIsNum) {
            if (this.fStr == null) {
                this.set("");
                return;
            }
            if (this.fStr.length() == 0) {
                this.set("");
                return;
            }
            if (this.fStr.charAt(0) == '=') {
                object = new TableEquation(this.fStr, this.fContainer);
                try {
                    double d = ((TableEquation)object).eval(this.fContainer, this.fRowNum);
                    if (d == -1.23456123 || d == -0.7654321) {
                        throw new BadComputationException();
                    }
                    this.set(d);
                }
                catch (BadComputationException badComputationException) {
                    this.set(fp_resource.getString("str_undefined"));
                    return;
                }
            }
            if (this.fRowNum >= 0) {
                try {
                    TableEquation tableEquation = new TableEquation("=" + this.fStr, this.fContainer);
                    double d = tableEquation.eval(this.fContainer, this.fRowNum);
                    if (d == -1.23456123 || d == -0.7654321) {
                        this.set(fp_resource.getString("str_error"));
                    } else {
                        this.set(d);
                    }
                }
                catch (BadComputationException badComputationException) {
                    this.set(fp_resource.getString("str_undefined"));
                }
                return;
            }
        } else if (this.fContainer.displayAsEquations()) {
            this.fStr = this.fColumn.equationString();
            this.fNumElements = 0;
            if (this.fStr != null) {
                int n = 0;
                while (n < this.fStr.length()) {
                    this.add(this.fStr.charAt(n));
                    ++n;
                }
                return;
            }
            this.fStr = "=";
        }
        if (this.fIsNum) {
            if (this.fStr == null) {
                this.set("");
                return;
            }
            if (this.fStr.length() == 0) {
                this.set("");
                return;
            }
            object = "";
            object = Double.isNaN(this.fNum) || Double.isInfinite(this.fNum) ? fp_resource.getString("str_undefined") : (this.fColumn.sciNotation() ? utils.num2scistr(this.fNum, this.fColumn.numDecimalPlaces()) : utils.num2str(this.fNum, this.fColumn.numDecimalPlaces()));
            if (!this.fStr.equals(object)) {
                this.fStr = object;
                this.fNumElements = 0;
                int n = 0;
                while (n < this.fStr.length()) {
                    this.add(this.fStr.charAt(n));
                    ++n;
                }
            }
        }
    }

    public void draw(Graphics graphics) {
        this.draw(graphics, 0);
    }

    public void draw(Graphics graphics, int n) {
        int n2 = this.fLeft;
        int n3 = this.fLeft + this.fWidth;
        int n4 = this.fTop;
        int n5 = this.fHeight;
        if (n > this.fTop) {
            n4 = n;
            n5 = this.fHeight - (n - this.fTop);
            if (n5 < 0) {
                return;
            }
        }
        graphics.setClip(this.fLeft, n4, this.fWidth, n5);
        this.erase(graphics);
        if (this.fColumn.active()) {
            graphics.setFont(fFont);
        } else {
            graphics.setFont(fItalicFont);
        }
        graphics.setColor(this.fColumn.foregroundColor());
        int n6 = 0;
        while (n6 < this.fNumElements) {
            if (this.fElement[n6].theChar() != '\n' && this.fElement[n6].right() >= n2 && this.fElement[n6].left() <= n3 && this.fElement[n6].bottom() >= this.fTop && this.fElement[n6].top() <= this.fTop + this.fHeight) {
                if (this.isNum() || this.fRowNum == -3) {
                    this.fElement[n6].draw(graphics);
                } else {
                    this.fElement[n6].drawNoSpecialChars(graphics);
                }
            }
            ++n6;
        }
        graphics.setClip(-16000, -16000, 32000, 32000);
    }

    private void drawCaret(Graphics graphics, int n, int n2) {
        graphics.setColor(Color.red);
        graphics.drawLine(n - 1, n2 + 15 - 1, n + 2 - 1, n2 + 15 + 1);
        graphics.drawLine(n - 1, n2 + 15 - 1, n - 2 - 1, n2 + 15 + 1);
        graphics.drawLine(n - 1, n2 + 2, n - 1, n2 + 15 - 1);
        graphics.drawLine(n - 1, n2 + 2, n + 2 - 1, n2);
        graphics.drawLine(n - 1, n2 + 2, n - 2 - 1, n2);
        graphics.setColor(Color.black);
    }

    public void drawSelected(Graphics graphics, int n) {
        int n2 = this.fLeft;
        int n3 = this.fLeft + this.fWidth;
        int n4 = this.fTop;
        int n5 = this.fHeight;
        if (n > this.fTop) {
            n4 = n;
            n5 = this.fHeight - (n - this.fTop);
            if (n5 < 0) {
                return;
            }
        }
        graphics.setClip(this.fLeft, n4, this.fWidth, n5);
        if (this.fColumn.active()) {
            graphics.setFont(fFont);
        } else {
            graphics.setFont(fItalicFont);
        }
        int n6 = 0;
        if (this.fRowNum < 0) {
            n6 = 1;
        }
        if (this.fSelectedStart == -1) {
            graphics.setClip(-16000, -16000, 32000, 32000);
            return;
        }
        if (this.fSelectedStop == -1) {
            int n7;
            int n8;
            if (this.fSelectedStart == this.fNumElements) {
                if (this.fSelectedStart == 0) {
                    graphics.setColor(Color.lightGray);
                    graphics.fillRect(this.fLeft + 1 + n6, this.fTop + n6, this.fWidth - 1 - 2 * n6, this.fHeight - 2 * n6);
                } else {
                    int n9;
                    int n10;
                    if (this.fElement[this.fSelectedStart - 1].theChar() == '\n') {
                        n10 = (n2 + n3) / 2;
                        n9 = 0;
                        int n11 = this.fSelectedStart - 2;
                        while (n11 >= 0) {
                            if (this.fElement[n11].theChar() != '\n') {
                                n9 = this.fElement[n11].top() + 15;
                                break;
                            }
                            --n11;
                        }
                    } else {
                        n10 = this.fElement[this.fSelectedStart - 1].right();
                        n9 = this.fElement[this.fSelectedStart - 1].top();
                    }
                    if (n10 < n2 || n10 > n3) {
                        graphics.setClip(-16000, -16000, 32000, 32000);
                        return;
                    }
                    this.drawCaret(graphics, n10, n9);
                }
                graphics.setClip(-16000, -16000, 32000, 32000);
                return;
            }
            if (this.fElement[this.fSelectedStart] == null) {
                graphics.setClip(-16000, -16000, 32000, 32000);
                return;
            }
            if (this.fElement[this.fSelectedStart].theChar() == '\n') {
                int n12 = this.fSelectedStart - 1;
                if (n12 < 0) {
                    n12 = 0;
                }
                n8 = this.fElement[n12].right();
                n7 = this.fElement[n12].top();
            } else {
                n8 = this.fElement[this.fSelectedStart].left();
                n7 = this.fElement[this.fSelectedStart].top();
            }
            if (n8 < n2 || n8 > n3) {
                return;
            }
            this.drawCaret(graphics, n8, n7);
            graphics.setClip(-16000, -16000, 32000, 32000);
            return;
        }
        int n13 = 0;
        int n14 = 0;
        if (this.fSelectedStart > this.fSelectedStop) {
            n13 = this.fSelectedStop;
            n14 = this.fSelectedStart;
        } else {
            n13 = this.fSelectedStart;
            n14 = this.fSelectedStop;
        }
        if (n13 == 0 && n14 >= this.fNumElements - 1) {
            graphics.setColor(Color.lightGray);
            graphics.fillRect(this.fLeft + 1 + n6, this.fTop + n6, this.fWidth - 1 - 2 * n6, this.fHeight - 2 * n6);
        }
        if (n14 > this.fNumElements - 1 && this.fNumElements > 0) {
            n14 = this.fNumElements - 1;
        }
        graphics.setColor(this.fColumn.foregroundColor());
        int n15 = n13;
        while (n15 <= n14) {
            if (this.fElement[n15].right() >= n2 && this.fElement[n15].left() <= n3) {
                if (this.isNum() || this.fRowNum == -3) {
                    this.fElement[n15].drawInv(graphics);
                } else {
                    this.fElement[n15].drawInvNoSpecialChars(graphics);
                }
            }
            ++n15;
        }
        graphics.setClip(-16000, -16000, 32000, 32000);
    }

    public boolean allSelected() {
        int n = 0;
        int n2 = 0;
        if (this.fSelectedStart > this.fSelectedStop) {
            n = this.fSelectedStop;
            n2 = this.fSelectedStart;
        } else {
            n = this.fSelectedStart;
            n2 = this.fSelectedStop;
        }
        return n == 0 && n2 >= this.fNumElements - 1;
    }

    private Point findSelectedRowElements(int n, int n2) {
        int n3 = -1;
        int n4 = -1;
        int n5 = 0;
        int n6 = 0;
        while (n6 < this.fNumElements) {
            if (n2 >= this.fElement[n6].top() && n2 <= this.fElement[n6].bottom()) {
                n3 = n6;
                n5 = n6;
                while (n5 < this.fNumElements) {
                    if (this.fElement[n5].top() > n2) break;
                    ++n5;
                }
                n4 = n5;
                break;
            }
            ++n6;
        }
        return new Point(n3, n4);
    }

    public boolean handleDrag(int n, int n2) {
        if (n2 < this.fTop || n2 > this.fTop + this.fHeight) {
            if (this.fSelectedStart == -1) {
                return false;
            }
            this.selectAll();
            return true;
        }
        if (this.fSelectedStart == -1) {
            return false;
        }
        this.fSelectedStop = -1;
        if (this.fNumElements == 0) {
            return false;
        }
        Point point = this.findSelectedRowElements(n, n2);
        int n3 = point.x;
        int n4 = point.y;
        if (n3 == -1 || n4 == -1) {
            return false;
        }
        if (n < this.fElement[n3].left()) {
            this.fSelectedStop = n3;
            return true;
        }
        int n5 = n3;
        while (n5 < n4) {
            if (this.fElement[n5].inside(n, n2)) {
                this.fSelectedStop = n5;
                if (this.fSelectedStart >= this.fNumElements) {
                    this.fSelectedStart = this.fNumElements - 1;
                }
                return true;
            }
            ++n5;
        }
        this.fSelectedStop = n4;
        if (this.fSelectedStart >= this.fNumElements) {
            this.fSelectedStart = this.fNumElements - 1;
        }
        return true;
    }

    public boolean handleMouse(int n, int n2) {
        this.fSelectedStart = -1;
        if (n2 < this.fTop) {
            return false;
        }
        if (n2 > this.fTop + this.fHeight) {
            return false;
        }
        if (n < this.fLeft) {
            return false;
        }
        if (n > this.fLeft + this.fWidth) {
            return false;
        }
        if (this.fNumElements == 0) {
            this.fSelectedStart = 0;
            this.fSelectedStop = -1;
            return true;
        }
        if (n2 > this.fElement[this.fNumElements - 1].bottom()) {
            this.fSelectedStart = this.fNumElements;
            this.fSelectedStop = -1;
            return true;
        }
        Point point = this.findSelectedRowElements(n, n2);
        int n3 = point.x;
        int n4 = point.y;
        if (n3 == -1 || n4 == -1) {
            return false;
        }
        if (n < this.fElement[n3].left()) {
            this.fSelectedStart = n3 + 1;
            if (n3 == 0) {
                this.fSelectedStart = 0;
            }
            this.fSelectedStop = -1;
            return true;
        }
        int n5 = n3;
        while (n5 < n4) {
            if (n5 == this.fNumElements) break;
            if (this.fElement[n5].inside(n, n2)) {
                this.fSelectedStart = n5;
                this.fSelectedStop = -1;
                if (n - this.fElement[n5].left() > this.fElement[n5].right() - n) {
                    this.fSelectedStart = n5 + 1;
                }
                return true;
            }
            ++n5;
        }
        this.fSelectedStart = n4;
        this.fSelectedStop = -1;
        return true;
    }

    public int selectedRange() {
        if (this.fSelectedStop < 0) {
            return 0;
        }
        if (this.fSelectedStart > this.fSelectedStop) {
            int n = this.fSelectedStart;
            this.fSelectedStart = this.fSelectedStop;
            this.fSelectedStop = n;
        }
        return this.fSelectedStop - this.fSelectedStart + 1;
    }

    public void selectAll() {
        this.fSelectedStart = 0;
        this.fSelectedStop = this.fNumElements - 1;
    }

    public boolean isEmpty() {
        return this.fNumElements == 0;
    }

    public boolean isNum() {
        return this.fIsNum;
    }

    public double num() {
        return this.fNum;
    }

    public String str() {
        return this.fStr;
    }

    public void set(double d, String string) {
        String string2 = "";
        this.fIsNum = true;
        this.fNum = d;
        this.fNumElements = 0;
        this.fStr = this.fColumn.equationString();
        if (this.fStr == null) {
            return;
        }
        int n = 0;
        while (n < this.fStr.length()) {
            this.add(this.fStr.charAt(n));
            ++n;
        }
        this.fSelectedStart = -1;
        this.fSelectedStop = -1;
    }

    public void set(double d) {
        String string = "";
        this.fIsNum = true;
        this.fNum = d;
        string = !this.fColumn.addTrailingZeros() ? (this.fColumn.sciNotation() ? utils.num2scistr(this.fNum, this.fColumn.numDecimalPlaces()) : utils.num2str(this.fNum + 0.0, this.fColumn.numDecimalPlaces())) : (this.fColumn.sciNotation() ? utils.num2scistrwith0s(this.fNum, this.fColumn.numDecimalPlaces()) : utils.num2strwith0s(this.fNum, this.fColumn.numDecimalPlaces()));
        if (!this.fStr.equals(string)) {
            this.fStr = string;
            this.fNumElements = 0;
            int n = 0;
            while (n < this.fStr.length()) {
                this.add(this.fStr.charAt(n));
                ++n;
            }
        }
        this.fSelectedStart = -1;
        this.fSelectedStop = -1;
    }

    public void set(String string) {
        this.fIsNum = false;
        this.fNum = 0.0;
        this.fNumElements = 0;
        if (string == null) {
            this.fStr = "";
        } else {
            this.fStr = string;
            int n = 0;
            while (n < this.fStr.length()) {
                this.add(this.fStr.charAt(n));
                ++n;
            }
        }
        this.fSelectedStart = -1;
        this.fSelectedStop = -1;
    }

    public void setVal(double d) {
        this.set(d);
    }

    public void setVal(TableRow tableRow) {
        if (tableRow.isNum()) {
            this.set(tableRow.num());
        } else {
            this.set(tableRow.str());
        }
    }

    public void setVal(String string) {
        if (string.length() == 0) {
            this.set("");
            return;
        }
        if (string.length() > 1 && string.charAt(1) == '=') {
            TableEquation tableEquation = new TableEquation(string, this.fContainer);
            try {
                double d = tableEquation.eval(this.fContainer, this.fRowNum);
                if (d == -1.23456123 || d == -0.7654321) {
                    throw new BadComputationException();
                }
                this.set(d);
            }
            catch (BadComputationException badComputationException) {
                this.set(fp_resource.getString("str_undefined"));
            }
            return;
        }
        try {
            double d = Double.valueOf(string);
            this.set(d);
        }
        catch (NumberFormatException numberFormatException) {
            this.set(string);
        }
    }
}

