/*
 * Decompiled with CFR 0.152.
 */
package com.questmsm.FPTable;

import com.questmsm.FPTable.Column;
import com.questmsm.FPTable.TablePanel;
import com.questmsm.FPTable.TableRow;
import java.awt.Color;

public class UndoTable {
    private TablePanel tpanel;
    private boolean fUndoable;
    private String fUndoString;
    private int NumColumns;
    private int NumRows;
    private int[] NumIntervals;
    private int[][] IntervalLoc;
    private String[] EquationStr;
    private String[] LabelStr;
    private int[] NumDecPlaces;
    private boolean[] Scientific;
    private char[] DepVar;
    private int[] Width;
    private int[] NudgeFactor;
    private int[] WidgetMode;
    private boolean[] Active;
    private boolean[] Dependent;
    private double[] AccumStart;
    private int[] EqType;
    private boolean[] Linked;
    private Color[] Colors;
    private int[] ID;
    private int idCounter;
    private boolean[][] IsNum;
    private String[][] Str;
    private double[][] Num;
    private int[][] Dependents;
    private int[] NumColsDependsOn;
    private int varmode;
    private boolean displayasequations;
    private int runawayfill;
    private boolean allowiteratefill;
    private boolean allowcomplexfill;
    private boolean showdependencies;
    private boolean actonlinks;
    private int numdecimalplaces;
    private int DX;
    private int DY;
    private int xTagColID;
    private int yTagColID;
    private int rTagColID;
    private int thTagColID;

    public UndoTable(TablePanel tablePanel) {
        this.tpanel = tablePanel;
        this.fUndoable = false;
        this.fUndoString = "";
    }

    public String undoString() {
        return this.fUndoString;
    }

    public boolean undoable() {
        return this.fUndoable;
    }

    public void undoable(boolean bl) {
        this.fUndoable = bl;
        if (!bl) {
            this.fUndoString = "";
        }
    }

    public void copyToUndo(String string) {
        this.fUndoString = string;
        this.NumColumns = this.tpanel.numColumns();
        this.NumRows = this.tpanel.numRows();
        this.xTagColID = this.tpanel.getVarColID("x");
        this.yTagColID = this.tpanel.getVarColID("y");
        this.rTagColID = this.tpanel.getVarColID("r");
        this.thTagColID = this.tpanel.getVarColID("theta");
        this.actonlinks = this.tpanel.actOnLinks();
        this.numdecimalplaces = this.tpanel.numDecimalPlaces();
        this.showdependencies = this.tpanel.showDependencies();
        this.allowcomplexfill = this.tpanel.allowComplexFill();
        this.allowiteratefill = this.tpanel.allowIterateFill();
        this.runawayfill = this.tpanel.runawayFill();
        this.displayasequations = this.tpanel.displayAsEquations();
        this.DX = this.tpanel.dx;
        this.DY = this.tpanel.dy;
        this.varmode = this.tpanel.varMode();
        if (this.NumColumns > 0) {
            this.NumIntervals = new int[this.NumColumns];
            this.IntervalLoc = new int[this.NumColumns][];
            this.EquationStr = new String[this.NumColumns];
            this.LabelStr = new String[this.NumColumns];
            this.NumDecPlaces = new int[this.NumColumns];
            this.Scientific = new boolean[this.NumColumns];
            this.DepVar = new char[this.NumColumns];
            this.Width = new int[this.NumColumns];
            this.NudgeFactor = new int[this.NumColumns];
            this.WidgetMode = new int[this.NumColumns];
            this.Active = new boolean[this.NumColumns];
            this.Dependent = new boolean[this.NumColumns];
            this.AccumStart = new double[this.NumColumns];
            this.EqType = new int[this.NumColumns];
            this.Linked = new boolean[this.NumColumns];
            this.IsNum = new boolean[this.NumColumns][];
            this.Str = new String[this.NumColumns][];
            this.Num = new double[this.NumColumns][];
            this.Dependents = new int[this.NumColumns][20];
            this.NumColsDependsOn = new int[this.NumColumns];
            this.ID = new int[this.NumColumns];
            this.Colors = new Color[this.NumColumns];
            this.idCounter = Column.gIdentifier;
            Column column = this.tpanel.firstCol();
            int n = 0;
            while (n < this.NumColumns) {
                this.NumIntervals[n] = column.numIntervals();
                this.EquationStr[n] = column.equationRow().str();
                this.LabelStr[n] = column.labelRow().str();
                this.NumDecPlaces[n] = column.numDecimalPlaces();
                this.Scientific[n] = column.sciNotation();
                this.DepVar[n] = column.depVar();
                this.Width[n] = column.width();
                this.NudgeFactor[n] = column.nudgeFactor();
                this.WidgetMode[n] = column.widgetMode();
                this.Active[n] = column.active();
                this.Dependent[n] = column.dependent();
                this.NumColsDependsOn[n] = column.getDepColIndices(this.Dependents[n]);
                this.AccumStart[n] = column.accumStart();
                this.EqType[n] = column.equationType();
                this.Linked[n] = column.linked();
                this.Colors[n] = column.foregroundColor();
                this.ID[n] = column.getID();
                if (this.NumIntervals[n] > 1) {
                    this.IntervalLoc[n] = new int[this.NumIntervals[n] - 1];
                    int n2 = 0;
                    while (n2 < this.NumIntervals[n] - 1) {
                        this.IntervalLoc[n][n2] = column.intervalLoc(n2);
                        ++n2;
                    }
                }
                this.IsNum[n] = new boolean[this.NumRows];
                this.Str[n] = new String[this.NumRows];
                this.Num[n] = new double[this.NumRows];
                int n3 = 0;
                while (n3 < this.NumRows) {
                    TableRow tableRow = column.row(n3);
                    this.IsNum[n][n3] = tableRow.isNum();
                    this.Str[n][n3] = tableRow.str();
                    this.Num[n][n3] = tableRow.num();
                    ++n3;
                }
                column = column.next;
                ++n;
            }
        }
        this.fUndoable = true;
    }

    public void undo() {
        if (!this.fUndoable) {
            return;
        }
        this.tpanel.clearTable();
        this.tpanel.numRows(this.NumRows);
        Column.gIdentifier = this.idCounter;
        int n = 0;
        int n2 = 0;
        while (n2 < this.NumColumns) {
            Column column = this.tpanel.appendColumn(n, this.Width[n2], this.NumDecPlaces[n2]);
            n += this.Width[n2];
            int n3 = 0;
            while (n3 < this.NumIntervals[n2] - 1) {
                column.addInterval(this.IntervalLoc[n2][n3]);
                ++n3;
            }
            column.equationRow().set(this.EquationStr[n2]);
            column.labelRow().set(this.LabelStr[n2]);
            column.depVar(this.DepVar[n2]);
            column.nudgeFactor(this.NudgeFactor[n2]);
            column.widgetMode(this.WidgetMode[n2]);
            column.active(this.Active[n2]);
            column.dependent(this.Dependent[n2]);
            column.accumStart(this.AccumStart[n2]);
            column.equationType(this.EqType[n2]);
            column.foregroundColor(this.Colors[n2]);
            column.setDependencies(this.NumColsDependsOn[n2], this.Dependents[n2]);
            column.setID(this.ID[n2]);
            if (this.Linked[n2]) {
                this.tpanel.linkColumn(column);
            }
            int n4 = 0;
            while (n4 < this.NumRows) {
                if (this.IsNum[n2][n4]) {
                    column.row(n4).set(this.Num[n2][n4]);
                } else {
                    column.row(n4).set(this.Str[n2][n4]);
                }
                ++n4;
            }
            if (this.Scientific[n2]) {
                column.sciNotation(true);
            }
            ++n2;
        }
        this.tpanel.setVarColID("x", this.xTagColID);
        this.tpanel.setVarColID("y", this.yTagColID);
        this.tpanel.setVarColID("r", this.rTagColID);
        this.tpanel.setVarColID("theta", this.thTagColID);
        this.tpanel.dx = this.DX;
        this.tpanel.dy = this.DY;
        this.tpanel.panel().setHScrollVal(this.DX);
        this.tpanel.panel().setVScrollVal(this.DY);
        this.tpanel.varMode(this.varmode);
        this.tpanel.displayAsEquations(this.displayasequations);
        this.tpanel.runawayFill(this.runawayfill);
        this.tpanel.allowIterateFill(this.allowiteratefill);
        this.tpanel.allowComplexFill(this.allowcomplexfill);
        this.tpanel.showDependencies(this.showdependencies);
        this.tpanel.numDecimalPlaces(this.numdecimalplaces);
        this.tpanel.actOnLinks(this.actonlinks);
        this.tpanel.reevaluate();
        this.tpanel.redraw(true);
    }
}

