/*
 * Decompiled with CFR 0.152.
 */
package com.questmsm.FunctionProbe;

import com.questmsm.FPCalculator.Calculator;
import com.questmsm.FPGrapher.Grapher;
import com.questmsm.FPTable.Table;
import com.questmsm.FunctionProbe.Evaluatable;
import com.questmsm.FunctionProbe.Master;
import com.questmsm.FunctionProbe.ProbeFilenameFilter;
import com.questmsm.FunctionProbe.WorkspaceFileData;
import com.questmsm.Main;
import com.questmsm.Utilities.fp_resource;
import com.questmsm.Utilities.utils;
import java.awt.Component;
import java.awt.FileDialog;
import java.awt.Frame;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

public class Master {
    public static final boolean ENABLEGRAPHER = true;
    public static final boolean ENABLETABLE = true;
    public static final boolean ENABLECALCULATOR = true;
    private static boolean fWindows = Main.getHostOS().indexOf("Windows") >= 0;
    public static final double gBadResult = -1.23456123;
    public static final String gTheta = "T";
    public static final char gThetaChar = 'T';
    public static final String gPi = "P";
    public static final char gPiChar = 'P';
    public static final char gDeltaChar = 'D';
    private static Table fTable;
    private static Calculator fCalc;
    private static Grapher fGrapher;
    private static Grapher fGrapherB;
    private static Grapher fGrapherC;
    public static Frame gFrame;
    private static int fNumGraphers;
    public static final int kMaxEvaluators = 200;
    private static Evaluatable[] fEvaluators;
    private static int fNumEvaluators;
    private static String[] fEvaluatorLabels;
    private static boolean[] fDefinedEquations;
    private static boolean[] fDefinedOther;
    public static int gTop;
    public static int gSmallTop;
    public static final String gExtension = ".prb";
    private static double[] Xvals;
    private static double[] Yvals;
    private static int Num;
    private static char xChar;
    private static char yChar;

    static {
        fNumGraphers = 1;
        fEvaluators = new Evaluatable[200];
        fNumEvaluators = 0;
        fEvaluatorLabels = new String[200];
        fDefinedEquations = new boolean[200];
        fDefinedOther = new boolean[200];
        gTop = 0;
        gSmallTop = 0;
    }

    public Master() {
        gFrame = new Frame();
        ((Component)gFrame).setBounds(-100, -100, 10, 10);
        if (fWindows) {
            gTop = 54;
            gSmallTop = 27;
        }
        fGrapher = new Grapher(1);
        fCalc = new Calculator();
        fTable = new Table();
    }

    public static void sendGrapherButton(String string) {
        fCalc.functionCanvas().defineGrapherButton(string);
    }

    public static void clearEvaluators() {
        fNumEvaluators = 0;
        int n = 0;
        while (n < 200) {
            Master.fDefinedEquations[n] = false;
            Master.fDefinedOther[n] = false;
            ++n;
        }
    }

    public static void equationDefined(int n) {
        Master.fDefinedEquations[n] = true;
    }

    public static int nextEqNumber() {
        int n = 1;
        while (n < 200) {
            if (!fDefinedEquations[n]) {
                return n;
            }
            ++n;
        }
        return 0;
    }

    public static void otherDefined(int n) {
        Master.fDefinedOther[n] = true;
    }

    public static int nextOtherNumber() {
        int n = 1;
        while (n < 200) {
            if (!fDefinedOther[n]) {
                return n;
            }
            ++n;
        }
        return 0;
    }

    public static void addEvaluator(Evaluatable evaluatable, String string) {
        int n = 0;
        while (n < fNumEvaluators) {
            if (string.equals(fEvaluatorLabels[n])) {
                Master.fEvaluators[Master.fNumEvaluators] = evaluatable;
                return;
            }
            ++n;
        }
        if (fNumEvaluators == 200) {
            utils.showErrorDialog(gFrame, fp_resource.getString("str_error__too_many_evaluators"));
            return;
        }
        Master.fEvaluators[Master.fNumEvaluators] = evaluatable;
        Master.fEvaluatorLabels[Master.fNumEvaluators] = string;
        ++fNumEvaluators;
    }

    public static double evaluate(String string, double d) {
        int n = 0;
        while (n < fNumEvaluators) {
            if (string.equals(fEvaluatorLabels[n])) {
                return fEvaluators[n].eval_(d);
            }
            ++n;
        }
        return -1.23456123;
    }

    public static Grapher graphA() {
        return fGrapher;
    }

    public static Grapher graphB() {
        return fGrapherB;
    }

    public static Grapher graphC() {
        return fGrapherC;
    }

    public static Calculator calculator() {
        return fCalc;
    }

    public static Table table() {
        return fTable;
    }

    public static void showTable() {
        fTable.setVisible(true);
    }

    public static void showCalc() {
        fCalc.setVisible(true);
    }

    public static void showGrapher() {
        if (fGrapherB != null && fGrapherB.isVisible()) {
            fGrapherB.axes().clearMode();
        }
        if (fGrapherC != null && fGrapherC.isVisible()) {
            fGrapherC.axes().clearMode();
        }
        fGrapher.setVisible(true);
    }

    public static void showGrapherB() {
        if (fGrapherB == null) {
            return;
        }
        if (fGrapher.isVisible()) {
            fGrapher.axes().clearMode();
        }
        if (fGrapherC != null && fGrapherC.isVisible()) {
            fGrapherC.axes().clearMode();
        }
        fGrapherB.setVisible(true);
    }

    public static void showGrapherC() {
        if (fGrapherC == null) {
            return;
        }
        if (fGrapher.isVisible()) {
            fGrapher.axes().clearMode();
        }
        if (fGrapherB != null && fGrapherB.isVisible()) {
            fGrapherB.axes().clearMode();
        }
        fGrapherC.setVisible(true);
    }

    public static void sendBarsToGraph(double[] dArray, double[] dArray2, int n) {
        Xvals = dArray;
        Yvals = dArray2;
        Num = n;
        Component component = null;
        switch (fNumGraphers) {
            case 1: {
                Master.sendBarsToGraphA(dArray, dArray2, n);
                return;
            }
            case 2: {
                component = new 1.SureDialog(gFrame, fp_resource.getString("str_send_to"), fp_resource.getString("str_which_graph"), Master.graphATitle(), Master.graphBTitle(), null);
                break;
            }
            case 3: {
                component = new 1.SureDialog(gFrame, fp_resource.getString("str_send_to"), fp_resource.getString("str_which_graph"), Master.graphATitle(), Master.graphBTitle(), Master.graphCTitle());
                break;
            }
        }
        component.setVisible(true);
    }

    public static void sendBarsToGraphA(double[] dArray, double[] dArray2, int n) {
        fGrapher.createBarSet(dArray, dArray2, n);
    }

    public static void sendBarsToGraphB(double[] dArray, double[] dArray2, int n) {
        fGrapherB.createBarSet(dArray, dArray2, n);
    }

    public static void sendBarsToGraphC(double[] dArray, double[] dArray2, int n) {
        fGrapherC.createBarSet(dArray, dArray2, n);
    }

    public static void sendPointsToGraph(double[] dArray, double[] dArray2, int n, char c, char c2) {
        Xvals = dArray;
        Yvals = dArray2;
        Num = n;
        xChar = c;
        yChar = c2;
        Component component = null;
        switch (fNumGraphers) {
            case 1: {
                Master.sendPointsToGraphA(dArray, dArray2, n);
                return;
            }
            case 2: {
                component = new 2.SureDialog(gFrame, fp_resource.getString("str_send_to"), fp_resource.getString("str_which_graph"), Master.graphATitle(), Master.graphBTitle(), null);
                break;
            }
            case 3: {
                component = new 2.SureDialog(gFrame, fp_resource.getString("str_send_to"), fp_resource.getString("str_which_graph"), Master.graphATitle(), Master.graphBTitle(), Master.graphCTitle());
                break;
            }
        }
        component.setVisible(true);
    }

    public static void sendPointsToGraphA(double[] dArray, double[] dArray2, int n) {
        fGrapher.createPointSet(dArray, dArray2, n, xChar, yChar);
    }

    public static void sendPointsToGraphB(double[] dArray, double[] dArray2, int n) {
        if (fGrapherB == null) {
            return;
        }
        fGrapherB.createPointSet(dArray, dArray2, n, xChar, yChar);
    }

    public static void sendPointsToGraphC(double[] dArray, double[] dArray2, int n) {
        if (fGrapherC == null) {
            return;
        }
        fGrapherC.createPointSet(dArray, dArray2, n, xChar, yChar);
    }

    public static void sendPolarPointsToGraph(double[] dArray, double[] dArray2, int n) {
        Xvals = dArray;
        Yvals = dArray2;
        Num = n;
        Component component = null;
        switch (fNumGraphers) {
            case 1: {
                Master.sendPolarPointsToGraphA(dArray, dArray2, n);
                return;
            }
            case 2: {
                component = new 3.SureDialog(gFrame, fp_resource.getString("str_send_to"), fp_resource.getString("str_which_graph"), Master.graphATitle(), Master.graphBTitle(), null);
                break;
            }
            case 3: {
                component = new 3.SureDialog(gFrame, fp_resource.getString("str_send_to"), fp_resource.getString("str_which_graph"), Master.graphATitle(), Master.graphBTitle(), Master.graphCTitle());
                break;
            }
        }
        component.setVisible(true);
    }

    public static void sendPolarPointsToGraphA(double[] dArray, double[] dArray2, int n) {
        fGrapher.createPolarPointSet(dArray, dArray2, n);
    }

    public static void sendPolarPointsToGraphB(double[] dArray, double[] dArray2, int n) {
        if (fGrapherB == null) {
            return;
        }
        fGrapherB.createPolarPointSet(dArray, dArray2, n);
    }

    public static void sendPolarPointsToGraphC(double[] dArray, double[] dArray2, int n) {
        if (fGrapherC == null) {
            return;
        }
        fGrapherC.createPolarPointSet(dArray, dArray2, n);
    }

    public static void sendButtonToGraph(int n) {
        Num = n;
        Component component = null;
        switch (fNumGraphers) {
            case 1: {
                Master.sendButtonToGraphA(n);
                return;
            }
            case 2: {
                component = new 4.SureDialog(gFrame, fp_resource.getString("str_send_to"), fp_resource.getString("str_which_graph"), Master.graphATitle(), Master.graphBTitle(), null);
                break;
            }
            case 3: {
                component = new 4.SureDialog(gFrame, fp_resource.getString("str_send_to"), fp_resource.getString("str_which_graph"), Master.graphATitle(), Master.graphBTitle(), Master.graphCTitle());
                break;
            }
        }
        component.setVisible(true);
    }

    public static void sendButtonToGraphA(int n) {
        fGrapher.axes().getFromCalc(n);
    }

    public static void sendButtonToGraphB(int n) {
        if (fGrapherB == null) {
            return;
        }
        fGrapherB.axes().getFromCalc(n);
    }

    public static void sendButtonToGraphC(int n) {
        if (fGrapherC == null) {
            return;
        }
        fGrapherC.axes().getFromCalc(n);
    }

    public static void hideGrapherAuxWindows() {
        if (fGrapher == null) {
            return;
        }
        fGrapher.hideAuxWindows();
    }

    public static void hideGrapherBAuxWindows() {
        fGrapherB.hideAuxWindows();
    }

    public static void hideGrapherCAuxWindows() {
        fGrapherC.hideAuxWindows();
    }

    public static void sendValueToCalc(double d) {
        fCalc.setCalcValueTo(d);
    }

    public static void sendValueToTable(double d) {
        fTable.setValueTo(d);
    }

    public static void sendPointsToTable(double[] dArray, double[] dArray2, int n, char c, char c2) {
        fTable.sendPointsToTable(dArray, dArray2, n, c, c2);
    }

    public static void sendBarsToTable(double[] dArray, double[] dArray2, double[] dArray3, int n, String string, char c) {
        fTable.sendBarsToTable(dArray, dArray2, dArray3, n, string, c);
    }

    public static void forceUpdate(Frame frame) {
        if (fWindows) {
            return;
        }
        if (!frame.isVisible()) {
            return;
        }
        if (!frame.isShowing()) {
            return;
        }
    }

    public static boolean isWindows() {
        return fWindows;
    }

    public static int windowsOffset() {
        if (fWindows) {
            return 23;
        }
        return 0;
    }

    public static int numGraphers() {
        return fNumGraphers;
    }

    public static void numGraphers(int n) {
        fNumGraphers = n;
    }

    public static void createGrapherB() {
        fGrapherB = new Grapher(2);
        fGrapherB.setTitle(String.valueOf(fp_resource.getString("str_graph")) + " B");
    }

    public static void createGrapherC() {
        fGrapherC = new Grapher(3);
        fGrapherC.setTitle(String.valueOf(fp_resource.getString("str_graph")) + " C");
    }

    public static void addGrapher() {
        if (fNumGraphers > 2) {
            utils.showErrorDialog(gFrame, fp_resource.getString("str_error__already_have__graphers"));
            return;
        }
        if (++fNumGraphers == 2) {
            fGrapher.axes().clearMode();
            Master.createGrapherB();
            if (fGrapher.getTitle().equals(fp_resource.getString("str_graph"))) {
                fGrapher.setTitle(String.valueOf(fp_resource.getString("str_graph")) + " A");
            }
            fGrapherB.setVisible(true);
        } else if (fNumGraphers == 3) {
            fGrapher.axes().clearMode();
            fGrapherB.axes().clearMode();
            Master.createGrapherC();
            fGrapherC.setVisible(true);
        }
    }

    public static String graphATitle() {
        if (fGrapher != null) {
            return fGrapher.getTitle();
        }
        return fp_resource.getString("str_graph");
    }

    public static String graphBTitle() {
        if (fGrapherB != null) {
            return fGrapherB.getTitle();
        }
        return String.valueOf(fp_resource.getString("str_graph")) + " B";
    }

    public static String graphCTitle() {
        if (fGrapherC != null) {
            return fGrapherC.getTitle();
        }
        return String.valueOf(fp_resource.getString("str_graph")) + " C";
    }

    public static String calcTitle() {
        if (fCalc != null) {
            return fCalc.getTitle();
        }
        return fp_resource.getString("str_calculator");
    }

    public static String tableTitle() {
        if (fTable != null) {
            return fTable.getTitle();
        }
        return fp_resource.getString("str_table");
    }

    public static boolean graphAVisible() {
        if (fGrapher != null) {
            return fGrapher.isVisible();
        }
        return false;
    }

    public static boolean graphBVisible() {
        if (fGrapherB != null) {
            return fGrapherB.isVisible();
        }
        return false;
    }

    public static boolean graphCVisible() {
        if (fGrapherC != null) {
            return fGrapherC.isVisible();
        }
        return false;
    }

    public static boolean calcVisible() {
        if (fCalc != null) {
            return fCalc.isVisible();
        }
        return false;
    }

    public static boolean tableVisible() {
        if (fTable != null) {
            return fTable.isVisible();
        }
        return false;
    }

    public static boolean somethingVisible() {
        return Master.tableVisible() || Master.calcVisible() || Master.graphAVisible() || Master.graphBVisible() || Master.graphCVisible();
    }

    public static void sureToQuit() {
        5.SureDialog sureDialog = new 5.SureDialog(gFrame, fp_resource.getString("str_save_workspace"), fp_resource.getString("str_save_workspace_before_quitting"), fp_resource.getString("str_yes"), fp_resource.getString("str_no"), fp_resource.getString("str_cancel"));
        ((Component)sureDialog).setVisible(true);
    }

    public static boolean saveWorkspace() {
        String string = gExtension;
        FileDialog fileDialog = new FileDialog(gFrame, fp_resource.getString("str_save_workspace"), 1);
        fileDialog.setFile(String.valueOf(fp_resource.getString("str_untitled")) + string);
        ((Component)fileDialog).setVisible(true);
        String string2 = fileDialog.getFile();
        String string3 = fileDialog.getDirectory();
        if (string2 != null) {
            if (!string2.endsWith(string)) {
                string2 = String.valueOf(string2) + string;
            }
            try {
                FileOutputStream fileOutputStream = new FileOutputStream(String.valueOf(string3) + string2);
                GZIPOutputStream gZIPOutputStream = new GZIPOutputStream(fileOutputStream);
                ObjectOutputStream objectOutputStream = new ObjectOutputStream(gZIPOutputStream);
                WorkspaceFileData workspaceFileData = new WorkspaceFileData();
                objectOutputStream.writeObject(workspaceFileData);
                objectOutputStream.flush();
                objectOutputStream.close();
                return true;
            }
            catch (IOException iOException) {
                utils.showErrorDialog(gFrame, String.valueOf(fp_resource.getString("str_error__in_io_during_save")) + ": " + iOException.getMessage());
            }
        }
        return false;
    }

    public static void loadWorkspace(String string) {
        WorkspaceFileData workspaceFileData;
        try {
            FileInputStream fileInputStream = new FileInputStream(string);
            GZIPInputStream gZIPInputStream = new GZIPInputStream(fileInputStream);
            ObjectInputStream objectInputStream = new ObjectInputStream(gZIPInputStream);
            workspaceFileData = (WorkspaceFileData)objectInputStream.readObject();
            objectInputStream.close();
        }
        catch (IOException iOException) {
            File file = new File(string);
            String string2 = utils.sprintf(fp_resource.getString("str_error__wrong_or_corrupt_file"), file.getName());
            utils.showErrorDialog(gFrame, string2);
            return;
        }
        catch (Exception exception) {
            utils.showErrorDialog(gFrame, String.valueOf(fp_resource.getString("str_error__in_io_during_load")) + ": " + exception.getMessage());
            return;
        }
        workspaceFileData.setWorkspaceData();
        Master.scanForEvaluators();
    }

    public static void loadWorkspace() {
        FileDialog fileDialog = new FileDialog(gFrame, fp_resource.getString("str_load_workspace"), 0);
        fileDialog.setFilenameFilter(new ProbeFilenameFilter());
        ((Component)fileDialog).setVisible(true);
        String string = fileDialog.getFile();
        if (string != null) {
            Master.loadWorkspace(String.valueOf(fileDialog.getDirectory()) + string);
        }
    }

    public static void scanForEvaluators() {
        Master.clearEvaluators();
        Evaluatable[] evaluatableArray = new Evaluatable[200];
        String[] stringArray = new String[200];
        int n = fCalc.functionCanvas().scanForEvaluators(evaluatableArray, stringArray);
        int n2 = 0;
        while (n2 < n) {
            Master.addEvaluator(evaluatableArray[n2], stringArray[n2]);
            ++n2;
        }
        n = fGrapher.axes().history().scanForEvaluators(evaluatableArray, stringArray);
        int n3 = 0;
        while (n3 < n) {
            Master.addEvaluator(evaluatableArray[n3], stringArray[n3]);
            ++n3;
        }
        if (fNumGraphers > 1) {
            n = fGrapherB.axes().history().scanForEvaluators(evaluatableArray, stringArray);
            int n4 = 0;
            while (n4 < n) {
                Master.addEvaluator(evaluatableArray[n4], stringArray[n4]);
                ++n4;
            }
            if (fNumGraphers > 2) {
                n = fGrapherC.axes().history().scanForEvaluators(evaluatableArray, stringArray);
                int n5 = 0;
                while (n5 < n) {
                    Master.addEvaluator(evaluatableArray[n5], stringArray[n5]);
                    ++n5;
                }
            }
        }
    }

    public static void newWorkspace() {
        6.SureDialog sureDialog = new 6.SureDialog(gFrame, fp_resource.getString("str_are_you_sure"), fp_resource.getString("str_are_you_sure__any_changes_will_be_lost"), fp_resource.getString("str_yes"), fp_resource.getString("str_cancel"), null);
        ((Component)sureDialog).setVisible(true);
    }

    public static boolean tableColumnValid() {
        return fTable.columnValid();
    }

    public static int tableColumnData(double[] dArray) {
        return fTable.columnData(dArray);
    }

    static /* synthetic */ double[] access$0() {
        return Xvals;
    }

    static /* synthetic */ double[] access$1() {
        return Yvals;
    }

    static /* synthetic */ int access$2() {
        return Num;
    }

    static /* synthetic */ int access$3() {
        return fNumEvaluators;
    }

    static /* synthetic */ void access$4(int n) {
        fNumEvaluators = n;
    }

    static /* synthetic */ Grapher access$5() {
        return fGrapherB;
    }

    static /* synthetic */ Grapher access$6() {
        return fGrapherC;
    }

    static /* synthetic */ Grapher access$7() {
        return fGrapher;
    }

    static /* synthetic */ Calculator access$8() {
        return fCalc;
    }

    static /* synthetic */ Table access$9() {
        return fTable;
    }
}

