/*
 * Decompiled with CFR 0.152.
 */
package com.questmsm.FunctionProbe;

import com.questmsm.FunctionProbe.Master;
import com.questmsm.FunctionProbe.WindowNameDialog;
import com.questmsm.Utilities.FPMenuItem;
import com.questmsm.Utilities.fp_resource;
import java.awt.CheckboxMenuItem;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Menu;
import java.awt.MenuItem;
import java.awt.MenuShortcut;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Enumeration;
import java.util.Vector;

public class WindowMenuHandler
implements ActionListener,
ItemListener {
    private Menu fMenu;
    private Frame fOwner;
    private MenuItem fRename;
    private MenuItem fAddGraph;
    private CheckboxMenuItem fTable;
    private CheckboxMenuItem fCalc;
    private CheckboxMenuItem fGraphA;
    private CheckboxMenuItem fGraphB;
    private CheckboxMenuItem fGraphC;
    private boolean fGraphBShowing;
    private boolean fGraphCShowing;
    private int fInsertLoc = 0;
    static Vector handlers = new Vector();

    public WindowMenuHandler(Frame frame) {
        this.fOwner = frame;
        this.fMenu = new Menu(fp_resource.getString("str_windows"));
        this.fMenu.setFont(FPMenuItem.FNT);
        this.fRename = new FPMenuItem(String.valueOf(fp_resource.getString("str_rename_window")) + "...");
        this.fAddGraph = new FPMenuItem(fp_resource.getString("str_add_graph_window"));
        this.fGraphA = new CheckboxMenuItem(fp_resource.getString("str_graph"));
        this.fGraphA.setFont(FPMenuItem.FNT);
        this.fGraphA.setShortcut(new MenuShortcut(71));
        this.fGraphB = new CheckboxMenuItem(String.valueOf(fp_resource.getString("str_graph")) + " B");
        this.fGraphB.setFont(FPMenuItem.FNT);
        this.fGraphC = new CheckboxMenuItem(String.valueOf(fp_resource.getString("str_graph")) + " C");
        this.fGraphC.setFont(FPMenuItem.FNT);
        this.fGraphA.setState(true);
        this.fGraphB.setState(true);
        this.fAddGraph.setActionCommand("Add Graph Window");
        this.fAddGraph.addActionListener(this);
        this.fGraphA.addItemListener(this);
        this.fGraphB.addItemListener(this);
        this.fGraphC.addItemListener(this);
        this.fGraphBShowing = false;
        this.fGraphCShowing = false;
        this.fTable = new CheckboxMenuItem(fp_resource.getString("str_table"));
        this.fTable.setFont(FPMenuItem.FNT);
        this.fTable.setShortcut(new MenuShortcut(84));
        this.fTable.setState(true);
        this.fTable.addItemListener(this);
        this.fCalc = new CheckboxMenuItem(fp_resource.getString("str_calculator"));
        this.fCalc.setFont(FPMenuItem.FNT);
        this.fCalc.setShortcut(new MenuShortcut(76));
        this.fCalc.setState(true);
        this.fCalc.addItemListener(this);
        this.fRename.setActionCommand("Rename Window...");
        this.fRename.addActionListener(this);
        this.fMenu.add(this.fRename);
        ++this.fInsertLoc;
        this.fMenu.add(this.fAddGraph);
        ++this.fInsertLoc;
        this.fMenu.addSeparator();
        ++this.fInsertLoc;
        this.fMenu.add(this.fTable);
        ++this.fInsertLoc;
        this.fMenu.add(this.fCalc);
        ++this.fInsertLoc;
        this.fMenu.add(this.fGraphA);
        ++this.fInsertLoc;
        handlers.addElement(this);
        WindowMenuHandler.synchHandlers();
    }

    public static void synchHandlers() {
        Enumeration enumeration = handlers.elements();
        while (enumeration.hasMoreElements()) {
            WindowMenuHandler windowMenuHandler = (WindowMenuHandler)enumeration.nextElement();
            windowMenuHandler.updateMenu();
        }
    }

    public Menu menu() {
        return this.fMenu;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals("Add Graph Window")) {
            Master.addGrapher();
        } else if (string.equals("Rename Window...")) {
            WindowNameDialog windowNameDialog = new WindowNameDialog(this.fOwner);
            ((Component)windowNameDialog).setVisible(true);
            this.updateMenu();
        }
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        CheckboxMenuItem checkboxMenuItem = (CheckboxMenuItem)itemEvent.getSource();
        checkboxMenuItem.setState(true);
        if (checkboxMenuItem == this.fCalc) {
            Master.showCalc();
        } else if (checkboxMenuItem == this.fTable) {
            Master.showTable();
        } else if (checkboxMenuItem == this.fGraphA) {
            Master.showGrapher();
        } else if (checkboxMenuItem == this.fGraphB) {
            Master.showGrapherB();
        } else if (checkboxMenuItem == this.fGraphC) {
            Master.showGrapherC();
        }
    }

    public void hideGrapher(int n) {
        if (this.fGraphA == null) {
            return;
        }
        switch (n) {
            case 1: {
                this.fGraphA.setState(false);
                break;
            }
            case 2: {
                this.fGraphB.setState(false);
                break;
            }
            case 3: {
                this.fGraphC.setState(false);
                break;
            }
        }
    }

    public void hideCalc() {
        if (this.fCalc == null) {
            return;
        }
        this.fCalc.setState(false);
    }

    public void hideTable() {
        if (this.fTable == null) {
            return;
        }
        this.fTable.setState(false);
    }

    public void updateMenu() {
        this.fAddGraph.setEnabled(Master.numGraphers() <= 2);
        this.fGraphA.setLabel(Master.graphATitle());
        this.fGraphA.setState(Master.graphAVisible());
        this.fGraphB.setState(Master.graphBVisible());
        this.fGraphC.setState(Master.graphCVisible());
        if (Master.numGraphers() == 2) {
            if (!this.fGraphBShowing) {
                this.fMenu.insert(this.fGraphB, this.fInsertLoc);
                ++this.fInsertLoc;
                this.fGraphBShowing = true;
            }
            this.fGraphB.setLabel(Master.graphBTitle());
        } else if (Master.numGraphers() == 3) {
            if (!this.fGraphCShowing) {
                this.fMenu.insert(this.fGraphC, this.fInsertLoc);
                this.fGraphCShowing = true;
            }
            this.fGraphC.setLabel(Master.graphCTitle());
        }
        this.fTable.setLabel(Master.tableTitle());
        this.fTable.setState(Master.tableVisible());
        this.fCalc.setLabel(Master.calcTitle());
        this.fCalc.setState(Master.calcVisible());
    }
}

