/*
 * Decompiled with CFR 0.152.
 */
package com.questmsm.Utilities;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;
import java.util.Enumeration;
import java.util.Vector;

public class FPTextField
extends Canvas {
    Font fnt;
    Color bgColor;
    Color fgColor;
    String txt;
    int width;
    FontMetrics fm;
    CaretUpdaterThread caretUpdater;
    int caretpos = 0;
    boolean hasfocus = false;
    Vector textListeners = new Vector();
    Vector actionListeners = new Vector();
    boolean exit = false;
    private boolean textSelected = false;
    private int selectionoffset = 0;
    boolean paintcaret = false;
    static final boolean ISMAC = System.getProperty("os.name").startsWith("Mac");
    Color caretcolor;
    Color selectionColor = new Color(10, 36, 106);

    public FPTextField(String string, int n) {
        this.txt = string == null ? "" : string;
        this.bgColor = Color.white;
        this.caretcolor = this.fgColor = Color.black;
        this.width = n;
        this.setFont(new Font("Helvetica", 0, 12));
        this.addMouseListener(new 1());
        this.addMouseMotionListener(new 2());
        this.addFocusListener(new 3());
        this.addKeyListener(new 4());
    }

    private int coords2charpos(int n) {
        int n2 = 0;
        int n3 = 0;
        while (n3 < this.txt.length()) {
            if ((n2 += this.fm.charWidth(this.txt.charAt(n3))) >= n) {
                return n3;
            }
            ++n3;
        }
        return this.txt.length();
    }

    public boolean hasFocus() {
        return this.hasfocus;
    }

    public void addTextListener(TextListener textListener) {
        this.textListeners.addElement(textListener);
    }

    public void removeTextListener(TextListener textListener) {
        this.textListeners.removeElement(textListener);
    }

    private void fireTextValueChanged() {
        if (this.textListeners.size() > 0) {
            TextEvent textEvent = new TextEvent(this, 900);
            Enumeration enumeration = this.textListeners.elements();
            while (enumeration.hasMoreElements()) {
                ((TextListener)enumeration.nextElement()).textValueChanged(textEvent);
            }
        }
    }

    public void addActionListener(ActionListener actionListener) {
        this.actionListeners.addElement(actionListener);
    }

    public void removeActionListener(ActionListener actionListener) {
        this.actionListeners.removeElement(actionListener);
    }

    private void fireActionPerformed() {
        if (this.actionListeners.size() > 0) {
            ActionEvent actionEvent = new ActionEvent(this, 1001, this.txt);
            Enumeration enumeration = this.actionListeners.elements();
            while (enumeration.hasMoreElements()) {
                ((ActionListener)enumeration.nextElement()).actionPerformed(actionEvent);
            }
        }
    }

    public String getText() {
        return this.txt;
    }

    public void setText(String string) {
        this.txt = string == null ? "" : string;
        this.caretpos = this.txt.length();
        this.repaint();
    }

    public int getCaretPosition() {
        return this.caretpos;
    }

    public void setCaretPosition(int n) {
        this.caretpos = n;
        if (this.caretpos < 0) {
            this.caretpos = 0;
        }
        if (this.caretpos > this.txt.length()) {
            this.caretpos = this.txt.length();
        }
    }

    public void addNotify() {
        super.addNotify();
        this.exit = false;
        this.caretUpdater = new CaretUpdaterThread();
        this.caretUpdater.start();
    }

    public boolean isFocusTraversable() {
        return true;
    }

    public String getSelectedText() {
        return this.txt.substring(this.selectionoffset, this.caretpos);
    }

    public int getSelectionStart() {
        return this.selectionoffset;
    }

    public int getSelectionEnd() {
        return this.caretpos;
    }

    synchronized void updateCaret() {
        this.paintcaret = true;
        this.repaint();
    }

    public void removeNotify() {
        super.removeNotify();
        this.exit = true;
        this.caretUpdater = null;
    }

    public Dimension getPreferredSize() {
        int n = this.width * this.fm.charWidth('0') + 24;
        return new Dimension(n, this.fm.getHeight() + 4);
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public void setFont(Font font) {
        this.fnt = font;
        this.fm = this.getFontMetrics(this.fnt);
    }

    public void setSize(int n, int n2) {
        this.width = (n - 24) / this.fm.charWidth('0');
        if (this.width < 24) {
            this.width = 24;
        }
        super.setSize(n, n2);
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public void paint(Graphics graphics) {
        Dimension dimension = this.getSize();
        graphics.setFont(this.fnt);
        if (this.paintcaret) {
            this.paintCaret(graphics, dimension);
            this.paintcaret = false;
            return;
        }
        this.paintBorder(graphics, dimension);
        graphics.setColor(this.bgColor);
        graphics.fillRect(2, 2, dimension.width - 4, dimension.height - 4);
        graphics.setColor(this.fgColor);
        if (ISMAC) {
            graphics.drawString(this.txt, 4, this.fm.getHeight() + 2);
        } else {
            graphics.drawString(this.txt, 4, this.fm.getHeight() - 2);
        }
        if (this.textSelected) {
            String string;
            int n;
            int n2;
            if (this.selectionoffset < this.caretpos) {
                n2 = this.fm.stringWidth(this.txt.substring(0, this.selectionoffset)) + 4;
                n = this.fm.stringWidth(this.txt.substring(0, this.caretpos)) + 4;
                string = this.txt.substring(this.selectionoffset, this.caretpos);
            } else {
                n2 = this.fm.stringWidth(this.txt.substring(0, this.caretpos)) + 4;
                n = this.fm.stringWidth(this.txt.substring(0, this.selectionoffset)) + 4;
                string = this.txt.substring(this.caretpos, this.selectionoffset);
            }
            graphics.setColor(this.selectionColor);
            graphics.fillRect(n2, 3, n - n2, dimension.height - 6);
            graphics.setColor(Color.white);
            if (ISMAC) {
                graphics.drawString(string, n2, this.fm.getHeight() + 2);
            } else {
                graphics.drawString(string, n2, this.fm.getHeight() - 2);
            }
        }
    }

    private void paintCaret(Graphics graphics, Dimension dimension) {
        Color color;
        if (this.caretcolor == this.fgColor) {
            this.caretcolor = this.bgColor;
            color = this.fgColor;
        } else {
            this.caretcolor = this.fgColor;
            color = this.bgColor;
        }
        graphics.setColor(this.caretcolor);
        graphics.setXORMode(color);
        int n = 4 + this.fm.stringWidth(this.txt.substring(0, this.caretpos));
        if (ISMAC) {
            graphics.drawLine(n, 4, n, this.fm.getHeight() + 4);
        } else {
            graphics.drawLine(n, 3, n, this.fm.getHeight());
        }
    }

    private void paintBorder(Graphics graphics, Dimension dimension) {
        graphics.setColor(Color.gray);
        graphics.drawLine(0, 0, dimension.width - 1, 0);
        graphics.drawLine(0, 0, 0, dimension.height - 1);
        graphics.setColor(Color.darkGray);
        graphics.drawLine(1, 1, dimension.width - 2, 1);
        graphics.drawLine(1, 1, 1, dimension.height - 2);
        graphics.setColor(Color.lightGray);
        graphics.drawLine(dimension.width - 1, 1, dimension.width - 1, dimension.height - 1);
        graphics.drawLine(1, dimension.height - 1, dimension.width - 1, dimension.height - 1);
    }

    class CaretUpdaterThread
    extends Thread {
        Object lock = new Object();

        /*
         * Unable to fully structure code
         */
        public void run() {
            while (!FPTextField.this.exit) {
                try {
                    var1_1 = this.lock;
                    synchronized (var1_1) {
                        this.lock.wait();
                        // MONITOREXIT @DISABLED, blocks:[0, 1, 2, 5] lbl7 : MonitorExitStatement: MONITOREXIT : var1_1
                        if (true) ** GOTO lbl14
                    }
                    do {
                        FPTextField.this.updateCaret();
                        Thread.sleep(500L);
lbl14:
                        // 2 sources

                    } while (FPTextField.this.hasFocus());
                }
                catch (InterruptedException v1) {}
            }
        }

        CaretUpdaterThread() {
        }
    }

    private final class 1
    extends MouseAdapter {
        public void mouseEntered(MouseEvent mouseEvent) {
            FPTextField.this.setCursor(Cursor.getPredefinedCursor(2));
        }

        public void mouseExited(MouseEvent mouseEvent) {
            FPTextField.this.setCursor(Cursor.getPredefinedCursor(0));
        }

        public void mousePressed(MouseEvent mouseEvent) {
            FPTextField.this.caretpos = FPTextField.this.coords2charpos(mouseEvent.getX());
            FPTextField.this.repaint();
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            FPTextField.this.requestFocus();
            FPTextField.this.textSelected = false;
            FPTextField.this.repaint();
        }

        /* synthetic */ 1() {
        }
    }

    private final class 2
    implements MouseMotionListener {
        public void mouseDragged(MouseEvent mouseEvent) {
            FPTextField.this.textSelected = true;
            FPTextField.this.selectionoffset = FPTextField.this.coords2charpos(mouseEvent.getX());
            FPTextField.this.repaint();
        }

        public void mouseMoved(MouseEvent mouseEvent) {
        }

        /* synthetic */ 2() {
        }
    }

    private final class 3
    implements FocusListener {
        public void focusGained(FocusEvent focusEvent) {
            Object object = FPTextField.this.caretUpdater.lock;
            synchronized (object) {
                FPTextField.this.hasfocus = true;
                FPTextField.this.caretUpdater.lock.notify();
            }
            FPTextField.this.repaint();
        }

        public void focusLost(FocusEvent focusEvent) {
            FPTextField.this.hasfocus = false;
            FPTextField.this.repaint();
        }

        /* synthetic */ 3() {
        }
    }

    private final class 4
    extends KeyAdapter {
        public void keyReleased(KeyEvent keyEvent) {
            switch (keyEvent.getKeyCode()) {
                case 10: {
                    FPTextField.this.fireActionPerformed();
                }
                case 9: 
                case 16: 
                case 17: 
                case 18: 
                case 19: 
                case 20: 
                case 27: 
                case 144: 
                case 145: {
                    return;
                }
                case 33: 
                case 36: {
                    if ((keyEvent.getModifiers() & 1) != 0) {
                        if (!FPTextField.this.textSelected) {
                            FPTextField.this.textSelected = true;
                            FPTextField.this.selectionoffset = FPTextField.this.caretpos;
                        }
                    } else {
                        FPTextField.this.textSelected = false;
                    }
                    FPTextField.this.caretpos = 0;
                    break;
                }
                case 34: 
                case 35: {
                    if ((keyEvent.getModifiers() & 1) != 0) {
                        if (!FPTextField.this.textSelected) {
                            FPTextField.this.textSelected = true;
                            FPTextField.this.selectionoffset = FPTextField.this.caretpos;
                        }
                    } else {
                        FPTextField.this.textSelected = false;
                    }
                    FPTextField.this.caretpos = FPTextField.this.txt.length();
                    break;
                }
                case 8: {
                    if (FPTextField.this.textSelected) {
                        if (FPTextField.this.selectionoffset < FPTextField.this.caretpos) {
                            FPTextField.this.txt = String.valueOf(FPTextField.this.txt.substring(0, FPTextField.this.selectionoffset)) + FPTextField.this.txt.substring(FPTextField.this.caretpos);
                            FPTextField.this.caretpos = FPTextField.this.selectionoffset;
                        } else {
                            FPTextField.this.txt = String.valueOf(FPTextField.this.txt.substring(0, FPTextField.this.caretpos)) + FPTextField.this.txt.substring(FPTextField.this.selectionoffset);
                        }
                        FPTextField.this.textSelected = false;
                        break;
                    }
                    if (FPTextField.this.caretpos == 0) break;
                    String string = FPTextField.this.txt;
                    FPTextField.this.txt = string.substring(0, FPTextField.this.caretpos - 1);
                    if (FPTextField.this.caretpos < string.length()) {
                        FPTextField.this.txt = String.valueOf(FPTextField.this.txt) + string.substring(FPTextField.this.caretpos);
                    }
                    --FPTextField.this.caretpos;
                    if (FPTextField.this.caretpos >= 0) break;
                    FPTextField.this.caretpos = 0;
                    break;
                }
                case 127: {
                    if (FPTextField.this.textSelected) {
                        if (FPTextField.this.selectionoffset < FPTextField.this.caretpos) {
                            FPTextField.this.txt = String.valueOf(FPTextField.this.txt.substring(0, FPTextField.this.selectionoffset)) + FPTextField.this.txt.substring(FPTextField.this.caretpos);
                            FPTextField.this.caretpos = FPTextField.this.selectionoffset;
                        } else {
                            FPTextField.this.txt = String.valueOf(FPTextField.this.txt.substring(0, FPTextField.this.caretpos)) + FPTextField.this.txt.substring(FPTextField.this.selectionoffset);
                        }
                        FPTextField.this.textSelected = false;
                        break;
                    }
                    if (FPTextField.this.caretpos == FPTextField.this.txt.length()) break;
                    String string = FPTextField.this.txt;
                    FPTextField.this.txt = String.valueOf(string.substring(0, FPTextField.this.caretpos)) + string.substring(FPTextField.this.caretpos + 1);
                    break;
                }
                case 39: 
                case 40: {
                    if ((keyEvent.getModifiers() & 1) != 0) {
                        if (!FPTextField.this.textSelected) {
                            FPTextField.this.textSelected = true;
                            FPTextField.this.selectionoffset = FPTextField.this.caretpos;
                        }
                    } else {
                        FPTextField.this.textSelected = false;
                    }
                    ++FPTextField.this.caretpos;
                    if (FPTextField.this.caretpos <= FPTextField.this.txt.length()) break;
                    FPTextField.this.caretpos = FPTextField.this.txt.length();
                    break;
                }
                case 37: 
                case 38: {
                    if ((keyEvent.getModifiers() & 1) != 0) {
                        if (!FPTextField.this.textSelected) {
                            FPTextField.this.textSelected = true;
                            FPTextField.this.selectionoffset = FPTextField.this.caretpos;
                        }
                    } else {
                        FPTextField.this.textSelected = false;
                    }
                    --FPTextField.this.caretpos;
                    if (FPTextField.this.caretpos >= 0) break;
                    FPTextField.this.caretpos = 0;
                    break;
                }
                default: {
                    if (Character.isISOControl(keyEvent.getKeyChar())) break;
                    String string = FPTextField.this.txt;
                    if (FPTextField.this.textSelected) {
                        if (FPTextField.this.selectionoffset < FPTextField.this.caretpos) {
                            string = String.valueOf(string.substring(0, FPTextField.this.selectionoffset)) + string.substring(FPTextField.this.caretpos);
                            FPTextField.this.caretpos = FPTextField.this.selectionoffset;
                        } else {
                            string = String.valueOf(string.substring(0, FPTextField.this.caretpos)) + string.substring(FPTextField.this.selectionoffset);
                        }
                        FPTextField.this.textSelected = false;
                    }
                    FPTextField.this.txt = String.valueOf(string.substring(0, FPTextField.this.caretpos)) + keyEvent.getKeyChar();
                    if (FPTextField.this.caretpos < string.length()) {
                        FPTextField.this.txt = String.valueOf(FPTextField.this.txt) + string.substring(FPTextField.this.caretpos);
                    }
                    ++FPTextField.this.caretpos;
                }
            }
            FPTextField.this.fireTextValueChanged();
            FPTextField.this.repaint();
        }

        /* synthetic */ 4() {
        }
    }
}

