/*
 * Decompiled with CFR 0.152.
 */
package com.questmsm.FPCalculator;

import com.questmsm.FPCalculator.CalcButton;
import com.questmsm.FPCalculator.CalcUtils;
import com.questmsm.FPCalculator.Calculator;
import com.questmsm.FPCalculator.DisplayField;
import com.questmsm.FPCalculator.EditDisplayField;
import com.questmsm.FPCalculator.SpecialTextField;
import com.questmsm.Utilities.fp_resource;
import com.questmsm.Utilities.utils;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Event;
import java.awt.Graphics;
import java.awt.Image;

public class CalcButtonCanvas
extends Canvas {
    private CalcButton f1;
    private CalcButton f2;
    private CalcButton f3;
    private CalcButton f4;
    private CalcButton f5;
    private CalcButton f6;
    private CalcButton f7;
    private CalcButton f8;
    private CalcButton f9;
    private CalcButton f0;
    private CalcButton fPeriod;
    private CalcButton fEquals;
    private CalcButton fMult;
    private CalcButton fAdd;
    private CalcButton fSub;
    private CalcButton fDiv;
    private CalcButton fOpenParen;
    private CalcButton fCloseParen;
    private CalcButton fClear;
    private CalcButton fInv;
    private CalcButton fPi = null;
    private CalcButton fE;
    private CalcButton fClearAll;
    private CalcButton fChangeSign;
    public static final char kPi = '\u0001';
    public static final char kE = '\u0002';
    public static final char kClear = '\u0003';
    public static final char kClearAll = '\u0004';
    public static final char kChangeSign = 'i';
    public static final char kXToA = '\u00cf';
    public static final char kAToX = '\u00d0';
    public static final char kInv = '\t';
    public static final char kReturn = '\n';
    public static final char kLogAX = '\u00d1';
    public static final char kX1OA = '\u00d2';
    private Image fBackgroundImage = null;
    private Image fForegroundImage = null;
    private Graphics fBackgroundGraphics = null;
    private Graphics fForegroundGraphics = null;
    private static final int kBgndImageWidth = 192;
    private static final int kBgndImageHeight = 128;
    private Calculator fCalc;
    private EditDisplayField fEditField;
    private DisplayField fDisplayField;
    private SpecialTextField fSpecialField;
    public static final int kNothing = 0;
    public static final int kNumber = 1;
    public static final int kResult = 2;
    public static final int kEndRow = 3;
    public static final int kPartialResult = 4;
    private final int kPreDecimal = 0;
    private final int kPostDecimal = 1;
    private final int kErrorMode = -1;
    private int fCurrent;
    private int fDecimal = 0;
    private int fDecimalPlace = 0;
    private int fNumOpenParens = 0;
    private String fDisplayString = "0";
    private double fNumber = 0.0;
    private final int kMaxStack = 20;
    private double[] fStack = new double[20];
    private int fStackIndex = 0;
    private boolean fTypingExponent = false;
    private boolean fTypingInvExponent = false;
    private boolean fTypingLog = false;
    private String fLogVal = "";
    boolean initialized = false;

    public CalcButtonCanvas(Color color, Calculator calculator, DisplayField displayField, EditDisplayField editDisplayField, SpecialTextField specialTextField) {
        this.setBackground(color);
        this.fDisplayField = displayField;
        this.fSpecialField = specialTextField;
        this.fCalc = calculator;
        this.fEditField = editDisplayField;
    }

    public void clear() {
        this.fCurrent = 0;
        this.fDecimal = 0;
        this.fDecimalPlace = 0;
        this.fNumOpenParens = 0;
        this.fDisplayString = "0";
        this.fNumber = 0.0;
        this.fStackIndex = 0;
        this.fTypingExponent = false;
        this.fTypingInvExponent = false;
        this.fTypingLog = false;
        this.fLogVal = "";
    }

    public void createButtons() {
        Image image = this.createImage(32, 32);
        Image image2 = this.createImage(32, 32);
        if (image == null || image2 == null) {
            return;
        }
        Image image3 = utils.getImage("calc.gif", this);
        image.getGraphics().drawImage(image3, 0, 0, 32, 32, 0, 0, 32, 32, this);
        image2.getGraphics().drawImage(image3, 0, 0, 32, 32, 32, 0, 64, 32, this);
        CalcButton.setStaticVars(image, image2, this);
        this.fPi = new CalcButton("Pi", '\u0001', 1, 3);
        this.fE = new CalcButton("e", '\u0002', 2, 3);
        this.fClearAll = new CalcButton("ca", '\u0004', 1, 2);
        this.fInv = new CalcButton("INV", '\t', 1, 4);
        this.fChangeSign = new CalcButton("+/-", 'i', 2, 4);
        this.fClear = new CalcButton("CE", 'C', 1, 1);
        this.fOpenParen = new CalcButton("(", '(', 2, 1);
        this.fCloseParen = new CalcButton(")", ')', 2, 2);
        this.f0 = new CalcButton("0", '0', 3, 4);
        this.f1 = new CalcButton("1", '1', 3, 3);
        this.f2 = new CalcButton("2", '2', 4, 3);
        this.f3 = new CalcButton("3", '3', 5, 3);
        this.f4 = new CalcButton("4", '4', 3, 2);
        this.f5 = new CalcButton("5", '5', 4, 2);
        this.f6 = new CalcButton("6", '6', 5, 2);
        this.f7 = new CalcButton("7", '7', 3, 1);
        this.f8 = new CalcButton("8", '8', 4, 1);
        this.f9 = new CalcButton("9", '9', 5, 1);
        this.fPeriod = new CalcButton(".", '.', 4, 4);
        this.fEquals = new CalcButton("=", '=', 5, 4);
        this.fMult = new CalcButton("*", '*', 6, 2);
        this.fDiv = new CalcButton("/", '/', 6, 1);
        this.fAdd = new CalcButton("+", '+', 6, 4);
        this.fSub = new CalcButton("-", '-', 6, 3);
    }

    public void createImages() {
        this.fBackgroundImage = this.createImage(192, 128);
        this.fBackgroundGraphics = this.fBackgroundImage.getGraphics();
        this.fForegroundImage = this.createImage(192, 128);
        this.fForegroundGraphics = this.fForegroundImage.getGraphics();
    }

    void initialize() {
        if (this.fBackgroundGraphics == null) {
            this.createImages();
        }
        if (this.fPi == null) {
            this.createButtons();
            this.current(3);
        }
        this.drawBackground();
        this.initialized = true;
    }

    private synchronized void drawBackground(Graphics graphics) {
        if (graphics == null) {
            return;
        }
        this.draw(graphics);
    }

    public synchronized void drawBackground() {
        this.drawBackground(this.fBackgroundGraphics);
    }

    public void drawForeground(Graphics graphics) {
        if (this.fPi == null) {
            return;
        }
        this.fPi.drawIfSelected(graphics);
        this.fE.drawIfSelected(graphics);
        this.fClearAll.drawIfSelected(graphics);
        this.fChangeSign.drawIfSelected(graphics);
        this.fClear.drawIfSelected(graphics);
        this.fOpenParen.drawIfSelected(graphics);
        this.fCloseParen.drawIfSelected(graphics);
        this.f0.drawIfSelected(graphics);
        this.f1.drawIfSelected(graphics);
        this.f2.drawIfSelected(graphics);
        this.f3.drawIfSelected(graphics);
        this.f4.drawIfSelected(graphics);
        this.f5.drawIfSelected(graphics);
        this.f6.drawIfSelected(graphics);
        this.f7.drawIfSelected(graphics);
        this.f8.drawIfSelected(graphics);
        this.f9.drawIfSelected(graphics);
        this.fPeriod.drawIfSelected(graphics);
        this.fEquals.drawIfSelected(graphics);
        this.fMult.drawIfSelected(graphics);
        this.fDiv.drawIfSelected(graphics);
        this.fAdd.drawIfSelected(graphics);
        this.fSub.drawIfSelected(graphics);
        this.fInv.drawIfSelected(graphics);
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public synchronized void paint(Graphics graphics) {
        if (!this.initialized) {
            this.initialize();
        }
        if (this.fBackgroundImage == null) {
            return;
        }
        if (this.fForegroundImage == null) {
            return;
        }
        this.fForegroundGraphics.drawImage(this.fBackgroundImage, 0, 0, this);
        this.drawForeground(this.fForegroundGraphics);
        graphics.drawImage(this.fForegroundImage, 0, 0, this);
    }

    public void draw(Graphics graphics) {
        if (graphics == null) {
            return;
        }
        graphics.setColor(Color.black);
        graphics.fillRect(0, 0, this.getSize().width, this.getSize().height);
        if (this.fPi == null) {
            return;
        }
        this.fPi.draw(graphics);
        this.fE.draw(graphics);
        this.fClearAll.draw(graphics);
        this.fChangeSign.draw(graphics);
        this.fClear.draw(graphics);
        this.fOpenParen.draw(graphics);
        this.fCloseParen.draw(graphics);
        this.f0.draw(graphics);
        this.f1.draw(graphics);
        this.f2.draw(graphics);
        this.f3.draw(graphics);
        this.f4.draw(graphics);
        this.f5.draw(graphics);
        this.f6.draw(graphics);
        this.f7.draw(graphics);
        this.f8.draw(graphics);
        this.f9.draw(graphics);
        this.fPeriod.draw(graphics);
        this.fEquals.draw(graphics);
        this.fMult.draw(graphics);
        this.fDiv.draw(graphics);
        this.fAdd.draw(graphics);
        this.fSub.draw(graphics);
        this.fInv.draw(graphics);
    }

    public void setButtonEnables() {
        if (this.fCurrent == -1) {
            this.fPi.enable(false);
            this.fE.enable(false);
            this.fClearAll.enable(true);
            this.fChangeSign.enable(false);
            this.fClear.enable(false);
            this.fOpenParen.enable(false);
            this.fCloseParen.enable(false);
            this.f0.enable(false);
            this.f1.enable(false);
            this.f2.enable(false);
            this.f3.enable(false);
            this.f4.enable(false);
            this.f5.enable(false);
            this.f6.enable(false);
            this.f7.enable(false);
            this.f8.enable(false);
            this.f9.enable(false);
            this.fPeriod.enable(false);
            this.fEquals.enable(false);
            this.fMult.enable(false);
            this.fDiv.enable(false);
            this.fAdd.enable(false);
            this.fSub.enable(false);
            this.fInv.enable(false);
            this.fPi.draw(this.fBackgroundGraphics);
            this.fE.draw(this.fBackgroundGraphics);
            this.fClearAll.draw(this.fBackgroundGraphics);
            this.fChangeSign.draw(this.fBackgroundGraphics);
            this.fClear.draw(this.fBackgroundGraphics);
            this.fOpenParen.draw(this.fBackgroundGraphics);
            this.fCloseParen.draw(this.fBackgroundGraphics);
            this.f0.draw(this.fBackgroundGraphics);
            this.f1.draw(this.fBackgroundGraphics);
            this.f2.draw(this.fBackgroundGraphics);
            this.f3.draw(this.fBackgroundGraphics);
            this.f4.draw(this.fBackgroundGraphics);
            this.f5.draw(this.fBackgroundGraphics);
            this.f6.draw(this.fBackgroundGraphics);
            this.f7.draw(this.fBackgroundGraphics);
            this.f8.draw(this.fBackgroundGraphics);
            this.f9.draw(this.fBackgroundGraphics);
            this.fPeriod.draw(this.fBackgroundGraphics);
            this.fEquals.draw(this.fBackgroundGraphics);
            this.fMult.draw(this.fBackgroundGraphics);
            this.fDiv.draw(this.fBackgroundGraphics);
            this.fAdd.draw(this.fBackgroundGraphics);
            this.fSub.draw(this.fBackgroundGraphics);
            this.fInv.draw(this.fBackgroundGraphics);
            return;
        }
        if (!this.fCalc.matrixView()) {
            if (this.fCalc.editing()) {
                if (this.fPi.enable(true)) {
                    this.fPi.draw(this.fBackgroundGraphics);
                }
                if (this.fE.enable(true)) {
                    this.fE.draw(this.fBackgroundGraphics);
                }
                if (this.fClearAll.enable(true)) {
                    this.fClearAll.draw(this.fBackgroundGraphics);
                }
                if (this.fChangeSign.enable(true)) {
                    this.fChangeSign.draw(this.fBackgroundGraphics);
                }
                if (this.fClear.enable(false)) {
                    this.fClear.draw(this.fBackgroundGraphics);
                }
                if (this.fOpenParen.enable(true)) {
                    this.fOpenParen.draw(this.fBackgroundGraphics);
                }
                if (this.fCloseParen.enable(true)) {
                    this.fCloseParen.draw(this.fBackgroundGraphics);
                }
                if (this.f0.enable(true)) {
                    this.f0.draw(this.fBackgroundGraphics);
                }
                if (this.f1.enable(true)) {
                    this.f1.draw(this.fBackgroundGraphics);
                }
                if (this.f2.enable(true)) {
                    this.f2.draw(this.fBackgroundGraphics);
                }
                if (this.f3.enable(true)) {
                    this.f3.draw(this.fBackgroundGraphics);
                }
                if (this.f4.enable(true)) {
                    this.f4.draw(this.fBackgroundGraphics);
                }
                if (this.f5.enable(true)) {
                    this.f5.draw(this.fBackgroundGraphics);
                }
                if (this.f6.enable(true)) {
                    this.f6.draw(this.fBackgroundGraphics);
                }
                if (this.f7.enable(true)) {
                    this.f7.draw(this.fBackgroundGraphics);
                }
                if (this.f8.enable(true)) {
                    this.f8.draw(this.fBackgroundGraphics);
                }
                if (this.f9.enable(true)) {
                    this.f9.draw(this.fBackgroundGraphics);
                }
                if (this.fPeriod.enable(true)) {
                    this.fPeriod.draw(this.fBackgroundGraphics);
                }
                if (this.fEquals.enable(true)) {
                    this.fEquals.draw(this.fBackgroundGraphics);
                }
                if (this.fMult.enable(true)) {
                    this.fMult.draw(this.fBackgroundGraphics);
                }
                if (this.fDiv.enable(true)) {
                    this.fDiv.draw(this.fBackgroundGraphics);
                }
                if (this.fAdd.enable(true)) {
                    this.fAdd.draw(this.fBackgroundGraphics);
                }
                if (this.fSub.enable(true)) {
                    this.fSub.draw(this.fBackgroundGraphics);
                }
                if (this.fInv.enable(true)) {
                    this.fInv.draw(this.fBackgroundGraphics);
                }
            } else {
                if (this.fPi.enable((this.fCurrent == 1 || this.fCurrent == 2) ^ true)) {
                    this.fPi.draw(this.fBackgroundGraphics);
                }
                if (this.fE.enable((this.fCurrent == 1 || this.fCurrent == 2) ^ true)) {
                    this.fE.draw(this.fBackgroundGraphics);
                }
                this.fClearAll.enable(true);
                if (this.fChangeSign.enable(this.fCurrent != 0)) {
                    this.fChangeSign.draw(this.fBackgroundGraphics);
                }
                this.fClear.enable(true);
                if (this.fOpenParen.enable((this.fCurrent == 1 || this.fCurrent == 2) ^ true)) {
                    this.fOpenParen.draw(this.fBackgroundGraphics);
                }
                if (this.fCloseParen.enable(this.fCurrent != 0 && this.fNumOpenParens > 0)) {
                    this.fCloseParen.draw(this.fBackgroundGraphics);
                }
                if (this.f0.enable(this.fCurrent != 2)) {
                    this.f0.draw(this.fBackgroundGraphics);
                }
                if (this.f1.enable(this.fCurrent != 2)) {
                    this.f1.draw(this.fBackgroundGraphics);
                }
                if (this.f2.enable(this.fCurrent != 2)) {
                    this.f2.draw(this.fBackgroundGraphics);
                }
                if (this.f3.enable(this.fCurrent != 2)) {
                    this.f3.draw(this.fBackgroundGraphics);
                }
                if (this.f4.enable(this.fCurrent != 2)) {
                    this.f4.draw(this.fBackgroundGraphics);
                }
                if (this.f5.enable(this.fCurrent != 2)) {
                    this.f5.draw(this.fBackgroundGraphics);
                }
                if (this.f6.enable(this.fCurrent != 2)) {
                    this.f6.draw(this.fBackgroundGraphics);
                }
                if (this.f7.enable(this.fCurrent != 2)) {
                    this.f7.draw(this.fBackgroundGraphics);
                }
                if (this.f8.enable(this.fCurrent != 2)) {
                    this.f8.draw(this.fBackgroundGraphics);
                }
                if (this.f9.enable(this.fCurrent != 2)) {
                    this.f9.draw(this.fBackgroundGraphics);
                }
                if (this.fPeriod.enable(this.fCurrent != 2 && this.fDecimal == 0)) {
                    this.fPeriod.draw(this.fBackgroundGraphics);
                }
                if (this.fEquals.enable(this.fCurrent != 0 && this.fCurrent != 4 && this.fNumOpenParens == 0)) {
                    this.fEquals.draw(this.fBackgroundGraphics);
                }
                if (this.fMult.enable(this.fCurrent != 0)) {
                    this.fMult.draw(this.fBackgroundGraphics);
                }
                if (this.fDiv.enable(this.fCurrent != 0)) {
                    this.fDiv.draw(this.fBackgroundGraphics);
                }
                if (this.fAdd.enable(this.fCurrent != 0)) {
                    this.fAdd.draw(this.fBackgroundGraphics);
                }
                if (this.fSub.enable(this.fCurrent != 0)) {
                    this.fSub.draw(this.fBackgroundGraphics);
                }
                if (this.fInv.enable(true)) {
                    this.fInv.draw(this.fBackgroundGraphics);
                }
            }
            this.repaint();
        } else {
            int n = this.fCalc.matrixCanvas().current();
            boolean bl = n == 2;
            boolean bl2 = n == 5 || n == 6 || n == 8;
            bl = true;
            boolean bl3 = false;
            if (n == 2 && this.fCalc.matrixCanvas().currentMatrix() != null && this.fCalc.matrixCanvas().currentMatrix().square()) {
                bl3 = true;
            }
            if (this.fPi.enable(bl2)) {
                this.fPi.draw(this.fBackgroundGraphics);
            }
            if (this.fE.enable(bl2)) {
                this.fE.draw(this.fBackgroundGraphics);
            }
            if (this.fClearAll.enable(true)) {
                this.fClearAll.draw(this.fBackgroundGraphics);
            }
            if (this.fChangeSign.enable(bl)) {
                this.fChangeSign.draw(this.fBackgroundGraphics);
            }
            if (this.fClear.enable(true)) {
                this.fClear.draw(this.fBackgroundGraphics);
            }
            if (this.fOpenParen.enable(true)) {
                this.fOpenParen.draw(this.fBackgroundGraphics);
            }
            if (this.fCloseParen.enable(true)) {
                this.fCloseParen.draw(this.fBackgroundGraphics);
            }
            if (this.f0.enable(bl2)) {
                this.f0.draw(this.fBackgroundGraphics);
            }
            if (this.f1.enable(bl2)) {
                this.f1.draw(this.fBackgroundGraphics);
            }
            if (this.f2.enable(bl2)) {
                this.f2.draw(this.fBackgroundGraphics);
            }
            if (this.f3.enable(bl2)) {
                this.f3.draw(this.fBackgroundGraphics);
            }
            if (this.f4.enable(bl2)) {
                this.f4.draw(this.fBackgroundGraphics);
            }
            if (this.f5.enable(bl2)) {
                this.f5.draw(this.fBackgroundGraphics);
            }
            if (this.f6.enable(bl2)) {
                this.f6.draw(this.fBackgroundGraphics);
            }
            if (this.f7.enable(bl2)) {
                this.f7.draw(this.fBackgroundGraphics);
            }
            if (this.f8.enable(bl2)) {
                this.f8.draw(this.fBackgroundGraphics);
            }
            if (this.f9.enable(bl2)) {
                this.f9.draw(this.fBackgroundGraphics);
            }
            if (this.fPeriod.enable(bl2 && this.fDecimal == 0)) {
                this.fPeriod.draw(this.fBackgroundGraphics);
            }
            if (this.fEquals.enable(true)) {
                this.fEquals.draw(this.fBackgroundGraphics);
            }
            if (this.fMult.enable(bl)) {
                this.fMult.draw(this.fBackgroundGraphics);
            }
            if (this.fDiv.enable(true)) {
                this.fDiv.draw(this.fBackgroundGraphics);
            }
            if (this.fAdd.enable(bl)) {
                this.fAdd.draw(this.fBackgroundGraphics);
            }
            if (this.fSub.enable(bl)) {
                this.fSub.draw(this.fBackgroundGraphics);
            }
            if (this.fInv.enable(this.fCalc.autoInverse() && bl3)) {
                this.fInv.draw(this.fBackgroundGraphics);
            }
            this.repaint();
        }
    }

    public String displayString() {
        return this.fDisplayString;
    }

    public void displayString(String string) {
        this.fDisplayString = string;
    }

    public void current(int n) {
        if (this.fCurrent == -1 && n != 0) {
            return;
        }
        this.fCurrent = n;
        this.setButtonEnables();
    }

    public int current() {
        return this.fCurrent;
    }

    public double number() {
        return this.fNumber;
    }

    public void number(double d) {
        this.fNumber = d;
        if (Double.isNaN(d)) {
            this.current(-1);
        }
    }

    private boolean stackEmpty() {
        return this.fStackIndex == 0;
    }

    private void push(double d) {
        if (this.fStackIndex == 20) {
            return;
        }
        this.fStack[this.fStackIndex] = d;
        ++this.fStackIndex;
    }

    private double peek() {
        if (this.stackEmpty()) {
            return 0.0;
        }
        return this.fStack[this.fStackIndex - 1];
    }

    private double pop() {
        if (this.stackEmpty()) {
            return 0.0;
        }
        --this.fStackIndex;
        return this.fStack[this.fStackIndex];
    }

    private void clearStack() {
        this.fStackIndex = 0;
    }

    private void doOperationMult() {
        while (!this.stackEmpty()) {
            int n = (int)this.peek();
            if (n == 40 || n == 43 || n == 45) break;
            n = (int)this.pop();
            double d = this.pop();
            switch (n) {
                case 209: {
                    if (d <= 0.0 || this.fNumber <= 0.0) {
                        utils.showErrorDialog(this.fCalc, fp_resource.getString("str_error__logs_require_positive_value"));
                        this.handleInput('\u0004', true);
                        return;
                    }
                    if (this.fNumber == 1.0) {
                        utils.showErrorDialog(this.fCalc, fp_resource.getString("str_error__base_of_log_cant_be_"));
                        this.handleInput('\u0004', true);
                        return;
                    }
                    this.fNumber = Math.log(d) / Math.log(this.fNumber);
                    this.fTypingLog = false;
                    break;
                }
                case 210: {
                    if (this.fNumber == 0.0) {
                        this.number(Double.NaN);
                        break;
                    }
                    try {
                        this.fNumber = Math.pow(d, 1.0 / this.fNumber);
                    }
                    catch (ArithmeticException arithmeticException) {
                        this.number(Double.NaN);
                        break;
                    }
                    this.fTypingInvExponent = false;
                    this.fTypingExponent = false;
                    this.fDisplayField.setExponent("");
                    break;
                }
                case 207: {
                    if (d == 0.0 && this.fNumber <= 0.0) {
                        this.fTypingExponent = false;
                        this.number(Double.NaN);
                    } else {
                        try {
                            this.fNumber = Math.pow(d, this.fNumber);
                        }
                        catch (ArithmeticException arithmeticException) {
                            this.number(Double.NaN);
                        }
                    }
                    this.fDisplayField.setExponent("");
                    this.fTypingExponent = false;
                    break;
                }
                case 208: {
                    if (this.fNumber == 0.0 && d <= 0.0) {
                        this.number(Double.NaN);
                    } else {
                        try {
                            this.fNumber = Math.pow(this.fNumber, d);
                        }
                        catch (ArithmeticException arithmeticException) {
                            this.number(Double.NaN);
                        }
                    }
                    this.fDisplayField.setExponent("");
                    break;
                }
                case 42: {
                    this.fNumber *= d;
                    break;
                }
                case 47: {
                    if (this.fNumber == 0.0) {
                        this.number(Double.NaN);
                        break;
                    }
                    this.fNumber = d / this.fNumber;
                    break;
                }
                case 45: {
                    this.fNumber = d - this.fNumber;
                    break;
                }
                case 43: {
                    this.fNumber += d;
                    break;
                }
            }
        }
    }

    private void doOperationPlus() {
        while (!this.stackEmpty()) {
            int n = (int)this.peek();
            if (n == 40) break;
            n = (int)this.pop();
            double d = this.pop();
            switch (n) {
                case 207: {
                    if (d == 0.0 && this.fNumber <= 0.0) {
                        this.number(Double.NaN);
                    } else {
                        try {
                            this.fNumber = Math.pow(d, this.fNumber);
                        }
                        catch (ArithmeticException arithmeticException) {
                            this.number(Double.NaN);
                        }
                    }
                    this.fDisplayField.setExponent("");
                    this.fTypingExponent = false;
                    break;
                }
                case 208: {
                    if (this.fNumber == 0.0 && d <= 0.0) {
                        this.number(Double.NaN);
                    } else {
                        try {
                            this.fNumber = Math.pow(this.fNumber, d);
                        }
                        catch (ArithmeticException arithmeticException) {
                            this.number(Double.NaN);
                        }
                    }
                    this.fDisplayField.setExponent("");
                    break;
                }
                case 209: {
                    if (d <= 0.0 || this.fNumber <= 0.0) {
                        utils.showErrorDialog(this.fCalc, fp_resource.getString("str_error__logs_require_positive_value"));
                        this.handleInput('\u0004', true);
                        return;
                    }
                    if (this.fNumber == 1.0) {
                        utils.showErrorDialog(this.fCalc, fp_resource.getString("str_error__base_of_log_cant_be_"));
                        this.handleInput('\u0004', true);
                        return;
                    }
                    this.fNumber = Math.log(d) / Math.log(this.fNumber);
                    this.fTypingLog = false;
                    break;
                }
                case 210: {
                    if (this.fNumber == 0.0) {
                        this.number(Double.NaN);
                        break;
                    }
                    try {
                        this.fNumber = Math.pow(d, 1.0 / this.fNumber);
                    }
                    catch (ArithmeticException arithmeticException) {
                        this.number(Double.NaN);
                        break;
                    }
                    this.fTypingInvExponent = false;
                    this.fTypingExponent = false;
                    this.fDisplayField.setExponent("");
                    break;
                }
                case 42: {
                    this.fNumber *= d;
                    break;
                }
                case 47: {
                    if (this.fNumber == 0.0) {
                        this.number(Double.NaN);
                        break;
                    }
                    this.fNumber = d / this.fNumber;
                    break;
                }
                case 45: {
                    this.fNumber = d - this.fNumber;
                    break;
                }
                case 43: {
                    this.fNumber += d;
                    break;
                }
            }
        }
    }

    public void handleEditInput(char c) {
        EditDisplayField editDisplayField = this.fEditField;
        switch (c) {
            case 'i': {
                editDisplayField.pushFunctionToCurrent("+/-", 105);
                break;
            }
            case '\u0001': {
                this.fNumber = Math.PI;
                this.fDisplayString = CalcUtils.toString(this.fNumber);
                editDisplayField.pushStringToCurrentRow(this.fDisplayString);
                break;
            }
            case '\u0002': {
                this.fNumber = Math.E;
                this.fDisplayString = CalcUtils.toString(this.fNumber);
                editDisplayField.pushStringToCurrentRow(this.fDisplayString);
                break;
            }
            case '(': {
                editDisplayField.pushToCurrentRow(c);
                break;
            }
            case ')': {
                editDisplayField.pushToCurrentRow(c);
                break;
            }
            case '\u0003': {
                editDisplayField.clearRow();
                break;
            }
            case '\u0004': {
                editDisplayField.clearRow();
                break;
            }
            case '=': {
                editDisplayField.endRow(this.fDisplayString);
                break;
            }
            case '\u00cf': {
                editDisplayField.pushFunctionToCurrent("%xA", 207);
                break;
            }
            case '\u00d0': {
                editDisplayField.pushFunctionToCurrent("%aX", 208);
                break;
            }
            case '\u00d1': {
                editDisplayField.pushFunctionToCurrent("%log_ x", 209);
                break;
            }
            case '\u00d2': {
                editDisplayField.pushFunctionToCurrent("%xI", 210);
                break;
            }
            case '*': 
            case '+': 
            case '-': 
            case '.': 
            case '/': 
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': 
            case '8': 
            case '9': {
                editDisplayField.pushToCurrentRow(c);
                editDisplayField.redraw();
                break;
            }
            default: {
                return;
            }
        }
        this.fEditField.redraw();
        this.fEditField.repaint();
    }

    public void handleInput(char c, boolean bl) {
        if (this.fCalc.matrixView()) {
            this.fCalc.matrixCanvas().matrixViewInput(c);
            return;
        }
        if (this.fCalc.editing()) {
            this.handleEditInput(c);
            return;
        }
        switch (c) {
            case '\n': {
                if (this.fCurrent == 0 || this.fCurrent == 3) {
                    return;
                }
                if (this.fNumOpenParens > 0) {
                    return;
                }
                if (this.fCurrent == 1) {
                    this.fSpecialField.pushStringToCurrentRow(this.fDisplayString);
                }
                this.doOperationPlus();
                this.fDisplayString = CalcUtils.toString(this.fNumber);
                if (this.fCurrent == 4) {
                    this.fSpecialField.endRowNoEqual(this.fDisplayString);
                } else {
                    this.fSpecialField.endRow(this.fDisplayString);
                }
                this.current(3);
                if (!bl) break;
                this.fSpecialField.redraw();
                break;
            }
            case 'i': {
                if (this.fCurrent == 0) {
                    return;
                }
                if (this.fCurrent == 1 || this.fCurrent == 3) {
                    this.fSpecialField.pushStringToCurrentRow(this.fDisplayString);
                }
                this.fNumber = -this.fNumber;
                this.fDisplayString = CalcUtils.toString(this.fNumber);
                this.fSpecialField.setResult(this.fDisplayString);
                this.fSpecialField.pushFunctionToCurrent("+/-", 105);
                this.current(2);
                if (!bl) break;
                this.fSpecialField.redraw();
                break;
            }
            case '\u0001': {
                if (this.fCurrent == 1 || this.fCurrent == 2) {
                    return;
                }
                if (this.fCurrent == 4) {
                    this.fSpecialField.endRowNoEqual(this.fDisplayString);
                    this.current(3);
                }
                this.fNumber = Math.PI;
                this.fDisplayString = CalcUtils.toString(this.fNumber);
                this.fSpecialField.setResult(this.fDisplayString);
                this.fSpecialField.pushStringToCurrentRow(this.fDisplayString);
                this.current(2);
                if (!bl) break;
                this.fSpecialField.redraw();
                break;
            }
            case '\u0002': {
                if (this.fCurrent == 1 || this.fCurrent == 2) {
                    return;
                }
                if (this.fCurrent == 4) {
                    this.fSpecialField.endRowNoEqual(this.fDisplayString);
                    this.current(3);
                }
                this.fNumber = Math.E;
                this.fDisplayString = CalcUtils.toString(this.fNumber);
                this.fSpecialField.setResult(this.fDisplayString);
                this.fSpecialField.pushStringToCurrentRow(this.fDisplayString);
                this.current(2);
                if (!bl) break;
                this.fSpecialField.redraw();
                break;
            }
            case '(': {
                if (this.fCurrent == 1 || this.fCurrent == 2) {
                    return;
                }
                this.fTypingExponent = false;
                this.fTypingInvExponent = false;
                this.fTypingLog = false;
                if (this.fCurrent == 4) {
                    this.fSpecialField.endRowNoEqual(this.fDisplayString);
                    this.current(3);
                }
                this.push(c);
                ++this.fNumOpenParens;
                this.fSpecialField.pushToCurrentRow(c);
                this.current(0);
                if (!bl) break;
                this.fSpecialField.redraw();
                break;
            }
            case ')': {
                if (this.fCurrent == 0) {
                    return;
                }
                if (this.fNumOpenParens == 0) {
                    return;
                }
                if (this.fCurrent == 1) {
                    this.fSpecialField.pushStringToCurrentRow(this.fDisplayString);
                }
                --this.fNumOpenParens;
                this.doOperationPlus();
                this.pop();
                this.fDisplayString = CalcUtils.toString(this.fNumber);
                this.fSpecialField.setResult(this.fDisplayString);
                this.current(2);
                this.fSpecialField.pushToCurrentRow(c);
                if (!bl) break;
                this.fSpecialField.redraw();
                break;
            }
            case '\u0003': {
                if (this.fCurrent == 2 || this.fCurrent == 4) {
                    this.fSpecialField.endRowNoEqual(this.fDisplayString);
                    this.current(3);
                }
                this.fNumber = 0.0;
                this.fDisplayString = "0";
                this.fSpecialField.setResult("");
                this.current(0);
                break;
            }
            case '\u0004': {
                this.clearAll();
                this.fSpecialField.clearRow();
                if (!bl) break;
                this.fSpecialField.redraw();
                break;
            }
            case '=': {
                if (this.fCurrent == 0 || this.fCurrent == 4) {
                    return;
                }
                if (this.fNumOpenParens > 0) {
                    return;
                }
                if (this.fCurrent == 1 || this.fCurrent == 3) {
                    this.fSpecialField.pushStringToCurrentRow(this.fDisplayString);
                }
                this.doOperationPlus();
                this.fDisplayString = CalcUtils.toString(this.fNumber);
                this.current(4);
                this.fSpecialField.pushStringToCurrentRow("=");
                this.fSpecialField.setResult(this.fDisplayString);
                if (!bl) break;
                this.fSpecialField.redraw();
                break;
            }
            case '\u00cf': {
                if (this.fCurrent == 0) {
                    return;
                }
                this.push(this.fNumber);
                this.push(c);
                this.fSpecialField.pushFunctionToCurrent("%xA", 207);
                this.current(0);
                this.fTypingExponent = true;
                this.fDisplayString = "_";
                if (!bl) break;
                this.fSpecialField.redraw();
                break;
            }
            case '\u00d0': {
                if (this.fCurrent == 0) {
                    return;
                }
                this.push(this.fNumber);
                this.push(c);
                this.fDisplayField.setExponent(this.fDisplayString);
                this.fDisplayString = "_";
                this.fSpecialField.pushFunctionToCurrent("%aX", 208);
                this.current(0);
                if (!bl) break;
                this.fSpecialField.redraw();
                break;
            }
            case '\u00d1': {
                if (this.fCurrent == 0) {
                    return;
                }
                this.push(this.fNumber);
                this.push(c);
                this.fSpecialField.pushFunctionToCurrent("%log_ x", 209);
                this.current(0);
                this.fTypingLog = true;
                this.fDisplayString = "_";
                this.fLogVal = CalcUtils.toString(this.fNumber);
                if (!bl) break;
                this.fSpecialField.redraw();
                break;
            }
            case '\u00d2': {
                if (this.fCurrent == 0) {
                    return;
                }
                this.push(this.fNumber);
                this.push(c);
                this.fSpecialField.pushFunctionToCurrent("%xI", 210);
                this.current(0);
                this.fTypingExponent = true;
                this.fTypingInvExponent = true;
                this.fDisplayString = "_";
                if (!bl) break;
                this.fSpecialField.redraw();
                break;
            }
            case '*': 
            case '/': {
                int n;
                if (this.fCurrent == 0) {
                    return;
                }
                if (this.fCurrent == 1 || this.fCurrent == 3) {
                    this.fTypingExponent = false;
                    this.fTypingInvExponent = false;
                    this.fTypingLog = false;
                    this.fSpecialField.pushStringToCurrentRow(this.fDisplayString);
                    this.fSpecialField.setResult(this.fDisplayString);
                }
                if (!this.stackEmpty() && (n = (int)this.peek()) != 43 && n != 45) {
                    this.doOperationMult();
                    this.fDisplayString = CalcUtils.toString(this.fNumber);
                    this.fSpecialField.setResult(this.fDisplayString);
                }
                this.push(this.fNumber);
                this.push(c);
                this.current(0);
                this.fSpecialField.pushToCurrentRow(c);
                if (!bl) break;
                this.fSpecialField.redraw();
                break;
            }
            case '+': 
            case '-': {
                if (this.fCurrent == 0) {
                    return;
                }
                if (this.fCurrent == 1 || this.fCurrent == 3) {
                    this.fSpecialField.pushStringToCurrentRow(this.fDisplayString);
                    this.fSpecialField.setResult(this.fDisplayString);
                }
                if (!this.stackEmpty()) {
                    this.doOperationPlus();
                    this.fDisplayString = CalcUtils.toString(this.fNumber);
                    this.fSpecialField.setResult(this.fDisplayString);
                }
                this.fSpecialField.setResult(this.fDisplayString);
                this.push(this.fNumber);
                this.push(c);
                this.current(0);
                this.fSpecialField.pushToCurrentRow(c);
                if (!bl) break;
                this.fSpecialField.redraw();
                break;
            }
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': 
            case '8': 
            case '9': {
                if (this.fCurrent == 2) break;
                if (this.fCurrent == 4) {
                    this.fSpecialField.endRowNoEqual(this.fDisplayString);
                    this.current(3);
                }
                if (this.fCurrent == 1) {
                    if (this.fDecimal == 0) {
                        this.fNumber = this.fNumber * 10.0 + (double)c - 48.0;
                    } else {
                        try {
                            this.fNumber += (double)(c - 48) / Math.pow(10.0, this.fDecimalPlace);
                            ++this.fDecimalPlace;
                        }
                        catch (ArithmeticException arithmeticException) {
                            this.number(Double.NaN);
                            break;
                        }
                    }
                    this.fDisplayString = String.valueOf(this.fDisplayString) + String.valueOf(c - 48);
                    break;
                }
                this.fDisplayString = String.valueOf(c - 48);
                this.fNumber = c - 48;
                this.fDecimal = 0;
                this.fDecimalPlace = 0;
                this.current(1);
                break;
            }
            case '.': {
                if (this.fCurrent == 2) break;
                if (this.fCurrent == 4) {
                    this.fSpecialField.endRowNoEqual(this.fDisplayString);
                    this.current(3);
                }
                if (this.fCurrent == 1) {
                    if (this.fDecimal != 0) break;
                    this.fDisplayString = String.valueOf(this.fDisplayString) + ".";
                    this.fDecimalPlace = 1;
                    this.fDecimal = 1;
                    break;
                }
                this.current(1);
                this.fDisplayString = "0.";
                this.fDecimalPlace = 1;
                this.fNumber = 0.0;
                this.fDecimal = 1;
                break;
            }
            default: {
                this.current(0);
                this.fDisplayString = "0";
                this.fNumber = 0.0;
                return;
            }
        }
        if (this.fTypingExponent) {
            if (this.fTypingInvExponent) {
                this.fDisplayField.setExponent("1/" + this.fDisplayString);
            } else {
                this.fDisplayField.setExponent(this.fDisplayString);
            }
        } else if (this.fTypingLog) {
            this.fDisplayField.setDisplay("log~" + this.fDisplayString + "#" + this.fLogVal);
        } else {
            this.fDisplayField.setDisplay(this.fDisplayString);
        }
        if (bl) {
            this.fDisplayField.repaint();
        }
    }

    public synchronized boolean mouseDown(Event event, int n, int n2) {
        this.fPi.handleMouseDown(n, n2);
        this.fE.handleMouseDown(n, n2);
        this.fClearAll.handleMouseDown(n, n2);
        this.fChangeSign.handleMouseDown(n, n2);
        this.fClear.handleMouseDown(n, n2);
        this.fOpenParen.handleMouseDown(n, n2);
        this.fCloseParen.handleMouseDown(n, n2);
        this.f0.handleMouseDown(n, n2);
        this.f1.handleMouseDown(n, n2);
        this.f2.handleMouseDown(n, n2);
        this.f3.handleMouseDown(n, n2);
        this.f4.handleMouseDown(n, n2);
        this.f5.handleMouseDown(n, n2);
        this.f6.handleMouseDown(n, n2);
        this.f7.handleMouseDown(n, n2);
        this.f8.handleMouseDown(n, n2);
        this.f9.handleMouseDown(n, n2);
        this.fPeriod.handleMouseDown(n, n2);
        this.fEquals.handleMouseDown(n, n2);
        this.fMult.handleMouseDown(n, n2);
        this.fDiv.handleMouseDown(n, n2);
        this.fAdd.handleMouseDown(n, n2);
        this.fSub.handleMouseDown(n, n2);
        this.fInv.handleToggleMouseDown(n, n2);
        this.repaint();
        return false;
    }

    public synchronized boolean mouseUp(Event event, int n, int n2) {
        if (this.fClearAll.handleMouseUp(n, n2)) {
            this.handleInput('\u0004', true);
        }
        if (this.fPi.handleMouseUp(n, n2)) {
            this.handleInput('\u0001', true);
        }
        if (this.fE.handleMouseUp(n, n2)) {
            this.handleInput('\u0002', true);
        }
        if (this.fChangeSign.handleMouseUp(n, n2)) {
            this.handleInput('i', true);
        }
        if (this.fClear.handleMouseUp(n, n2)) {
            this.handleInput('\u0003', true);
        }
        if (this.fOpenParen.handleMouseUp(n, n2)) {
            this.handleInput('(', true);
        }
        if (this.fCloseParen.handleMouseUp(n, n2)) {
            this.handleInput(')', true);
        }
        if (this.f0.handleMouseUp(n, n2)) {
            this.handleInput('0', true);
        }
        if (this.f1.handleMouseUp(n, n2)) {
            this.handleInput('1', true);
        }
        if (this.f2.handleMouseUp(n, n2)) {
            this.handleInput('2', true);
        }
        if (this.f3.handleMouseUp(n, n2)) {
            this.handleInput('3', true);
        }
        if (this.f4.handleMouseUp(n, n2)) {
            this.handleInput('4', true);
        }
        if (this.f5.handleMouseUp(n, n2)) {
            this.handleInput('5', true);
        }
        if (this.f6.handleMouseUp(n, n2)) {
            this.handleInput('6', true);
        }
        if (this.f7.handleMouseUp(n, n2)) {
            this.handleInput('7', true);
        }
        if (this.f8.handleMouseUp(n, n2)) {
            this.handleInput('8', true);
        }
        if (this.f9.handleMouseUp(n, n2)) {
            this.handleInput('9', true);
        }
        if (this.fPeriod.handleMouseUp(n, n2)) {
            this.handleInput('.', true);
        }
        if (this.fEquals.handleMouseUp(n, n2)) {
            this.handleInput('=', true);
        }
        if (this.fMult.handleMouseUp(n, n2)) {
            this.handleInput('*', true);
        }
        if (this.fDiv.handleMouseUp(n, n2)) {
            this.handleInput('/', true);
        }
        if (this.fAdd.handleMouseUp(n, n2)) {
            this.handleInput('+', true);
        }
        if (this.fSub.handleMouseUp(n, n2)) {
            this.handleInput('-', true);
        }
        if (this.fInv.handleToggleMouseUp(n, n2)) {
            if (this.fCalc.matrixView()) {
                this.fCalc.matrixCanvas().doInverse();
                this.fInv.select(false);
                this.repaint();
                return false;
            }
            this.fCalc.toggleInverses();
            return false;
        }
        this.fInv.select(this.fCalc.functionCanvas().inverses());
        this.repaint();
        return false;
    }

    public void setInverseButtonState(boolean bl) {
        this.fInv.select(bl);
        this.repaint();
    }

    public synchronized boolean mouseDrag(Event event, int n, int n2) {
        boolean bl = false;
        if (this.fClearAll.handleMouseDrag(n, n2)) {
            bl = true;
        } else if (this.fPi.handleMouseDrag(n, n2)) {
            bl = true;
        } else if (this.fE.handleMouseDrag(n, n2)) {
            bl = true;
        } else if (this.fChangeSign.handleMouseDrag(n, n2)) {
            bl = true;
        } else if (this.fClear.handleMouseDrag(n, n2)) {
            bl = true;
        } else if (this.fOpenParen.handleMouseDrag(n, n2)) {
            bl = true;
        } else if (this.fCloseParen.handleMouseDrag(n, n2)) {
            bl = true;
        } else if (this.f0.handleMouseDrag(n, n2)) {
            bl = true;
        } else if (this.f1.handleMouseDrag(n, n2)) {
            bl = true;
        } else if (this.f2.handleMouseDrag(n, n2)) {
            bl = true;
        } else if (this.f3.handleMouseDrag(n, n2)) {
            bl = true;
        } else if (this.f4.handleMouseDrag(n, n2)) {
            bl = true;
        } else if (this.f5.handleMouseDrag(n, n2)) {
            bl = true;
        } else if (this.f6.handleMouseDrag(n, n2)) {
            bl = true;
        } else if (this.f7.handleMouseDrag(n, n2)) {
            bl = true;
        } else if (this.f8.handleMouseDrag(n, n2)) {
            bl = true;
        } else if (this.f9.handleMouseDrag(n, n2)) {
            bl = true;
        } else if (this.fPeriod.handleMouseDrag(n, n2)) {
            bl = true;
        } else if (this.fEquals.handleMouseDrag(n, n2)) {
            bl = true;
        } else if (this.fMult.handleMouseDrag(n, n2)) {
            bl = true;
        } else if (this.fDiv.handleMouseDrag(n, n2)) {
            bl = true;
        } else if (this.fAdd.handleMouseDrag(n, n2)) {
            bl = true;
        } else if (this.fSub.handleMouseDrag(n, n2)) {
            bl = true;
        } else if (this.fInv.handleToggleMouseDrag(n, n2)) {
            bl = true;
        }
        if (bl) {
            this.repaint();
        }
        return false;
    }

    public boolean keyDown(Event event, int n) {
        if ((event.modifiers & 2) != 0 || (event.modifiers & 4) != 0 || (event.modifiers & 8) != 0) {
            return super.keyDown(event, n);
        }
        switch (n) {
            case 48: {
                this.clearAllSelects();
                this.f0.select(true);
                this.repaint();
                break;
            }
            case 49: {
                this.clearAllSelects();
                this.f1.select(true);
                this.repaint();
                break;
            }
            case 50: {
                this.clearAllSelects();
                this.f2.select(true);
                this.repaint();
                break;
            }
            case 51: {
                this.clearAllSelects();
                this.f3.select(true);
                this.repaint();
                break;
            }
            case 52: {
                this.clearAllSelects();
                this.f4.select(true);
                this.repaint();
                break;
            }
            case 53: {
                this.clearAllSelects();
                this.f5.select(true);
                this.repaint();
                break;
            }
            case 54: {
                this.clearAllSelects();
                this.f6.select(true);
                this.repaint();
                break;
            }
            case 55: {
                this.clearAllSelects();
                this.f7.select(true);
                this.repaint();
                break;
            }
            case 56: {
                this.clearAllSelects();
                this.f8.select(true);
                this.repaint();
                break;
            }
            case 57: {
                this.clearAllSelects();
                this.f9.select(true);
                this.repaint();
                break;
            }
            case 61: {
                this.clearAllSelects();
                this.fEquals.select(true);
                this.repaint();
                break;
            }
            case 40: {
                this.clearAllSelects();
                this.fOpenParen.select(true);
                this.repaint();
                break;
            }
            case 41: {
                this.clearAllSelects();
                this.fCloseParen.select(true);
                this.repaint();
                break;
            }
            case 99: {
                this.clearAllSelects();
                this.fClear.select(true);
                this.repaint();
                break;
            }
            case 46: {
                this.clearAllSelects();
                this.fPeriod.select(true);
                this.repaint();
                break;
            }
            case 42: {
                this.clearAllSelects();
                this.fMult.select(true);
                this.repaint();
                break;
            }
            case 47: {
                this.clearAllSelects();
                this.fDiv.select(true);
                this.repaint();
                break;
            }
            case 43: {
                this.clearAllSelects();
                this.fAdd.select(true);
                this.repaint();
                break;
            }
            case 45: {
                this.clearAllSelects();
                this.fSub.select(true);
                this.repaint();
                break;
            }
            case 112: {
                this.clearAllSelects();
                this.fPi.select(true);
                this.repaint();
                break;
            }
            case 101: {
                this.clearAllSelects();
                this.fE.select(true);
                this.repaint();
                break;
            }
        }
        return false;
    }

    public void clearAll() {
        this.fNumber = 0.0;
        this.fNumOpenParens = 0;
        this.fDisplayString = "0";
        this.fDisplayField.setDisplay("0");
        this.fDisplayField.setExponent("");
        this.clear();
        this.current(0);
        this.clearStack();
    }

    public void setValueTo(double d) {
        if (this.fCurrent == 1 || this.fCurrent == 2) {
            utils.showErrorDialog(this.fCalc, fp_resource.getString("str_error__entering_a_number_doesnt_make_sense_here"));
            return;
        }
        if (this.fCurrent == 4) {
            this.fSpecialField.endRowNoEqual(this.fDisplayString);
            this.current(3);
        }
        this.fNumber = d;
        this.fDisplayString = CalcUtils.toString(d);
        this.fSpecialField.pushStringToCurrentRow(this.fDisplayString);
        this.current(2);
        this.fSpecialField.redraw();
        this.fDisplayField.setDisplay(d);
        this.fDisplayField.repaint();
    }

    private boolean checkSelect(CalcButton calcButton) {
        if (calcButton.select()) {
            this.handleInput(calcButton.id(), true);
            calcButton.select(false);
            return true;
        }
        calcButton.select(false);
        return false;
    }

    private boolean clearAllSelects() {
        if (this.checkSelect(this.f0)) {
            return true;
        }
        if (this.checkSelect(this.f1)) {
            return true;
        }
        if (this.checkSelect(this.f2)) {
            return true;
        }
        if (this.checkSelect(this.f3)) {
            return true;
        }
        if (this.checkSelect(this.f4)) {
            return true;
        }
        if (this.checkSelect(this.f5)) {
            return true;
        }
        if (this.checkSelect(this.f6)) {
            return true;
        }
        if (this.checkSelect(this.f7)) {
            return true;
        }
        if (this.checkSelect(this.f8)) {
            return true;
        }
        if (this.checkSelect(this.f9)) {
            return true;
        }
        if (this.checkSelect(this.fEquals)) {
            return true;
        }
        if (this.checkSelect(this.fOpenParen)) {
            return true;
        }
        if (this.checkSelect(this.fCloseParen)) {
            return true;
        }
        if (this.checkSelect(this.fClear)) {
            return true;
        }
        if (this.checkSelect(this.fClearAll)) {
            return true;
        }
        if (this.checkSelect(this.fPeriod)) {
            return true;
        }
        if (this.checkSelect(this.fMult)) {
            return true;
        }
        if (this.checkSelect(this.fAdd)) {
            return true;
        }
        if (this.checkSelect(this.fSub)) {
            return true;
        }
        if (this.checkSelect(this.fDiv)) {
            return true;
        }
        if (this.checkSelect(this.fPi)) {
            return true;
        }
        return this.checkSelect(this.fE);
    }

    public boolean keyUp(Event event, int n) {
        if (n == 8) {
            if (this.fCalc.editing()) {
                this.fEditField.doBackspace();
                this.fEditField.redraw();
                this.fEditField.repaint();
            }
        } else if (n == 13 || n == 10) {
            this.handleInput('\n', true);
        } else if (this.clearAllSelects()) {
            this.repaint();
        }
        return false;
    }

    public int decimal() {
        return this.fDecimal;
    }

    public void decimal(int n) {
        this.fDecimal = n;
    }

    public int decimalPlace() {
        return this.fDecimalPlace;
    }

    public void decimalPlace(int n) {
        this.fDecimalPlace = n;
    }

    public int numOpenParens() {
        return this.fNumOpenParens;
    }

    public void numOpenParens(int n) {
        this.fNumOpenParens = n;
    }
}

