/*
 * Decompiled with CFR 0.152.
 */
package com.questmsm.FPCalculator;

import com.questmsm.FPCalculator.Calculator;
import com.questmsm.FPCalculator.EditButtons;
import com.questmsm.FPCalculator.Row;
import com.questmsm.FPCalculator.RowContainer;
import com.questmsm.FPCalculator.SpecialTextField;
import com.questmsm.Utilities.utils;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Event;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;

public class EditDisplayField
extends Canvas
implements RowContainer {
    private Font fMainFont;
    private Font fSmallFont;
    private FontMetrics fMainMetric;
    private Calculator fCalc;
    private Row fRow;
    private EditButtons fEditButtons;
    private final int kSpacing = 3;
    private Image fBackgroundImage = null;
    private Image fForegroundImage = null;
    private Graphics fBackgroundGraphics = null;
    private Graphics fForegroundGraphics = null;

    public EditDisplayField(Calculator calculator, EditButtons editButtons, Color color) {
        this.fCalc = calculator;
        this.fEditButtons = editButtons;
        this.setBackground(color);
        this.fMainFont = new Font("Times", 1, 18);
        this.fSmallFont = new Font("Times", 1, 14);
        this.fMainMetric = this.getFontMetrics(this.fMainFont);
        this.fRow = new Row(this, 5, 17);
        this.fRow.editable(true);
    }

    public void clear() {
        this.fRow.clear();
    }

    public Row row() {
        return this.fRow;
    }

    public void createImages(int n, int n2) {
        this.fBackgroundImage = this.createImage(n, n2);
        this.fBackgroundGraphics = this.fBackgroundImage.getGraphics();
        this.fForegroundImage = this.createImage(n, n2);
        this.fForegroundGraphics = this.fForegroundImage.getGraphics();
    }

    public void setBounds(int n, int n2, int n3, int n4) {
        super.setBounds(n, n2, n3, n4);
        this.createImages(n3, n4);
        this.drawBackground();
    }

    private synchronized void drawBackground(Graphics graphics) {
        if (graphics == null) {
            return;
        }
        graphics.setFont(this.fMainFont);
        utils.fancyBorder(graphics, this.getSize().width, this.getSize().height);
        graphics.setColor(Color.black);
        this.fRow.draw(graphics);
    }

    public synchronized void drawBackground() {
        this.drawBackground(this.fBackgroundGraphics);
    }

    private synchronized void drawForeground(Graphics graphics) {
        graphics.setFont(this.fMainFont);
        this.fRow.drawSelected(graphics);
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public synchronized void paint(Graphics graphics) {
        if (this.fBackgroundImage == null) {
            return;
        }
        if (this.fForegroundImage == null) {
            return;
        }
        this.fForegroundGraphics.drawImage(this.fBackgroundImage, 0, 0, this);
        this.drawForeground(this.fForegroundGraphics);
        graphics.drawImage(this.fForegroundImage, 0, 0, this);
    }

    public void pushchar(char c) {
        this.fRow.add(c);
    }

    public int resultLineLoc() {
        return 5;
    }

    public boolean keyDown(Event event, int n) {
        this.fCalc.setFocus();
        this.fCalc.buttonsKeyDown(event, n);
        return false;
    }

    public synchronized boolean mouseDrag(Event event, int n, int n2) {
        if (this.fRow.handleDrag(n, n2)) {
            this.repaint();
            this.fCalc.setFocus();
            return true;
        }
        this.fCalc.setFocus();
        return false;
    }

    public synchronized boolean mouseDown(Event event, int n, int n2) {
        if (this.fRow.handleMouse(n, n2, true)) {
            this.repaint();
            this.fCalc.setFocus();
            return true;
        }
        this.fCalc.setFocus();
        return false;
    }

    public synchronized void redraw() {
        this.drawBackground();
        this.repaint();
    }

    public void pushStringToCurrentRow(String string) {
        int n = 0;
        while (n < string.length()) {
            this.fRow.insert(string.charAt(n));
            ++n;
        }
        this.fEditButtons.okEnable(this.fRow.isValid());
    }

    public void pushFunctionToCurrent(String string, int n) {
        this.fRow.insert(string, n);
        this.fEditButtons.okEnable(this.fRow.isValid());
    }

    public void pushToCurrentRow(char c) {
        this.fRow.insert(c);
        this.fEditButtons.okEnable(this.fRow.isValid());
    }

    public void clearRow() {
        this.fRow.clear();
        this.drawBackground();
        this.fEditButtons.okEnable(false);
    }

    public void endRow(String string) {
        this.fRow.insert('=');
        this.fEditButtons.okEnable(this.fRow.isValid());
    }

    public void doBackspace() {
        this.fRow.backspace();
        this.fEditButtons.okEnable(this.fRow.isValid());
    }

    public void transferRow(SpecialTextField specialTextField) {
        specialTextField.clearRow();
        this.fRow.transferRow(specialTextField, this.fCalc);
    }

    public void createNewRow() {
    }

    public void setResult(String string) {
    }
}

