/*
 * Decompiled with CFR 0.152.
 */
package com.questmsm.FPCalculator;

import com.questmsm.FPCalculator.CalcUtils;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.ImageObserver;
import java.io.Serializable;

public class FunctionButton
implements Serializable {
    private static transient Image fImg;
    private static transient Image fImgInv;
    private static transient ImageObserver fObs;
    private int fx;
    private int fy;
    private int fHeight;
    private int fWidth;
    private boolean fSelected;
    private String fLabel;
    private boolean fVisible;
    private boolean fInvDefined;
    public static final int kXGrid = 64;
    public static final int kYGrid = 24;
    private final int kXoffset = 0;
    private final int kYoffset = 1;
    private static final Font Times12B;
    private static final Font Times9B;

    static {
        Times12B = new Font("Times", 1, 12);
        Times9B = new Font("Times", 1, 9);
    }

    public FunctionButton(String string, boolean bl) {
        this.fLabel = string;
        this.fHeight = fImg.getHeight(fObs);
        this.fWidth = fImg.getWidth(fObs);
        this.fVisible = bl;
        this.fInvDefined = false;
        this.select(false);
        this.setPos(0, 0);
    }

    public static void setStaticVars(Image image, Image image2, ImageObserver imageObserver) {
        fImg = image;
        fImgInv = image2;
        fObs = imageObserver;
    }

    public FunctionButton copy() {
        FunctionButton functionButton = new FunctionButton(this.fLabel, this.fVisible);
        functionButton.fInvDefined = this.fInvDefined;
        return functionButton;
    }

    public void setLoc(int n, int n2) {
        this.setPos(64 * n, 1 + 24 * n2);
    }

    public void setInverse(boolean bl) {
        this.fInvDefined = bl;
    }

    public boolean inverse() {
        return this.fInvDefined;
    }

    public String label() {
        return this.fLabel;
    }

    public void label(String string) {
        this.fLabel = string;
    }

    public void select(boolean bl) {
        this.fSelected = bl;
    }

    public void setPos(int n, int n2) {
        this.fx = n;
        this.fy = n2;
    }

    private void drawString(Graphics graphics) {
        int n = -1;
        CalcUtils.drawSpecial(graphics, this.fLabel, this.fx, fImg.getWidth(fObs), this.fy + n + 16, Times12B, Times9B);
    }

    public boolean visible() {
        return this.fVisible;
    }

    public void visible(boolean bl) {
        this.fVisible = bl;
    }

    public void drawIfSelected(Graphics graphics) {
        if (!this.visible()) {
            return;
        }
        if (this.fSelected) {
            graphics.drawImage(fImgInv, this.fx, this.fy, fObs);
            graphics.setColor(Color.white);
            if (this.fLabel.equals("?")) {
                graphics.fillOval(this.fx + fImg.getWidth(fObs) / 2 - 8, this.fy + 4, 16, 14);
                graphics.setColor(Color.black);
            }
            this.drawString(graphics);
        }
    }

    public void draw(Graphics graphics) {
        if (!this.visible()) {
            return;
        }
        graphics.drawImage(fImg, this.fx, this.fy, fObs);
        graphics.setColor(Color.black);
        if (this.fLabel.equals("?")) {
            graphics.fillOval(this.fx + fImg.getWidth(fObs) / 2 - 8, this.fy + 4, 16, 14);
            graphics.setColor(Color.white);
        }
        this.drawString(graphics);
    }

    public boolean handleMouseDrag(int n, int n2) {
        if (!this.visible()) {
            return false;
        }
        boolean bl = this.fSelected;
        this.fSelected = false;
        if (n < this.fx) {
            return bl;
        }
        if (n > this.fx + this.fWidth) {
            return bl;
        }
        if (n2 < this.fy) {
            return bl;
        }
        if (n2 > this.fy + this.fHeight) {
            return bl;
        }
        this.fSelected = true;
        return !bl;
    }

    public boolean handleMouseDown(int n, int n2) {
        if (!this.visible()) {
            return false;
        }
        this.fSelected = false;
        if (n < this.fx) {
            return false;
        }
        if (n > this.fx + this.fWidth) {
            return false;
        }
        if (n2 < this.fy) {
            return false;
        }
        if (n2 > this.fy + this.fHeight) {
            return false;
        }
        this.fSelected = true;
        return true;
    }

    public boolean handleMouseUp(int n, int n2) {
        if (!this.visible()) {
            return false;
        }
        boolean bl = this.fSelected;
        this.fSelected = false;
        return bl;
    }
}

