/*
 * Decompiled with CFR 0.152.
 */
package com.questmsm.FPCalculator;

import com.questmsm.FPCalculator.CalcUtils;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.io.Serializable;

public class Node
implements Serializable {
    public static final int kChar = 0;
    public static final int kImage = 1;
    public static final int kFunction = 2;
    public static final int kError = -1;
    private int fKind;
    private int fLeft;
    private int fRight;
    private int fSpacing;
    private char fChar;
    private int fWidth;
    private int fFunctionType;
    private String fLabel = null;
    private static final Font fBigFont = new Font("Times", 0, 10);
    private static final Font fSmallFont = new Font("Times", 0, 9);
    private static FontMetrics fMetric;
    private static final int kFunctionWidth = 30;
    private static final int kFunctionHeight = 18;

    public Node() {
        this.fKind = -1;
    }

    public Node(char c) {
        this.fKind = 0;
        this.fChar = c;
        this.fLeft = 0;
        this.fRight = 0;
        this.fSpacing = 0;
        this.setWidth();
    }

    public Node(String string, int n) {
        this.fKind = 2;
        this.fFunctionType = n;
        this.fLabel = string;
        this.fLeft = 0;
        this.fRight = 0;
        this.fSpacing = 0;
        this.setWidth();
    }

    public static void setMetric(Canvas canvas) {
        fMetric = canvas.getFontMetrics(fBigFont);
    }

    private void setWidth() {
        this.fWidth = 0;
        if (fMetric == null) {
            return;
        }
        if (this.fKind == 2) {
            this.fWidth = fMetric.stringWidth(this.fLabel) + 8;
            if (this.fWidth < 30) {
                this.fWidth = 30;
            }
        } else if (this.fKind == 0) {
            this.fWidth = fMetric.charWidth(this.fChar);
        }
    }

    public Node copy() {
        switch (this.fKind) {
            case 0: {
                return new Node(this.fChar);
            }
            case 2: {
                return new Node(this.fLabel, this.fFunctionType);
            }
        }
        return null;
    }

    public int kind() {
        return this.fKind;
    }

    public char theChar() {
        return this.fChar;
    }

    public void setChar(char c) {
        this.fChar = c;
    }

    public int functionType() {
        return this.fFunctionType;
    }

    public int itemWidth() {
        return this.fWidth;
    }

    public String label() {
        return this.fLabel;
    }

    public void setSpacing(int n, int n2, int n3) {
        this.fLeft = n;
        this.fRight = n2;
        this.fSpacing = n3;
    }

    public void drawFunction(Graphics graphics, int n, int n2, boolean bl) {
        int n3 = n + (n2 - 18) / 2;
        graphics.setColor(Color.white);
        if (!bl) {
            graphics.fillRoundRect(this.fLeft + this.fSpacing, n3, this.fWidth, 18, 4, 4);
            graphics.setColor(Color.black);
        }
        graphics.drawRoundRect(this.fLeft + this.fSpacing, n3, this.fWidth, 18, 4, 4);
        Font font = graphics.getFont();
        if (this.fFunctionType >= 0) {
            CalcUtils.drawSpecial(graphics, this.fLabel, this.fLeft + this.fSpacing, this.fWidth, n3 + (18 + graphics.getFontMetrics(graphics.getFont()).getAscent()) / 2 - 2, fBigFont, fSmallFont);
        } else {
            CalcUtils.drawCenter(graphics, this.fLabel, this.fLeft + this.fSpacing, this.fWidth, n3 + (18 + graphics.getFontMetrics(graphics.getFont()).getAscent()) / 2 - 2, fBigFont, fSmallFont);
        }
        graphics.setFont(font);
    }

    public void drawQuestion(Graphics graphics, int n, int n2, boolean bl) {
        int n3 = n + (n2 - 18) / 2;
        if (bl) {
            graphics.setColor(Color.white);
        } else {
            graphics.setColor(Color.black);
        }
        graphics.fillOval(this.fLeft + this.fSpacing, n3 + 2, 12, 14);
        Font font = graphics.getFont();
        if (bl) {
            graphics.setColor(Color.black);
        } else {
            graphics.setColor(Color.white);
        }
        CalcUtils.drawSpecial(graphics, this.fLabel, this.fLeft + this.fSpacing, 12, n3 + (18 + graphics.getFontMetrics(graphics.getFont()).getAscent()) / 2 - 3, fBigFont, fSmallFont);
        graphics.setFont(font);
        graphics.setColor(Color.black);
    }

    public void draw(Graphics graphics, int n, int n2) {
        if (this.fKind == 0) {
            char[] cArray = new char[]{this.fChar};
            int n3 = n + (n2 + graphics.getFontMetrics(graphics.getFont()).getAscent()) / 2;
            graphics.drawChars(cArray, 0, 1, this.fLeft + this.fSpacing, n3);
        } else if (this.fKind == 2) {
            if (this.fLabel.equals("?")) {
                this.drawQuestion(graphics, n, n2, false);
            } else {
                this.drawFunction(graphics, n, n2, false);
            }
        }
    }

    public void drawInv(Graphics graphics, int n, int n2) {
        graphics.setColor(Color.black);
        graphics.fillRect(this.left(), n, this.right() - this.left(), n2);
        graphics.setColor(Color.white);
        if (this.fKind == 0) {
            this.draw(graphics, n, n2);
        } else if (this.fKind == 2) {
            if (this.fLabel.equals("?")) {
                this.drawQuestion(graphics, n, n2, true);
            } else {
                this.drawFunction(graphics, n, n2, true);
            }
        }
    }

    public int left() {
        return this.fLeft;
    }

    public int right() {
        return this.fRight;
    }
}

