/*
 * Decompiled with CFR 0.152.
 */
package com.questmsm.FPGrapher;

import com.questmsm.FPGrapher.FPAxes;
import com.questmsm.FPGrapher.Grapher;
import com.questmsm.FunctionProbe.Master;
import com.questmsm.Utilities.DialogSuperClass;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;

public class ColorPalette
extends DialogSuperClass {
    private FPAxes fAxes;
    private Grapher fFP;
    private final int kNumColors = 8;
    private final int kSquareSide = 20;
    private Rectangle[] fRects = new Rectangle[8];
    private Color[] fColors = new Color[8];
    private int fSelected = -1;
    private int fCurrentColor = 7;

    public ColorPalette(Color color, FPAxes fPAxes, Grapher grapher) {
        super(grapher);
        this.setModal(false);
        this.setTitle("");
        this.fAxes = fPAxes;
        this.fFP = grapher;
        int n = 0;
        if (Master.isWindows()) {
            n = 20;
        }
        this.setBounds(400, 115, 100, 70 + n);
        this.setLayout(null);
        this.setValues();
        this.addMouseListener(new 1());
        this.addMouseMotionListener(new 2());
    }

    private void setValues() {
        int n = Master.gSmallTop;
        int n2 = 10;
        int n3 = 10 + n;
        int n4 = 0;
        while (n4 < 2) {
            int n5 = 0;
            while (n5 < 4) {
                this.fRects[n4 * 4 + n5] = new Rectangle(n2 + n5 * 20, n3 + n4 * 20, 20, 20);
                ++n5;
            }
            ++n4;
        }
        this.fColors[0] = Color.blue;
        this.fColors[1] = Color.red;
        this.fColors[2] = Color.green.darker();
        this.fColors[3] = Color.magenta.darker();
        this.fColors[4] = Color.cyan.darker();
        this.fColors[5] = Color.darkGray;
        this.fColors[6] = Color.orange.darker();
        this.fColors[7] = Color.black;
    }

    public Color nextColor() {
        if (this.fAxes.autoColor()) {
            ++this.fCurrentColor;
            if (this.fCurrentColor == 8) {
                this.fCurrentColor = 0;
            }
        }
        Color color = this.fColors[this.fCurrentColor];
        return color;
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public void paint(Graphics graphics) {
        int n = 0;
        while (n < 8) {
            graphics.setColor(this.fColors[n]);
            graphics.fillRect(this.fRects[n].x, this.fRects[n].y, this.fRects[n].width, this.fRects[n].height);
            graphics.setColor(Color.black);
            graphics.drawRect(this.fRects[n].x, this.fRects[n].y, this.fRects[n].width, this.fRects[n].height);
            if (this.fSelected == n) {
                graphics.drawRect(this.fRects[n].x + 1, this.fRects[n].y + 1, this.fRects[n].width - 2, this.fRects[n].height - 2);
            }
            ++n;
        }
    }

    public void setBounds(int n, int n2, int n3, int n4) {
        this.setBoundsWithoutCentering(n, n2, n3, n4);
    }

    static /* synthetic */ int access$4(ColorPalette colorPalette) {
        return colorPalette.fCurrentColor;
    }

    private final class 1
    extends MouseAdapter {
        public void mouseClicked(MouseEvent mouseEvent) {
            int n = mouseEvent.getX();
            int n2 = mouseEvent.getY();
            int n3 = 0;
            while (n3 < 8) {
                if (ColorPalette.this.fRects[n3].contains(n, n2)) {
                    if (ColorPalette.this.fSelected == n3) {
                        return;
                    }
                    ColorPalette.this.fSelected = n3;
                    ColorPalette.this.repaint();
                }
                ++n3;
            }
            ColorPalette.this.fFP.toFront();
            if (ColorPalette.this.fSelected == -1) {
                return;
            }
            ColorPalette.this.fCurrentColor = ColorPalette.this.fSelected;
            ((ColorPalette)ColorPalette.this).fAxes.fSelectionList.setColor(ColorPalette.this.fColors[ColorPalette.this.fSelected]);
            ColorPalette.this.fAxes.drawBackground();
            ColorPalette.this.fAxes.repaint();
            ColorPalette.this.fSelected = -1;
            ColorPalette.this.repaint();
        }

        /* synthetic */ 1() {
        }
    }

    private final class 2
    extends MouseMotionAdapter {
        public void mouseDragged(MouseEvent mouseEvent) {
            int n = mouseEvent.getX();
            int n2 = mouseEvent.getY();
            int n3 = 0;
            while (n3 < 8) {
                if (ColorPalette.this.fRects[n3].contains(n, n2)) {
                    if (ColorPalette.this.fSelected == n3) {
                        return;
                    }
                    ColorPalette.this.fSelected = n3;
                    ColorPalette.this.repaint();
                }
                ++n3;
            }
        }

        /* synthetic */ 2() {
        }
    }
}

