/*
 * Decompiled with CFR 0.152.
 */
package com.questmsm.FPGrapher;

import com.questmsm.FPGrapher.BarsFromPointsFrame;
import com.questmsm.FPGrapher.CurvePalette;
import com.questmsm.FPGrapher.DrawingObject;
import com.questmsm.FPGrapher.FPAxesShell;
import com.questmsm.FPGrapher.FPBarSet;
import com.questmsm.FPGrapher.FPEquation;
import com.questmsm.FPGrapher.FPFreeHand;
import com.questmsm.FPGrapher.FPGroup;
import com.questmsm.FPGrapher.FPLine;
import com.questmsm.FPGrapher.FPObject;
import com.questmsm.FPGrapher.FPObjectList;
import com.questmsm.FPGrapher.FPParametricEquation;
import com.questmsm.FPGrapher.FPPointSet;
import com.questmsm.FPGrapher.FPPolarEquation;
import com.questmsm.FPGrapher.FPPolarParametric;
import com.questmsm.FPGrapher.FPPolarPointSet;
import com.questmsm.FPGrapher.FPSelectionList;
import com.questmsm.FPGrapher.FPSlopeSet;
import com.questmsm.FPGrapher.Grapher;
import com.questmsm.FPGrapher.GrapherClipboard;
import com.questmsm.FPGrapher.HistoryArea;
import com.questmsm.FPGrapher.Samplable;
import com.questmsm.FPGrapher.SampleFrame;
import com.questmsm.FPGrapher.ZoomCoords;
import com.questmsm.FPGrapher.ZoomPercentDialog;
import com.questmsm.FunctionProbe.Evaluatable;
import com.questmsm.FunctionProbe.Master;
import com.questmsm.Utilities.Drawers;
import com.questmsm.Utilities.FPNumberFormatException;
import com.questmsm.Utilities.MyDouble;
import com.questmsm.Utilities.fp_resource;
import com.questmsm.Utilities.utils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.PrintJob;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Properties;

public class FPAxes
extends FPAxesShell {
    public FPObjectList fList;
    public FPSelectionList fSelectionList;
    private int fMode = 0;
    private boolean fInitialized = false;
    public static final int kNormal = 0;
    public static final int kPoint = 1;
    public static final int kDrawing = 2;
    public static final int kZoom = 3;
    public static final int kTranslateUD = 4;
    public static final int kTranslateLR = 5;
    public static final int kStretchUD = 6;
    public static final int kStretchLR = 7;
    public static final int kMirrorX = 8;
    public static final int kMirrorY = 9;
    public static final int kMirrorXY = 10;
    public static final int kDrawBar = 11;
    public static final int kDrawObject = 12;
    public static final int kFitLine1 = 16;
    public static final int kHookedPoint = 17;
    public static final int kHookedSlope = 18;
    public static final int kHookedBar = 19;
    public static final int kSampleHookedPoint = 20;
    public static final int kSampleHookedBar = 21;
    public static final int kSampleHookedSlope = 22;
    public static final int kEquation = 23;
    public static final int kParametric = 24;
    public static final int kPolar = 25;
    public static final int kRelation = 26;
    public static final int kFitLine3 = 27;
    public static final int kDrawSlope = 28;
    public static final int kUnZoom = 29;
    public static final int kSampleHookedSlope2 = 30;
    public static final int kDrawTangent = 31;
    public static final int kFitLine2 = 32;
    public static final int kZoom2 = 33;
    private int fCursor = 0;
    private Rectangle fZoomRect = new Rectangle();
    private FPFreeHand fFreeHand = null;
    private double fAnchorX = 0.0;
    private double fAnchorY = 0.0;
    private boolean fDraggingAnchor = false;
    private FPSlopeSet fSlopeSet;
    private FPPointSet fPointSet;
    private FPBarSet fBarSet;
    private Evaluatable fHookingEvaluator = null;
    private Point fDraggingPoint = null;
    private Point fHotPoint = null;
    private Rectangle fBarRect = new Rectangle();
    private Point fSlopePt1;
    private Point fSlopePt2;
    private final int kMaxDrawObjects = 15;
    private int fNumDrawObjects = 0;
    private DrawingObject[] fDrawObject = new DrawingObject[15];
    private int fDrawObjectType = 0;
    private Color fDrawObjectColor = null;
    private boolean fTranslatingDrawing = false;
    private boolean fDragLineLeft = false;
    private boolean fDragLineRight = false;
    private FPLine fLine;
    private ZoomCoords fZoomCoords = new ZoomCoords();
    private boolean fAddingOrdinates = false;
    private boolean fOrdinatesInPieces = false;
    private FPEquation fOrdinateEquation;
    private int fOrdinateMaxX = 400;
    private boolean fDraggingOrdinateMax = false;
    private String fXFormString = null;
    private String fAnchorString = null;
    private Dialog fCurvePalette;
    private HistoryArea fHistory;
    private boolean fAnchorSet = false;
    private boolean fShowAsymptotes = false;
    private boolean fAutoDefine = false;
    public static final int Return = 13;
    public static final int Enter = 10;
    public static final int Backspace = 8;
    public static final int LeftArrow = 1006;
    public static final int RightArrow = 1007;
    public static final int UpArrow = 1004;
    public static final int DownArrow = 1005;
    private double oldx;
    private double oldy;
    private int oldix;
    private int oldiy;
    private int newix = 0;
    private int newiy = 0;
    private boolean fAdding = false;
    private boolean fLeastSquaresMode = true;
    private int SampleAgainPoints;
    private int SampleAgainKind;
    private int SampleAgainMode;
    private double[] SampleAgainArray;
    private boolean SampleAgainAvailable = false;
    double translatevalue = 0.0;
    double stretchvalue = 1.0;
    static final int XINDENT = 40;
    static final int YINDENT = 40;

    public FPAxes(double d, double d2, double d3, double d4, double d5, double d6, Grapher grapher) {
        super(d, d2, d3, d4, d5, d6, grapher);
        this.fList = new FPObjectList(this);
        this.fSelectionList = new FPSelectionList(this);
        this.fCurvePalette = new CurvePalette(this, this.fGrapher);
        1 var14_8 = new 1();
        this.fMinXField.addActionListener(var14_8);
        this.fMaxXField.addActionListener(var14_8);
        this.fMinYField.addActionListener(var14_8);
        this.fMaxYField.addActionListener(var14_8);
    }

    public void getFromCalc(int n) {
        this.addToList(new FPEquation(String.valueOf(this.gDepChar) + "=" + "B" + n + "(" + this.gIndepChar + ")", this.fGrapher.colorPalette().nextColor(), this));
        this.drawBackground();
        this.clearMode();
    }

    public void clearMode() {
        this.mode(0);
        this.fGrapher.toolbar().mode(1);
        this.fGrapher.toolbar().repaint();
        this.repaint();
    }

    public void freeOldMode(int n) {
        if (n == 12 && this.fMode != 12) {
            this.drawObjectsToFreehand();
            ((Component)this.fCurvePalette).setVisible(false);
        } else if (n == 2) {
            if (this.fFreeHand != null) {
                this.addToList(this.fFreeHand);
                this.fFreeHand = null;
                this.drawBackground();
                this.repaint();
            }
        } else if (n == 1 || n == 17) {
            if (this.fPointSet == null) {
                return;
            }
            if (this.fPointSet.numPoints() > 0) {
                if (!this.fAdding) {
                    this.addToList(this.fPointSet);
                }
                this.drawBackground();
                this.repaint();
            }
            this.fPointSet = null;
        } else if (n == 11 || n == 19) {
            if (this.fBarSet == null) {
                return;
            }
            if (this.fBarSet.numPoints() > 0) {
                if (!this.fAdding) {
                    this.addToList(this.fBarSet);
                }
                this.drawBackground();
                this.repaint();
            }
            this.fBarSet = null;
        } else if (n == 28 || n == 18) {
            if (this.fSlopeSet == null) {
                return;
            }
            if (this.fSlopeSet.numPoints() > 0) {
                if (!this.fAdding) {
                    this.addToList(this.fSlopeSet);
                }
                this.drawBackground();
                this.repaint();
            }
            this.fSlopeSet = null;
        } else if (n == 16 || n == 32) {
            if (this.fLine == null) {
                return;
            }
            if (this.fLine != null) {
                this.addToList(new FPEquation(String.valueOf(this.gDepChar) + "=" + utils.num2str(this.fLine.getM()) + this.gIndepChar + " + " + utils.num2str(this.fLine.getB()), this.fLine.getColor(), this));
                this.fLine = null;
                this.fGrapher.setToolbarMode(1);
                this.drawBackground();
                this.repaint();
                this.fPointSet = null;
            }
        }
    }

    public int getMode() {
        return this.fMode;
    }

    public void mode(int n) {
        int n2 = this.fMode;
        this.newiy = -1;
        this.oldiy = -1;
        this.newix = -1;
        this.oldix = -1;
        this.fGrapher.toolbar().repaint();
        if (n2 == n && n2 != 12) {
            return;
        }
        this.fMode = n;
        this.freeOldMode(n2);
        switch (n) {
            case 23: {
                if (this.polarMode()) {
                    this.fHistory.mode(1);
                    this.fHistory.setText("r = ", "0 <= T <= 2P");
                } else {
                    this.fHistory.mode(0);
                    this.fHistory.setText(String.valueOf(this.gDepChar) + " = ");
                }
                this.fHistory.setTextFieldsVisible(true);
                this.fHistory.requestFocus();
                break;
            }
            case 24: {
                if (this.polarMode()) {
                    this.fHistory.mode(3);
                    this.fHistory.setText("r = ", "T = ");
                } else {
                    this.fHistory.mode(2);
                    this.fHistory.setText(String.valueOf(this.gDepChar) + " = ", String.valueOf(this.gIndepChar) + " = ");
                }
                this.fHistory.setTextFieldsVisible(true);
                this.fHistory.requestFocus();
                break;
            }
            case 26: {
                this.fHistory.mode(4);
                this.fHistory.setTextFieldsVisible(true);
                this.fHistory.setText("0 < ");
                this.fHistory.requestFocus();
                break;
            }
            case 32: {
                this.fPointSet = (FPPointSet)this.selectedObject();
            }
            case 16: {
                this.fLine = new FPLine(1.0, 0.0, this.fGrapher.colorPalette().nextColor(), this);
                this.fSelectionList.clear();
                this.fHistory.clearSelect();
                this.fHistory.repaint();
                this.repaint();
                break;
            }
            case 27: {
                String string = "";
                String string2 = "";
                MyDouble myDouble = new MyDouble(0.0);
                if (this.fSelectionList.numObjects() == 1 && this.fSelectionList.objectNum(0) instanceof FPPointSet) {
                    FPPointSet fPPointSet = (FPPointSet)this.fSelectionList.objectNum(0);
                    MyDouble myDouble2 = new MyDouble(0.0);
                    MyDouble myDouble3 = new MyDouble(0.0);
                    if (this.fLeastSquaresMode) {
                        fPPointSet.fitLineLeastSquares(myDouble2, myDouble3, myDouble);
                        string = fp_resource.getString("str_rss");
                    } else {
                        fPPointSet.fitLineMinAbs(myDouble2, myDouble3, myDouble);
                        string = fp_resource.getString("str_asd");
                    }
                    string2 = String.valueOf(this.gDepChar) + "=" + utils.num2str(myDouble2.get()) + this.gIndepChar + "+" + utils.num2str(myDouble3.get());
                    this.history().addItem(null, String.valueOf(fp_resource.getString("str_auto_fit")) + ": " + string2 + " , " + string + " = " + utils.num2str(myDouble.get()), "", "");
                    this.history().setCurrentItemXForm();
                    FPEquation fPEquation = new FPEquation(string2, this.fGrapher.colorPalette().nextColor(), this);
                    if (this.fLeastSquaresMode) {
                        fPEquation.setShowRSS(true);
                        fPEquation.setRSS(myDouble.get());
                    } else {
                        fPEquation.setShowADS(true);
                        fPEquation.setADS(myDouble.get());
                    }
                    this.addToList(fPEquation);
                    this.drawBackground();
                }
                this.fGrapher.setToolbarMode(1);
                this.fCursor = 0;
                this.fMode = 0;
                if (string.equals("")) break;
                this.history().comment(String.valueOf(fp_resource.getString("str_auto_fit")) + " " + string + " = " + utils.num2str(myDouble.get()));
                break;
            }
            case 31: {
                this.fHookingEvaluator = (Evaluatable)((Object)this.selectedObject());
                this.fSelectionList.clear();
                this.fHistory.clearSelect();
                this.fHistory.repaint();
                this.fGrapher.handleMenus();
                break;
            }
            case 12: {
                if (n2 != 12) {
                    this.fNumDrawObjects = 0;
                    this.fDrawObjectColor = this.fGrapher.colorPalette().nextColor();
                    ((Component)this.fCurvePalette).setVisible(true);
                    this.fSelectionList.clear();
                    this.fHistory.clearSelect();
                    this.fHistory.repaint();
                }
                if (this.fDrawObjectType == -1) break;
                this.fDrawObject[this.fNumDrawObjects] = new DrawingObject(20, 20, 120, 120, this.fDrawObjectType, this.fDrawObjectColor);
                ++this.fNumDrawObjects;
                this.fCursor = 12;
                this.repaint();
                break;
            }
            case 19: {
                this.fHookingEvaluator = (Evaluatable)((Object)this.selectedObject());
            }
            case 11: {
                this.fBarRect = new Rectangle();
                this.fCursor = 1;
                this.fBarSet = new FPBarSet(this.fGrapher.colorPalette().nextColor(), this);
                this.fBarSet.setPos(2);
                this.fSelectionList.clear();
                this.fHistory.clearSelect();
                this.fHistory.repaint();
                this.fGrapher.handleMenus();
                break;
            }
            case 18: {
                this.fHookingEvaluator = (Evaluatable)((Object)this.selectedObject());
            }
            case 28: {
                this.fSlopePt1 = new Point(-1, -1);
                this.fSlopePt2 = new Point(-1, -1);
                this.fCursor = 1;
                this.fSlopeSet = new FPSlopeSet(this.fGrapher.colorPalette().nextColor(), this);
                this.fSelectionList.clear();
                this.fHistory.clearSelect();
                this.fHistory.repaint();
                this.fGrapher.handleMenus();
                break;
            }
            case 3: {
                this.fCursor = 1;
                this.fSelectionList.clear();
                this.fHistory.clearSelect();
                this.fHistory.repaint();
                this.fGrapher.handleMenus();
                this.repaint();
                break;
            }
            case 29: {
                this.fZoomCoords.pop(this);
                if (this.fZoomCoords.isEmpty()) {
                    this.fGrapher.toolbar().setMag();
                }
                this.setUpAxes();
                this.drawBackground();
                this.fGrapher.toolbar().setToArrowMode();
                this.fGrapher.toolbar().repaint();
                this.fCursor = 0;
                this.fMode = 0;
                this.repaint();
                break;
            }
            case 33: {
                ZoomPercentDialog zoomPercentDialog = new ZoomPercentDialog(this, this.fGrapher);
                ((Component)zoomPercentDialog).setVisible(true);
                this.fGrapher.toolbar().setToArrowMode();
                this.fCursor = 0;
                this.fMode = 0;
                this.repaint();
                break;
            }
            case 17: {
                this.fHookingEvaluator = (Evaluatable)((Object)this.selectedObject());
            }
            case 1: {
                this.fCursor = 1;
                this.fPointSet = this.fPolarMode ? new FPPolarPointSet(this.fGrapher.colorPalette().nextColor(), this) : new FPPointSet(this.fGrapher.colorPalette().nextColor(), this);
                this.fSelectionList.clear();
                this.fHistory.clearSelect();
                this.fHistory.repaint();
                this.fGrapher.handleMenus();
                break;
            }
            case 2: {
                this.fSelectionList.clear();
                this.fHistory.clearSelect();
                this.fHistory.repaint();
                this.fGrapher.handleMenus();
                break;
            }
            case 4: {
                this.fCursor = 12;
                this.fXFormString = "";
                this.fHistory.drawTransUD("0");
                break;
            }
            case 5: {
                this.fCursor = 12;
                this.fXFormString = "";
                this.fHistory.drawTransLR("0");
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                this.fAnchorX = this.fMinX > 0.0 ? this.fMinX + this.pxl2xDelta(10) : (this.fMaxX < 0.0 ? this.fMaxX - this.pxl2xDelta(10) : 0.0);
                this.fAnchorY = this.fMinY > 0.0 ? this.fMinY + this.pxl2yDelta(10) : (this.fMaxY < 0.0 ? this.fMaxY - this.pxl2yDelta(10) : 0.0);
                this.repaint();
                this.fCursor = 0;
                this.fXFormString = "";
                this.fAnchorSet = false;
                this.fAnchorString = "";
                this.fHistory.drawAnchor("0");
                break;
            }
            case 10: {
                this.fSelectionList.copy(this.fList, this);
                this.fSelectionList.mirrorxy(this.fLogX, this.fLogY);
                this.fSelectionList.calculate(this);
                this.selectLast();
                this.drawBackground();
                this.repaint();
            }
            default: {
                this.fCursor = 0;
                this.fHistory.mode(-1);
            }
        }
        this.setCursor(Cursor.getPredefinedCursor(this.fCursor));
        if (n2 == 7 || n2 == 6 || n2 == 8 || n2 == 9) {
            this.repaint();
        }
    }

    public void setUpAxes() {
        super.setUpAxes();
        this.recalculate();
    }

    public void setUpAxesNoCalculate() {
        super.setUpAxes();
    }

    public void zoomByPercent(double d) {
        d /= 100.0;
        double d2 = (this.fMaxX + this.fMinX) / 2.0;
        double d3 = (this.fMaxY + this.fMinY) / 2.0;
        double d4 = d2 - this.fMinX;
        double d5 = d3 - this.fMinY;
        this.fZoomCoords.push((this.fMaxX + this.fMinX) / 2.0, (this.fMaxY + this.fMinY) / 2.0, this.fPixelsPerXUnit, this.fPixelsPerYUnit);
        this.minXNoLog(d2 - d4 * d);
        this.maxXNoLog(d2 + d4 * d);
        this.minYNoLog(d3 - d5 * d);
        this.maxYNoLog(d3 + d5 * d);
        this.setUpAxes();
        this.drawBackground();
        this.fGrapher.toolbar().setMagUnmag();
        this.fGrapher.toolbar().repaint();
        this.fGrapher.toolbar().setToArrowMode();
        this.fGrapher.toolbar().repaint();
        this.fCursor = 0;
        this.fMode = 0;
        this.repaint();
    }

    public int kindOfObjectSelected() {
        if (this.fSelectionList.numObjects() != 1) {
            return -1;
        }
        return this.fSelectionList.objectNum(0).kind();
    }

    public boolean isCurrentPointDeleted() {
        FPObject fPObject;
        int n = this.fSelectionList.numObjects();
        if (n == 1 && (fPObject = this.fSelectionList.objectNum(0)) instanceof FPPointSet) {
            return ((FPPointSet)fPObject).isDeleted();
        }
        return false;
    }

    public void deletePoint() {
        FPObject fPObject;
        int n = this.fSelectionList.numObjects();
        if (n == 1 && (fPObject = this.fSelectionList.objectNum(0)) instanceof FPPointSet) {
            ((FPPointSet)fPObject).togglePointDeleted();
        }
    }

    public void addPoints() {
        int n = this.fSelectionList.numObjects();
        if (n == 1) {
            this.fCursor = 1;
            this.setCursor(Cursor.getPredefinedCursor(this.fCursor));
            FPObject fPObject = this.fSelectionList.objectNum(0);
            switch (fPObject.kind()) {
                case 6: {
                    this.fPointSet = (FPPointSet)this.fSelectionList.objectNum(0);
                    this.fMode = 1;
                    this.fGrapher.toolbar().mode(5);
                    break;
                }
                case 7: {
                    this.fBarSet = (FPBarSet)this.fSelectionList.objectNum(0);
                    this.fMode = 11;
                    this.fGrapher.toolbar().mode(8);
                    break;
                }
                case 8: {
                    this.fSlopeSet = (FPSlopeSet)this.fSelectionList.objectNum(0);
                    this.fMode = 28;
                    this.fGrapher.toolbar().mode(7);
                    break;
                }
            }
            this.fAdding = true;
            this.fSelectionList.clear();
            this.fHistory.clearSelect();
            this.fHistory.repaint();
            this.fGrapher.handleMenus();
            this.fGrapher.toolbar().repaint();
        }
    }

    public void addingOrdinates(boolean bl) {
        this.fAddingOrdinates = bl;
        if (!bl) {
            this.ordinatesInPieces(false);
        }
        if (bl) {
            if (this.fSelectionList == null) {
                return;
            }
            if (this.fSelectionList.numObjects() != 2) {
                return;
            }
            if (this.fSelectionList.objectNum(0).kind() != 0 || this.fSelectionList.objectNum(1).kind() != 0) {
                return;
            }
            if (this.fSelectionList.objectNum(0).varIndex() != 0 || this.fSelectionList.objectNum(1).varIndex() != 0) {
                utils.showErrorDialog(this.fGrapher, fp_resource.getString("str_error__both_equations_must_use_the_default_xy_variable_pair"));
                return;
            }
            this.fGrapher.addOrdFrame().show((FPEquation)this.fSelectionList.objectNum(0), (FPEquation)this.fSelectionList.objectNum(1));
        }
    }

    public boolean addingOrdinates() {
        return this.fAddingOrdinates;
    }

    public void ordinatesInPieces(boolean bl) {
        this.fOrdinatesInPieces = bl;
    }

    public boolean ordinatesInPieces() {
        return this.fOrdinatesInPieces;
    }

    public void ordinateEquation(String string) {
        this.fOrdinateEquation = new FPEquation(string, this.fGrapher.colorPalette().nextColor(), this);
        this.fOrdinateEquation.calculate(this);
        this.fOrdinateMaxX = 15;
    }

    public void connectPoints() {
        int n = this.fSelectionList.numObjects();
        int n2 = 0;
        while (n2 < n) {
            FPObject fPObject = this.fSelectionList.objectNum(n2);
            if (fPObject instanceof FPPointSet) {
                ((FPPointSet)fPObject).connected(((FPPointSet)fPObject).connected() ^ true);
            }
            ++n2;
        }
        this.fGrapher.handleMenus();
        this.drawBackground();
        this.repaint();
    }

    public void barsFromPoints() {
        FPObject fPObject;
        int n = this.fSelectionList.numObjects();
        if (n == 1 && (fPObject = this.fSelectionList.objectNum(0)) instanceof FPPointSet) {
            BarsFromPointsFrame barsFromPointsFrame = new BarsFromPointsFrame(Color.white, this, this.fGrapher, (FPPointSet)fPObject);
            ((Component)barsFromPointsFrame).setVisible(true);
        }
    }

    public void slopesFromPoints() {
        FPObject fPObject;
        int n = this.fSelectionList.numObjects();
        if (n == 1 && (fPObject = this.fSelectionList.objectNum(0)) instanceof FPPointSet) {
            FPSlopeSet fPSlopeSet = new FPSlopeSet((FPPointSet)fPObject, this);
            this.addToList(fPSlopeSet);
            this.drawBackground();
            this.repaint();
        }
    }

    public void pointsFromBars() {
        int n = this.fSelectionList.numObjects();
        int n2 = 0;
        while (n2 < n) {
            FPObject fPObject = this.fSelectionList.objectNum(n2);
            if (fPObject instanceof FPBarSet) {
                FPBarSet fPBarSet = (FPBarSet)fPObject;
                FPPointSet fPPointSet = fPBarSet.barsToPoints();
                fPPointSet.calculate(this);
                this.addToList(fPPointSet);
            }
            ++n2;
        }
        this.selectLast();
        this.drawBackground();
        this.repaint();
    }

    public void pointsFromSlopes() {
        int n = this.fSelectionList.numObjects();
        int n2 = 0;
        while (n2 < n) {
            FPObject fPObject = this.fSelectionList.objectNum(n2);
            if (fPObject instanceof FPSlopeSet) {
                FPSlopeSet fPSlopeSet = (FPSlopeSet)fPObject;
                FPPointSet fPPointSet = fPSlopeSet.slopesToPoints();
                fPSlopeSet.calculate(this);
                this.addToList(fPPointSet);
            }
            ++n2;
        }
        this.selectLast();
        this.drawBackground();
        this.repaint();
    }

    public void createPointSet(double[] dArray, double[] dArray2, int n, char c, char c2) {
        if (this.fPolarMode) {
            utils.showErrorDialog(Master.gFrame, fp_resource.getString("str_error__can_only_send_xy_points_in_cartesian_coordinates"));
            return;
        }
        if (c2 != '\u0000' && c != '\u0000') {
            int n2 = this.variables().whichIndex(c2, c);
            if (n2 >= 0) {
                this.currentVar(n2);
            } else {
                this.variables().add(c2, c, "", "", "", "", this.fGrapher);
                this.currentVar(this.variables().numVars() - 1);
            }
        }
        FPPointSet fPPointSet = new FPPointSet(this.fGrapher.colorPalette().nextColor(), this);
        fPPointSet.varIndex(this.currentVar());
        int n3 = 0;
        while (n3 < n) {
            fPPointSet.addPoint(dArray[n3], dArray2[n3]);
            ++n3;
        }
        fPPointSet.calculate(this);
        this.addToList(fPPointSet);
        this.drawBackground();
        this.repaint();
    }

    public void createPolarPointSet(double[] dArray, double[] dArray2, int n) {
        if (!this.fPolarMode) {
            utils.showErrorDialog(Master.gFrame, fp_resource.getString("str_error__can_only_send_rt_points_in_polar_coordinates"));
            return;
        }
        FPPolarPointSet fPPolarPointSet = new FPPolarPointSet(this.fGrapher.colorPalette().nextColor(), this);
        int n2 = 0;
        while (n2 < n) {
            fPPolarPointSet.addPoint(dArray2[n2], dArray[n2]);
            ++n2;
        }
        fPPolarPointSet.calculate(this);
        this.addToList(fPPolarPointSet);
        this.drawBackground();
        this.repaint();
    }

    public void createBarSet(double[] dArray, double[] dArray2, int n) {
        FPBarSet fPBarSet = new FPBarSet(this.fGrapher.colorPalette().nextColor(), this);
        int n2 = 0;
        while (n2 < n - 1) {
            fPBarSet.addBar(dArray[n2], dArray2[n2], dArray[n2 + 1] - dArray[n2]);
            ++n2;
        }
        fPBarSet.calculate(this);
        this.addToList(fPBarSet);
        this.drawBackground();
        this.repaint();
    }

    public void sampleEquation(int n) {
        FPObject fPObject = this.fSelectionList.objectNum(0);
        if (fPObject instanceof Samplable) {
            SampleFrame sampleFrame = new SampleFrame(Color.white, this, this.fGrapher, (Samplable)((Object)fPObject), n);
            if (fPObject.kind() == 1) {
                sampleFrame.setToSamplePolar();
            }
            ((Component)sampleFrame).setVisible(true);
            return;
        }
    }

    public boolean sampleAgainEnabled() {
        return this.SampleAgainAvailable;
    }

    public boolean sampleAgain() {
        if (this.selectedObject() == null) {
            utils.showErrorDialog(Master.gFrame, fp_resource.getString("str_error__nothing_selected_to_sample"));
            return false;
        }
        if (this.SampleAgainArray == null) {
            utils.showErrorDialog(Master.gFrame, fp_resource.getString("str_error__no_valid_sampling_data_stored"));
            return false;
        }
        return this.samplePoints(this.SampleAgainPoints, this.SampleAgainArray, (Samplable)((Object)this.selectedObject()), this.SampleAgainKind, this.SampleAgainMode);
    }

    public boolean samplePoints(int n, double[] dArray, Samplable samplable, int n2, int n3) {
        if (n == 0) {
            return false;
        }
        FPPointSet fPPointSet = samplable.sample(n, dArray, n3);
        if (fPPointSet == null) {
            return false;
        }
        if (fPPointSet.numPoints() == 0) {
            utils.showErrorDialog(Master.gFrame, fp_resource.getString("str_error__no_points_satisfy_sampling_criteria"));
            return false;
        }
        this.SampleAgainPoints = n;
        this.SampleAgainArray = dArray;
        this.SampleAgainKind = n2;
        this.SampleAgainMode = n3;
        this.SampleAgainAvailable = true;
        fPPointSet.calculate(this);
        if (n2 == 7) {
            BarsFromPointsFrame barsFromPointsFrame = new BarsFromPointsFrame(Color.white, this, this.fGrapher, fPPointSet);
            ((Component)barsFromPointsFrame).setVisible(true);
            return true;
        }
        if (n2 == -8) {
            FPSlopeSet fPSlopeSet = new FPSlopeSet(fPPointSet, this, true);
            fPSlopeSet.calculate(this);
            this.addToList(fPSlopeSet);
            this.drawBackground();
            this.repaint();
            return true;
        }
        if (n2 == 8) {
            FPSlopeSet fPSlopeSet = new FPSlopeSet(fPPointSet, this);
            fPSlopeSet.calculate(this);
            this.addToList(fPSlopeSet);
            this.drawBackground();
            this.repaint();
            return true;
        }
        this.addToList(fPPointSet);
        this.drawBackground();
        this.repaint();
        return true;
    }

    public boolean samplePolarPoints(int n, double[] dArray, FPPolarEquation fPPolarEquation, int n2) {
        if (n == 0) {
            return false;
        }
        FPPolarPointSet fPPolarPointSet = fPPolarEquation.samplePolar(n, dArray, n2);
        if (fPPolarPointSet == null) {
            return false;
        }
        fPPolarPointSet.calculate(this);
        this.addToList(fPPolarPointSet);
        this.drawBackground();
        this.repaint();
        return true;
    }

    private void drawBackground(Graphics graphics) {
        if (graphics == null) {
            return;
        }
        graphics.setColor(this.fBackgroundColor);
        graphics.fillRect(0, 0, this.fWidth, this.fHeight);
        this.checkValid();
        if (this.fValid) {
            if (this.fBackdropImage != null) {
                int n = (this.fWidth - this.fBackdropImage.getWidth(this)) / 2;
                int n2 = (this.fHeight - this.fBackdropImage.getHeight(this)) / 2;
                graphics.drawImage(this.fBackdropImage, n, n2, this);
            }
            this.fList.drawInequalities(graphics);
            this.drawGridLines(graphics);
            this.drawTickLabels(graphics);
            this.fList.draw(graphics);
            if (this.addingOrdinates()) {
                this.fGrapher.addOrdFrame().eq1().drawArrows(graphics, 5, this);
                this.fGrapher.addOrdFrame().eq2().drawArrows(graphics, 15, this);
            }
        } else {
            FontMetrics fontMetrics = this.getFontMetrics(graphics.getFont());
            graphics.setColor(Color.red);
            String string = fp_resource.getString("str_invalid_settings");
            int n = utils.drawCenteredString(graphics, string, this.fWidth, 150);
            utils.drawCenteredString(graphics, this.fInvalidStr, this.fWidth, n);
        }
        graphics.setColor(Color.black);
        graphics.drawLine(0, this.fHeight + 1, this.fWidth, this.fHeight + 1);
        graphics.drawLine(0, this.fHeight, this.fWidth, this.fHeight);
    }

    public synchronized void drawBackground() {
        this.drawBackground(this.fBackgroundGraphics);
    }

    private synchronized void drawForeground(Graphics graphics) {
        if (!this.fValid) {
            return;
        }
        this.fSelectionList.draw(graphics, this);
        this.drawAxisLabels(graphics);
        this.drawRescales(graphics);
        if (this.fOrdinatesInPieces) {
            graphics.setColor(Color.black);
            utils.drawDashedLine(graphics, this.fOrdinateMaxX, this.fminYPxl, this.fOrdinateMaxX, this.fmaxYPxl);
            utils.drawDashedLine(graphics, this.fOrdinateMaxX + 1, this.fminYPxl, this.fOrdinateMaxX + 1, this.fmaxYPxl);
            this.fOrdinateEquation.drawToMax(graphics, this.fOrdinateMaxX);
        }
        switch (this.fMode) {
            case 18: 
            case 28: {
                if (this.fSlopePt1.x == -1) {
                    if (this.fSlopeSet == null) {
                        return;
                    }
                    this.fSlopeSet.draw(graphics);
                    return;
                }
                this.fSlopeSet.drawSlope(graphics, this.fSlopePt1.x, this.fSlopePt1.y, this.fSlopePt2.x, this.fSlopePt2.y, false);
                this.fSlopeSet.draw(graphics);
                return;
            }
            case 11: 
            case 19: {
                int n;
                int n2;
                int n3;
                int n4;
                if (this.fBarRect.height <= 0) {
                    if (this.fBarSet == null) {
                        return;
                    }
                    this.fBarSet.draw(graphics);
                    return;
                }
                if (this.fOriginY > this.fBarRect.y) {
                    n4 = this.fBarRect.y;
                    n3 = this.fOriginY - this.fBarRect.y;
                } else {
                    n4 = this.fOriginY;
                    n3 = this.fBarRect.y - this.fOriginY;
                }
                if (this.fBarRect.width < 0) {
                    n2 = -this.fBarRect.width;
                    n = this.fBarRect.x - n2;
                } else {
                    n2 = this.fBarRect.width;
                    n = this.fBarRect.x;
                }
                graphics.setColor(this.fBarSet.getColor());
                graphics.fillRect(n, n4, n2, n3);
                graphics.setColor(Color.black);
                graphics.drawRect(n, n4, n2, n3);
                this.fBarSet.draw(graphics);
                return;
            }
            case 1: 
            case 17: {
                if (this.fPointSet != null) {
                    this.fPointSet.draw(graphics);
                }
                if (this.fDraggingPoint != null) {
                    this.fPointSet.drawPoint(graphics, this.fDraggingPoint.x, this.fDraggingPoint.y);
                }
                if (this.fHotPoint != null) {
                    graphics.setColor(Color.darkGray);
                    if (this.fPolarMode) {
                        graphics.drawLine(this.fHotPoint.x, this.fHotPoint.y, this.fOriginX, this.fOriginY);
                    } else {
                        graphics.drawLine(this.fHotPoint.x, this.fHotPoint.y, this.fOriginX, this.fHotPoint.y);
                        graphics.drawLine(this.fHotPoint.x, this.fHotPoint.y, this.fHotPoint.x, this.fOriginY);
                    }
                }
                return;
            }
            case 32: {
                if (this.fLine != null) {
                    this.fLine.draw(graphics);
                    this.fPointSet.drawResiduals(graphics, this.fLine.getM(), this.fLine.getB(), this);
                }
                return;
            }
            case 16: {
                if (this.fLine != null) {
                    this.fLine.draw(graphics);
                }
                return;
            }
            case 31: {
                if (this.fLine != null) {
                    this.fLine.drawLine(graphics);
                    if (this.fDraggingPoint != null) {
                        graphics.setColor(Color.black);
                        int n = 1;
                        graphics.fillRect(this.fDraggingPoint.x - n, this.fDraggingPoint.y - n, 2 * n + 1, 2 * n + 1);
                    }
                }
                return;
            }
            case 3: {
                if (this.fZoomRect.width == 0) {
                    return;
                }
                graphics.setColor(Color.pink);
                graphics.drawRect(this.fZoomRect.x, this.fZoomRect.y, this.fZoomRect.width, this.fZoomRect.height);
                return;
            }
            case 4: {
                this.fSelectionList.drawVerticalArrows(graphics, this.getSize().width);
                return;
            }
            case 5: {
                this.fSelectionList.drawHorizontalArrows(graphics, this.getSize().height);
                return;
            }
            case 8: {
                this.drawAnchorLineX(graphics, this.fAnchorX);
                return;
            }
            case 7: {
                this.drawAnchorLineX(graphics, this.fAnchorX);
                if (this.fDraggingAnchor) {
                    return;
                }
                if (this.newiy != -1) {
                    graphics.setColor(Color.darkGray);
                    Drawers.drawHorizStretchy(graphics, this.x2pxlSuppressLog(this.fAnchorX), this.newix, this.oldiy);
                }
                return;
            }
            case 9: {
                this.drawAnchorLineY(graphics, this.fAnchorY);
                return;
            }
            case 6: {
                this.drawAnchorLineY(graphics, this.fAnchorY);
                if (this.fDraggingAnchor) {
                    return;
                }
                if (this.newiy != -1) {
                    graphics.setColor(Color.darkGray);
                    Drawers.drawVertStretchy(graphics, this.y2pxlSuppressLog(this.fAnchorY), this.newiy, this.oldix);
                }
                return;
            }
            case 2: {
                if (this.fFreeHand != null) {
                    this.fFreeHand.draw(graphics);
                }
                return;
            }
            case 12: {
                int n = 0;
                while (n < this.fNumDrawObjects) {
                    this.fDrawObject[n].draw(graphics);
                    ++n;
                }
                return;
            }
        }
    }

    public void addToList(FPObject fPObject) {
        this.addToListNoSelect(fPObject);
        this.selectObject(fPObject);
    }

    public void addToListNoSelect(FPObject fPObject) {
        fPObject.varIndex(this.fCurrentVar);
        this.addToListNoHistory(fPObject);
        if (fPObject.kind() == 2) {
            FPParametricEquation fPParametricEquation = (FPParametricEquation)fPObject;
            this.fHistory.addItem(fPParametricEquation, fPParametricEquation.getEqYString(), fPParametricEquation.getEqXString(), "");
        } else if (fPObject.kind() == 3) {
            FPPolarParametric fPPolarParametric = (FPPolarParametric)fPObject;
            this.fHistory.addItem(fPPolarParametric, fPPolarParametric.getEqYString(), fPPolarParametric.getEqXString(), "");
        } else if (fPObject.kind() == 1) {
            FPPolarEquation fPPolarEquation = (FPPolarEquation)fPObject;
            this.fHistory.addItem(fPPolarEquation, fPPolarEquation.getEqString(), fPPolarEquation.getRangeString(), "");
        } else {
            this.fHistory.addItem(fPObject, fPObject.getEqString(), "", "");
        }
    }

    public void addToListNoHistory(FPObject fPObject) {
        this.fList.addToList(fPObject, this);
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public synchronized void paint(Graphics graphics) {
        if (this.fBackgroundImage == null) {
            return;
        }
        if (this.fForegroundImage == null) {
            return;
        }
        this.fForegroundGraphics.drawImage(this.fBackgroundImage, 0, 0, this);
        this.drawForeground(this.fForegroundGraphics);
        graphics.drawImage(this.fForegroundImage, 0, 0, this);
    }

    private void handleXFormKey(int n) {
        double d = 0.0;
        if (!this.fXFormString.equals("")) {
            try {
                d = utils.str2num(this.fXFormString);
                this.fSelectionList.copy(this.fList, this);
                if (n == 4) {
                    this.fSelectionList.translate(0.0, d, this.fLogX, this.fLogY);
                } else if (n == 5) {
                    this.fSelectionList.translate(d, 0.0, this.fLogX, this.fLogY);
                }
            }
            catch (FPNumberFormatException fPNumberFormatException) {
                String string = fp_resource.getString("str_error__cant_convert_into_a_number");
                if (this.fXFormString.trim().length() > 0) {
                    string = String.valueOf(string) + ": " + this.fXFormString;
                }
                utils.showErrorDialog(this.fGrapher, string);
            }
        }
        if (n == 4 || n == 5) {
            this.translatevalue = 0.0;
        }
        this.fSelectionList.calculate(this);
        this.fHistory.setSelect(this.fSelectionList.first());
        this.fGrapher.toolbar().setToArrowMode();
        this.drawBackground();
        this.repaint();
    }

    public boolean keyDown(Event event, int n) {
        if ((event.modifiers & 2) != 0 || (event.modifiers & 4) != 0 || (event.modifiers & 8) != 0) {
            return super.keyDown(event, n);
        }
        if (this.fMode == 4 || this.fMode == 5) {
            if (n == 13 || n == 10 || n == 10) {
                this.handleXFormKey(this.fMode);
                return true;
            }
            if (n == 8 || n == 8) {
                if (this.fXFormString.length() >= 1) {
                    this.fXFormString = this.fXFormString.substring(0, this.fXFormString.length() - 1);
                }
            } else {
                this.fXFormString = String.valueOf(this.fXFormString) + (char)n;
            }
            try {
                this.translatevalue = utils.str2num(this.fXFormString);
            }
            catch (FPNumberFormatException fPNumberFormatException) {}
            if (this.fMode == 4) {
                this.fHistory.drawTransUD(this.fXFormString);
                this.fSelectionList.fastTranslate(0, -this.y2pxlDelta(this.translatevalue));
            } else {
                this.fHistory.drawTransLR(this.fXFormString);
                this.fSelectionList.fastTranslate(this.x2pxlDelta(this.translatevalue), 0);
            }
            this.repaint();
            return true;
        }
        if (this.fMode == 8 || this.fMode == 9) {
            double d;
            if (n == 13 || n == 10 || n == 10) {
                this.doMouseUpOption(this.fMode, 0, 0);
                return true;
            }
            if (n == 8 || n == 8) {
                if (this.fAnchorString.length() >= 1) {
                    this.fAnchorString = this.fAnchorString.substring(0, this.fAnchorString.length() - 1);
                }
            } else {
                this.fAnchorString = String.valueOf(this.fAnchorString) + (char)n;
            }
            try {
                d = utils.str2num(this.fAnchorString);
            }
            catch (FPNumberFormatException fPNumberFormatException) {
                d = this.fAnchorX;
            }
            this.fAnchorX = d;
            this.fAnchorY = d;
            this.fHistory.drawAnchor(this.fAnchorString);
            this.repaint();
            return true;
        }
        if (this.fMode == 6 || this.fMode == 7) {
            if (n == 13 || n == 10 || n == 10) {
                if (this.fAnchorSet) {
                    this.doMouseUpOption(this.fMode, 0, 0);
                } else {
                    if (this.fAnchorString.equals("")) {
                        this.fAnchorString = String.valueOf(this.fAnchorX);
                    }
                    try {
                        utils.str2num(this.fAnchorString);
                        this.fAnchorSet = true;
                    }
                    catch (FPNumberFormatException fPNumberFormatException) {
                        String string = fp_resource.getString("str_error__cant_convert_into_a_number");
                        if (this.fAnchorString.trim().length() > 0) {
                            string = String.valueOf(string) + ": " + this.fAnchorString;
                        }
                        utils.showErrorDialog(this.fGrapher, string);
                    }
                }
                this.fHistory.drawAnchor(this.fAnchorString);
                this.repaint();
                return true;
            }
            if (n == 8) {
                if (!this.fAnchorSet) {
                    if (this.fAnchorString.length() > 0) {
                        this.fAnchorString = this.fAnchorString.substring(0, this.fAnchorString.length() - 1);
                    }
                } else if (this.fXFormString.length() > 0) {
                    this.fXFormString = this.fXFormString.substring(0, this.fXFormString.length() - 1);
                }
            } else if (Character.isLetterOrDigit((char)n)) {
                if (this.fAnchorSet) {
                    this.fXFormString = String.valueOf(this.fXFormString) + (char)n;
                } else {
                    this.fAnchorString = String.valueOf(this.fAnchorString) + (char)n;
                }
            }
            if (!this.fAnchorSet) {
                double d;
                try {
                    d = utils.str2num(this.fAnchorString);
                }
                catch (FPNumberFormatException fPNumberFormatException) {
                    d = this.fAnchorX;
                }
                this.fAnchorX = d;
                this.fAnchorY = d;
                this.fHistory.drawAnchor(this.fAnchorString);
                this.repaint();
            } else {
                try {
                    this.stretchvalue = utils.str2num(this.fXFormString);
                }
                catch (FPNumberFormatException fPNumberFormatException) {}
                if (this.fMode == 7) {
                    this.fHistory.drawStretchLR(this.fXFormString);
                    this.fHistory.drawAnchor(this.fAnchorString);
                    this.fSelectionList.fastStretchLR(this.x2pxlSuppressLog(this.fAnchorX), this.stretchvalue);
                } else {
                    this.fHistory.drawStretchUD(this.fXFormString);
                    this.fHistory.drawAnchor(this.fAnchorString);
                    this.fSelectionList.fastStretchUD(this.y2pxlSuppressLog(this.fAnchorY), this.stretchvalue);
                }
                this.stretchvalue = 1.0;
                this.repaint();
            }
            return true;
        }
        if (this.fMinXField.isVisible() || this.fMaxXField.isVisible() || this.fMinYField.isVisible() || this.fMaxYField.isVisible()) {
            return super.keyDown(event, n);
        }
        switch (n) {
            case 10: 
            case 13: {
                this.fGrapher.toolbar().setToArrowMode();
                return true;
            }
            case 8: 
            case 127: {
                this.deleteSelection();
                return true;
            }
            case 1007: {
                switch (this.fMode) {
                    case 17: {
                        int n2 = this.fPointSet.numPoints();
                        if (n2 < 2) break;
                        double d = 2.0 * this.fPointSet.getX(n2 - 1) - this.fPointSet.getX(n2 - 2);
                        double d2 = this.fHookingEvaluator.eval_(d);
                        this.fPointSet.addPoint(d, d2);
                        this.repaint();
                        return true;
                    }
                    case 18: {
                        int n3 = this.fSlopeSet.numPoints();
                        if (n3 < 1) break;
                        double d = this.fSlopeSet.dx(n3 - 1);
                        double d3 = this.fSlopeSet.getX(n3 - 1) + d;
                        double d4 = this.fHookingEvaluator.eval_(d3);
                        this.fSlopeSet.addSlope(d3, d4, d3 + d, this.fHookingEvaluator.eval_(d3 + d));
                        this.repaint();
                        return true;
                    }
                    case 19: {
                        int n4 = this.fBarSet.numPoints();
                        if (n4 < 1) break;
                        double d = this.fBarSet.width(n4 - 1);
                        double d5 = this.fBarSet.getX(n4 - 1) + d;
                        double d6 = FPBarSet.getBarHeight(d5, d5 + d, this.fHookingEvaluator);
                        this.fBarSet.addBar(d5, d6, d);
                        this.repaint();
                        return true;
                    }
                }
                this.fHistory.handleArrowKeys(39);
                return true;
            }
            case 1006: {
                switch (this.fMode) {
                    case 17: {
                        int n5 = this.fPointSet.numPoints();
                        if (n5 < 2) break;
                        double d = 2.0 * this.fPointSet.getX(0) - this.fPointSet.getX(1);
                        double d7 = this.fHookingEvaluator.eval_(d);
                        this.fPointSet.prependPoint(d, d7);
                        this.repaint();
                        return true;
                    }
                    case 18: {
                        int n6 = this.fSlopeSet.numPoints();
                        if (n6 < 1) break;
                        double d = this.fSlopeSet.dx(0);
                        double d8 = this.fSlopeSet.getX(0) - d;
                        double d9 = this.fHookingEvaluator.eval_(d8);
                        this.fSlopeSet.prependSlope(d8, d9, d8 + d, this.fHookingEvaluator.eval_(d8 + d));
                        this.repaint();
                        return true;
                    }
                    case 19: {
                        int n7 = this.fBarSet.numPoints();
                        if (n7 < 1) break;
                        double d = this.fBarSet.width(0);
                        double d10 = this.fBarSet.getX(0) - d;
                        double d11 = FPBarSet.getBarHeight(d10, d10 + d, this.fHookingEvaluator);
                        this.fBarSet.prependBar(d10, d11, d);
                        this.repaint();
                        return true;
                    }
                }
                this.fHistory.handleArrowKeys(37);
                return true;
            }
            case 1004: {
                this.fHistory.handleArrowKeys(38);
                return true;
            }
            case 1005: {
                this.fHistory.handleArrowKeys(40);
                return true;
            }
        }
        return false;
    }

    public boolean mouseEnter(Event event, int n, int n2) {
        this.setCursor(Cursor.getPredefinedCursor(this.fCursor));
        return true;
    }

    public boolean mouseMove(Event event, int n, int n2) {
        switch (this.fMode) {
            case 7: 
            case 8: {
                int n3 = this.x2pxlSuppressLog(this.fAnchorX);
                if (Math.abs(n - n3) < 4) {
                    this.fCursor = 11;
                    this.setCursor(Cursor.getPredefinedCursor(this.fCursor));
                    return true;
                }
                if (this.fMode != 8) break;
                this.fCursor = 0;
                this.setCursor(Cursor.getPredefinedCursor(this.fCursor));
                return true;
            }
            case 6: 
            case 9: {
                int n3 = this.y2pxlSuppressLog(this.fAnchorY);
                if (Math.abs(n2 - n3) < 4) {
                    this.fCursor = 8;
                    this.setCursor(Cursor.getPredefinedCursor(this.fCursor));
                    return true;
                }
                if (this.fMode != 9) break;
                this.fCursor = 0;
                this.setCursor(Cursor.getPredefinedCursor(this.fCursor));
                return true;
            }
        }
        switch (this.fMode) {
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                this.fCursor = this.fSelectionList.mouseMove(n, n2, this) ? 12 : 0;
                this.setCursor(Cursor.getPredefinedCursor(this.fCursor));
                return true;
            }
            case 16: 
            case 32: {
                if (this.fLine.handleHighlights(n, n2)) {
                    this.repaint();
                }
                return true;
            }
            case 1: {
                Evaluatable evaluatable;
                if (!this.fPolarMode) {
                    int n4 = 0;
                    while (n4 < this.fList.numObjects()) {
                        double d;
                        double d2;
                        int n5;
                        if (!this.fList.objectNum(n4).deleted() && this.fList.objectNum(n4) instanceof Evaluatable && Math.abs(n2 - (n5 = this.y2pxlSuppressLog(d2 = (evaluatable = (Evaluatable)((Object)this.fList.objectNum(n4))).eval_(d = this.pxl2xSuppressLog(n))))) < 4) {
                            this.fHotPoint = new Point(n, n5);
                            this.repaint();
                            this.fHistory.drawInField("(" + this.gIndepChar + "," + this.gDepChar + ") = (" + utils.num2str(d) + "," + utils.num2str(d2) + ")");
                            return true;
                        }
                        ++n4;
                    }
                    if (this.fHotPoint != null) {
                        this.fHotPoint = null;
                        this.repaint();
                    }
                } else {
                    int n6 = 0;
                    while (n6 < this.fList.numObjects()) {
                        if (!this.fList.objectNum(n6).deleted() && this.fList.objectNum(n6) instanceof FPPolarEquation) {
                            evaluatable = (FPPolarEquation)this.fList.objectNum(n6);
                            double d = this.pxl2xSuppressLog(n);
                            double d3 = this.pxl2ySuppressLog(n2);
                            double d4 = FPPolarEquation.getTheta(d, d3);
                            double d5 = ((FPEquation)evaluatable).eval_(d4);
                            d = d5 * Math.sin(d4);
                            int n7 = this.y2pxlSuppressLog(d);
                            d3 = d5 * Math.cos(d4);
                            int n8 = this.x2pxlSuppressLog(d3);
                            if (Math.abs(n2 - n7) < 4 && Math.abs(n - n8) < 4) {
                                this.fHotPoint = new Point(n8, n7);
                                this.repaint();
                                this.fHistory.drawInField("(r,T) = (" + utils.num2str(d) + "," + utils.num2str(d3) + ")");
                                return true;
                            }
                        }
                        ++n6;
                    }
                    if (this.fHotPoint != null) {
                        this.fHotPoint = null;
                        this.repaint();
                    }
                }
                if (!this.fPolarMode) {
                    this.fHistory.drawInField("(" + this.gIndepChar + "," + this.gDepChar + ") = (" + utils.num2str(this.pxl2x(n)) + "," + utils.num2str(this.pxl2y(n2)) + ")");
                } else {
                    double d = this.pxl2x(n);
                    double d6 = this.pxl2y(n2);
                    double d7 = Math.sqrt(d * d + d6 * d6);
                    double d8 = FPPolarEquation.getTheta(d, d6);
                    this.fHistory.drawInField("(r,T) = (" + utils.num2str(d7) + "," + utils.num2str(d8) + ")");
                }
                return true;
            }
        }
        return true;
    }

    public boolean mouseExit(Event event, int n, int n2) {
        FPAxesShell.fRegString = "";
        this.repaint();
        this.setCursor(Cursor.getPredefinedCursor(0));
        return true;
    }

    private void doMouseUpOption(int n, int n2, int n3) {
        switch (n) {
            case 7: {
                double d = 1.0;
                if (this.fXFormString.equals("")) break;
                try {
                    d = utils.str2num(this.fXFormString);
                    this.fSelectionList.copy(this.fList, this);
                    this.fSelectionList.stretchLR(this.fAnchorX, 1.0 / d, this.fLogX);
                    this.fSelectionList.calculate(this);
                }
                catch (FPNumberFormatException fPNumberFormatException) {
                    String string = fp_resource.getString("str_error__cant_convert_into_a_number");
                    if (this.fXFormString.trim().length() > 0) {
                        string = String.valueOf(string) + ": " + this.fXFormString;
                    }
                    utils.showErrorDialog(this.fGrapher, string);
                }
                break;
            }
            case 6: {
                double d = 1.0;
                if (this.fXFormString.equals("")) break;
                try {
                    d = utils.str2num(this.fXFormString);
                    this.fSelectionList.copy(this.fList, this);
                    this.fSelectionList.stretchUD(this.fAnchorY, d, this.fLogY);
                    this.fSelectionList.calculate(this);
                }
                catch (FPNumberFormatException fPNumberFormatException) {
                    String string = fp_resource.getString("str_error__cant_convert_into_a_number");
                    if (this.fXFormString.trim().length() > 0) {
                        string = String.valueOf(string) + ": " + this.fXFormString;
                    }
                    utils.showErrorDialog(this.fGrapher, string);
                }
                break;
            }
            case 8: {
                this.fSelectionList.copy(this.fList, this);
                this.fSelectionList.mirrorx(this.fAnchorX, this.fLogX);
                this.fSelectionList.calculate(this);
                break;
            }
            case 9: {
                this.fSelectionList.copy(this.fList, this);
                this.fSelectionList.mirrory(this.fAnchorY, this.fLogY);
                this.fSelectionList.calculate(this);
                break;
            }
            case 4: {
                if (n3 != this.oldiy) {
                    this.fSelectionList.copy(this.fList, this);
                    this.fSelectionList.translate(0.0, this.pxl2ySuppressLog(n3) - this.oldy, this.fLogX, this.fLogY);
                    this.fSelectionList.calculate(this);
                    break;
                }
                return;
            }
            case 5: {
                if (n2 != this.oldix) {
                    this.fSelectionList.copy(this.fList, this);
                    this.fSelectionList.translate(this.pxl2xSuppressLog(n2) - this.oldx, 0.0, this.fLogX, this.fLogY);
                    this.fSelectionList.calculate(this);
                    break;
                }
                return;
            }
            default: {
                return;
            }
        }
        this.fHistory.setSelect(this.fSelectionList.first());
        this.fGrapher.toolbar().setToArrowMode();
        this.drawBackground();
        this.repaint();
    }

    public synchronized boolean mouseUp(Event event, int n, int n2) {
        this.newiy = -1;
        this.newix = -1;
        this.oldiy = -1;
        this.oldix = -1;
        this.fCursor = 0;
        this.setCursor(Cursor.getPredefinedCursor(this.fCursor));
        if (this.fDraggingOrdinateMax) {
            this.fDraggingOrdinateMax = false;
            return true;
        }
        if (this.fDraggingAnchor) {
            this.fDraggingAnchor = false;
            if (this.fMode == 7 || this.fMode == 8) {
                this.fAnchorX = this.pxl2xSuppressLog(n);
                this.repaint();
                this.fAnchorSet = true;
                return true;
            }
            if (this.fMode == 6 || this.fMode == 9) {
                this.fAnchorY = this.pxl2ySuppressLog(n2);
                this.repaint();
                this.fAnchorSet = true;
                return true;
            }
            return true;
        }
        switch (this.fMode) {
            case 16: 
            case 32: {
                this.fLine.resetDrags();
                return true;
            }
            case 3: {
                if (this.oldix != n && this.oldiy != n2) {
                    this.fZoomCoords.push((this.fMaxX + this.fMinX) / 2.0, (this.fMaxY + this.fMinY) / 2.0, this.fPixelsPerXUnit, this.fPixelsPerYUnit);
                    this.fGrapher.toolbar().setMagUnmag();
                    this.minX(this.oldx);
                    this.maxY(this.oldy);
                    this.maxX(this.pxl2x(n));
                    this.minY(this.pxl2y(n2));
                    this.setUpAxes();
                    this.drawBackground();
                    this.repaint();
                }
                this.fZoomRect.width = 0;
                this.fZoomRect.height = 0;
                this.fGrapher.setToolbarMode(1);
                this.mode(0);
                this.selectLast();
                return true;
            }
            case 12: {
                int n3 = 0;
                while (n3 < this.fNumDrawObjects) {
                    this.fDrawObject[n3].mouseUp();
                    ++n3;
                }
                return true;
            }
            case 18: 
            case 28: {
                this.fSlopeSet.addSlope(this.pxl2x(this.fSlopePt1.x), this.pxl2y(this.fSlopePt1.y), this.pxl2x(this.fSlopePt2.x), this.pxl2y(this.fSlopePt2.y));
                this.fSlopePt1 = new Point(-1, -1);
                this.repaint();
                return true;
            }
            case 11: 
            case 19: {
                this.fBarSet.addBar(this.pxl2x(this.fBarRect.x), this.pxl2y(this.fBarRect.y), this.pxl2x(this.fBarRect.width) - this.pxl2x(0));
                this.fBarRect.height = -1;
                this.repaint();
                return true;
            }
            case 1: {
                if (this.fPolarMode) {
                    double d = this.pxl2x(n);
                    double d2 = this.pxl2y(n2);
                    double d3 = Math.sqrt(d * d + d2 * d2);
                    double d4 = FPPolarEquation.getTheta(d, d2);
                    this.fPointSet.addPoint(d4, d3);
                } else {
                    this.fPointSet.addPoint(this.pxl2x(n), this.pxl2y(n2));
                }
                this.fDraggingPoint = null;
                this.repaint();
                return true;
            }
            case 17: {
                double d = this.pxl2x(n);
                double d5 = this.fHookingEvaluator.eval_(d);
                this.fPointSet.addPoint(d, d5);
                this.fDraggingPoint = null;
                this.repaint();
                return true;
            }
            case 31: {
                this.addToList(new FPEquation(String.valueOf(this.gDepChar) + "=" + utils.num2str(this.fLine.getM()) + String.valueOf(this.gIndepChar) + " + " + utils.num2str(this.fLine.getB()), this.fLine.getColor(), this));
                this.fLine = null;
                this.fDraggingPoint = null;
                this.fGrapher.toolbar().setToArrowMode();
                this.drawBackground();
                this.repaint();
                return true;
            }
        }
        if (this.fSelectionList.isEmpty()) {
            return true;
        }
        this.doMouseUpOption(this.fMode, n, n2);
        return true;
    }

    public synchronized boolean mouseDrag(Event event, int n, int n2) {
        if (this.fDraggingOrdinateMax) {
            this.fOrdinateMaxX = n;
            this.repaint();
            this.fHistory.drawInField(String.valueOf(this.gIndepChar) + " =" + utils.num2str(this.pxl2x(n)));
            return true;
        }
        if (this.fDraggingAnchor) {
            if (this.fMode == 7 || this.fMode == 8) {
                this.fAnchorX = this.pxl2xSuppressLog(n);
                this.repaint();
                this.fAnchorString = utils.num2str(this.fAnchorX);
                this.fHistory.drawAnchor(this.fAnchorString);
                return true;
            }
            if (this.fMode == 6 || this.fMode == 9) {
                this.fAnchorY = this.pxl2ySuppressLog(n2);
                this.repaint();
                this.fAnchorString = utils.num2str(this.fAnchorY);
                this.fHistory.drawAnchor(this.fAnchorString);
                return true;
            }
            this.fDraggingAnchor = false;
            return true;
        }
        this.newix = n;
        this.newiy = n2;
        switch (this.fMode) {
            case 32: {
                if (this.fLine.handleDrags(this.pxl2x(n), this.pxl2y(n2))) {
                    this.repaint();
                    if (this.fLeastSquaresMode) {
                        this.fHistory.drawInField(String.valueOf(this.gDepChar) + "=" + utils.num2str(this.fLine.getM()) + this.gIndepChar + " + " + utils.num2str(this.fLine.getB()) + "  :  " + fp_resource.getString("str_rss") + " = " + utils.num2str(this.fPointSet.totalError(this.fLine.getM(), this.fLine.getB(), this)));
                    } else {
                        this.fHistory.drawInField(String.valueOf(this.gDepChar) + "=" + utils.num2str(this.fLine.getM()) + this.gIndepChar + " + " + utils.num2str(this.fLine.getB()) + "  :  " + fp_resource.getString("str_asd") + " = " + utils.num2str(this.fPointSet.totalDev(this.fLine.getM(), this.fLine.getB(), this)));
                    }
                }
                this.fCursor = 13;
                this.setCursor(Cursor.getPredefinedCursor(this.fCursor));
                return true;
            }
            case 16: {
                if (this.fLine.handleDrags(this.pxl2x(n), this.pxl2y(n2))) {
                    this.repaint();
                    this.fHistory.drawInField(String.valueOf(this.gDepChar) + "=" + utils.num2str(this.fLine.getM()) + this.gIndepChar + " + " + utils.num2str(this.fLine.getB()));
                }
                this.fCursor = 13;
                this.setCursor(Cursor.getPredefinedCursor(this.fCursor));
                return true;
            }
            case 12: {
                int n3 = 0;
                while (n3 < this.fNumDrawObjects) {
                    if (this.fDrawObject[n3].mouseDrag(n - this.oldix, n2 - this.oldiy, n, n2)) {
                        this.oldix = n;
                        this.oldiy = n2;
                        this.fCursor = 13;
                        this.setCursor(Cursor.getPredefinedCursor(this.fCursor));
                        this.repaint();
                        return true;
                    }
                    ++n3;
                }
                return true;
            }
            case 31: {
                double d = this.pxl2x(n);
                double d2 = this.fHookingEvaluator.eval_(d);
                this.fDraggingPoint.x = n;
                this.fDraggingPoint.y = this.y2pxl(d2);
                double d3 = this.pxl2xDelta(1);
                double d4 = (this.fHookingEvaluator.eval_(d + d3) - d2) / d3;
                this.fLine.setM(d4);
                this.fLine.setB(d, d2);
                this.repaint();
                this.fHistory.drawInField(String.valueOf(this.gDepChar) + "=" + utils.num2str(this.fLine.getM()) + this.gIndepChar + " + " + utils.num2str(this.fLine.getB()));
                return true;
            }
            case 17: {
                this.fDraggingPoint.x = n;
                double d = this.fHookingEvaluator.eval_(this.pxl2x(n));
                this.fDraggingPoint.y = this.y2pxl(d);
                this.fHistory.drawInField("(" + this.gIndepChar + "," + this.gDepChar + ") = (" + utils.num2str(this.pxl2x(n)) + "," + utils.num2str(d) + ")");
                this.repaint();
                return this.mouseMove(event, n, n2);
            }
            case 1: {
                this.fDraggingPoint.x = n;
                this.fDraggingPoint.y = n2;
                this.repaint();
                return this.mouseMove(event, n, n2);
            }
            case 18: 
            case 28: {
                this.fSlopePt2.x = n;
                this.fSlopePt2.y = this.fMode == 18 ? this.y2pxl(this.fHookingEvaluator.eval_(this.pxl2x(n))) : n2;
                this.repaint();
                String string = utils.num2str((this.pxl2y(this.fSlopePt2.y) - this.pxl2y(this.fSlopePt1.y)) / (this.pxl2x(this.fSlopePt2.x) - this.pxl2x(this.fSlopePt1.x)));
                this.fHistory.drawInField("(" + this.gDepChar + "2-" + this.gDepChar + "1)/(" + this.gIndepChar + "2-" + this.gIndepChar + "1) = (" + utils.num2str(this.pxl2y(this.fSlopePt2.y)) + "-" + utils.num2str(this.pxl2y(this.fSlopePt1.y)) + ")/(" + utils.num2str(this.pxl2x(this.fSlopePt2.x)) + "-" + utils.num2str(this.pxl2x(this.fSlopePt1.x)) + ")" + "    m = " + string);
                return true;
            }
            case 11: 
            case 19: {
                this.fBarRect.width = n - this.fBarRect.x;
                this.fBarRect.y = this.fMode == 19 ? this.y2pxl(FPBarSet.getBarHeight(this.pxl2x(this.fBarRect.x), this.pxl2x(n), this.fHookingEvaluator)) : n2;
                this.repaint();
                this.fHistory.drawInField("[" + this.gIndepChar + "1," + this.gIndepChar + "2]," + this.gDepChar + " = [" + utils.num2str(this.pxl2x(this.fBarRect.x)) + "," + utils.num2str(this.pxl2x(n)) + "]," + utils.num2str(this.pxl2y(this.fBarRect.y)));
                return true;
            }
            case 7: {
                int n4 = this.x2pxlSuppressLog(this.fAnchorX);
                double d = (double)(n - n4) / (double)(this.oldix - n4);
                this.fSelectionList.fastStretchLR(n4, d);
                this.fXFormString = utils.num2str(d);
                this.fHistory.drawStretchLR(this.fXFormString);
                this.fHistory.drawAnchor(this.fAnchorString);
                this.fCursor = 13;
                this.setCursor(Cursor.getPredefinedCursor(this.fCursor));
                this.repaint();
                return true;
            }
            case 6: {
                int n5 = this.y2pxlSuppressLog(this.fAnchorY);
                double d = (double)(n2 - n5) / (double)(this.oldiy - n5);
                this.fSelectionList.fastStretchUD(n5, d);
                this.fXFormString = utils.num2str(d);
                this.fHistory.drawStretchLR(this.fXFormString);
                this.fHistory.drawAnchor(this.fAnchorString);
                this.fCursor = 13;
                this.setCursor(Cursor.getPredefinedCursor(this.fCursor));
                this.repaint();
                return true;
            }
            case 4: {
                double d = this.pxl2y(n2) - this.oldy;
                this.fSelectionList.fastTranslate(0, n2 - this.oldiy);
                this.fCursor = 13;
                this.setCursor(Cursor.getPredefinedCursor(this.fCursor));
                this.repaint();
                this.fXFormString = utils.num2str(d);
                this.fHistory.drawTransUD(this.fXFormString);
                return true;
            }
            case 5: {
                double d = this.pxl2x(n) - this.oldx;
                this.fSelectionList.fastTranslate(n - this.oldix, 0);
                this.fCursor = 13;
                this.setCursor(Cursor.getPredefinedCursor(this.fCursor));
                this.repaint();
                this.fXFormString = utils.num2str(d);
                this.fHistory.drawTransLR(this.fXFormString);
                return true;
            }
            case 3: {
                this.fZoomRect.width = n - this.fZoomRect.x;
                this.fZoomRect.height = n2 - this.fZoomRect.y;
                this.repaint();
                return true;
            }
            case 2: {
                if (n == this.oldix && n2 == this.oldiy) {
                    return true;
                }
                Graphics graphics = this.getGraphics();
                graphics.setColor(this.fFreeHand.getColor());
                graphics.drawLine(this.oldix, this.oldiy, n, n2);
                double d = this.pxl2x(n);
                double d5 = this.pxl2y(n2);
                this.fFreeHand.addPoint(d, d5, n, n2);
                this.oldix = n;
                this.oldiy = n2;
                return true;
            }
        }
        return true;
    }

    public synchronized boolean mouseDown(Event event, int n, int n2) {
        if (this.handleRescales(n, n2)) {
            return true;
        }
        if (this.handleAxesArrows(n, n2)) {
            this.setUpAxes();
            this.fList.recalculate(this);
            this.drawBackground();
            this.repaint();
            return true;
        }
        if (this.fOrdinatesInPieces && Math.abs(n - this.fOrdinateMaxX) < 4) {
            this.fDraggingOrdinateMax = true;
            return true;
        }
        if (this.fMode == 2) {
            this.oldx = this.pxl2x(n);
            this.oldy = this.pxl2y(n2);
        } else {
            this.oldx = this.pxl2xSuppressLog(n);
            this.oldy = this.pxl2ySuppressLog(n2);
        }
        this.oldix = n;
        this.oldiy = n2;
        switch (this.fMode) {
            case 16: 
            case 32: {
                if (this.fLine.checkDrags(n, n2)) {
                    this.repaint();
                    return true;
                }
                if (this.fLine != null) {
                    FPEquation fPEquation = new FPEquation(String.valueOf(this.gDepChar) + "=" + utils.num2str(this.fLine.getM()) + this.gIndepChar + " + " + utils.num2str(this.fLine.getB()), this.fLine.getColor(), this);
                    this.addToList(fPEquation);
                    if (this.fMode == 32) {
                        if (this.fLeastSquaresMode) {
                            fPEquation.setShowRSS(true);
                            fPEquation.setRSS(this.fPointSet.totalError(this.fLine.getM(), this.fLine.getB(), this));
                        } else {
                            fPEquation.setShowADS(true);
                            fPEquation.setADS(this.fPointSet.totalDev(this.fLine.getM(), this.fLine.getB(), this));
                        }
                    }
                    this.fLine = null;
                    this.fGrapher.setToolbarMode(1);
                    this.mode(0);
                    this.drawBackground();
                    this.repaint();
                }
                return true;
            }
            case 31: {
                this.fLine = new FPLine(0.0, 0.0, Color.blue, this);
                this.fDraggingPoint = new Point(0, 0);
                return this.mouseDrag(event, n, n2);
            }
            case 12: {
                int n3 = 0;
                while (n3 < this.fNumDrawObjects) {
                    if (this.fDrawObject[n3].mouseDown(n, n2)) {
                        return true;
                    }
                    ++n3;
                }
                this.drawObjectsToFreehand();
                this.mode(0);
                return true;
            }
            case 7: 
            case 8: {
                int n4 = this.x2pxlSuppressLog(this.fAnchorX);
                if (Math.abs(n - n4) < 4) {
                    this.fDraggingAnchor = true;
                    this.fCursor = 13;
                    this.setCursor(Cursor.getPredefinedCursor(this.fCursor));
                    return true;
                }
                if (this.fMode != 8) break;
                this.doMouseUpOption(this.fMode, 0, 0);
                return true;
            }
            case 6: 
            case 9: {
                int n5 = this.y2pxlSuppressLog(this.fAnchorY);
                if (Math.abs(n2 - n5) < 4) {
                    this.fDraggingAnchor = true;
                    this.fCursor = 13;
                    this.setCursor(Cursor.getPredefinedCursor(this.fCursor));
                    return true;
                }
                if (this.fMode != 9) break;
                this.doMouseUpOption(this.fMode, 0, 0);
                return true;
            }
            case 3: {
                this.fZoomRect.x = n;
                this.fZoomRect.y = n2;
                this.fZoomRect.width = 0;
                this.fZoomRect.height = 0;
                return true;
            }
            case 2: {
                if (this.fFreeHand == null) {
                    this.fFreeHand = new FPFreeHand(this.fGrapher.colorPalette().nextColor(), this);
                } else {
                    this.fFreeHand.addBreak();
                }
                this.fFreeHand.addPoint(this.oldx, this.oldy, n, n2);
                return true;
            }
            case 17: {
                this.fDraggingPoint = new Point(0, 0);
                return this.mouseDrag(event, n, n2);
            }
            case 1: {
                this.fDraggingPoint = new Point(n, n2);
                this.repaint();
                return true;
            }
            case 18: 
            case 28: {
                if (event.shiftDown() && this.fSlopeSet.numPoints() > 0) {
                    this.fSlopePt1.x = this.fSlopePt2.x;
                    this.fSlopePt1.y = this.fSlopePt2.y;
                } else {
                    this.fSlopePt1.x = n;
                    this.fSlopePt1.y = this.fMode == 18 ? this.y2pxl(this.fHookingEvaluator.eval_(this.pxl2x(n))) : n2;
                }
                return this.mouseDrag(event, n, n2);
            }
            case 11: 
            case 19: {
                this.fBarRect.height = 1;
                if (event.shiftDown() && this.fBarSet.numPoints() > 0) {
                    this.fBarRect.x += this.fBarRect.width;
                } else {
                    this.fBarRect.y = this.fMode == 19 ? this.y2pxl(this.fHookingEvaluator.eval_(this.pxl2x(n))) : n2;
                    this.fBarRect.x = n;
                    this.fBarRect.width = 0;
                }
                return this.mouseDrag(event, n, n2);
            }
        }
        FPObject fPObject = this.fList.handleMouseDown(n, n2, this);
        switch (this.fMode) {
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                return false;
            }
        }
        if (fPObject == null) {
            if (event.shiftDown()) {
                this.selectLast();
                this.fGrapher.handleMenus();
            } else {
                this.fGrapher.toolbar().setToArrowMode();
            }
            return true;
        }
        if (!event.shiftDown()) {
            if (this.fSelectionList.mouseMove(n, n2, this)) {
                FPObject fPObject2 = this.fList.checkUnderneath(n, n2, this.fSelectionList.last());
                if (fPObject2 == null) {
                    this.repaint();
                    this.fHistory.repaint();
                    if (!(this.fMode != 6 && this.fMode != 7 || this.fAnchorSet)) {
                        this.fAnchorSet = true;
                        this.fAnchorString = this.fMode == 6 ? utils.num2str(this.fAnchorY) : utils.num2str(this.fAnchorX);
                        this.fHistory.drawAnchor(this.fAnchorString);
                    }
                    if (this.fSelectionList.numObjects() == 1) {
                        return true;
                    }
                } else {
                    fPObject = fPObject2;
                }
            }
            this.fSelectionList.clear();
        }
        this.selectObjectWithoutClearing(fPObject);
        this.fGrapher.handleMenus();
        this.repaint();
        return true;
    }

    public void clearSelect() {
        this.fSelectionList.clear();
        this.fGrapher.handleMenus();
    }

    public void deleteSelection() {
        this.fSelectionList.delete();
        this.drawBackground();
        this.repaint();
        this.fHistory.repaint();
        this.fGrapher.handleMenus();
    }

    public void deleteOthers() {
        this.fSelectionList.deleteOthers(this.fList);
        this.drawBackground();
        this.fGrapher.handleMenus();
        this.repaint();
    }

    public void selectAll() {
        this.clearSelect();
        int n = 0;
        while (n < this.fList.numObjects()) {
            this.fSelectionList.addToList(this.fList.objectNum(n));
            ++n;
        }
        this.fGrapher.handleMenus();
        this.repaint();
    }

    public boolean somethingSelected() {
        if (this.fSelectionList.isEmpty()) {
            return false;
        }
        return !this.fSelectionList.isCombEquationSelected();
    }

    public int numSelectedObjects() {
        return this.fSelectionList.numObjects();
    }

    public FPObject selectedObject() {
        return this.selectedObject(0);
    }

    public FPObject selectedObject(int n) {
        return this.fSelectionList.objectNum(n);
    }

    public void selectObject(int n) {
        this.selectObject(this.fList.objectNum(n));
    }

    public void setBounds(int n, int n2, int n3, int n4) {
        if (!this.fInitialized) {
            this.fMinXField.setVisible(false);
            this.fMaxXField.setVisible(false);
            this.fMinYField.setVisible(false);
            this.fMaxYField.setVisible(false);
            this.fInitialized = true;
        }
        super.setBounds(n, n2, n3, n4);
        this.drawBackground();
    }

    public void selectObjectWithoutClearing(FPObject fPObject) {
        this.fSelectionList.addToList(fPObject);
        this.fHistory.setSelect(fPObject);
        this.currentVar(fPObject.varIndex());
        this.fGrapher.handleMenus();
        this.repaint();
    }

    public void selectObject(FPObject fPObject) {
        this.fSelectionList.clear();
        this.selectObjectWithoutClearing(fPObject);
    }

    public void selectLast() {
        if (this.fList.last() == null) {
            return;
        }
        this.selectObject(this.fList.last());
    }

    public void doCut(GrapherClipboard grapherClipboard) {
        grapherClipboard.placeOnClipboard(this.fSelectionList.groupToCut(this));
        this.drawBackground();
        this.repaint();
    }

    public void doCopy(GrapherClipboard grapherClipboard) {
        grapherClipboard.placeOnClipboard(this.fSelectionList.groupToCopy(this));
    }

    public void doPaste(GrapherClipboard grapherClipboard) {
        FPGroup fPGroup = grapherClipboard.getFromClipboard();
        if (fPGroup != null) {
            int n = 0;
            while (n < fPGroup.numObjects()) {
                FPObject fPObject = fPGroup.objectNum(n);
                fPObject.calculate(this);
                this.addToList(fPObject);
                ++n;
            }
            this.drawBackground();
            this.repaint();
        }
    }

    public FPObject firstFPObject() {
        return this.fList.first();
    }

    public FPObjectList objectList() {
        return this.fList;
    }

    public void clearAll() {
        this.clearSelect();
        this.fList.clearAll();
        this.fZoomCoords = new ZoomCoords();
        this.parent().toolbar().setMag();
    }

    private void quickRescalesChanged() {
        try {
            double d;
            if (this.fMinXField.isVisible()) {
                d = utils.getDouble(this.fMinXField);
                this.minX(d);
            }
            if (this.fMaxXField.isVisible()) {
                d = utils.getDouble(this.fMaxXField);
                this.maxX(d);
            }
            if (this.fMinYField.isVisible()) {
                d = utils.getDouble(this.fMinYField);
                this.minY(d);
            }
            if (this.fMaxYField.isVisible()) {
                d = utils.getDouble(this.fMaxYField);
                this.maxY(d);
            }
            this.setUpAxes();
            this.drawBackground();
            this.repaint();
        }
        catch (FPNumberFormatException fPNumberFormatException) {}
    }

    public void doPrint() {
        Properties properties = new Properties();
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        PrintJob printJob = toolkit.getPrintJob(this.fGrapher, fp_resource.getString("str_graph"), properties);
        if (printJob == null) {
            return;
        }
        Dimension dimension = printJob.getPageDimension();
        Dimension dimension2 = this.getSize();
        dimension.width -= 80;
        dimension.height -= 80;
        int n = (int)Math.floor((double)dimension2.width / (double)dimension.width) + 1;
        int n2 = (int)Math.floor((double)dimension2.height / (double)dimension.height) + 1;
        Graphics graphics = printJob.getGraphics();
        int n3 = 0;
        while (n3 < n2) {
            int n4 = n3 * dimension.height + 40;
            int n5 = 0;
            while (n5 < n) {
                int n6 = n5 * dimension.width + 40;
                graphics = printJob.getGraphics();
                graphics.translate(n6, n4);
                int n7 = dimension.width;
                int n8 = dimension.height;
                if (n6 + n7 > dimension2.width) {
                    n7 = dimension2.width - n6;
                }
                if (n4 + n8 > dimension2.height) {
                    n8 = dimension2.height - n4;
                }
                graphics.setClip(0, 0, n7 + n6, n8 + n4);
                this.drawBackground(graphics);
                graphics.translate(-n6, -n4);
                graphics.dispose();
                ++n5;
            }
            ++n3;
        }
        printJob.end();
    }

    public void drawObjectType(int n) {
        this.fDrawObjectType = n;
    }

    public void drawObjectsToFreehand() {
        FPFreeHand fPFreeHand = new FPFreeHand(this.fDrawObjectColor, this);
        int n = 0;
        while (n < this.fNumDrawObjects) {
            this.fDrawObject[n].appendToFreehand(this, fPFreeHand);
            if (n != this.fNumDrawObjects - 1) {
                fPFreeHand.addBreak();
            }
            ++n;
        }
        this.addToList(fPFreeHand);
        this.fGrapher.setToolbarMode(1);
        this.drawBackground();
        this.repaint();
    }

    public Dialog curvePalette() {
        return this.fCurvePalette;
    }

    public void sendToCalculator() {
        if (this.fSelectionList == null) {
            return;
        }
        if (this.fSelectionList.numObjects() != 1) {
            return;
        }
        FPObject fPObject = this.fSelectionList.objectNum(0);
        if (fPObject.kind() != 0) {
            return;
        }
        FPEquation fPEquation = (FPEquation)fPObject;
        String string = this.fHistory.getName(fPObject);
        if (string == null) {
            this.fHistory.define(fPObject);
            string = this.fHistory.getName(fPObject);
        }
        Master.sendGrapherButton(string);
    }

    public void defineSelection() {
        if (this.fSelectionList == null) {
            return;
        }
        if (this.fSelectionList.numObjects() != 1) {
            return;
        }
        this.fHistory.define();
    }

    public void groupSelection() {
        if (this.fSelectionList == null) {
            utils.showErrorDialog(this.fGrapher, fp_resource.getString("str_error__null_selection"));
            return;
        }
        if (this.fSelectionList.numObjects() < 2) {
            utils.showErrorDialog(this.fGrapher, fp_resource.getString("str_error__must_have_multiple_objects_selected"));
            return;
        }
        this.fSelectionList.group(this);
        this.drawBackground();
        this.repaint();
        this.fGrapher.handleMenus();
    }

    public void ungroup() {
        this.fSelectionList.ungroup(this);
        this.drawBackground();
        this.repaint();
        this.fGrapher.handleMenus();
    }

    public HistoryArea history() {
        return this.fHistory;
    }

    public void history(HistoryArea historyArea) {
        this.fHistory = historyArea;
    }

    public boolean isVarIndexUsed(int n) {
        return this.fList.isVarIndexUsed(n);
    }

    public void recalculate() {
        this.fList.recalculate(this);
        if (this.fFreeHand != null) {
            this.fFreeHand.calculate(this);
        }
        if (this.fPointSet != null) {
            this.fPointSet.calculate(this);
        }
        if (this.fBarSet != null) {
            this.fBarSet.calculate(this);
        }
        if (this.fSlopeSet != null) {
            this.fSlopeSet.calculate(this);
        }
    }

    public boolean showAsymptotes() {
        return this.fShowAsymptotes;
    }

    public void showAsymptotes(boolean bl) {
        this.fShowAsymptotes = bl;
        this.recalculate();
        this.drawBackground();
        this.repaint();
    }

    public boolean autoDefine() {
        return this.fAutoDefine;
    }

    public void autoDefine(boolean bl) {
        this.fAutoDefine = bl;
    }

    public void leastSquaresMode(boolean bl) {
        this.fLeastSquaresMode = bl;
    }

    public boolean leastSquaresMode() {
        return this.fLeastSquaresMode;
    }

    private final class 1
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            FPAxes.this.quickRescalesChanged();
        }

        /* synthetic */ 1() {
        }
    }
}

