/*
 * Decompiled with CFR 0.152.
 */
package com.questmsm.FPGrapher;

import com.questmsm.FPGrapher.FPAxes;
import com.questmsm.FPGrapher.FPObject;
import com.questmsm.FPGrapher.FPRPNConverter;
import com.questmsm.FunctionProbe.Master;
import com.questmsm.Utilities.BadComputationException;
import com.questmsm.Utilities.FPNumberFormatException;
import com.questmsm.Utilities.fp_resource;
import com.questmsm.Utilities.utils;
import java.awt.Color;
import java.awt.Graphics;
import java.io.Serializable;

public class FPParametricEquation
extends FPObject
implements Serializable {
    protected double[] fInstructionsX = new double[50];
    protected double[] fInstructionsY = new double[50];
    protected int fLastInstructionX;
    protected int fLastInstructionY;
    public transient double[] fStack;
    public static final transient int kEnd = 0;
    public static final transient int kPushConst = 1;
    public static final transient int kPushVar = 2;
    public static final transient int kAdd = 3;
    public static final transient int kSub = 4;
    public static final transient int kMult = 5;
    public static final transient int kDiv = 6;
    public static final transient int kPow = 7;
    public static final transient int kSqrt = 8;
    public static final transient int kSin = 9;
    public static final transient int kCos = 10;
    public static final transient int kTan = 11;
    public static final transient int kASin = 12;
    public static final transient int kACos = 13;
    public static final transient int kATan = 14;
    public static final transient int kE = 15;
    public static final transient int kLn = 16;
    public static final transient int kPushYVar = 17;
    public static final transient int kFloor = 18;
    public static final transient int kCalcButton = 19;
    public static final transient int kCeil = 20;
    public static final transient int kSec = 21;
    public static final transient int kCsc = 22;
    public static final transient int kCot = 23;
    public static final transient int kStep = 24;
    public static final transient int kRound = 25;
    public static final transient int kOtherEq = 26;
    public static final transient int kCosh = 31;
    public static final transient int kSinh = 32;
    public static final transient int kTanh = 33;
    public static final transient int kSech = 34;
    public static final transient int kCsch = 35;
    public static final transient int kCoth = 36;
    public static final transient int kASec = 37;
    public static final transient int kACsc = 38;
    public static final transient int kACot = 39;
    public static final transient int kSgn = 40;
    public static final transient int kFrac = 41;
    public static final transient int kInt = 42;
    public static final transient int kAbs = 43;
    public static final transient int kMod = 44;
    public static final transient int kIDiv = 45;
    protected static final transient double kBadResult = -0.1234567;
    protected static final transient int kMaxSteps = 300;
    protected static final transient double kMaxSlope = 10.0;
    protected transient int[] fX;
    protected transient int[] fY;
    protected transient int[] fOldX;
    protected transient int[] fOldY;
    protected FPRPNConverter fConverterX;
    protected FPRPNConverter fConverterY;
    public static final transient int kContinuous = 0;
    public static final transient int kDiscrete = 1;
    protected String fEquationStringX;
    protected String fEquationStringY;
    protected int fMode = 0;
    protected double fMin;
    protected double fMax;
    protected double fStart;
    protected double fStop;
    protected double fIncr;
    protected boolean fBadEquation = false;

    public FPParametricEquation() {
        this.allocateTransients(null);
    }

    public FPParametricEquation(String string, String string2, Color color) {
        this.fConverterX = new FPRPNConverter("x", "t");
        this.fConverterY = new FPRPNConverter("y", "t");
        this.fEquationStringY = string;
        this.fEquationStringX = string2;
        this.fKind = 2;
        this.fColor = color;
        if (string.length() == 0 || string2.length() == 0) {
            this.fInstructionsX[0] = 0.0;
            this.fLastInstructionX = 0;
            this.fInstructionsY[0] = 0.0;
            this.fLastInstructionY = 0;
        } else {
            this.stringToEquationX(this.fEquationStringX);
            this.stringToEquationY(this.fEquationStringY);
        }
        this.allocateTransients(null);
    }

    public void allocateTransients(FPAxes fPAxes) {
        this.fStack = new double[50];
        this.fX = new int[300];
        this.fY = new int[300];
        this.fOldX = new int[300];
        this.fOldY = new int[300];
    }

    public void setTmode(int n) {
        this.fMode = n;
    }

    public void setMinMax(double d, double d2) {
        this.fMin = d;
        this.fMax = d2;
    }

    public void setDiscrete(double d, double d2, double d3) {
        this.fStart = d;
        this.fStop = d2;
        this.fIncr = d3;
    }

    public String getEqString() {
        return this.fEquationStringX;
    }

    public String getEqXString() {
        return this.fEquationStringX;
    }

    public String getEqYString() {
        return this.fEquationStringY;
    }

    public boolean badEquation() {
        return this.fBadEquation;
    }

    protected void stringToEquationY(String string) {
        int n = 0;
        int n2 = 0;
        String string2 = this.fConverterY.convert(new StringBuffer(string)).toString();
        if (string2 == null) {
            this.fBadEquation = true;
            return;
        }
        this.fLastInstructionY = 0;
        do {
            double d;
            String string3;
            if ((n2 = utils.getNextSpace(string2, n)) == -1) {
                return;
            }
            try {
                string3 = string2.substring(n, n2);
            }
            catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                break;
            }
            n = n2 + 1;
            if (string3.equals("t")) {
                this.fInstructionsY[this.fLastInstructionY++] = 2.0;
                continue;
            }
            if (string3.equals("+")) {
                this.fInstructionsY[this.fLastInstructionY++] = 3.0;
                continue;
            }
            if (string3.equals("-")) {
                this.fInstructionsY[this.fLastInstructionY++] = 4.0;
                continue;
            }
            if (string3.equals("*")) {
                this.fInstructionsY[this.fLastInstructionY++] = 5.0;
                continue;
            }
            if (string3.equals("/")) {
                this.fInstructionsY[this.fLastInstructionY++] = 6.0;
                continue;
            }
            if (string3.equals("^")) {
                this.fInstructionsY[this.fLastInstructionY++] = 7.0;
                continue;
            }
            if (string3.equals("sqrt")) {
                this.fInstructionsY[this.fLastInstructionY++] = 8.0;
                continue;
            }
            if (string3.equals(fp_resource.sin) || string3.equals("sin")) {
                this.fInstructionsY[this.fLastInstructionY++] = 9.0;
                continue;
            }
            if (string3.equals(fp_resource.cos) || string3.equals("cos")) {
                this.fInstructionsY[this.fLastInstructionY++] = 10.0;
                continue;
            }
            if (string3.equals(fp_resource.tan) || string3.equals("tan")) {
                this.fInstructionsY[this.fLastInstructionY++] = 11.0;
                continue;
            }
            if (string3.equals("asin")) {
                this.fInstructionsY[this.fLastInstructionY++] = 12.0;
                continue;
            }
            if (string3.equals("acos")) {
                this.fInstructionsY[this.fLastInstructionY++] = 13.0;
                continue;
            }
            if (string3.equals("atan")) {
                this.fInstructionsY[this.fLastInstructionY++] = 14.0;
                continue;
            }
            if (string3.equals("exp")) {
                this.fInstructionsY[this.fLastInstructionY++] = 15.0;
                continue;
            }
            if (string3.equals("log")) {
                this.fInstructionsY[this.fLastInstructionY++] = 16.0;
                continue;
            }
            if (string3.equals("sinh")) {
                this.fInstructionsY[this.fLastInstructionY++] = 32.0;
                continue;
            }
            if (string3.equals("cosh")) {
                this.fInstructionsY[this.fLastInstructionY++] = 31.0;
                continue;
            }
            if (string3.equals("tanh")) {
                this.fInstructionsY[this.fLastInstructionY++] = 33.0;
                continue;
            }
            if (string3.equals("csch")) {
                this.fInstructionsY[this.fLastInstructionY++] = 35.0;
                continue;
            }
            if (string3.equals("coth")) {
                this.fInstructionsY[this.fLastInstructionY++] = 36.0;
                continue;
            }
            if (string3.equals("sech")) {
                this.fInstructionsY[this.fLastInstructionY++] = 34.0;
                continue;
            }
            if (string3.equals("asec")) {
                this.fInstructionsY[this.fLastInstructionY++] = 37.0;
                continue;
            }
            if (string3.equals("acsc")) {
                this.fInstructionsY[this.fLastInstructionY++] = 38.0;
                continue;
            }
            if (string3.equals("acot")) {
                this.fInstructionsY[this.fLastInstructionY++] = 39.0;
                continue;
            }
            if (string3.equals("sgn")) {
                this.fInstructionsY[this.fLastInstructionY++] = 40.0;
                continue;
            }
            if (string3.equals("frac")) {
                this.fInstructionsY[this.fLastInstructionY++] = 41.0;
                continue;
            }
            if (string3.equals("int")) {
                this.fInstructionsY[this.fLastInstructionY++] = 42.0;
                continue;
            }
            if (string3.equals("abs")) {
                this.fInstructionsY[this.fLastInstructionY++] = 43.0;
                continue;
            }
            if (string3.equals("mod")) {
                this.fInstructionsY[this.fLastInstructionY++] = 44.0;
                continue;
            }
            if (string3.equals("div")) {
                this.fInstructionsY[this.fLastInstructionY++] = 45.0;
                continue;
            }
            if (string3.equals("step")) {
                this.fInstructionsY[this.fLastInstructionY++] = 24.0;
                continue;
            }
            if (string3.equals("round")) {
                this.fInstructionsY[this.fLastInstructionY++] = 25.0;
                continue;
            }
            if (string3.equals("floor")) {
                this.fInstructionsY[this.fLastInstructionY++] = 18.0;
                continue;
            }
            if (string3.equals("ceil")) {
                this.fInstructionsY[this.fLastInstructionY++] = 20.0;
                continue;
            }
            if (string3.equals("sec")) {
                this.fInstructionsY[this.fLastInstructionY++] = 21.0;
                continue;
            }
            if (string3.equals("csc")) {
                this.fInstructionsY[this.fLastInstructionY++] = 22.0;
                continue;
            }
            if (string3.equals("cot")) {
                this.fInstructionsY[this.fLastInstructionY++] = 23.0;
                continue;
            }
            if (string3.charAt(0) == 'B') {
                this.fInstructionsY[this.fLastInstructionY++] = 19.0;
                this.fInstructionsY[this.fLastInstructionY++] = string3.charAt(1) - 48;
                continue;
            }
            if (string3.charAt(0) == 'G') {
                this.fInstructionsY[this.fLastInstructionY++] = 26.0;
                try {
                    this.fInstructionsY[this.fLastInstructionY++] = utils.str2num(string3.substring(1, string3.length()));
                }
                catch (FPNumberFormatException fPNumberFormatException) {
                    this.fBadEquation = true;
                    return;
                }
            }
            boolean bl = true;
            try {
                d = Double.valueOf(string3);
            }
            catch (NumberFormatException numberFormatException) {
                d = 0.0;
                bl = false;
            }
            if (!bl) continue;
            this.fInstructionsY[this.fLastInstructionY++] = 1.0;
            this.fInstructionsY[this.fLastInstructionY++] = d;
        } while (n < string2.length());
        this.fInstructionsY[this.fLastInstructionY++] = 0.0;
    }

    protected void stringToEquationX(String string) {
        int n = 0;
        int n2 = 0;
        String string2 = this.fConverterX.convert(new StringBuffer(string)).toString();
        if (string2 == null) {
            this.fBadEquation = true;
            return;
        }
        this.fLastInstructionX = 0;
        do {
            double d;
            String string3;
            if ((n2 = utils.getNextSpace(string2, n)) == -1) {
                return;
            }
            try {
                string3 = string2.substring(n, n2);
            }
            catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                break;
            }
            n = n2 + 1;
            if (string3.equals("t")) {
                this.fInstructionsX[this.fLastInstructionX++] = 2.0;
                continue;
            }
            if (string3.equals("+")) {
                this.fInstructionsX[this.fLastInstructionX++] = 3.0;
                continue;
            }
            if (string3.equals("-")) {
                this.fInstructionsX[this.fLastInstructionX++] = 4.0;
                continue;
            }
            if (string3.equals("*")) {
                this.fInstructionsX[this.fLastInstructionX++] = 5.0;
                continue;
            }
            if (string3.equals("/")) {
                this.fInstructionsX[this.fLastInstructionX++] = 6.0;
                continue;
            }
            if (string3.equals("^")) {
                this.fInstructionsX[this.fLastInstructionX++] = 7.0;
                continue;
            }
            if (string3.equals("sqrt")) {
                this.fInstructionsX[this.fLastInstructionX++] = 8.0;
                continue;
            }
            if (string3.equals(fp_resource.sin) || string3.equals("sin")) {
                this.fInstructionsX[this.fLastInstructionX++] = 9.0;
                continue;
            }
            if (string3.equals(fp_resource.cos) || string3.equals("cos")) {
                this.fInstructionsX[this.fLastInstructionX++] = 10.0;
                continue;
            }
            if (string3.equals(fp_resource.tan) || string3.equals("tan")) {
                this.fInstructionsX[this.fLastInstructionX++] = 11.0;
                continue;
            }
            if (string3.equals("asin")) {
                this.fInstructionsX[this.fLastInstructionX++] = 12.0;
                continue;
            }
            if (string3.equals("acos")) {
                this.fInstructionsX[this.fLastInstructionX++] = 13.0;
                continue;
            }
            if (string3.equals("atan")) {
                this.fInstructionsX[this.fLastInstructionX++] = 14.0;
                continue;
            }
            if (string3.equals("e")) {
                this.fInstructionsX[this.fLastInstructionX++] = 15.0;
                continue;
            }
            if (string3.equals("log")) {
                this.fInstructionsX[this.fLastInstructionX++] = 16.0;
                continue;
            }
            boolean bl = true;
            try {
                d = Double.valueOf(string3);
            }
            catch (NumberFormatException numberFormatException) {
                d = 0.0;
                bl = false;
            }
            if (!bl) continue;
            this.fInstructionsX[this.fLastInstructionX++] = 1.0;
            this.fInstructionsX[this.fLastInstructionX++] = d;
        } while (n < string2.length());
        this.fInstructionsX[this.fLastInstructionX++] = 0.0;
    }

    protected double eval(double[] dArray, int n, double d, double d2) throws BadComputationException {
        int n2 = -1;
        int n3 = 0;
        while (n3 <= n) {
            switch ((int)dArray[n3]) {
                case 0: {
                    return this.fStack[n2];
                }
                case 1: {
                    this.fStack[++n2] = dArray[++n3];
                    break;
                }
                case 2: {
                    this.fStack[++n2] = d;
                    break;
                }
                case 17: {
                    this.fStack[++n2] = d2;
                    break;
                }
                case 26: {
                    int n4 = (int)dArray[++n3];
                    this.fStack[n2] = Master.evaluate("G" + n4, this.fStack[n2]);
                    if (this.fStack[n2] != -1.23456123) break;
                    return -1.23456123;
                }
                case 19: {
                    int n4 = (int)dArray[++n3];
                    this.fStack[n2] = Master.evaluate("B" + n4, this.fStack[n2]);
                    if (this.fStack[n2] != -1.23456123) break;
                    return -1.23456123;
                }
                case 3: {
                    this.fStack[n2 - 1] = this.fStack[n2 - 1] + this.fStack[n2];
                    --n2;
                    break;
                }
                case 4: {
                    this.fStack[n2 - 1] = this.fStack[n2 - 1] - this.fStack[n2];
                    --n2;
                    break;
                }
                case 5: {
                    this.fStack[n2 - 1] = this.fStack[n2 - 1] * this.fStack[n2];
                    --n2;
                    break;
                }
                case 6: {
                    if (this.fStack[n2] == 0.0) {
                        return -0.1234567;
                    }
                    this.fStack[n2 - 1] = this.fStack[n2 - 1] / this.fStack[n2];
                    --n2;
                    break;
                }
                case 7: {
                    try {
                        this.fStack[n2 - 1] = Math.pow(this.fStack[n2 - 1], this.fStack[n2]);
                        --n2;
                        break;
                    }
                    catch (ArithmeticException arithmeticException) {
                        return -0.1234567;
                    }
                }
                case 8: {
                    this.fStack[n2] = Math.sqrt(this.fStack[n2]);
                    if (!Double.isNaN(this.fStack[n2])) break;
                    throw new BadComputationException();
                }
                case 9: {
                    this.fStack[n2] = Math.sin(this.fStack[n2]);
                    break;
                }
                case 10: {
                    this.fStack[n2] = Math.cos(this.fStack[n2]);
                    break;
                }
                case 11: {
                    this.fStack[n2] = Math.tan(this.fStack[n2]);
                    break;
                }
                case 12: {
                    if (Math.abs(this.fStack[n2]) > 1.0) {
                        return -0.1234567;
                    }
                    this.fStack[n2] = Math.asin(this.fStack[n2]);
                    break;
                }
                case 13: {
                    if (Math.abs(this.fStack[n2]) > 1.0) {
                        return -0.1234567;
                    }
                    this.fStack[n2] = Math.acos(this.fStack[n2]);
                    break;
                }
                case 14: {
                    this.fStack[n2] = Math.atan(this.fStack[n2]);
                    break;
                }
                case 15: {
                    this.fStack[++n2] = Math.E;
                    break;
                }
                case 16: {
                    if (this.fStack[n2] <= 0.0) {
                        return -0.1234567;
                    }
                    this.fStack[n2] = Math.log(this.fStack[n2]);
                    break;
                }
                default: {
                    this.fStack[++n2] = 0.0;
                    break;
                }
            }
            ++n3;
        }
        return this.fStack[n2];
    }

    protected double evalX(double d) throws BadComputationException {
        return this.eval(this.fInstructionsX, this.fLastInstructionX, d, 0.0);
    }

    protected double evalY(double d) throws BadComputationException {
        return this.eval(this.fInstructionsY, this.fLastInstructionY, d, 0.0);
    }

    double evalX_(double d) {
        double d2 = -0.1234567;
        try {
            d2 = this.eval(this.fInstructionsX, this.fLastInstructionX, d, 0.0);
        }
        catch (BadComputationException badComputationException) {
            badComputationException.printStackTrace();
        }
        return d2;
    }

    double evalY_(double d) {
        double d2 = -0.1234567;
        try {
            d2 = this.eval(this.fInstructionsY, this.fLastInstructionY, d, 0.0);
        }
        catch (BadComputationException badComputationException) {
            badComputationException.printStackTrace();
        }
        return d2;
    }

    public void fastStretchLR(int n, double d) {
        int n2 = this.getNumSteps();
        int n3 = 0;
        while (n3 < n2) {
            this.fX[n3] = n + (int)(d * (double)(this.fOldX[n3] - n));
            ++n3;
        }
    }

    public void fastStretchUD(int n, double d) {
        int n2 = this.getNumSteps();
        int n3 = 0;
        while (n3 < n2) {
            this.fY[n3] = n + (int)(d * (double)(this.fOldY[n3] - n));
            ++n3;
        }
    }

    public void stretchLR(double d, double d2, boolean bl) {
        if (bl) {
            this.fEquationStringX = Math.abs(d) < 1.0E-8 ? String.valueOf(FPRPNConverter.replace(this.fEquationStringX, "=", "=(")) + ")^" + utils.num2str(d2) : String.valueOf(FPRPNConverter.replace(this.fEquationStringX, "=", "=(")) + ")" + "^" + utils.num2str(d2) + "*10^" + utils.num2str(d * (1.0 - d2));
        } else if (Math.abs(d) < 1.0E-8) {
            this.fEquationStringX = FPRPNConverter.replace(this.fEquationStringX, "=", "=(");
            this.fEquationStringX = String.valueOf(this.fEquationStringX) + ")/" + utils.num2str(d2);
        } else {
            this.fEquationStringX = FPRPNConverter.replace(this.fEquationStringX, "=", "=(");
            this.fEquationStringX = String.valueOf(this.fEquationStringX) + "-" + utils.num2str(d) + ")/" + utils.num2str(d2) + "+" + utils.num2str(d);
        }
        this.stringToEquationX(this.fEquationStringX);
    }

    public void stretchUD(double d, double d2, boolean bl) {
        if (bl) {
            this.fEquationStringY = Math.abs(d) < 1.0E-8 ? String.valueOf(FPRPNConverter.replace(this.fEquationStringY, "=", "=(")) + ")^" + utils.num2str(d2) : String.valueOf(FPRPNConverter.replace(this.fEquationStringY, "=", "=(")) + ")" + "^" + utils.num2str(d2) + "*10^" + utils.num2str(d * (1.0 - d2));
        } else if (Math.abs(d) < 1.0E-8) {
            this.fEquationStringY = FPRPNConverter.replace(this.fEquationStringY, "=", "=(");
            this.fEquationStringY = String.valueOf(this.fEquationStringY) + ")*" + utils.num2str(d2);
        } else {
            this.fEquationStringY = FPRPNConverter.replace(this.fEquationStringY, "=", "=(");
            this.fEquationStringY = String.valueOf(this.fEquationStringY) + "-" + utils.num2str(d) + ")*" + utils.num2str(d2) + "+" + utils.num2str(d);
        }
        this.stringToEquationY(this.fEquationStringY);
    }

    public void mirrorx(double d, boolean bl) {
        if (bl) {
            this.fEquationStringX = String.valueOf(FPRPNConverter.replace(this.fEquationStringX, "=", "=1/(")) + ")";
            if (Math.abs(d) > 0.001) {
                this.fEquationStringX = String.valueOf(this.fEquationStringX) + "*10^" + utils.num2str(2.0 * d);
            }
        } else {
            this.fEquationStringX = String.valueOf(FPRPNConverter.replace(this.fEquationStringX, "=", "=-(")) + ")";
            if (Math.abs(d) > 0.001) {
                this.fEquationStringX = String.valueOf(this.fEquationStringX) + "+" + utils.num2str(2.0 * d);
            }
        }
        this.stringToEquationX(this.fEquationStringX);
    }

    public void mirrory(double d, boolean bl) {
        if (bl) {
            this.fEquationStringY = String.valueOf(FPRPNConverter.replace(this.fEquationStringY, "=", "=1/(")) + ")";
            if (Math.abs(d) > 0.001) {
                this.fEquationStringY = String.valueOf(this.fEquationStringY) + "*10^" + utils.num2str(2.0 * d);
            }
        } else {
            this.fEquationStringY = String.valueOf(FPRPNConverter.replace(this.fEquationStringY, "=", "=-(")) + ")";
            if (Math.abs(d) > 0.001) {
                this.fEquationStringY = String.valueOf(this.fEquationStringY) + "+" + utils.num2str(2.0 * d);
            }
        }
        this.stringToEquationY(this.fEquationStringY);
    }

    public void mirrorxy(boolean bl, boolean bl2) {
        String string = this.fEquationStringY;
        this.fEquationStringY = "y" + this.fEquationStringX.substring(1, this.fEquationStringX.length());
        this.fEquationStringX = "x" + this.fEquationStringY.substring(1, this.fEquationStringY.length());
        this.stringToEquationX(this.fEquationStringX);
        this.stringToEquationY(this.fEquationStringY);
        this.mirrorXY = true;
    }

    public void translate(double d, double d2, boolean bl, boolean bl2) {
        if (Math.abs(d) > 0.001) {
            this.fEquationStringX = bl ? String.valueOf(FPRPNConverter.replace(this.fEquationStringX, "=", "=(")) + ")*10^" + utils.num2str(d) : String.valueOf(this.fEquationStringX) + "+" + utils.num2str(d);
        }
        if (Math.abs(d2) > 0.001) {
            this.fEquationStringY = bl2 ? String.valueOf(FPRPNConverter.replace(this.fEquationStringY, "=", "=(")) + ")*10^" + utils.num2str(d2) : String.valueOf(this.fEquationStringY) + "+" + utils.num2str(d2);
        }
        this.stringToEquationX(this.fEquationStringX);
        this.stringToEquationY(this.fEquationStringY);
    }

    public void fastTranslate(int n, int n2) {
        int n3 = this.getNumSteps();
        int n4 = 0;
        while (n4 < n3) {
            if (this.fY[n4] != -1) {
                this.fX[n4] = this.fOldX[n4] + n;
                this.fY[n4] = this.fOldY[n4] + n2;
            }
            ++n4;
        }
    }

    public void copyToOld() {
        int n = 0;
        while (n < 300) {
            this.fOldX[n] = this.fX[n];
            this.fOldY[n] = this.fY[n];
            ++n;
        }
    }

    public FPObject copy() {
        FPParametricEquation fPParametricEquation = new FPParametricEquation(this.fEquationStringY, this.fEquationStringX, this.fColor);
        int n = 0;
        while (n < this.getNumSteps()) {
            fPParametricEquation.fX[n] = this.fX[n];
            fPParametricEquation.fY[n] = this.fY[n];
            ++n;
        }
        fPParametricEquation.fMode = this.fMode;
        fPParametricEquation.fMin = this.fMin;
        fPParametricEquation.fMax = this.fMax;
        fPParametricEquation.fStart = this.fStart;
        fPParametricEquation.fStop = this.fStop;
        fPParametricEquation.fIncr = this.fIncr;
        return fPParametricEquation;
    }

    protected int getNumSteps() {
        int n;
        if (this.fMode == 0) {
            n = 300;
        } else {
            n = (int)((this.fStop - this.fStart) / this.fIncr) + 1;
            if (n > 300) {
                n = 300;
            }
        }
        return n;
    }

    public void calculate(FPAxes fPAxes) {
        double d;
        double d2;
        double d3;
        if (this.deleted()) {
            return;
        }
        if (this.fMode == 0) {
            d3 = 300.0;
            d2 = this.fMin;
            d = (this.fMax - this.fMin) / (d3 - 1.0);
        } else {
            d3 = (int)((this.fStop - this.fStart) / this.fIncr) + 1;
            if (d3 > 300.0) {
                d3 = 300.0;
            }
            d2 = this.fStart;
            d = this.fIncr;
        }
        double d4 = d2;
        int n = 0;
        while ((double)n < d3) {
            int n2;
            int n3;
            double d5 = this.evalX_(d4);
            double d6 = this.evalY_(d4);
            if (d5 == -0.1234567) {
                n3 = -1001;
                n2 = -1001;
            } else {
                n3 = fPAxes.x2pxl(d5);
                n2 = d6 == -0.1234567 ? -1001 : fPAxes.y2pxl(d6);
            }
            this.fX[n] = n3;
            this.fY[n] = n2;
            d4 += d;
            ++n;
        }
    }

    protected Color darker(Color color) {
        double d = 0.98;
        return new Color(Math.max((int)((double)color.getRed() * d), 0), Math.max((int)((double)color.getGreen() * d), 0), Math.max((int)((double)color.getBlue() * d), 0));
    }

    public void draw(Graphics graphics) {
        boolean bl = this.select();
        graphics.setColor(this.fColor);
        if (this.fMode == 0) {
            int n = 300;
            int n2 = 1;
            while (n2 < n) {
                if (this.fY[n2] != -1001 && this.fY[n2 - 1] != -1001) {
                    graphics.drawLine(this.fX[n2 - 1], this.fY[n2 - 1], this.fX[n2], this.fY[n2]);
                    if (bl) {
                        graphics.drawLine(this.fX[n2 - 1] + 1, this.fY[n2 - 1], this.fX[n2] + 1, this.fY[n2]);
                        graphics.drawLine(this.fX[n2 - 1], this.fY[n2 - 1] + 1, this.fX[n2], this.fY[n2] + 1);
                    }
                }
                ++n2;
            }
        } else {
            if (bl) {
                graphics.setColor(FPObject.fSelectColor);
            }
            Color color = graphics.getColor();
            int n = (int)((this.fStop - this.fStart) / this.fIncr) + 1;
            if (n > 300) {
                n = 300;
            }
            int n3 = 0;
            while (n3 < n) {
                graphics.setColor(color);
                if (this.fY[n3] != -1001 && this.fX[n3] != -1001) {
                    graphics.fillOval(this.fX[n3] - 2, this.fY[n3] - 2, 5, 5);
                    graphics.setColor(Color.black);
                    graphics.drawOval(this.fX[n3] - 2, this.fY[n3] - 2, 5, 5);
                }
                color = this.darker(color);
                ++n3;
            }
        }
    }

    public boolean mouseDown(int n, int n2, FPAxes fPAxes) {
        if (this.deleted()) {
            return false;
        }
        if (this.fMode == 0) {
            int n3 = 300;
            int n4 = 0;
            while (n4 < n3 - 1) {
                if (utils.distance(this.fX[n4], this.fY[n4], this.fX[n4 + 1], this.fY[n4 + 1], n, n2) < 4) {
                    return true;
                }
                ++n4;
            }
        } else {
            int n5 = (int)((this.fStop - this.fStart) / this.fIncr) + 1;
            if (n5 > 300) {
                n5 = 300;
            }
            int n6 = 0;
            while (n6 < n5) {
                if (Math.abs(n - this.fX[n6]) < 4 && Math.abs(n2 - this.fY[n6]) < 4) {
                    return true;
                }
                ++n6;
            }
        }
        return false;
    }
}

