/*
 * Decompiled with CFR 0.152.
 */
package com.questmsm.FPGrapher;

import com.questmsm.FPGrapher.FPAxes;
import com.questmsm.FPGrapher.FPPointSet;
import com.questmsm.FPGrapher.FPPolarEquation;
import com.questmsm.Utilities.utils;
import java.awt.Color;
import java.io.Serializable;

public class FPPolarPointSet
extends FPPointSet
implements Serializable {
    public FPPolarPointSet(Color color, FPAxes fPAxes) {
        super(color, fPAxes);
    }

    public FPPolarPointSet(FPAxes fPAxes) {
        super(fPAxes);
    }

    public void addPoint(double d, double d2) {
        if (this.fNumPoints == 400) {
            return;
        }
        if (d == -1.23456123 || d2 == -1.23456123) {
            return;
        }
        double d3 = d2 * Math.cos(d);
        double d4 = d2 * Math.sin(d);
        this.fXint[this.fNumPoints] = this.fAxes.x2pxl(d3);
        this.fYint[this.fNumPoints] = this.fAxes.y2pxl(d4);
        this.fXval[this.fNumPoints] = d3;
        this.fYval[this.fNumPoints] = d4;
        this.fDeleted[this.fNumPoints] = false;
        ++this.fNumPoints;
        this.createEqString();
    }

    public void prependPoint(double d, double d2) {
        if (this.fNumPoints == 400) {
            return;
        }
        if (d2 == -1.23456123 || d == -1.23456123) {
            return;
        }
        int n = this.fNumPoints;
        while (n > 0) {
            this.fXint[n] = this.fXint[n - 1];
            this.fYint[n] = this.fYint[n - 1];
            this.fXval[n] = this.fXval[n - 1];
            this.fYval[n] = this.fYval[n - 1];
            this.fDeleted[n] = this.fDeleted[n - 1];
            --n;
        }
        double d3 = d2 * Math.cos(d);
        double d4 = d2 * Math.sin(d);
        this.fXint[0] = this.fAxes.x2pxl(d3);
        this.fYint[0] = this.fAxes.x2pxl(d4);
        this.fXval[0] = d3;
        this.fYval[0] = d4;
        this.fDeleted[0] = false;
        ++this.fNumPoints;
    }

    protected String prefix() {
        String string = "r";
        String string2 = "T";
        String string3 = "(" + string + "," + string2 + ") = {";
        if (this.fSelectedPoint > 0) {
            string3 = String.valueOf(string3) + "...";
        }
        return string3;
    }

    protected String middle() {
        double d = Math.sqrt(this.fXval[this.fSelectedPoint] * this.fXval[this.fSelectedPoint] + this.fYval[this.fSelectedPoint] * this.fYval[this.fSelectedPoint]);
        double d2 = FPPolarEquation.getTheta(this.fXval[this.fSelectedPoint], this.fYval[this.fSelectedPoint]);
        String string = "(" + utils.num2str(d) + "," + utils.num2str(d2) + ")";
        return string;
    }
}

