/*
 * Decompiled with CFR 0.152.
 */
package com.questmsm.FPGrapher;

import com.questmsm.FPGrapher.FPAxes;
import com.questmsm.FPGrapher.FPObject;
import com.questmsm.FPGrapher.FPPointSet;
import com.questmsm.Utilities.utils;
import java.awt.Color;
import java.awt.Graphics;
import java.io.Serializable;

public class FPSlopeSet
extends FPPointSet
implements Serializable {
    private double[] fXval2 = new double[400];
    private double[] fYval2 = new double[400];
    private transient int[] fXint2;
    private transient int[] fYint2;
    private transient int[] fOldX2;
    private transient int[] fOldY2;

    public FPSlopeSet(Color color, FPAxes fPAxes) {
        super(fPAxes);
        this.fEquationString = "";
        this.fColor = color;
        this.fNumPoints = 0;
        this.fKind = 8;
        this.allocateTransients(fPAxes);
    }

    public FPSlopeSet(FPPointSet fPPointSet, FPAxes fPAxes, boolean bl) {
        super(fPAxes);
        this.fEquationString = "";
        this.fColor = fPPointSet.getColor();
        this.fKind = 8;
        this.allocateTransients(fPAxes);
        int n = 0;
        while (n < fPPointSet.fNumPoints - 1) {
            this.fXint[n] = fPPointSet.fXint[0];
            this.fYint[n] = fPPointSet.fYint[0];
            this.fXval[n] = fPPointSet.fXval[0];
            this.fYval[n] = fPPointSet.fYval[0];
            this.fOldX[n] = fPPointSet.fOldX[0];
            this.fOldY[n] = fPPointSet.fOldY[0];
            this.fXint2[n] = fPPointSet.fXint[n + 1];
            this.fYint2[n] = fPPointSet.fYint[n + 1];
            this.fXval2[n] = fPPointSet.fXval[n + 1];
            this.fYval2[n] = fPPointSet.fYval[n + 1];
            this.fOldX2[n] = fPPointSet.fOldX[n + 1];
            this.fOldY2[n] = fPPointSet.fOldY[n + 1];
            ++n;
        }
        this.fNumPoints = fPPointSet.fNumPoints;
    }

    public FPSlopeSet(FPPointSet fPPointSet, FPAxes fPAxes) {
        super(fPAxes);
        this.fEquationString = "";
        this.fColor = fPPointSet.getColor();
        this.fKind = 8;
        this.allocateTransients(fPAxes);
        this.fNumPoints = 0;
        int n = 0;
        while (n < fPPointSet.fNumPoints - 1) {
            if (!fPPointSet.isDeleted(n)) {
                this.fXint[this.fNumPoints] = fPPointSet.fXint[n];
                this.fYint[this.fNumPoints] = fPPointSet.fYint[n];
                this.fXval[this.fNumPoints] = fPPointSet.fXval[n];
                this.fYval[this.fNumPoints] = fPPointSet.fYval[n];
                this.fOldX[this.fNumPoints] = fPPointSet.fOldX[n];
                this.fOldY[this.fNumPoints] = fPPointSet.fOldY[n];
                int n2 = n + 1;
                while (n2 < fPPointSet.fNumPoints) {
                    if (!fPPointSet.isDeleted(n2)) break;
                    ++n2;
                }
                if (n2 == fPPointSet.fNumPoints) break;
                this.fXint2[this.fNumPoints] = fPPointSet.fXint[n2];
                this.fYint2[this.fNumPoints] = fPPointSet.fYint[n2];
                this.fXval2[this.fNumPoints] = fPPointSet.fXval[n2];
                this.fYval2[this.fNumPoints] = fPPointSet.fYval[n2];
                this.fOldX2[this.fNumPoints] = fPPointSet.fOldX[n2];
                this.fOldY2[this.fNumPoints] = fPPointSet.fOldY[n2];
                ++this.fNumPoints;
            }
            ++n;
        }
        this.createEqString();
    }

    public void allocateTransients(FPAxes fPAxes) {
        this.fAxes = fPAxes;
        this.fXint2 = new int[400];
        this.fYint2 = new int[400];
        this.fOldX2 = new int[400];
        this.fOldY2 = new int[400];
        super.allocateTransients(fPAxes);
    }

    public double dx(int n) {
        return this.fXval2[n] - this.fXval[n];
    }

    public double dy(int n) {
        return this.fYval2[n] - this.fYval[n];
    }

    public double m(int n) {
        return this.dy(n) / this.dx(n);
    }

    public void addSlope(double d, double d2, double d3, double d4) {
        if (this.fNumPoints == 400) {
            return;
        }
        if (d == -1.23456123 || d2 == -1.23456123 || d3 == -1.23456123 || d4 == -1.23456123) {
            return;
        }
        this.fXint[this.fNumPoints] = this.fAxes.x2pxl(d);
        this.fYint[this.fNumPoints] = this.fAxes.y2pxl(d2);
        this.fXint2[this.fNumPoints] = this.fAxes.x2pxl(d3);
        this.fYint2[this.fNumPoints] = this.fAxes.y2pxl(d4);
        this.fXval[this.fNumPoints] = d;
        this.fYval[this.fNumPoints] = d2;
        this.fXval2[this.fNumPoints] = d3;
        this.fYval2[this.fNumPoints] = d4;
        this.fDeleted[this.fNumPoints] = false;
        ++this.fNumPoints;
        this.createEqString();
    }

    public void prependSlope(double d, double d2, double d3, double d4) {
        if (this.fNumPoints == 400) {
            return;
        }
        if (d == -1.23456123 || d2 == -1.23456123 || d3 == -1.23456123 || d4 == -1.23456123) {
            return;
        }
        int n = this.fNumPoints;
        while (n > 0) {
            this.fXint[n] = this.fXint[n - 1];
            this.fYint[n] = this.fYint[n - 1];
            this.fXint2[n] = this.fXint2[n - 1];
            this.fYint2[n] = this.fYint2[n - 1];
            this.fXval[n] = this.fXval[n - 1];
            this.fXval2[n] = this.fXval2[n - 1];
            this.fYval[n] = this.fYval[n - 1];
            this.fYval2[n] = this.fYval2[n - 1];
            this.fDeleted[n] = this.fDeleted[n - 1];
            --n;
        }
        this.fXint[0] = this.fAxes.x2pxl(d);
        this.fYint[0] = this.fAxes.y2pxl(d2);
        this.fXint2[0] = this.fAxes.x2pxl(d3);
        this.fYint2[0] = this.fAxes.y2pxl(d4);
        this.fXval[0] = d;
        this.fYval[0] = d2;
        this.fXval2[0] = d3;
        this.fYval2[0] = d4;
        this.fDeleted[0] = false;
        ++this.fNumPoints;
        this.createEqString();
    }

    public void calculate(FPAxes fPAxes) {
        if (this.deleted()) {
            return;
        }
        int n = 0;
        while (n < this.fNumPoints) {
            this.fXint2[n] = fPAxes.x2pxl(this.fXval2[n]);
            this.fYint2[n] = fPAxes.y2pxl(this.fYval2[n]);
            ++n;
        }
        super.calculate(fPAxes);
    }

    public void copyToOld() {
        int n = 0;
        while (n < this.fNumPoints) {
            this.fOldX2[n] = this.fXint2[n];
            this.fOldY2[n] = this.fYint2[n];
            ++n;
        }
        super.copyToOld();
    }

    public void fastTranslate(int n, int n2) {
        int n3 = 0;
        while (n3 < this.fNumPoints) {
            this.fXint2[n3] = this.fOldX2[n3] + n;
            this.fYint2[n3] = this.fOldY2[n3] + n2;
            ++n3;
        }
        super.fastTranslate(n, n2);
    }

    public void translate(double d, double d2, boolean bl, boolean bl2) {
        int n = 0;
        while (n < this.fNumPoints) {
            if (bl) {
                int n2 = n;
                this.fXval2[n2] = this.fXval2[n2] * Math.pow(10.0, d);
            } else {
                int n3 = n;
                this.fXval2[n3] = this.fXval2[n3] + d;
            }
            if (bl2) {
                int n4 = n;
                this.fYval2[n4] = this.fYval2[n4] * Math.pow(10.0, d2);
            } else {
                int n5 = n;
                this.fYval2[n5] = this.fYval2[n5] + d2;
            }
            ++n;
        }
        super.translate(d, d2, bl, bl2);
    }

    public FPObject copy() {
        FPSlopeSet fPSlopeSet = new FPSlopeSet(this.fColor, this.fAxes);
        fPSlopeSet.fEquationString = this.fEquationString;
        fPSlopeSet.fKind = this.fKind;
        int n = 0;
        while (n < this.fNumPoints) {
            fPSlopeSet.fXint[n] = this.fXint[n];
            fPSlopeSet.fYint[n] = this.fYint[n];
            fPSlopeSet.fXval[n] = this.fXval[n];
            fPSlopeSet.fYval[n] = this.fYval[n];
            fPSlopeSet.fOldX[n] = this.fOldX[n];
            fPSlopeSet.fOldY[n] = this.fOldY[n];
            fPSlopeSet.fXint2[n] = this.fXint2[n];
            fPSlopeSet.fYint2[n] = this.fYint2[n];
            fPSlopeSet.fXval2[n] = this.fXval2[n];
            fPSlopeSet.fYval2[n] = this.fYval2[n];
            fPSlopeSet.fOldX2[n] = this.fOldX2[n];
            fPSlopeSet.fOldY2[n] = this.fOldY2[n];
            ++n;
        }
        fPSlopeSet.fNumPoints = this.fNumPoints;
        return fPSlopeSet;
    }

    public FPPointSet slopesToPoints() {
        FPPointSet fPPointSet = new FPPointSet(this.fAxes);
        fPPointSet.fColor = this.fColor;
        fPPointSet.fKind = 6;
        int n = 0;
        while (n < this.fNumPoints) {
            fPPointSet.fXint[n] = this.fXint[n];
            fPPointSet.fYint[n] = this.fYint[n];
            fPPointSet.fXval[n] = this.fXval[n];
            fPPointSet.fYval[n] = this.fYval[n];
            fPPointSet.fOldX[n] = this.fOldX[n];
            fPPointSet.fOldY[n] = this.fOldY[n];
            ++n;
        }
        int n2 = this.fNumPoints - 1;
        fPPointSet.fXint[this.fNumPoints] = this.fXint2[n2];
        fPPointSet.fYint[this.fNumPoints] = this.fYint2[n2];
        fPPointSet.fXval[this.fNumPoints] = this.fXval2[n2];
        fPPointSet.fYval[this.fNumPoints] = this.fYval2[n2];
        fPPointSet.fOldX[this.fNumPoints] = this.fOldX2[n2];
        fPPointSet.fOldY[this.fNumPoints] = this.fOldY2[n2];
        fPPointSet.fNumPoints = this.fNumPoints + 1;
        fPPointSet.createEqString();
        return fPPointSet;
    }

    public void drawSlope(Graphics graphics, int n, int n2, int n3, int n4, boolean bl) {
        graphics.setColor(this.fColor);
        if (n4 < n2) {
            graphics.drawLine(n, n2, n3, n2);
            graphics.drawLine(n, n2, n3, n4);
            graphics.drawLine(n3, n2, n3, n4);
            if (this.select()) {
                graphics.drawLine(n + 1, n2, n3 + 1, n2);
                graphics.drawLine(n, n2 + 1, n3, n2 + 1);
                graphics.drawLine(n + 1, n2, n3 + 1, n4);
                graphics.drawLine(n, n2 + 1, n3, n4 + 1);
                graphics.drawLine(n3 + 1, n2, n3 + 1, n4);
                graphics.drawLine(n3, n2 + 1, n3, n4 + 1);
                if (bl) {
                    graphics.drawLine(n, n2 - 1, n3, n2 - 1);
                    graphics.drawLine(n3 - 1, n2, n3 - 1, n4);
                }
            }
        } else {
            graphics.drawLine(n, n2, n, n4);
            graphics.drawLine(n, n4, n3, n4);
            graphics.drawLine(n, n2, n3, n4);
            if (this.select()) {
                graphics.drawLine(n + 1, n2, n + 1, n4);
                graphics.drawLine(n, n2 + 1, n, n4 + 1);
                graphics.drawLine(n + 1, n4, n3 + 1, n4);
                graphics.drawLine(n, n4 + 1, n3, n4 + 1);
                graphics.drawLine(n, n2 + 1, n3, n4 + 1);
                graphics.drawLine(n + 1, n2, n3 + 1, n4);
                if (bl) {
                    graphics.drawLine(n - 1, n2, n - 1, n4);
                    graphics.drawLine(n, n4 - 1, n3, n4 - 1);
                }
            }
        }
        int n5 = 0;
        if (this.select()) {
            n5 = 1;
        }
        graphics.fillOval(n - n5, n2 - n5, 2 * n5 + 1, 2 * n5 + 1);
        graphics.fillOval(n3 - n5, n4 - n5, 2 * n5 + 1, 2 * n5 + 1);
        graphics.setColor(Color.black);
        graphics.drawOval(n - n5, n2 - n5, 2 * n5 + 1, 2 * n5 + 1);
        graphics.drawOval(n3 - n5, n4 - n5, 2 * n5 + 1, 2 * n5 + 1);
    }

    public synchronized void draw(Graphics graphics) {
        int n = 0;
        while (n < this.fNumPoints) {
            if (!this.fDeleted[n]) {
                this.drawSlope(graphics, this.fXint[n], this.fYint[n], this.fXint2[n], this.fYint2[n], n == this.fSelectedPoint);
            }
            ++n;
        }
    }

    protected String prefix() {
        String string = String.valueOf(this.fAxes.variables().depVar(this.fVarIndex));
        String string2 = String.valueOf(this.fAxes.variables().indepVar(this.fVarIndex));
        String string3 = "(" + string + "2-" + string + "1)/(" + string2 + "2-" + string2 + "1) = {";
        if (this.fSelectedPoint > 0) {
            string3 = String.valueOf(string3) + "...";
        }
        return string3;
    }

    protected String middle() {
        String string = String.valueOf(this.fAxes.variables().depVar(this.fVarIndex));
        String string2 = String.valueOf(this.fAxes.variables().indepVar(this.fVarIndex));
        String string3 = "(" + utils.num2str(this.fYval2[this.fSelectedPoint]) + "-" + utils.num2str(this.fYval[this.fSelectedPoint]) + ")/(" + utils.num2str(this.fXval2[this.fSelectedPoint]) + "-" + utils.num2str(this.fXval[this.fSelectedPoint]) + ")";
        return string3;
    }

    protected void createEqString() {
        this.fEquationString = "";
        if (this.fNumPoints == 0) {
            return;
        }
        if (this.fSelectedPoint == -1) {
            this.fSelectedPoint = 0;
        }
        String string = String.valueOf(this.fAxes.variables().depVar(this.fVarIndex));
        String string2 = String.valueOf(this.fAxes.variables().indepVar(this.fVarIndex));
        String string3 = "(" + string + "2-" + string + "1)/(" + string2 + "2-" + string2 + "1) =";
        String string4 = "(" + utils.num2str(this.fYval2[this.fSelectedPoint]) + "-" + utils.num2str(this.fYval[this.fSelectedPoint]) + ")/(" + utils.num2str(this.fXval2[this.fSelectedPoint]) + "-" + utils.num2str(this.fXval[this.fSelectedPoint]) + ")";
        String string5 = "";
        if (this.fXval2[this.fSelectedPoint] == this.fXval[this.fSelectedPoint]) {
            string5 = "Infinity";
        } else {
            double d = (this.fYval2[this.fSelectedPoint] - this.fYval[this.fSelectedPoint]) / (this.fXval2[this.fSelectedPoint] - this.fXval[this.fSelectedPoint]);
            string5 = utils.num2str(d);
        }
        string5 = "     m = " + string5;
        this.fEquationString = this.fNumPoints == 1 ? String.valueOf(string3) + " {" + string4 + "}" + string5 : (this.fSelectedPoint == 0 ? String.valueOf(string3) + " {" + string4 + "..." + "}" + string5 : (this.fSelectedPoint == this.fNumPoints - 1 ? String.valueOf(string3) + " {" + "..." + string4 + "}" + string5 : String.valueOf(string3) + " {" + "..." + string4 + "..." + "}" + string5));
    }

    public void fastStretchLR(int n, double d) {
        int n2 = 0;
        while (n2 < this.fNumPoints) {
            this.fXint2[n2] = n + (int)((double)(this.fOldX2[n2] - n) * d);
            this.fYint2[n2] = this.fOldY2[n2];
            ++n2;
        }
        super.fastStretchLR(n, d);
    }

    public void fastStretchUD(int n, double d) {
        int n2 = 0;
        while (n2 < this.fNumPoints) {
            this.fYint2[n2] = n + (int)((double)(this.fOldY2[n2] - n) * d);
            ++n2;
        }
        super.fastStretchUD(n, d);
    }

    public void stretchLR(double d, double d2, boolean bl) {
        if (bl) {
            int n = 0;
            while (n < this.fNumPoints) {
                this.fXval2[n] = Math.pow(this.fXval2[n], 1.0 / d2) * Math.pow(10.0, d * (1.0 - 1.0 / d2));
                ++n;
            }
        } else {
            int n = 0;
            while (n < this.fNumPoints) {
                this.fXval2[n] = d + (this.fXval2[n] - d) / d2;
                ++n;
            }
        }
        super.stretchLR(d, d2, bl);
    }

    public void stretchUD(double d, double d2, boolean bl) {
        if (bl) {
            int n = 0;
            while (n < this.fNumPoints) {
                this.fYval2[n] = Math.pow(this.fYval2[n], d2) * Math.pow(10.0, d * (1.0 - d2));
                ++n;
            }
        } else {
            int n = 0;
            while (n < this.fNumPoints) {
                this.fYval2[n] = d + (this.fYval2[n] - d) * d2;
                ++n;
            }
        }
        super.stretchUD(d, d2, bl);
    }

    public void mirrorx(double d, boolean bl) {
        if (bl) {
            int n = 0;
            while (n < this.fNumPoints) {
                this.fXval2[n] = 1.0 / this.fXval2[n] * Math.pow(10.0, d * 2.0);
                ++n;
            }
        } else {
            int n = 0;
            while (n < this.fNumPoints) {
                this.fXval2[n] = 2.0 * d - this.fXval2[n];
                ++n;
            }
        }
        super.mirrorx(d, bl);
    }

    public void mirrory(double d, boolean bl) {
        if (bl) {
            int n = 0;
            while (n < this.fNumPoints) {
                this.fYval2[n] = 1.0 / this.fYval2[n] * Math.pow(10.0, d * 2.0);
                ++n;
            }
        } else {
            int n = 0;
            while (n < this.fNumPoints) {
                this.fYval2[n] = 2.0 * d - this.fYval2[n];
                ++n;
            }
        }
        super.mirrory(d, bl);
    }

    public void mirrorxy(boolean bl, boolean bl2) {
        int n = 0;
        while (n < this.fNumPoints) {
            double d = this.fXval2[n];
            this.fXval2[n] = this.fYval2[n];
            this.fYval2[n] = d;
            ++n;
        }
        super.mirrorxy(bl, bl2);
    }

    public boolean mouseDown(int n, int n2, FPAxes fPAxes) {
        if (this.deleted()) {
            return false;
        }
        int n3 = 0;
        while (n3 < this.fNumPoints) {
            if (Math.abs(n - this.fXint[n3]) < 4 && Math.abs(n2 - this.fYint[n3]) < 4) {
                this.selectedPoint(n3);
                return true;
            }
            if (Math.abs(n - this.fXint2[n3]) < 4 && Math.abs(n2 - this.fYint2[n3]) < 4) {
                this.selectedPoint(n3);
                return true;
            }
            ++n3;
        }
        int n4 = 0;
        while (n4 < this.fNumPoints) {
            if (utils.distance(this.fXint[n4], this.fYint[n4], this.fXint2[n4], this.fYint2[n4], n, n2) < 6) {
                this.selectedPoint(n4);
                return true;
            }
            if (this.fYint2[n4] > this.fYint[n4]) {
                if (utils.distance(this.fXint[n4], this.fYint[n4], this.fXint[n4], this.fYint2[n4], n, n2) < 6) {
                    this.selectedPoint(n4);
                    return true;
                }
                if (utils.distance(this.fXint[n4], this.fYint2[n4], this.fXint2[n4], this.fYint2[n4], n, n2) < 6) {
                    this.selectedPoint(n4);
                    return true;
                }
            } else {
                if (utils.distance(this.fXint2[n4], this.fYint[n4], this.fXint2[n4], this.fYint2[n4], n, n2) < 6) {
                    this.selectedPoint(n4);
                    return true;
                }
                if (utils.distance(this.fXint[n4], this.fYint[n4], this.fXint2[n4], this.fYint[n4], n, n2) < 6) {
                    this.selectedPoint(n4);
                    return true;
                }
            }
            ++n4;
        }
        this.selectedPoint(-1);
        return false;
    }
}

