/*
 * Decompiled with CFR 0.152.
 */
package com.questmsm.FPGrapher;

import com.questmsm.FPGrapher.FPAxes;
import com.questmsm.FPGrapher.Grapher;
import com.questmsm.FPGrapher.HistoryArea;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Event;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.TextField;

public class FPTextScroll
extends Canvas {
    private TextField fText;
    private int fWidth;
    private int fHeight;
    private Image fImage;
    private Image fImageUp;
    private Image fImageDown;
    private Image fCurrentImage = null;
    private HistoryArea fArea;
    private FPAxes fAxes;

    public FPTextScroll(HistoryArea historyArea, FPAxes fPAxes) {
        this.fArea = historyArea;
        this.fWidth = 0;
        this.fHeight = 0;
        this.setBackground(Color.white);
        this.fAxes = fPAxes;
    }

    public void loadImages() {
        this.fAxes.parent();
        if (Grapher.fGrapherIcons == null) {
            this.fAxes.parent().loadGrapherIcons();
        }
        this.fAxes.parent();
        Image image = Grapher.fGrapherIcons;
        this.fImage = this.createImage(15, 44);
        this.fImageUp = this.createImage(15, 44);
        this.fImageDown = this.createImage(15, 44);
        this.fImage.getGraphics().drawImage(image, 0, 0, 15, 44, 287, 1, 302, 45, this);
        this.fImageDown.getGraphics().drawImage(image, 0, 0, 15, 44, 303, 1, 318, 45, this);
        this.fImageUp.getGraphics().drawImage(image, 0, 0, 15, 44, 319, 1, 334, 45, this);
        this.fCurrentImage = this.fImage;
    }

    public void setBounds(int n, int n2, int n3, int n4) {
        super.setBounds(n, n2, n3, n4);
        this.fWidth = n3;
        this.fHeight = n4;
    }

    public void paint(Graphics graphics) {
        if (this.fWidth == 0) {
            return;
        }
        if (this.fCurrentImage == null) {
            this.loadImages();
        }
        graphics.drawImage(this.fCurrentImage, 0, 0, this);
        graphics.setColor(Color.black);
        graphics.drawRect(0, 0, this.getSize().width, this.getSize().height - 1);
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public void scrollUp() {
        int n = this.fArea.currentItemNum();
        if (--n < 0) {
            this.fAxes.parent().getToolkit().beep();
            return;
        }
        if (this.fArea.fItemList[n].object() != null) {
            this.fAxes.selectObject(this.fArea.fItemList[n].object());
        } else {
            this.fAxes.clearSelect();
            this.fArea.setSelect(n);
            this.fAxes.repaint();
        }
    }

    public void scrollDown() {
        int n = this.fArea.currentItemNum();
        if (++n >= this.fArea.fNumItems) {
            this.fAxes.parent().getToolkit().beep();
            return;
        }
        if (this.fArea.fItemList[n].object() != null) {
            this.fAxes.selectObject(this.fArea.fItemList[n].object());
        } else {
            this.fAxes.clearSelect();
            this.fArea.setSelect(n);
            this.fAxes.repaint();
        }
    }

    public boolean mouseUp(Event event, int n, int n2) {
        if (this.fArea.fNumItems == 0) {
            this.fCurrentImage = this.fImage;
            this.repaint();
            return true;
        }
        if (this.fCurrentImage == this.fImageUp) {
            this.fCurrentImage = this.fImage;
            this.repaint();
            this.scrollUp();
            return true;
        }
        if (this.fCurrentImage == this.fImageDown) {
            this.fCurrentImage = this.fImage;
            this.repaint();
            this.scrollDown();
            return true;
        }
        return true;
    }

    public boolean mouseDrag(Event event, int n, int n2) {
        if (n2 < 14) {
            if (this.fCurrentImage == this.fImageUp) {
                return true;
            }
            this.fCurrentImage = this.fImageUp;
        } else if (n2 > this.fHeight - 14) {
            if (this.fCurrentImage == this.fImageDown) {
                return true;
            }
            this.fCurrentImage = this.fImageDown;
        } else {
            if (this.fCurrentImage == this.fImage) {
                return true;
            }
            this.fCurrentImage = this.fImage;
        }
        this.repaint();
        return true;
    }

    public boolean mouseDown(Event event, int n, int n2) {
        return this.mouseDrag(event, n, n2);
    }

    public boolean keyDown(Event event, int n) {
        switch (n) {
            case 8: {
                this.fAxes.deleteSelection();
                return true;
            }
        }
        return true;
    }
}

