/*
 * Decompiled with CFR 0.152.
 */
package com.questmsm.FPGrapher;

import com.questmsm.FPGrapher.FPAxes;
import com.questmsm.FPGrapher.FPObject;
import com.questmsm.FPGrapher.GraphVariables;
import com.questmsm.FPGrapher.HistoryItem;
import java.awt.Component;
import java.awt.Dimension;
import java.io.Serializable;

public class GraphFileData
implements Serializable {
    private int NumHistoryItems;
    private HistoryItem[] theItems;
    private int windowTop;
    private int windowLeft;
    private int windowHeight;
    private int windowWidth;
    private double majXTick;
    private double majYTick;
    private double logXBase;
    private double logYBase;
    private boolean logTickSpacing;
    private boolean piXTickSpacing;
    private boolean piYTickSpacing;
    private double minX;
    private double minY;
    private double maxX;
    private double maxY;
    private boolean logX;
    private boolean logY;
    private boolean logMode;
    private boolean quickRescaleEnabled;
    private boolean showGridLines;
    private boolean showAnchors;
    private boolean autoColor;
    private boolean autoDefine;
    private int showTransformMode;
    private boolean polarMode;
    private boolean allowPolars;
    private boolean allowLogs;
    private boolean showBars;
    private boolean showParametric;
    private boolean leastSquaresMode;
    private GraphVariables variables;
    private int currentVar;
    private int historycount;
    private int historyeq;
    private int historyother;

    public GraphFileData(FPAxes fPAxes) {
        Dimension dimension = fPAxes.parent().getSize();
        this.windowHeight = dimension.height;
        this.windowWidth = dimension.width;
        this.windowTop = fPAxes.parent().getLocation().y;
        this.windowLeft = fPAxes.parent().getLocation().x;
        this.majXTick = fPAxes.xMajTick();
        this.majYTick = fPAxes.yMajTick();
        this.logXBase = fPAxes.logXBase();
        this.logYBase = fPAxes.logYBase();
        this.logTickSpacing = fPAxes.logTickSpacing();
        this.piXTickSpacing = fPAxes.piXTickSpacing();
        this.piYTickSpacing = fPAxes.piYTickSpacing();
        this.minX = fPAxes.minX();
        this.maxX = fPAxes.maxX();
        this.minY = fPAxes.minY();
        this.maxY = fPAxes.maxY();
        this.logX = fPAxes.logX();
        this.logY = fPAxes.logY();
        this.logMode = fPAxes.logMode();
        this.quickRescaleEnabled = fPAxes.quickRescale();
        this.showGridLines = fPAxes.showGridLines();
        this.showAnchors = fPAxes.fShowAnchors;
        this.autoColor = fPAxes.autoColor();
        this.autoDefine = fPAxes.autoDefine();
        this.showTransformMode = fPAxes.showTransform();
        this.polarMode = fPAxes.polarMode();
        this.allowPolars = fPAxes.allowPolars();
        this.allowLogs = fPAxes.allowLogs();
        this.showBars = fPAxes.parent().toolbar().showBars();
        this.showParametric = fPAxes.parent().toolbar().showParametric();
        this.leastSquaresMode = fPAxes.leastSquaresMode();
        this.variables = fPAxes.variables();
        this.currentVar = fPAxes.currentVar();
        fPAxes.setUpAxes();
        fPAxes.drawBackground();
        this.historycount = fPAxes.history().fCount;
        this.NumHistoryItems = fPAxes.history().numItems();
        this.theItems = new HistoryItem[this.NumHistoryItems];
        int n = 0;
        while (n < this.NumHistoryItems) {
            this.theItems[n] = fPAxes.history().item(n);
            ++n;
        }
    }

    public void getGraphData(FPAxes fPAxes) {
        fPAxes.clearAll();
        ((Component)fPAxes.history().frame()).setVisible(false);
        fPAxes.parent().setVisible(false);
        ((Component)fPAxes.parent()).setBounds(this.windowLeft, this.windowTop, this.windowWidth, this.windowHeight);
        int n = fPAxes.getSize().width;
        int n2 = fPAxes.getSize().height;
        fPAxes.minX(this.minX);
        fPAxes.maxX(this.maxX);
        fPAxes.minY(this.minY);
        fPAxes.maxY(this.maxY);
        fPAxes.xMajTick(this.majXTick);
        fPAxes.yMajTick(this.majYTick);
        fPAxes.logXBase(this.logXBase);
        fPAxes.logYBase(this.logYBase);
        fPAxes.logTickSpacing(this.logTickSpacing);
        fPAxes.piXTickSpacing(this.piXTickSpacing);
        fPAxes.piYTickSpacing(this.piYTickSpacing);
        fPAxes.logX(this.logX);
        fPAxes.logY(this.logY);
        fPAxes.logMode(this.logMode);
        fPAxes.quickRescale(this.quickRescaleEnabled);
        fPAxes.showGridLines(this.showGridLines);
        fPAxes.fShowAnchors = this.showAnchors;
        fPAxes.autoColor(this.autoColor);
        fPAxes.autoDefine(this.autoDefine);
        fPAxes.showTransform(this.showTransformMode);
        fPAxes.polarMode(this.polarMode);
        fPAxes.allowPolars(this.allowPolars);
        fPAxes.allowLogs(this.allowLogs);
        fPAxes.parent().toolbar().showBars(this.showBars);
        fPAxes.parent().toolbar().showParametric(this.showParametric);
        fPAxes.parent().toolbar().setUpPositions();
        fPAxes.leastSquaresMode(this.leastSquaresMode);
        fPAxes.variables(this.variables);
        fPAxes.currentVar(this.currentVar);
        FPObject fPObject = null;
        int n3 = 0;
        while (n3 < this.NumHistoryItems) {
            if (this.theItems[n3].object() != null) {
                this.theItems[n3].object().allocateTransients(fPAxes);
                fPAxes.addToListNoHistory(this.theItems[n3].object());
                fPObject = this.theItems[n3].object();
            }
            fPAxes.history().setItem(n3, this.theItems[n3]);
            ++n3;
        }
        fPAxes.history().fCount = this.historycount;
        fPAxes.history().setNumItems(this.NumHistoryItems);
        fPAxes.drawBackground();
        if (fPObject != null) {
            fPAxes.selectObject(fPObject);
        }
    }
}

