/*
 * Decompiled with CFR 0.152.
 */
package com.questmsm.FPGrapher;

import com.questmsm.FPGrapher.GraphHistoryFrame;
import com.questmsm.FPGrapher.Grapher;
import com.questmsm.FPGrapher.HistoryArea;
import com.questmsm.Utilities.MyInt;
import com.questmsm.Utilities.fp_resource;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.PrintJob;
import java.awt.Toolkit;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Properties;

public class GraphHistoryCanvas
extends Canvas {
    private GraphHistoryFrame fFrame;
    private HistoryArea fHistory;
    private static Font fMainFont;
    private static FontMetrics fMainMetric;
    private Grapher fGrapher;
    public static final int kPageWidth = 550;
    private int fPageHeight = 100;
    public static final int kPageHeightSteps = 30;
    private Image fBackgroundImage = null;
    private Graphics fBackgroundGraphics = null;
    private boolean fInitialized;
    private int dx;
    private int dy;
    static final int XINDENT = 40;
    static final int YINDENT = 40;

    public GraphHistoryCanvas(GraphHistoryFrame graphHistoryFrame, Grapher grapher, HistoryArea historyArea) {
        this.fGrapher = grapher;
        this.fFrame = graphHistoryFrame;
        fMainFont = new Font("Helvetica", 0, 14);
        fMainMetric = this.getFontMetrics(fMainFont);
        this.fHistory = historyArea;
        this.setBackground(Color.white);
        this.dx = 0;
        this.dy = 0;
        this.addComponentListener(new 1());
        this.addMouseListener(new 2());
    }

    public void createImages(int n) {
        this.fBackgroundImage = null;
        this.fBackgroundGraphics = null;
        this.fBackgroundImage = this.createImage(550, n);
        this.fBackgroundGraphics = this.fBackgroundImage == null ? null : this.fBackgroundImage.getGraphics();
        this.fPageHeight = n;
    }

    public int pageHeight() {
        return this.fPageHeight;
    }

    public int pageWidth() {
        return 550;
    }

    public void myResize(int n, int n2) {
        if (!this.fInitialized) {
            this.fInitialized = true;
            this.drawBackground();
        }
        if (n + this.dx > 550) {
            n = 550 - this.dx;
        }
        if (n2 + this.dy > this.fPageHeight) {
            n2 = this.fPageHeight - this.dy;
        }
        this.fFrame.setScrollSettings();
    }

    private synchronized void drawBackground(Graphics graphics) {
        if (graphics == null) {
            return;
        }
        graphics.setColor(Color.white);
        graphics.fillRect(0, 0, 550, 32000);
        this.fHistory.printItems(graphics, new MyInt(0), 32000);
        graphics.setColor(Color.black);
        graphics.drawRect(0, 0, 549, this.fPageHeight - 1);
    }

    public synchronized void drawBackground() {
        int n = this.fHistory.getPrintedItemHeight(0) + 15;
        if (n < 170) {
            n = 170;
        }
        if (n > this.fPageHeight) {
            this.createImages(n);
        }
        this.drawBackground(this.fBackgroundGraphics);
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public void doPrint() {
        Properties properties = new Properties();
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        PrintJob printJob = toolkit.getPrintJob(this.fFrame, fp_resource.getString("str_graph_history"), properties);
        if (printJob == null) {
            return;
        }
        Dimension dimension = printJob.getPageDimension();
        dimension.width -= 80;
        dimension.height -= 80;
        int n = 1;
        int n2 = (int)Math.floor((double)this.fPageHeight / (double)dimension.height) + 1;
        int n3 = 0;
        while (n3 < n2) {
            int n4 = n3 * dimension.height + 40;
            int n5 = 0;
            while (n5 < n) {
                int n6 = n5 * dimension.width + 40;
                Graphics graphics = printJob.getGraphics();
                graphics.translate(n6, n4);
                graphics.setClip(0, 0, dimension.width + n6, dimension.height + n4);
                this.drawBackground(graphics);
                graphics.translate(-n6, -n4);
                graphics.dispose();
                ++n5;
            }
            ++n3;
        }
        printJob.end();
    }

    public synchronized void paint(Graphics graphics) {
        if (this.fBackgroundImage == null) {
            this.createImages(this.fPageHeight);
        }
        this.drawBackground();
        graphics.setColor(Color.lightGray);
        graphics.fillRect(0, 0, this.getSize().width, this.getSize().height);
        graphics.translate(-this.dx, -this.dy);
        graphics.drawImage(this.fBackgroundImage, 0, 0, this);
        graphics.translate(this.dx, this.dy);
        this.fFrame.updateMenus();
    }

    private void adjustHScrollbar() {
    }

    public synchronized void redraw() {
        this.drawBackground();
        this.repaint();
    }

    public void translate(int n, int n2) {
        this.dx = n;
        this.dy = n2;
        this.redraw();
    }

    private final class 1
    extends ComponentAdapter {
        public void componentResized(ComponentEvent componentEvent) {
            GraphHistoryCanvas.this.myResize(GraphHistoryCanvas.this.getBounds().width, GraphHistoryCanvas.this.getBounds().height);
        }

        /* synthetic */ 1() {
        }
    }

    private final class 2
    extends MouseAdapter {
        public void mousePressed(MouseEvent mouseEvent) {
            int n = mouseEvent.getX() + GraphHistoryCanvas.this.dx;
            int n2 = mouseEvent.getY() + GraphHistoryCanvas.this.dy;
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            int n = mouseEvent.getX() + GraphHistoryCanvas.this.dx;
            int n2 = mouseEvent.getY() + GraphHistoryCanvas.this.dy;
        }

        /* synthetic */ 2() {
        }
    }
}

