/*
 * Decompiled with CFR 0.152.
 */
package com.questmsm.FPGrapher;

import com.questmsm.FPGrapher.GraphHistoryCanvas;
import com.questmsm.FPGrapher.Grapher;
import com.questmsm.FPGrapher.HistoryArea;
import com.questmsm.FunctionProbe.Master;
import com.questmsm.FunctionProbe.WindowMenuHandler;
import com.questmsm.Utilities.FPMenuItem;
import com.questmsm.Utilities.fp_resource;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.MenuShortcut;
import java.awt.Scrollbar;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;

public class GraphHistoryFrame
extends Frame
implements ActionListener {
    private Grapher fGrapher;
    private Scrollbar fVert;
    private Scrollbar fHoriz;
    private GraphHistoryCanvas fCanvas;
    private int fWidth;
    private int fHeight;
    private boolean fInitialized = false;
    private MenuBar fMenuBar;
    private WindowMenuHandler fWindowMenuHandler;

    public GraphHistoryFrame(Grapher grapher, HistoryArea historyArea) {
        this.setTitle(fp_resource.getString("str_graph_history"));
        this.fGrapher = grapher;
        this.fCanvas = new GraphHistoryCanvas(this, grapher, historyArea);
        this.setLayout(null);
        this.fVert = new Scrollbar(1);
        this.add(this.fVert);
        this.fHoriz = new Scrollbar(0);
        this.add(this.fHoriz);
        this.add(this.fCanvas);
        this.addComponentListener(new 1());
        this.addWindowListener(new 2());
        3 var3_3 = new 3();
        this.fVert.addAdjustmentListener(var3_3);
        this.fHoriz.addAdjustmentListener(var3_3);
        this.createMenus();
    }

    public synchronized void paint(Graphics graphics) {
        if (!this.fInitialized) {
            this.myResize();
        }
    }

    public GraphHistoryCanvas canvas() {
        return this.fCanvas;
    }

    public void setHScrollVal(int n) {
        this.fHoriz.setValue(n);
    }

    public void setVScrollVal(int n) {
        this.fVert.setValue(n);
    }

    public void setScrollSettings() {
        int n = this.fCanvas.getSize().height;
        int n2 = this.fCanvas.getSize().width;
        int n3 = this.fCanvas.pageHeight();
        int n4 = this.fCanvas.pageWidth();
        this.fVert.setMinimum(0);
        this.fVert.setMaximum(n3);
        this.fVert.setVisibleAmount(n);
        this.fHoriz.setMinimum(0);
        this.fHoriz.setMaximum(n4);
        this.fHoriz.setVisibleAmount(n2);
        this.fVert.setBlockIncrement(n / 10);
        this.fHoriz.setBlockIncrement(n2 / 10);
        this.fVert.setUnitIncrement(n / 10);
        this.fHoriz.setUnitIncrement(n2 / 10);
    }

    public void myResize(int n, int n2, int n3, int n4) {
        int n5 = Master.gTop;
        int n6 = n4;
        int n7 = n3;
        if (n4 - 15 - 4 - 4 - n5 > this.fCanvas.pageHeight()) {
            n6 = this.fCanvas.pageHeight() + 15 + 4 + 4 + n5;
        }
        if (n3 - 15 > this.fCanvas.pageWidth()) {
            n7 = this.fCanvas.pageWidth() + 15;
        }
        if (n7 != n3 || n6 != n4) {
            ((Component)this).setBounds(n, n2, n7, n6);
        }
        this.fCanvas.setBounds(4, 4 + n5, n3 - 15 - 4 - 4, n4 - 15 - 4 - 4 - n5);
        this.fVert.setBounds(n3 - 15, n5, 15, n4 - 15 - n5);
        this.fHoriz.setBounds(0, n4 - 15, n3 - 15, 15);
        this.fInitialized = true;
        this.setScrollSettings();
    }

    public void myResize() {
        this.myResize(this.getBounds().x, this.getBounds().y, this.getBounds().width, this.getBounds().height);
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals(fp_resource.getString("str_close"))) {
            ((Component)this).setVisible(false);
            return;
        }
        if (string.equals(String.valueOf(fp_resource.getString("str_print_graph_history")) + "...")) {
            this.fCanvas.doPrint();
            return;
        }
    }

    public MenuItem makeMenuItem(String string) {
        FPMenuItem fPMenuItem = new FPMenuItem(string);
        fPMenuItem.setActionCommand(string);
        fPMenuItem.addActionListener(this);
        return fPMenuItem;
    }

    public MenuItem makeMenuItem(String string, int n) {
        MenuItem menuItem = this.makeMenuItem(string);
        menuItem.setShortcut(new MenuShortcut(n));
        return menuItem;
    }

    public void createMenus() {
        this.fMenuBar = new MenuBar();
        this.fMenuBar.setFont(FPMenuItem.FNT);
        Menu menu = new Menu(fp_resource.getString("str_file"));
        menu.setFont(FPMenuItem.FNT);
        menu.add(this.makeMenuItem(fp_resource.getString("str_close")));
        menu.add(this.makeMenuItem(String.valueOf(fp_resource.getString("str_print_graph_history")) + "...", 80));
        this.fMenuBar.add(menu);
        this.fWindowMenuHandler = new WindowMenuHandler(this);
        this.fMenuBar.add(this.fWindowMenuHandler.menu());
        this.setMenuBar(this.fMenuBar);
    }

    public void updateMenus() {
        this.fWindowMenuHandler.updateMenu();
    }

    private final class 1
    extends ComponentAdapter {
        public void componentResized(ComponentEvent componentEvent) {
            GraphHistoryFrame.this.myResize(GraphHistoryFrame.this.getBounds().x, GraphHistoryFrame.this.getBounds().y, GraphHistoryFrame.this.getBounds().width, GraphHistoryFrame.this.getBounds().height);
        }

        /* synthetic */ 1() {
        }
    }

    private final class 2
    extends WindowAdapter {
        public void windowClosing(WindowEvent windowEvent) {
            ((Component)GraphHistoryFrame.this).setVisible(false);
            GraphHistoryFrame.this.fGrapher.handleMenus();
        }

        /* synthetic */ 2() {
        }
    }

    private final class 3
    implements AdjustmentListener {
        public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
            GraphHistoryFrame.this.fCanvas.translate(GraphHistoryFrame.this.fHoriz.getValue(), GraphHistoryFrame.this.fVert.getValue());
        }

        /* synthetic */ 3() {
        }
    }
}

