/*
 * Decompiled with CFR 0.152.
 */
package com.questmsm.FPGrapher;

import com.questmsm.FPGrapher.FPAxes;
import com.questmsm.FPGrapher.Grapher;
import com.questmsm.FunctionProbe.Master;
import com.questmsm.Utilities.DialogSuperClass;
import com.questmsm.Utilities.Drawers;
import com.questmsm.Utilities.fp_resource;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;

public class StretchFrame
extends DialogSuperClass {
    private FPAxes fAxes;
    private Grapher fGrapher;
    private int fMode;
    private static final int kLineLength = 40;
    private static final int kHLineX = 25;
    private static final int kHLineY = 45;
    private static final int kVLineX = 113;
    private static final int kVLineY = 25;
    private static final Rectangle kHRect = new Rectangle(17, 17, 56, 56);
    private static final Rectangle kVRect = new Rectangle(85, 17, 56, 56);

    public StretchFrame(FPAxes fPAxes, Grapher grapher) {
        super(grapher);
        this.setTitle(fp_resource.getString("str_stretch"));
        this.fAxes = fPAxes;
        this.fGrapher = grapher;
        int n = Master.gSmallTop;
        this.setBounds(0, 0, 160, 150 + n);
        this.setLayout(null);
        this.add(this.fOK);
        this.fOK.setBounds(15, 110 + n, 60, 18);
        this.add(this.fCancel);
        this.fCancel.setBounds(85, 110 + n, 60, 18);
        this.fMode = 7;
        this.addMouseListener(new 1());
    }

    public void doYes() {
        this.fAxes.mode(this.fMode);
        ((Component)this).setVisible(false);
    }

    public void doCancel() {
        this.fGrapher.setToolbarMode(1);
        this.fAxes.mode(0);
        ((Component)this).setVisible(false);
    }

    private void drawHLineRect(Graphics graphics) {
        int n = Master.gSmallTop;
        graphics.drawRect(StretchFrame.kHRect.x, StretchFrame.kHRect.y + n, StretchFrame.kHRect.width, StretchFrame.kHRect.height);
        graphics.drawRect(StretchFrame.kHRect.x + 1, StretchFrame.kHRect.y + 1 + n, StretchFrame.kHRect.width - 2, StretchFrame.kHRect.height - 2);
    }

    private void drawVLineRect(Graphics graphics) {
        int n = Master.gSmallTop;
        graphics.drawRect(StretchFrame.kVRect.x, StretchFrame.kVRect.y + n, StretchFrame.kVRect.width, StretchFrame.kVRect.height);
        graphics.drawRect(StretchFrame.kVRect.x + 1, StretchFrame.kVRect.y + 1 + n, StretchFrame.kVRect.width - 2, StretchFrame.kVRect.height - 2);
    }

    void handleMouseClicked(MouseEvent mouseEvent) {
        int n;
        int n2 = mouseEvent.getX();
        if (kHRect.contains(n2, n = mouseEvent.getY())) {
            this.fMode = 7;
        } else if (kVRect.contains(n2, n)) {
            this.fMode = 6;
        }
        this.repaint();
    }

    public void paint(Graphics graphics) {
        graphics.setColor(Color.black);
        int n = Master.gSmallTop;
        Drawers.drawHorizStretchy(graphics, 25, 65, 28 + n);
        Drawers.drawVertStretchy(graphics, 25 + n, 65 + n, 96);
        if (this.fMode == 7) {
            this.drawHLineRect(graphics);
        } else {
            this.drawVLineRect(graphics);
        }
    }

    private final class 1
    extends MouseAdapter {
        public void mouseClicked(MouseEvent mouseEvent) {
            StretchFrame.this.handleMouseClicked(mouseEvent);
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            StretchFrame.this.handleMouseClicked(mouseEvent);
        }

        /* synthetic */ 1() {
        }
    }
}

