/*
 * Decompiled with CFR 0.152.
 */
package com.questmsm.FPTable;

import com.questmsm.FPTable.ColorDialog;
import com.questmsm.FPTable.TablePanel;
import com.questmsm.FunctionProbe.Master;
import com.questmsm.Utilities.DialogSuperClass;
import com.questmsm.Utilities.fp_resource;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Panel;
import java.awt.Rectangle;

public class ColorDialog
extends DialogSuperClass {
    private TablePanel fTablePanel;
    private final int kNumColors = 8;
    private final int kSquareSide = this.ch_advance;
    private Rectangle[] fRects = new Rectangle[8];
    private Color[] fColors = new Color[8];
    private int fSelected = -1;
    private int fCurrentColor = 0;

    public ColorDialog(Frame frame, TablePanel tablePanel) {
        super(frame);
        this.fTablePanel = tablePanel;
        this.setTitle(fp_resource.getString("str_select_column_color"));
        Color color = this.fTablePanel.foregroundColor();
        int n = Master.gSmallTop;
        this.setBounds(400, 140, 60 + 4 * this.kSquareSide, 2 * this.kSquareSide + 30 + this.ch_ht * 6 + n);
        this.setLayout(new BorderLayout(10, 10));
        this.setValues();
        Panel panel = new Panel(new FlowLayout(1, this.ch_advance >> 2, this.ch_ht));
        panel.add(this.fOK);
        panel.add(this.fCancel);
        this.add((Component)new ColorPanel(), "Center");
        this.add((Component)panel, "South");
        this.fSelected = -1;
        int n2 = 0;
        while (n2 < 8) {
            if (color.equals(this.fColors[n2])) {
                this.fSelected = n2;
                break;
            }
            ++n2;
        }
    }

    private void setValues() {
        int n = 30;
        int n2 = 5;
        int n3 = 0;
        while (n3 < 2) {
            int n4 = 0;
            while (n4 < 4) {
                this.fRects[n3 * 4 + n4] = new Rectangle(n + n4 * this.kSquareSide, n2 + n3 * this.kSquareSide, this.kSquareSide, this.kSquareSide);
                ++n4;
            }
            ++n3;
        }
        this.fColors[0] = Color.blue;
        this.fColors[1] = Color.red;
        this.fColors[2] = Color.green.darker();
        this.fColors[3] = Color.magenta.darker();
        this.fColors[4] = Color.cyan.darker();
        this.fColors[5] = Color.darkGray;
        this.fColors[6] = Color.orange.darker();
        this.fColors[7] = Color.black;
    }

    public void doYes() {
        this.fTablePanel.foregroundColor(this.fColors[this.fSelected]);
        this.fTablePanel.redraw(false);
        ((Component)this).setVisible(false);
    }

    class ColorPanel
    extends Panel {
        public ColorPanel() {
            Dimension dimension = new Dimension(10 + 4 * ColorDialog.this.kSquareSide, 10 + 2 * ColorDialog.this.kSquareSide);
            this.setSize(dimension);
            this.addMouseListener(new 1(this));
            this.addMouseMotionListener(new 2(this));
        }

        void handleColorSelection(int n, int n2) {
            int n3 = 0;
            while (n3 < 8) {
                if (ColorDialog.this.fRects[n3].contains(n, n2)) {
                    if (ColorDialog.this.fSelected == n3) {
                        return;
                    }
                    ColorDialog.this.fSelected = n3;
                    this.repaint();
                }
                ++n3;
            }
        }

        public void update(Graphics graphics) {
            this.paint(graphics);
        }

        public void paint(Graphics graphics) {
            int n = 0;
            while (n < 8) {
                graphics.setColor(ColorDialog.this.fColors[n]);
                graphics.fillRect(((ColorDialog)ColorDialog.this).fRects[n].x, ((ColorDialog)ColorDialog.this).fRects[n].y, ((ColorDialog)ColorDialog.this).fRects[n].width, ((ColorDialog)ColorDialog.this).fRects[n].height);
                graphics.setColor(Color.black);
                graphics.drawRect(((ColorDialog)ColorDialog.this).fRects[n].x, ((ColorDialog)ColorDialog.this).fRects[n].y, ((ColorDialog)ColorDialog.this).fRects[n].width, ((ColorDialog)ColorDialog.this).fRects[n].height);
                graphics.setColor(Color.white);
                if (ColorDialog.this.fSelected == n) {
                    graphics.drawRect(((ColorDialog)ColorDialog.this).fRects[n].x + 1, ((ColorDialog)ColorDialog.this).fRects[n].y + 1, ((ColorDialog)ColorDialog.this).fRects[n].width - 2, ((ColorDialog)ColorDialog.this).fRects[n].height - 2);
                }
                ++n;
            }
            super.paint(graphics);
        }
    }
}

