/*
 * Decompiled with CFR 0.152.
 */
package com.questmsm.FPTable;

import com.questmsm.FPTable.AccumFromDialog;
import com.questmsm.FPTable.ColSetupDialog;
import com.questmsm.FPTable.ColorDialog;
import com.questmsm.FPTable.Column;
import com.questmsm.FPTable.FillDialog;
import com.questmsm.FPTable.InsertBetweenDialog;
import com.questmsm.FPTable.IntervalsDialog;
import com.questmsm.FPTable.SortTypeDialog;
import com.questmsm.FPTable.StatsDialog;
import com.questmsm.FPTable.Table;
import com.questmsm.FPTable.TableFileData;
import com.questmsm.FPTable.TableHolder;
import com.questmsm.FPTable.TablePanel;
import com.questmsm.FPTable.TableRow;
import com.questmsm.FPTable.TableSetupDialog;
import com.questmsm.FPTable.UndoTable;
import com.questmsm.FPTable.VariableTypeDialog;
import com.questmsm.FunctionProbe.Master;
import com.questmsm.FunctionProbe.WindowMenuHandler;
import com.questmsm.Utilities.FPMenuItem;
import com.questmsm.Utilities.YesNoDialog;
import com.questmsm.Utilities.fp_resource;
import com.questmsm.Utilities.utils;
import java.awt.CheckboxMenuItem;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.FileDialog;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.MenuShortcut;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

public class Table
extends Frame
implements FilenameFilter {
    private MenuBar fMenuBar;
    private final Color kBackground = Color.white;
    private int fWidth;
    private int fHeight;
    private MenuItem fFill;
    private MenuItem fFillBetween;
    private MenuItem fImport;
    private MenuItem fExport;
    private MenuItem fNew;
    private MenuItem fUndo;
    private MenuItem fInsertBetween;
    private MenuItem fDifference;
    private MenuItem fRatio;
    private MenuItem fArithmetic;
    private MenuItem fGeometric;
    private MenuItem fAccumulate;
    private MenuItem fSort;
    private MenuItem fNudgeUp;
    private MenuItem fNudgeDown;
    private MenuItem fInactivate;
    private MenuItem fSelect;
    private MenuItem fLink;
    private MenuItem fUnlink;
    private MenuItem fTableSetup;
    private MenuItem fColumnSetup;
    private MenuItem fIndex;
    private MenuItem fShowStats;
    private MenuItem fEliminateBlanks;
    private MenuItem fInsertCol;
    private MenuItem fDeleteCol;
    private MenuItem fMake;
    private MenuItem fInsertCell;
    private MenuItem fDeleteCell;
    private MenuItem fColumnColor;
    private MenuItem fSelectVariables;
    private MenuItem fSelectAllIntervals;
    private MenuItem fDeleteIntervals;
    private MenuItem fSelectIntervals;
    private MenuItem fSendPointsToGraph;
    private MenuItem fSendValueToCalc;
    private MenuItem fBarsToGraph;
    private MenuItem fSaveMenu;
    private MenuItem fRevertMenu;
    private MenuItem fCut;
    private MenuItem fCopy;
    private MenuItem fPaste;
    private MenuItem fClear;
    private MenuItem fSaveAsMenu;
    private MenuItem fOpen;
    private MenuItem fPrint;
    private Menu fTableMenu;
    private CheckboxMenuItem fShowDependencies;
    private TableHolder fTableHolder;
    private TablePanel fTablePanel;
    private UndoTable fUndoer;
    private static final String fFileExtension = ".tbl";
    private WindowMenuHandler fWindowMenuHandler;
    private String fFileName = null;
    private String fFilePath = null;
    private boolean statechanged;

    public Table() {
        this.addNotify();
        this.createMenus();
        this.resetVals();
        this.updateMenus();
        this.addComponentListener(new 1());
        this.addWindowListener(new 2());
        this.fTableHolder.setVScrollVal(0);
        this.fTableHolder.setHScrollVal(0);
        this.fTableHolder.setBounds();
    }

    public void cantUndo() {
        this.fUndoer.undoable(false);
        this.updateMenus();
    }

    public void copyToUndo(String string) {
        this.fUndoer.copyToUndo(string);
        this.updateMenus();
    }

    public void setVisible(boolean bl) {
        super.setVisible(bl);
        WindowMenuHandler.synchHandlers();
    }

    public void resetVals() {
        this.setVisible(false);
        this.removeAll();
        this.setTitle(fp_resource.getString("str_table"));
        ((Component)this).setBackground(this.kBackground);
        this.setLayout(null);
        this.fFileName = null;
        this.fFilePath = null;
        this.fTableHolder = new TableHolder(this, this.kBackground);
        this.add(this.fTableHolder);
        this.fTablePanel = this.fTableHolder.panel();
        this.fUndoer = new UndoTable(this.fTablePanel);
        this.cantUndo();
        int n = Master.gTop;
        int n2 = 0;
        if (Master.isWindows()) {
            n2 = 3;
        }
        this.fWidth = 271;
        this.fHeight = 165;
        FontMetrics fontMetrics = this.getGraphics().getFontMetrics(this.fMenuBar.getFont());
        this.fWidth = fontMetrics.stringWidth(fp_resource.getString("str_file")) + 20 + fontMetrics.stringWidth(fp_resource.getString("str_edit")) + 20 + fontMetrics.stringWidth(fp_resource.getString("str_send")) + 20 + fontMetrics.stringWidth(fp_resource.getString("str_windows")) + 20 + fontMetrics.stringWidth(fp_resource.getString("str_calculator"));
        this.fWidth = Math.max(271, this.fWidth);
        Dimension dimension = this.getToolkit().getScreenSize();
        Dimension dimension2 = Master.graphA().getSize();
        int n3 = dimension.width / 2 - dimension2.width - 15;
        int n4 = dimension.height / 2 - dimension2.height * 2 / 3 + (Master.isWindows() ? 0 : 45);
        this.setBounds(n3, n4 + dimension2.height + 10, this.fWidth + 2 * n2, this.fHeight + n + n2);
    }

    private void doNew() {
        1.SureDialog sureDialog = new 1.SureDialog(this, this, fp_resource.getString("str_are_you_sure"), fp_resource.getString("str_are_you_sure__any_changes_will_be_lost"), fp_resource.getString("str_yes"), fp_resource.getString("str_cancel"), null);
        ((Component)sureDialog).setVisible(true);
    }

    private void createMenus() {
        this.fMenuBar = new MenuBar();
        this.fMenuBar.setFont(FPMenuItem.FNT);
        Menu menu = new Menu(fp_resource.getString("str_file"));
        menu.setFont(FPMenuItem.FNT);
        this.fNew = new FPMenuItem(fp_resource.getString("str_new"));
        menu.add(this.fNew);
        this.fNew.setShortcut(new MenuShortcut(78));
        this.fOpen = new FPMenuItem(String.valueOf(fp_resource.getString("str_open")) + "...");
        menu.add(this.fOpen);
        this.fOpen.setShortcut(new MenuShortcut(79));
        this.fImport = new FPMenuItem(String.valueOf(fp_resource.getString("str_open_text_file")) + "...");
        menu.add(this.fImport);
        menu.addSeparator();
        MenuItem menuItem = new FPMenuItem(fp_resource.getString("str_close"));
        menu.add(menuItem);
        this.fSaveMenu = new FPMenuItem(fp_resource.getString("str_save_window"));
        menu.add(this.fSaveMenu);
        this.fSaveMenu.setShortcut(new MenuShortcut(83));
        this.fSaveAsMenu = new FPMenuItem(String.valueOf(fp_resource.getString("str_save_window_as")) + "...");
        menu.add(this.fSaveAsMenu);
        this.fExport = new FPMenuItem(fp_resource.getString("str_save_text_file"));
        menu.add(this.fExport);
        this.fRevertMenu = new FPMenuItem(fp_resource.getString("str_revert"));
        menu.add(this.fRevertMenu);
        menu.addSeparator();
        menuItem = menu.add(new FPMenuItem(fp_resource.getString("str_new_workspace")));
        menuItem = menu.add(new FPMenuItem(fp_resource.getString("str_load_workspace")));
        menuItem = menu.add(new FPMenuItem(fp_resource.getString("str_save_workspace")));
        menu.addSeparator();
        this.fPrint = new FPMenuItem(String.valueOf(fp_resource.getString("str_print_table")) + "...");
        menuItem = menu.add(this.fPrint);
        menu.addSeparator();
        menuItem = new FPMenuItem(fp_resource.getString("str_quit_function_probe"));
        menu.add(menuItem);
        menuItem.setShortcut(new MenuShortcut(81));
        this.fMenuBar.add(menu);
        menu = new Menu(fp_resource.getString("str_edit"));
        menu.setFont(FPMenuItem.FNT);
        this.fUndo = menu.add(new FPMenuItem(fp_resource.getString("str_cant_undo")));
        this.fUndo.setShortcut(new MenuShortcut(90));
        menu.addSeparator();
        this.fCut = menu.add(new FPMenuItem(fp_resource.getString("str_cut")));
        this.fCut.setShortcut(new MenuShortcut(88));
        this.fCopy = menu.add(new FPMenuItem(fp_resource.getString("str_copy")));
        this.fCopy.setShortcut(new MenuShortcut(67));
        this.fPaste = menu.add(new FPMenuItem(fp_resource.getString("str_paste")));
        this.fPaste.setShortcut(new MenuShortcut(86));
        this.fClear = menu.add(new FPMenuItem(fp_resource.getString("str_clear")));
        menu.addSeparator();
        this.fInsertCell = menu.add(new FPMenuItem(fp_resource.getString("str_insert_cell")));
        this.fInsertCell.setShortcut(new MenuShortcut(73));
        this.fDeleteCell = menu.add(new FPMenuItem(fp_resource.getString("str_delete_cells")));
        menu.addSeparator();
        this.fInsertCol = menu.add(new FPMenuItem(fp_resource.getString("str_insert_column")));
        this.fDeleteCol = menu.add(new FPMenuItem(fp_resource.getString("str_delete_column")));
        this.fDeleteCol.setShortcut(new MenuShortcut(68));
        menu.addSeparator();
        this.fColumnColor = menu.add(new FPMenuItem(fp_resource.getString("str_select_column_color")));
        this.fMenuBar.add(menu);
        menu = new Menu(fp_resource.getString("str_send"));
        menu.setFont(FPMenuItem.FNT);
        this.fSendPointsToGraph = menu.add(new FPMenuItem(fp_resource.getString("str_points_to_graph")));
        this.fBarsToGraph = menu.add(new FPMenuItem(fp_resource.getString("str_bars_to_graph")));
        menu.addSeparator();
        this.fSendValueToCalc = menu.add(new FPMenuItem(fp_resource.getString("str_value_to_calculator")));
        this.fMenuBar.add(menu);
        this.fWindowMenuHandler = new WindowMenuHandler(this);
        this.fMenuBar.add(this.fWindowMenuHandler.menu());
        this.fTableMenu = new Menu(fp_resource.getString("str_table"));
        this.fTableMenu.setFont(FPMenuItem.FNT);
        this.fFill = this.fTableMenu.add(new FPMenuItem(String.valueOf(fp_resource.getString("str_fill")) + "..."));
        this.fFill.setShortcut(new MenuShortcut(70));
        this.fSort = this.fTableMenu.add(new FPMenuItem(String.valueOf(fp_resource.getString("str_sort_column")) + "..."));
        this.fTableMenu.addSeparator();
        this.fDifference = this.fTableMenu.add(new FPMenuItem(fp_resource.getString("str_difference")));
        this.fRatio = this.fTableMenu.add(new FPMenuItem(fp_resource.getString("str_ratio")));
        this.fArithmetic = this.fTableMenu.add(new FPMenuItem(fp_resource.getString("str_arithmetic_mean")));
        this.fGeometric = this.fTableMenu.add(new FPMenuItem(fp_resource.getString("str_geometric_mean")));
        this.fAccumulate = this.fTableMenu.add(new FPMenuItem(String.valueOf(fp_resource.getString("str_accumulate")) + "..."));
        this.fIndex = this.fTableMenu.add(new FPMenuItem(fp_resource.getString("str_index_column")));
        this.fTableMenu.addSeparator();
        this.fFillBetween = this.fTableMenu.add(new FPMenuItem(String.valueOf(fp_resource.getString("str_fill_between")) + "..."));
        this.fInsertBetween = this.fTableMenu.add(new FPMenuItem(fp_resource.getString("str_insert_between")));
        this.fTableMenu.addSeparator();
        this.fShowStats = this.fTableMenu.add(new FPMenuItem(String.valueOf(fp_resource.getString("str_show_statistics")) + "..."));
        this.fNudgeUp = this.fTableMenu.add(new FPMenuItem(fp_resource.getString("str_nudge_up")));
        this.fNudgeDown = this.fTableMenu.add(new FPMenuItem(fp_resource.getString("str_nudge_down")));
        this.fInactivate = this.fTableMenu.add(new FPMenuItem(fp_resource.getString("str_inactivate_column")));
        this.fEliminateBlanks = this.fTableMenu.add(new FPMenuItem(fp_resource.getString("str_eliminate_blanks")));
        this.fShowDependencies = new CheckboxMenuItem(fp_resource.getString("str_show_dependencies"));
        this.fTableMenu.add(this.fShowDependencies);
        this.fShowDependencies.setFont(FPMenuItem.FNT);
        this.fTableMenu.addSeparator();
        this.fSelect = this.fTableMenu.add(new FPMenuItem(fp_resource.getString("str_select_columns")));
        this.fLink = this.fTableMenu.add(new FPMenuItem(fp_resource.getString("str_link_columns")));
        this.fLink.setShortcut(new MenuShortcut(76));
        this.fUnlink = this.fTableMenu.add(new FPMenuItem(fp_resource.getString("str_unlink_columns")));
        Menu menu2 = new Menu(fp_resource.getString("str_intervals"));
        menu2.setFont(FPMenuItem.FNT);
        this.fMake = menu2.add(new FPMenuItem(fp_resource.getString("str_make")));
        this.fDeleteIntervals = menu2.add(new FPMenuItem(fp_resource.getString("str_remove_all")));
        this.fSelectIntervals = menu2.add(new FPMenuItem(fp_resource.getString("str_select")));
        this.fSelectAllIntervals = menu2.add(new FPMenuItem(fp_resource.getString("str_select_all")));
        this.fTableMenu.add(menu2);
        this.fTableMenu.addSeparator();
        this.fColumnSetup = this.fTableMenu.add(new FPMenuItem(String.valueOf(fp_resource.getString("str_column_setup")) + "..."));
        this.fSelectVariables = this.fTableMenu.add(new FPMenuItem(String.valueOf(fp_resource.getString("str_select_variables")) + "..."));
        this.fTableSetup = this.fTableMenu.add(new FPMenuItem(String.valueOf(fp_resource.getString("str_table_setup")) + "..."));
        this.fMenuBar.add(this.fTableMenu);
        this.setMenuBar(this.fMenuBar);
    }

    public synchronized void setBounds(int n, int n2, int n3, int n4) {
        if (this.fTablePanel == null) {
            return;
        }
        int n5 = this.fTablePanel.maxWidth() + 15;
        int n6 = this.fTablePanel.maxHeight() + 15;
        int n7 = Master.gTop;
        int n8 = 0;
        if (Master.isWindows()) {
            n8 = 3;
        }
        super.setBounds(n, n2, n3, n4);
        this.fWidth = this.getSize().width;
        this.fHeight = this.getSize().height;
        this.fTableHolder.setBounds(n8, n7, this.fWidth - 2 * n8, this.fHeight - n7 - n8);
    }

    public void setBounds() {
        this.setBounds(this.getLocation().x, this.getLocation().y, this.getSize().width, this.getSize().height);
    }

    public boolean action(Event event, Object object) {
        if (event.target instanceof MenuItem) {
            if (event.target == this.fNew) {
                this.doNew();
                this.updateMenus();
                return false;
            }
            if (event.target == this.fUndo) {
                this.fUndoer.undo();
                this.cantUndo();
                this.updateMenus();
                return false;
            }
            if (event.target == this.fPrint) {
                this.fTablePanel.doPrint();
                this.cantUndo();
                return false;
            }
            if (event.target == this.fImport) {
                this.fTablePanel.doImport();
                this.updateMenus();
                return false;
            }
            if (event.target == this.fExport) {
                this.fTablePanel.doExport();
                this.cantUndo();
                this.updateMenus();
                return false;
            }
            if (event.target == this.fOpen) {
                this.doLoad();
                this.cantUndo();
                this.updateMenus();
                return false;
            }
            if (event.target == this.fDeleteIntervals) {
                this.copyToUndo(fp_resource.getString("str_undo_delete_intervals"));
                this.fTablePanel.deleteIntervals();
                this.fTablePanel.redraw(false);
                this.updateMenus();
                return false;
            }
            if (object.equals(fp_resource.getString("str_close"))) {
                this.cantUndo();
                this.setVisible(false);
                return true;
            }
            if (object.equals(fp_resource.getString("str_new_workspace"))) {
                this.cantUndo();
                Master.newWorkspace();
                return true;
            }
            if (object.equals(fp_resource.getString("str_load_workspace"))) {
                this.cantUndo();
                Master.loadWorkspace();
                return true;
            }
            if (object.equals(fp_resource.getString("str_save_workspace"))) {
                this.cantUndo();
                Master.saveWorkspace();
                return true;
            }
            if (object.equals(fp_resource.getString("str_save_window"))) {
                this.cantUndo();
                if (this.fFileName == null) {
                    return true;
                }
                this.save(String.valueOf(this.fFilePath) + this.fFileName + fFileExtension);
                return true;
            }
            if (object.equals(fp_resource.getString("str_revert"))) {
                this.copyToUndo(fp_resource.getString("str_undo_revert"));
                if (this.fFileName == null) {
                    return true;
                }
                this.load(String.valueOf(this.fFilePath) + this.fFileName + fFileExtension);
                return true;
            }
            if (object.equals(String.valueOf(fp_resource.getString("str_save_window_as")) + "...")) {
                this.cantUndo();
                this.doSave();
                this.updateMenus();
                return false;
            }
            if (event.target == this.fCut) {
                if (!this.fTablePanel.inDataRows()) {
                    utils.showErrorDialog(this, fp_resource.getString("str_error__must_be_in_data_cells_to_cut"));
                    return true;
                }
                this.copyToUndo(fp_resource.getString("str_undo_cut"));
                this.fTablePanel.doCut();
                this.updateMenus();
                return true;
            }
            if (event.target == this.fCopy) {
                if (!this.fTablePanel.inDataRows()) {
                    utils.showErrorDialog(this, fp_resource.getString("str_error__must_be_in_data_cells_to_copy"));
                    return true;
                }
                this.fTablePanel.doCopy();
                this.updateMenus();
                return true;
            }
            if (event.target == this.fPaste) {
                if (!this.fTablePanel.inDataRows()) {
                    utils.showErrorDialog(this, fp_resource.getString("str_error__must_be_in_data_cells_to_paste"));
                    return true;
                }
                this.copyToUndo(fp_resource.getString("str_undo_paste"));
                this.fTablePanel.doPaste();
                this.updateMenus();
                return true;
            }
            if (event.target == this.fClear) {
                if (!this.fTablePanel.inDataRows()) {
                    utils.showErrorDialog(this, fp_resource.getString("str_error__must_be_in_data_cells_to_clear"));
                    return true;
                }
                this.copyToUndo(fp_resource.getString("str_undo_clear"));
                this.fTablePanel.doClear();
                this.updateMenus();
                return true;
            }
            if (event.target == this.fSendValueToCalc) {
                this.fTablePanel.sendValueToCalc();
                this.cantUndo();
                this.updateMenus();
                return true;
            }
            if (event.target == this.fSendPointsToGraph) {
                this.fTablePanel.sendPointsToGraph();
                this.cantUndo();
                this.updateMenus();
                return true;
            }
            if (event.target == this.fShowStats) {
                StatsDialog statsDialog = new StatsDialog(this.fTablePanel);
                ((Component)statsDialog).setVisible(true);
                this.cantUndo();
                this.updateMenus();
                return false;
            }
            if (event.target == this.fSort) {
                SortTypeDialog sortTypeDialog = new SortTypeDialog(this.fTablePanel);
                ((Component)sortTypeDialog).setVisible(true);
                this.updateMenus();
                return false;
            }
            if (event.target == this.fDifference) {
                this.fTablePanel.doCommandOnColumn("difference");
                this.updateMenus();
                return false;
            }
            if (event.target == this.fAccumulate) {
                AccumFromDialog accumFromDialog = new AccumFromDialog(this.fTablePanel);
                ((Component)accumFromDialog).setVisible(true);
                this.updateMenus();
                return false;
            }
            if (event.target == this.fRatio) {
                this.fTablePanel.doCommandOnColumn("ratio");
                this.updateMenus();
                return false;
            }
            if (event.target == this.fArithmetic) {
                this.fTablePanel.doCommandOnColumn("amean");
                this.updateMenus();
                return false;
            }
            if (event.target == this.fGeometric) {
                this.fTablePanel.doCommandOnColumn("gmean");
                this.updateMenus();
                return false;
            }
            if (event.target == this.fFill) {
                int n;
                Column column;
                TableRow tableRow;
                FillDialog fillDialog = new FillDialog(this.fTableHolder.panel(), String.valueOf(fp_resource.getString("str_fill")) + ":", this.fTablePanel.currentVar(), this);
                if (this.fTablePanel.allowComplexFill()) {
                    fillDialog.showComplexFill();
                }
                if (this.fTablePanel.allowIterateFill()) {
                    fillDialog.showIterate();
                }
                if ((tableRow = (column = this.fTablePanel.selectedColumn()).row(n = this.fTablePanel.selectedRowNum())).isNum()) {
                    fillDialog.setStartValue(tableRow.num());
                }
                fillDialog.setVisible(true);
                this.fTablePanel.reevaluate();
                this.fTablePanel.redraw(true);
                this.updateMenus();
                return false;
            }
            if (event.target == this.fFillBetween) {
                int n;
                Column column;
                TableRow tableRow;
                FillDialog fillDialog = new FillDialog(this.fTableHolder.panel(), String.valueOf(fp_resource.getString("str_fill_between")) + ":", this.fTablePanel.currentVar(), this);
                if (this.fTablePanel.allowComplexFill()) {
                    fillDialog.showComplexFill();
                }
                if (this.fTablePanel.allowIterateFill()) {
                    fillDialog.showIterate();
                }
                if (!(tableRow = (column = this.fTablePanel.selectedColumn()).row(n = this.fTablePanel.selectedRowNum())).isNum()) {
                    utils.showErrorDialog(this, fp_resource.getString("str_must_have_numeric_entries_in_data_cells_selected"));
                    return false;
                }
                double d = tableRow.num();
                tableRow = column.row(n + 1);
                if (tableRow == null) {
                    utils.showErrorDialog(this, fp_resource.getString("str_error__null_row_this_is_a_bug__please_report"));
                    return false;
                }
                if (!tableRow.isNum()) {
                    utils.showErrorDialog(this, fp_resource.getString("str_must_have_numeric_entries_in_data_cells_selected"));
                    return false;
                }
                double d2 = tableRow.num();
                fillDialog.doFillBetween(d, d2);
                fillDialog.setVisible(true);
                this.updateMenus();
                return false;
            }
            if (event.target == this.fInsertBetween) {
                InsertBetweenDialog insertBetweenDialog = new InsertBetweenDialog(this.fTablePanel);
                ((Component)insertBetweenDialog).setVisible(true);
                this.updateMenus();
                return false;
            }
            if (event.target == this.fEliminateBlanks) {
                this.fTablePanel.doEliminateBlanks();
                this.updateMenus();
                return false;
            }
            if (event.target == this.fIndex) {
                this.fTablePanel.doIndex();
                this.updateMenus();
                return false;
            }
            if (event.target == this.fNudgeUp) {
                this.fTablePanel.nudgeUp();
                this.updateMenus();
                return false;
            }
            if (event.target == this.fNudgeDown) {
                this.fTablePanel.nudgeDown();
                this.updateMenus();
                return false;
            }
            if (event.target == this.fColumnSetup) {
                ColSetupDialog colSetupDialog = new ColSetupDialog((Frame)this, this.fTablePanel);
                ((Component)colSetupDialog).setVisible(true);
                this.cantUndo();
                this.updateMenus();
                return false;
            }
            if (event.target == this.fTableSetup) {
                TableSetupDialog tableSetupDialog = new TableSetupDialog((Frame)this, this.fTablePanel);
                ((Component)tableSetupDialog).setVisible(true);
                this.cantUndo();
                this.updateMenus();
                return false;
            }
            if (event.target == this.fInactivate) {
                this.fTablePanel.colActive(this.fTablePanel.colActive() ^ true);
                this.cantUndo();
                this.updateMenus();
                return false;
            }
            if (event.target == this.fShowDependencies) {
                this.fTablePanel.showDependencies(this.fShowDependencies.getState());
                this.fTablePanel.repaint();
                this.cantUndo();
                this.updateMenus();
                return false;
            }
            if (event.target == this.fInsertCol) {
                this.copyToUndo(fp_resource.getString("str_undo_insert_column"));
                this.fTablePanel.insertColumn();
                this.fTablePanel.redraw(true);
                this.updateMenus();
                return false;
            }
            if (event.target == this.fDeleteCol) {
                this.fTablePanel.deleteColumn();
                this.fTablePanel.recalculate();
                this.setBounds(this.getLocation().x, this.getLocation().y, this.getSize().width, this.getSize().height);
                this.fTablePanel.redraw(true);
                this.updateMenus();
                return false;
            }
            if (event.target == this.fInsertCell) {
                this.copyToUndo(fp_resource.getString("str_undo_insert_cell"));
                this.fTablePanel.insertCell();
                this.fTablePanel.reevaluate();
                this.fTablePanel.redraw(true);
                this.updateMenus();
                return false;
            }
            if (event.target == this.fDeleteCell) {
                this.copyToUndo(fp_resource.getString("str_undo_delete_cells"));
                this.fTablePanel.deleteCells();
                this.fTablePanel.reevaluate();
                this.fTablePanel.redraw(true);
                this.updateMenus();
                return false;
            }
            if (event.target == this.fSelect) {
                this.fTablePanel.selectColumns(this.fTablePanel.selectColumns() ^ true);
                this.fTablePanel.redraw(false);
                this.cantUndo();
                this.updateMenus();
                return false;
            }
            if (event.target == this.fColumnColor) {
                ColorDialog colorDialog = new ColorDialog((Frame)this, this.fTablePanel);
                ((Component)colorDialog).setVisible(true);
                this.cantUndo();
                this.updateMenus();
                return false;
            }
            if (event.target == this.fSelectVariables) {
                VariableTypeDialog variableTypeDialog = new VariableTypeDialog((Frame)this, this.fTablePanel);
                ((Component)variableTypeDialog).setVisible(true);
                this.cantUndo();
                this.updateMenus();
                return false;
            }
            if (event.target == this.fLink) {
                this.fTablePanel.linkColumns();
                this.fTablePanel.selectColumns(false);
                this.fTablePanel.redraw(false);
                this.cantUndo();
                this.updateMenus();
                return false;
            }
            if (event.target == this.fUnlink) {
                this.fTablePanel.unlinkColumns();
                this.fTablePanel.redraw(false);
                this.cantUndo();
                this.updateMenus();
                return false;
            }
            if (event.target == this.fMake) {
                this.copyToUndo(fp_resource.getString("str_undo_make_intervals"));
                IntervalsDialog intervalsDialog = new IntervalsDialog(this.fTablePanel);
                ((Component)intervalsDialog).setVisible(true);
                this.updateMenus();
                return false;
            }
            if (event.target == this.fSelectIntervals) {
                this.fTablePanel.selectIntervals(this.fTablePanel.selectIntervals() ^ true);
                this.fTablePanel.repaint();
                this.cantUndo();
                this.updateMenus();
                return false;
            }
            if (event.target == this.fSelectAllIntervals) {
                this.fTablePanel.selectAllIntervals();
                this.fTablePanel.redraw(false);
                this.cantUndo();
                this.updateMenus();
                return false;
            }
            if (event.target == this.fBarsToGraph) {
                this.fTablePanel.sendBarsToGraph();
                this.cantUndo();
                this.updateMenus();
                return false;
            }
            if (object.equals(fp_resource.getString("str_quit_function_probe"))) {
                Master.sureToQuit();
            }
        }
        return super.action(event, object);
    }

    private void setMenuEnable(MenuItem menuItem, boolean bl) {
        if (bl != menuItem.isEnabled()) {
            this.statechanged = true;
            menuItem.setEnabled(bl);
        }
    }

    private void setMenuLabel(MenuItem menuItem, String string) {
        if (!menuItem.getLabel().equals(string)) {
            this.statechanged = true;
            menuItem.setLabel(string);
        }
    }

    public void updateMenus() {
        boolean bl = this.fTablePanel.columnSelected();
        boolean bl2 = this.fTablePanel.inDataRows();
        boolean bl3 = this.fTablePanel.numRowsSelected() == 2;
        boolean bl4 = this.fTablePanel.canNudgeUp();
        boolean bl5 = this.fTablePanel.dependent();
        boolean bl6 = this.fTablePanel.deleteable();
        boolean bl7 = this.fTablePanel.selectColumns();
        boolean bl8 = this.fTablePanel.selectIntervals();
        boolean bl9 = this.fTablePanel.numLinkedCols() > 0;
        this.statechanged = false;
        this.setMenuEnable(this.fFill, bl && bl2 && !bl5 && !bl7 && !bl8);
        this.setMenuEnable(this.fSort, bl && !bl5 && !bl7);
        this.setMenuEnable(this.fDifference, bl && !bl7 && !bl8);
        this.setMenuEnable(this.fRatio, bl && !bl7 && !bl8);
        this.setMenuEnable(this.fArithmetic, bl && !bl7 && !bl8);
        this.setMenuEnable(this.fGeometric, bl && !bl7 && !bl8);
        this.setMenuEnable(this.fAccumulate, bl && !bl7 && !bl8);
        this.setMenuEnable(this.fIndex, bl && !bl7 && !bl8);
        this.setMenuEnable(this.fFillBetween, bl && bl3 && bl2 && !bl5 && !bl7 && !bl8);
        this.setMenuEnable(this.fInsertBetween, bl && !bl5 && !bl7 && !bl8);
        this.setMenuEnable(this.fShowStats, bl && !bl7);
        this.setMenuEnable(this.fNudgeUp, bl4 && bl && !bl7 && !bl8);
        this.setMenuEnable(this.fNudgeDown, bl && !bl7 && !bl8);
        this.setMenuEnable(this.fInactivate, bl && !bl7 && !bl8);
        this.setMenuEnable(this.fUndo, this.fUndoer.undoable());
        if (this.fUndoer.undoable()) {
            this.setMenuLabel(this.fUndo, this.fUndoer.undoString());
        } else {
            this.setMenuLabel(this.fUndo, fp_resource.getString("str_cant_undo"));
        }
        this.setMenuEnable(this.fDeleteIntervals, bl && this.fTablePanel.selectedColHasIntervals());
        this.setMenuEnable(this.fBarsToGraph, this.fTablePanel.allowSendBarsToGraph());
        this.setMenuEnable(this.fSendPointsToGraph, this.fTablePanel.allowSendPointsToGraph());
        if (bl && !this.fTablePanel.colActive()) {
            this.setMenuLabel(this.fInactivate, fp_resource.getString("str_activate_column"));
        } else {
            this.setMenuLabel(this.fInactivate, fp_resource.getString("str_inactivate_column"));
        }
        if (bl7) {
            this.setMenuLabel(this.fSelect, fp_resource.getString("str_stop_selecting_columns"));
        } else {
            this.setMenuLabel(this.fSelect, fp_resource.getString("str_select_columns"));
        }
        if (bl8) {
            this.setMenuLabel(this.fSelectIntervals, fp_resource.getString("str_stop_selecting_intervals"));
        } else {
            this.setMenuLabel(this.fSelectIntervals, fp_resource.getString("str_select_intervals"));
        }
        this.setMenuLabel(this.fDeleteCell, fp_resource.getString("str_delete_cells"));
        this.setMenuEnable(this.fDeleteCell, !bl5 && bl && this.fTablePanel.numRowsSelected() > 0 && !bl7 && !bl8);
        this.setMenuEnable(this.fInsertCell, !bl5 && bl && this.fTablePanel.numRowsSelected() > 0 && !bl7 && !bl8);
        this.setMenuEnable(this.fEliminateBlanks, bl && !bl5 && !bl7 && !bl8);
        this.setMenuEnable(this.fShowDependencies, bl && !bl7 && !bl8);
        this.setMenuEnable(this.fLink, bl7 && !bl8);
        this.setMenuEnable(this.fUnlink, bl9 && !bl7 && !bl8);
        this.setMenuEnable(this.fColumnSetup, bl && !bl7);
        this.setMenuEnable(this.fMake, bl && !bl7 && !bl8);
        this.setMenuEnable(this.fDeleteCol, bl && bl6 && !bl7 && !bl8);
        this.setMenuEnable(this.fColumnColor, bl);
        this.setMenuEnable(this.fSelectVariables, true);
        this.setMenuEnable(this.fSelectAllIntervals, bl && !bl7);
        this.setMenuEnable(this.fSelectIntervals, bl && !bl7);
        this.setMenuEnable(this.fSelect, bl8 ^ true);
        this.setMenuEnable(this.fSaveMenu, this.fFileName != null);
        this.setMenuEnable(this.fRevertMenu, this.fFileName != null);
        this.fWindowMenuHandler.updateMenu();
        if (this.statechanged) {
            Master.forceUpdate(this);
        }
    }

    public boolean handleEvent(Event event) {
        if (event.id == 201) {
            this.setVisible(false);
            return false;
        }
        return super.handleEvent(event);
    }

    public boolean mouseUp(Event event, int n, int n2) {
        return false;
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public void paint(Graphics graphics) {
        int n = Master.gSmallTop;
        graphics.drawLine(0, n - 1, this.getSize().width, n - 1);
        this.updateMenus();
    }

    public void setValueTo(double d) {
        this.fTablePanel.setValueTo(d);
    }

    public void sendPointsToTable(double[] dArray, double[] dArray2, int n, char c, char c2) {
        this.fTablePanel.sendPointsToTable(dArray, dArray2, n, c, c2);
    }

    public void sendBarsToTable(double[] dArray, double[] dArray2, double[] dArray3, int n, String string, char c) {
        this.fTablePanel.sendBarsToTable(dArray, dArray2, dArray3, n, string, c);
    }

    public boolean save(String string) {
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(string);
            GZIPOutputStream gZIPOutputStream = new GZIPOutputStream(fileOutputStream);
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(gZIPOutputStream);
            TableFileData tableFileData = new TableFileData(this.fTablePanel);
            objectOutputStream.writeObject(tableFileData);
            objectOutputStream.flush();
            objectOutputStream.close();
            return true;
        }
        catch (IOException iOException) {
            utils.showErrorDialog(this, String.valueOf(fp_resource.getString("str_error__in_io_during_save")) + iOException.getMessage());
            return false;
        }
    }

    public void doSave() {
        FileDialog fileDialog = new FileDialog((Frame)this, fp_resource.getString("str_save_table"), 1);
        fileDialog.setFile(String.valueOf(fp_resource.getString("str_untitled")) + fFileExtension);
        ((Component)fileDialog).setVisible(true);
        String string = fileDialog.getFile();
        String string2 = fileDialog.getDirectory();
        if (string != null) {
            if (!string.endsWith(fFileExtension)) {
                string = String.valueOf(string) + fFileExtension;
            }
            if (!this.save(String.valueOf(string2) + string)) {
                return;
            }
            this.fFileName = string.substring(0, string.length() - 4);
            this.fFilePath = string2;
            this.setTitle(this.fFileName);
        }
    }

    public void setFromFileData(TableFileData tableFileData) {
        this.fTablePanel.clearSelectsNoUpdate();
        tableFileData.setTableData(this.fTablePanel);
        this.fTablePanel.redraw(true);
    }

    public void load(String string) {
        TableFileData tableFileData;
        try {
            FileInputStream fileInputStream = new FileInputStream(string);
            GZIPInputStream gZIPInputStream = new GZIPInputStream(fileInputStream);
            ObjectInputStream objectInputStream = new ObjectInputStream(gZIPInputStream);
            tableFileData = (TableFileData)objectInputStream.readObject();
            objectInputStream.close();
        }
        catch (IOException iOException) {
            File file = new File(string);
            String string2 = utils.sprintf(fp_resource.getString("str_error__wrong_or_corrupt_file"), file.getName());
            utils.showErrorDialog(this, string2);
            return;
        }
        catch (Exception exception) {
            utils.showErrorDialog(this, String.valueOf(fp_resource.getString("str_error__in_io_during_load")) + exception.getMessage());
            return;
        }
        this.setVisible(false);
        this.setFromFileData(tableFileData);
        this.setVisible(true);
    }

    public void doLoad() {
        YesNoDialog yesNoDialog = new YesNoDialog(this, fp_resource.getString("str_warning"), fp_resource.getString("str_warning_table_will_be_lost"), fp_resource.getString("str_yes"), fp_resource.getString("str_no"), null);
        yesNoDialog.setVisible(true);
        if (yesNoDialog.getReturnValue() != 1) {
            return;
        }
        FileDialog fileDialog = new FileDialog((Frame)this, fp_resource.getString("str_load_table"), 0);
        fileDialog.setFilenameFilter(this);
        ((Component)fileDialog).setVisible(true);
        String string = fileDialog.getFile();
        if (string != null) {
            if (string.endsWith(fFileExtension)) {
                this.load(String.valueOf(fileDialog.getDirectory()) + string);
                this.fFileName = string.substring(0, string.length() - 4);
                this.fFilePath = fileDialog.getDirectory();
                this.setTitle(this.fFileName);
                this.updateMenus();
            } else {
                Master.loadWorkspace(String.valueOf(fileDialog.getDirectory()) + string);
            }
        }
    }

    public boolean accept(File file, String string) {
        return string.endsWith(fFileExtension) || string.endsWith(".prb");
    }

    public TablePanel tablePanel() {
        return this.fTablePanel;
    }

    public UndoTable undoer() {
        return this.fUndoer;
    }

    public boolean columnValid() {
        return this.fTablePanel.columnValid();
    }

    public int columnData(double[] dArray) {
        return this.fTablePanel.columnData(dArray);
    }

    private final class 1
    extends ComponentAdapter {
        public void componentResized(ComponentEvent componentEvent) {
            Table.this.setBounds(Table.this.getBounds().x, Table.this.getBounds().y, Table.this.getBounds().width, Table.this.getBounds().height);
        }

        /* synthetic */ 1() {
        }
    }

    private final class 2
    extends WindowAdapter {
        public void windowActivated(WindowEvent windowEvent) {
            switch (Master.numGraphers()) {
                case 3: {
                    Master.hideGrapherCAuxWindows();
                }
                case 2: {
                    Master.hideGrapherBAuxWindows();
                }
            }
            Master.hideGrapherAuxWindows();
        }

        public void windowClosing(WindowEvent windowEvent) {
            if (Master.graphAVisible() || Master.graphBVisible() || Master.graphCVisible() || Master.calcVisible()) {
                Table.this.setVisible(false);
            } else {
                Master.sureToQuit();
                Table.this.setVisible(true);
            }
        }

        /* synthetic */ 2() {
        }
    }
}

