/*
 * Decompiled with CFR 0.152.
 */
package com.questmsm.FPTable;

import com.questmsm.FPTable.Column;
import com.questmsm.FPTable.TableShell;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;

public class TableVariableTag {
    private TableShell fPanel;
    private Column fColumn;
    private char fChar;
    private boolean fDragging = false;
    private int fDragX = 0;
    private int fDragY = 0;
    private static int kRadius = 6;
    private static final Font kFont = new Font("Courier", 0, 12);
    public static final int kCenter = 0;
    public static final int kLeft = 1;
    public static final int kRight = 2;
    public static final int kFarLeft = 3;
    public static final int kFarRight = 4;
    private int fPos = 0;

    public TableVariableTag(TableShell tableShell, Column column, char c) {
        this.fPanel = tableShell;
        this.fColumn = column;
        this.fChar = c;
    }

    public void setPos(int n) {
        this.fPos = n;
    }

    private int getX() {
        int n = 0;
        switch (this.fPos) {
            case 1: {
                n = (this.fColumn.right() + this.fColumn.left()) / 2 - kRadius - 1 - kRadius - 1 - 2;
                break;
            }
            case 0: {
                n = (this.fColumn.right() + this.fColumn.left()) / 2 - kRadius - 1;
                break;
            }
            case 2: {
                n = (this.fColumn.right() + this.fColumn.left()) / 2 + 2;
                break;
            }
            case 3: {
                n = (this.fColumn.right() + this.fColumn.left()) / 2 - kRadius - 1 - 2 * (kRadius + 1 + 2);
                break;
            }
            case 4: {
                n = (this.fColumn.right() + this.fColumn.left()) / 2 - kRadius - 1 + 2 * (kRadius + 1 + 2);
                break;
            }
        }
        return n;
    }

    public void draw(Graphics graphics) {
        if (this.fDragging) {
            this.drawDragTag(graphics);
            return;
        }
        if (this.fColumn == null) {
            return;
        }
        int n = this.getX();
        int n2 = 2;
        this.draw(graphics, n, n2);
    }

    public void draw(Graphics graphics, int n, int n2) {
        graphics.setColor(Color.black);
        graphics.fillOval(n, n2, 2 * kRadius + 2, 2 * kRadius);
        graphics.setColor(Color.white);
        Font font = graphics.getFont();
        graphics.setFont(kFont);
        if (this.fChar == 'q') {
            graphics.drawOval(n + 4, n2 + 2, 6, 7);
            graphics.drawLine(n + 4, n2 + 5, n + 9, n2 + 5);
        } else {
            graphics.drawString(String.valueOf(this.fChar), n + 3, n2 + 9);
        }
        graphics.setFont(font);
    }

    public void drawDragTag(Graphics graphics) {
        this.draw(graphics, this.fDragX, 2);
    }

    public boolean inTag(int n, int n2) {
        int n3 = this.getX();
        boolean bl = true;
        if (n < n3) {
            return false;
        }
        if (n > n3 + 2 * kRadius + 2) {
            return false;
        }
        return n2 <= 2 * kRadius + 1;
    }

    public boolean dragging() {
        return this.fDragging;
    }

    public void dragging(boolean bl) {
        this.fDragging = bl;
    }

    public void setDragCoords(int n, int n2) {
        this.fDragX = n - kRadius;
        this.fDragY = n2 - kRadius;
    }

    public void column(Column column) {
        this.fColumn = column;
    }

    public Column column() {
        return this.fColumn;
    }
}

