/*
 * Decompiled with CFR 0.152.
 */
package com.questmsm.FunctionProbe;

import com.questmsm.FPCalculator.CalcUtils;
import com.questmsm.FunctionProbe.Master;
import com.questmsm.Utilities.fp_resource;
import com.questmsm.Utilities.utils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;

public class SplashFrame
extends Frame {
    private Image splash;
    private Image about;
    private int mode = 0;
    private boolean loading = true;
    private int inwhichbutton = 0;
    private static final transient Font fItalicFont = new Font("Helvetica", 3, 9);
    private static final transient Font fButtonFont = new Font("Helvetica", 1, 12);
    private static transient FontMetrics fMetric = null;
    Image offimg;

    public SplashFrame() {
        super("FunctionProbe");
        ((Component)this).setVisible(false);
        this.setLayout(null);
        ((Component)this).setBackground(Color.black);
        this.addNotify();
        this.validate();
        this.setResizable(false);
        this.addMouseListener(new 1());
    }

    void handleMousePressed(MouseEvent mouseEvent) {
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        this.inwhichbutton = 0;
        if (!this.loading && this.insideOK(n, n2)) {
            this.inwhichbutton = 1;
        } else if (this.insideAbout(n, n2)) {
            this.inwhichbutton = 2;
        }
        this.repaint();
    }

    void handleMouseReleased(MouseEvent mouseEvent) {
        this.inwhichbutton = 0;
        if (this.insideAbout(mouseEvent.getX(), mouseEvent.getY())) {
            this.mode = this.mode == 0 ? 1 : 0;
        }
        this.handleMouseClicked(mouseEvent);
    }

    void handleMouseClicked(MouseEvent mouseEvent) {
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        if (!this.loading && this.insideOK(n, n2)) {
            ((Component)this).setVisible(false);
            Master.showCalc();
            Master.calculator().myResize();
            Master.showTable();
            Master.showGrapher();
            this.dispose();
        } else if (this.insideAbout(n, n2)) {
            this.repaint();
        }
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public void disableOK() {
        this.loading = true;
        this.repaint();
    }

    public void enableOK() {
        this.addKeyListener(new 2());
        this.loading = false;
        this.repaint();
    }

    public void loadSplashImage() {
        if (this.splash != null) {
            return;
        }
        this.splash = utils.getImage(fp_resource.getString("image_splash"), this);
        if (this.about != null) {
            return;
        }
        this.about = utils.getImage(fp_resource.getString("image_about"), this);
    }

    public void drawOK(Graphics graphics) {
        graphics.setColor(Color.lightGray);
        graphics.fillRect(410, 361, 56, 21);
        int n = 0;
        if (this.inwhichbutton != 1) {
            graphics.setColor(Color.black);
            graphics.drawRect(410, 361, 56, 21);
            graphics.setColor(Color.white);
            graphics.drawLine(410, 361, 465, 361);
            graphics.drawLine(410, 361, 410, 382);
        } else {
            n = 1;
            graphics.setColor(Color.white);
            graphics.drawRect(410, 361, 56, 21);
            graphics.setColor(Color.black);
            graphics.drawLine(410, 361, 465, 361);
            graphics.drawLine(410, 361, 410, 382);
        }
        if (this.loading) {
            graphics.setColor(Color.gray);
            CalcUtils.drawCenter(graphics, fp_resource.getString("str_loading"), 410 + n, 56, 375 + n, fItalicFont);
        } else {
            graphics.setColor(Color.black);
            CalcUtils.drawCenter(graphics, fp_resource.getString("str_ok"), 410 + n, 56, 377 + n, fButtonFont);
        }
    }

    public void drawAbout(Graphics graphics) {
        graphics.setColor(Color.lightGray);
        graphics.fillRect(476, 361, 56, 21);
        int n = 0;
        if (this.inwhichbutton != 2) {
            graphics.setColor(Color.black);
            graphics.drawRect(476, 361, 56, 21);
            graphics.setColor(Color.white);
            graphics.drawLine(476, 361, 531, 361);
            graphics.drawLine(476, 361, 476, 382);
        } else {
            n = 1;
            graphics.setColor(Color.white);
            graphics.drawRect(476, 361, 56, 21);
            graphics.setColor(Color.black);
            graphics.drawLine(476, 361, 531, 361);
            graphics.drawLine(476, 361, 476, 382);
        }
        graphics.setColor(Color.black);
        if (this.mode == 1) {
            CalcUtils.drawCenter(graphics, fp_resource.getString("str_back"), 476 + n, 56, 377 + n, fButtonFont);
        } else {
            CalcUtils.drawCenter(graphics, fp_resource.getString("str_about"), 476 + n, 56, 377 + n, fButtonFont);
        }
    }

    public void paint(Graphics graphics) {
        Object object;
        if (this.offimg == null) {
            object = this.getSize();
            this.offimg = this.createImage(((Dimension)object).width, ((Dimension)object).height);
        }
        object = this.offimg.getGraphics();
        if (this.mode == 0) {
            if (this.splash != null) {
                ((Graphics)object).drawImage(this.splash, 0, 0, this);
            }
        } else if (this.mode == 1 && this.about != null) {
            ((Graphics)object).drawImage(this.about, 0, 0, this);
        }
        this.drawOK((Graphics)object);
        this.drawAbout((Graphics)object);
        graphics.drawImage(this.offimg, 0, Master.windowsOffset(), this);
    }

    private boolean insideOK(int n, int n2) {
        return n >= 411 && n <= 465 && n2 >= 361 + Master.windowsOffset() && n2 <= 404;
    }

    private boolean insideAbout(int n, int n2) {
        return n >= 478 && n <= 530 && n2 >= 361 + Master.windowsOffset() && n2 <= 403;
    }

    private final class 1
    extends MouseAdapter {
        public void mousePressed(MouseEvent mouseEvent) {
            SplashFrame.this.handleMousePressed(mouseEvent);
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            SplashFrame.this.handleMouseReleased(mouseEvent);
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            SplashFrame.this.handleMouseClicked(mouseEvent);
        }

        /* synthetic */ 1() {
        }
    }

    private final class 2
    extends KeyAdapter {
        public void keyTyped(KeyEvent keyEvent) {
            if (keyEvent.getKeyChar() == '\n') {
                ((Component)SplashFrame.this).setVisible(false);
                Master.showCalc();
                Master.calculator().myResize();
                Master.showTable();
                Master.showGrapher();
                SplashFrame.this.dispose();
            }
        }

        /* synthetic */ 2() {
        }
    }
}

